/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.elasticbeanstalk.model.UpdateApplicationVersionRequest;
import software.amazon.awssdk.util.StringUtils;

public class UpdateApplicationVersionRequestMarshaller
implements Marshaller<Request<UpdateApplicationVersionRequest>, UpdateApplicationVersionRequest> {
    public Request<UpdateApplicationVersionRequest> marshall(UpdateApplicationVersionRequest updateApplicationVersionRequest) {
        if (updateApplicationVersionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateApplicationVersionRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "UpdateApplicationVersion");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (updateApplicationVersionRequest.applicationName() != null) {
            request.addParameter("ApplicationName", StringUtils.fromString((String)updateApplicationVersionRequest.applicationName()));
        }
        if (updateApplicationVersionRequest.versionLabel() != null) {
            request.addParameter("VersionLabel", StringUtils.fromString((String)updateApplicationVersionRequest.versionLabel()));
        }
        if (updateApplicationVersionRequest.description() != null) {
            request.addParameter("Description", StringUtils.fromString((String)updateApplicationVersionRequest.description()));
        }
        return request;
    }
}

