/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.model.SourceConfiguration;

public class SourceConfigurationUnmarshaller
implements Unmarshaller<SourceConfiguration, StaxUnmarshallerContext> {
    private static SourceConfigurationUnmarshaller INSTANCE;

    public SourceConfiguration unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        SourceConfiguration.Builder sourceConfiguration = SourceConfiguration.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("ApplicationName", targetDepth)) {
                    sourceConfiguration.applicationName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("TemplateName", targetDepth)) continue;
                sourceConfiguration.templateName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (SourceConfiguration)sourceConfiguration.build();
    }

    public static SourceConfigurationUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SourceConfigurationUnmarshaller();
        }
        return INSTANCE;
    }
}

