/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.model.SolutionStackDescription;

public class SolutionStackDescriptionUnmarshaller
implements Unmarshaller<SolutionStackDescription, StaxUnmarshallerContext> {
    private static SolutionStackDescriptionUnmarshaller INSTANCE;

    public SolutionStackDescription unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        SolutionStackDescription.Builder solutionStackDescription = SolutionStackDescription.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("SolutionStackName", targetDepth)) {
                    solutionStackDescription.solutionStackName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PermittedFileTypes", targetDepth)) {
                    solutionStackDescription.permittedFileTypes(new ArrayList<String>());
                    continue;
                }
                if (!context.testExpression("PermittedFileTypes/member", targetDepth)) continue;
                solutionStackDescription.permittedFileTypes(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (SolutionStackDescription)solutionStackDescription.build();
    }

    public static SolutionStackDescriptionUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SolutionStackDescriptionUnmarshaller();
        }
        return INSTANCE;
    }
}

