/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.elasticbeanstalk.model.RestartAppServerRequest;
import software.amazon.awssdk.util.StringUtils;

public class RestartAppServerRequestMarshaller
implements Marshaller<Request<RestartAppServerRequest>, RestartAppServerRequest> {
    public Request<RestartAppServerRequest> marshall(RestartAppServerRequest restartAppServerRequest) {
        if (restartAppServerRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)restartAppServerRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "RestartAppServer");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (restartAppServerRequest.environmentId() != null) {
            request.addParameter("EnvironmentId", StringUtils.fromString((String)restartAppServerRequest.environmentId()));
        }
        if (restartAppServerRequest.environmentName() != null) {
            request.addParameter("EnvironmentName", StringUtils.fromString((String)restartAppServerRequest.environmentName()));
        }
        return request;
    }
}

