/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.model.Listener;
import software.amazon.awssdk.services.elasticbeanstalk.model.LoadBalancerDescription;
import software.amazon.awssdk.services.elasticbeanstalk.transform.ListenerUnmarshaller;

public class LoadBalancerDescriptionUnmarshaller
implements Unmarshaller<LoadBalancerDescription, StaxUnmarshallerContext> {
    private static LoadBalancerDescriptionUnmarshaller INSTANCE;

    public LoadBalancerDescription unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        LoadBalancerDescription.Builder loadBalancerDescription = LoadBalancerDescription.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("LoadBalancerName", targetDepth)) {
                    loadBalancerDescription.loadBalancerName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Domain", targetDepth)) {
                    loadBalancerDescription.domain(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Listeners", targetDepth)) {
                    loadBalancerDescription.listeners(new ArrayList<Listener>());
                    continue;
                }
                if (!context.testExpression("Listeners/member", targetDepth)) continue;
                loadBalancerDescription.listeners(ListenerUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (LoadBalancerDescription)loadBalancerDescription.build();
    }

    public static LoadBalancerDescriptionUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new LoadBalancerDescriptionUnmarshaller();
        }
        return INSTANCE;
    }
}

