/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformVersionsRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.PlatformFilter;
import software.amazon.awssdk.util.StringUtils;

public class ListPlatformVersionsRequestMarshaller
implements Marshaller<Request<ListPlatformVersionsRequest>, ListPlatformVersionsRequest> {
    public Request<ListPlatformVersionsRequest> marshall(ListPlatformVersionsRequest listPlatformVersionsRequest) {
        if (listPlatformVersionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listPlatformVersionsRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "ListPlatformVersions");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList filtersList = (SdkInternalList)listPlatformVersionsRequest.filters();
        if (!filtersList.isEmpty() || !filtersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (PlatformFilter filtersListValue : filtersList) {
                SdkInternalList valuesList;
                if (filtersListValue.type() != null) {
                    request.addParameter("Filters.member." + filtersListIndex + ".Type", StringUtils.fromString((String)filtersListValue.type()));
                }
                if (filtersListValue.operator() != null) {
                    request.addParameter("Filters.member." + filtersListIndex + ".Operator", StringUtils.fromString((String)filtersListValue.operator()));
                }
                if (!(valuesList = (SdkInternalList)filtersListValue.values()).isEmpty() || !valuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String valuesListValue : valuesList) {
                        if (valuesListValue != null) {
                            request.addParameter("Filters.member." + filtersListIndex + ".Values.member." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (listPlatformVersionsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)listPlatformVersionsRequest.maxRecords()));
        }
        if (listPlatformVersionsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)listPlatformVersionsRequest.nextToken()));
        }
        return request;
    }
}

