/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.model.AutoScalingGroup;
import software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentResourceDescription;
import software.amazon.awssdk.services.elasticbeanstalk.model.Instance;
import software.amazon.awssdk.services.elasticbeanstalk.model.LaunchConfiguration;
import software.amazon.awssdk.services.elasticbeanstalk.model.LoadBalancer;
import software.amazon.awssdk.services.elasticbeanstalk.model.Queue;
import software.amazon.awssdk.services.elasticbeanstalk.model.Trigger;
import software.amazon.awssdk.services.elasticbeanstalk.transform.AutoScalingGroupUnmarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.InstanceUnmarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.LaunchConfigurationUnmarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.LoadBalancerUnmarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.QueueUnmarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.TriggerUnmarshaller;

public class EnvironmentResourceDescriptionUnmarshaller
implements Unmarshaller<EnvironmentResourceDescription, StaxUnmarshallerContext> {
    private static EnvironmentResourceDescriptionUnmarshaller INSTANCE;

    public EnvironmentResourceDescription unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        EnvironmentResourceDescription.Builder environmentResourceDescription = EnvironmentResourceDescription.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("EnvironmentName", targetDepth)) {
                    environmentResourceDescription.environmentName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("AutoScalingGroups", targetDepth)) {
                    environmentResourceDescription.autoScalingGroups(new ArrayList<AutoScalingGroup>());
                    continue;
                }
                if (context.testExpression("AutoScalingGroups/member", targetDepth)) {
                    environmentResourceDescription.autoScalingGroups(AutoScalingGroupUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Instances", targetDepth)) {
                    environmentResourceDescription.instances(new ArrayList<Instance>());
                    continue;
                }
                if (context.testExpression("Instances/member", targetDepth)) {
                    environmentResourceDescription.instances(InstanceUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("LaunchConfigurations", targetDepth)) {
                    environmentResourceDescription.launchConfigurations(new ArrayList<LaunchConfiguration>());
                    continue;
                }
                if (context.testExpression("LaunchConfigurations/member", targetDepth)) {
                    environmentResourceDescription.launchConfigurations(LaunchConfigurationUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("LoadBalancers", targetDepth)) {
                    environmentResourceDescription.loadBalancers(new ArrayList<LoadBalancer>());
                    continue;
                }
                if (context.testExpression("LoadBalancers/member", targetDepth)) {
                    environmentResourceDescription.loadBalancers(LoadBalancerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Triggers", targetDepth)) {
                    environmentResourceDescription.triggers(new ArrayList<Trigger>());
                    continue;
                }
                if (context.testExpression("Triggers/member", targetDepth)) {
                    environmentResourceDescription.triggers(TriggerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Queues", targetDepth)) {
                    environmentResourceDescription.queues(new ArrayList<Queue>());
                    continue;
                }
                if (!context.testExpression("Queues/member", targetDepth)) continue;
                environmentResourceDescription.queues(QueueUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (EnvironmentResourceDescription)environmentResourceDescription.build();
    }

    public static EnvironmentResourceDescriptionUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new EnvironmentResourceDescriptionUnmarshaller();
        }
        return INSTANCE;
    }
}

