/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.elasticbeanstalk.model.DeleteApplicationVersionRequest;
import software.amazon.awssdk.util.StringUtils;

public class DeleteApplicationVersionRequestMarshaller
implements Marshaller<Request<DeleteApplicationVersionRequest>, DeleteApplicationVersionRequest> {
    public Request<DeleteApplicationVersionRequest> marshall(DeleteApplicationVersionRequest deleteApplicationVersionRequest) {
        if (deleteApplicationVersionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteApplicationVersionRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "DeleteApplicationVersion");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteApplicationVersionRequest.applicationName() != null) {
            request.addParameter("ApplicationName", StringUtils.fromString((String)deleteApplicationVersionRequest.applicationName()));
        }
        if (deleteApplicationVersionRequest.versionLabel() != null) {
            request.addParameter("VersionLabel", StringUtils.fromString((String)deleteApplicationVersionRequest.versionLabel()));
        }
        if (deleteApplicationVersionRequest.deleteSourceBundle() != null) {
            request.addParameter("DeleteSourceBundle", StringUtils.fromBoolean((Boolean)deleteApplicationVersionRequest.deleteSourceBundle()));
        }
        return request;
    }
}

