/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationVersionDescription;
import software.amazon.awssdk.services.elasticbeanstalk.transform.S3LocationUnmarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.SourceBuildInformationUnmarshaller;

public class ApplicationVersionDescriptionUnmarshaller
implements Unmarshaller<ApplicationVersionDescription, StaxUnmarshallerContext> {
    private static ApplicationVersionDescriptionUnmarshaller INSTANCE;

    public ApplicationVersionDescription unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        ApplicationVersionDescription.Builder applicationVersionDescription = ApplicationVersionDescription.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("ApplicationName", targetDepth)) {
                    applicationVersionDescription.applicationName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Description", targetDepth)) {
                    applicationVersionDescription.description(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("VersionLabel", targetDepth)) {
                    applicationVersionDescription.versionLabel(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SourceBuildInformation", targetDepth)) {
                    applicationVersionDescription.sourceBuildInformation(SourceBuildInformationUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("BuildArn", targetDepth)) {
                    applicationVersionDescription.buildArn(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SourceBundle", targetDepth)) {
                    applicationVersionDescription.sourceBundle(S3LocationUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DateCreated", targetDepth)) {
                    applicationVersionDescription.dateCreated(SimpleTypeStaxUnmarshallers.DateUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DateUpdated", targetDepth)) {
                    applicationVersionDescription.dateUpdated(SimpleTypeStaxUnmarshallers.DateUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Status", targetDepth)) continue;
                applicationVersionDescription.status(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (ApplicationVersionDescription)applicationVersionDescription.build();
    }

    public static ApplicationVersionDescriptionUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ApplicationVersionDescriptionUnmarshaller();
        }
        return INSTANCE;
    }
}

