/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationDescription;
import software.amazon.awssdk.services.elasticbeanstalk.transform.ApplicationResourceLifecycleConfigUnmarshaller;

public class ApplicationDescriptionUnmarshaller
implements Unmarshaller<ApplicationDescription, StaxUnmarshallerContext> {
    private static ApplicationDescriptionUnmarshaller INSTANCE;

    public ApplicationDescription unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        ApplicationDescription.Builder applicationDescription = ApplicationDescription.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("ApplicationName", targetDepth)) {
                    applicationDescription.applicationName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Description", targetDepth)) {
                    applicationDescription.description(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DateCreated", targetDepth)) {
                    applicationDescription.dateCreated(SimpleTypeStaxUnmarshallers.DateUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DateUpdated", targetDepth)) {
                    applicationDescription.dateUpdated(SimpleTypeStaxUnmarshallers.DateUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Versions", targetDepth)) {
                    applicationDescription.versions(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("Versions/member", targetDepth)) {
                    applicationDescription.versions(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ConfigurationTemplates", targetDepth)) {
                    applicationDescription.configurationTemplates(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("ConfigurationTemplates/member", targetDepth)) {
                    applicationDescription.configurationTemplates(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("ResourceLifecycleConfig", targetDepth)) continue;
                applicationDescription.resourceLifecycleConfig(ApplicationResourceLifecycleConfigUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (ApplicationDescription)applicationDescription.build();
    }

    public static ApplicationDescriptionUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ApplicationDescriptionUnmarshaller();
        }
        return INSTANCE;
    }
}

