/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.elasticbeanstalk.model.ValidationMessage;
import software.amazon.awssdk.services.elasticbeanstalk.model.ValidationMessagesListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ValidateConfigurationSettingsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ValidateConfigurationSettingsResponse> {
    private final List<ValidationMessage> messages;

    private ValidateConfigurationSettingsResponse(BuilderImpl builder) {
        this.messages = builder.messages;
    }

    public List<ValidationMessage> messages() {
        return this.messages;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.messages() == null ? 0 : this.messages().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidateConfigurationSettingsResponse)) {
            return false;
        }
        ValidateConfigurationSettingsResponse other = (ValidateConfigurationSettingsResponse)((Object)obj);
        if (other.messages() == null ^ this.messages() == null) {
            return false;
        }
        return other.messages() == null || other.messages().equals(this.messages());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.messages() != null) {
            sb.append("Messages: ").append(this.messages()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<ValidationMessage> messages = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(ValidateConfigurationSettingsResponse model) {
            this.setMessages(model.messages);
        }

        public final Collection<ValidationMessage> getMessages() {
            return this.messages;
        }

        @Override
        public final Builder messages(Collection<ValidationMessage> messages) {
            this.messages = ValidationMessagesListCopier.copy(messages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(ValidationMessage ... messages) {
            if (this.messages == null) {
                this.messages = new SdkInternalList(messages.length);
            }
            for (ValidationMessage e : messages) {
                this.messages.add(e);
            }
            return this;
        }

        public final void setMessages(Collection<ValidationMessage> messages) {
            this.messages = ValidationMessagesListCopier.copy(messages);
        }

        @SafeVarargs
        public final void setMessages(ValidationMessage ... messages) {
            if (this.messages == null) {
                this.messages = new SdkInternalList(messages.length);
            }
            for (ValidationMessage e : messages) {
                this.messages.add(e);
            }
        }

        public ValidateConfigurationSettingsResponse build() {
            return new ValidateConfigurationSettingsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ValidateConfigurationSettingsResponse> {
        public Builder messages(Collection<ValidationMessage> var1);

        public Builder messages(ValidationMessage ... var1);
    }
}

