/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import software.amazon.awssdk.services.elasticbeanstalk.model.SourceRepository;
import software.amazon.awssdk.services.elasticbeanstalk.model.SourceType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SourceBuildInformation
implements ToCopyableBuilder<Builder, SourceBuildInformation> {
    private final String sourceType;
    private final String sourceRepository;
    private final String sourceLocation;

    private SourceBuildInformation(BuilderImpl builder) {
        this.sourceType = builder.sourceType;
        this.sourceRepository = builder.sourceRepository;
        this.sourceLocation = builder.sourceLocation;
    }

    public String sourceType() {
        return this.sourceType;
    }

    public String sourceRepository() {
        return this.sourceRepository;
    }

    public String sourceLocation() {
        return this.sourceLocation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.sourceType() == null ? 0 : this.sourceType().hashCode());
        hashCode = 31 * hashCode + (this.sourceRepository() == null ? 0 : this.sourceRepository().hashCode());
        hashCode = 31 * hashCode + (this.sourceLocation() == null ? 0 : this.sourceLocation().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceBuildInformation)) {
            return false;
        }
        SourceBuildInformation other = (SourceBuildInformation)obj;
        if (other.sourceType() == null ^ this.sourceType() == null) {
            return false;
        }
        if (other.sourceType() != null && !other.sourceType().equals(this.sourceType())) {
            return false;
        }
        if (other.sourceRepository() == null ^ this.sourceRepository() == null) {
            return false;
        }
        if (other.sourceRepository() != null && !other.sourceRepository().equals(this.sourceRepository())) {
            return false;
        }
        if (other.sourceLocation() == null ^ this.sourceLocation() == null) {
            return false;
        }
        return other.sourceLocation() == null || other.sourceLocation().equals(this.sourceLocation());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.sourceType() != null) {
            sb.append("SourceType: ").append(this.sourceType()).append(",");
        }
        if (this.sourceRepository() != null) {
            sb.append("SourceRepository: ").append(this.sourceRepository()).append(",");
        }
        if (this.sourceLocation() != null) {
            sb.append("SourceLocation: ").append(this.sourceLocation()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String sourceType;
        private String sourceRepository;
        private String sourceLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceBuildInformation model) {
            this.setSourceType(model.sourceType);
            this.setSourceRepository(model.sourceRepository);
            this.setSourceLocation(model.sourceLocation);
        }

        public final String getSourceType() {
            return this.sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        @Override
        public final Builder sourceType(SourceType sourceType) {
            this.sourceType(sourceType.toString());
            return this;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        public final void setSourceType(SourceType sourceType) {
            this.sourceType(sourceType.toString());
        }

        public final String getSourceRepository() {
            return this.sourceRepository;
        }

        @Override
        public final Builder sourceRepository(String sourceRepository) {
            this.sourceRepository = sourceRepository;
            return this;
        }

        @Override
        public final Builder sourceRepository(SourceRepository sourceRepository) {
            this.sourceRepository(sourceRepository.toString());
            return this;
        }

        public final void setSourceRepository(String sourceRepository) {
            this.sourceRepository = sourceRepository;
        }

        public final void setSourceRepository(SourceRepository sourceRepository) {
            this.sourceRepository(sourceRepository.toString());
        }

        public final String getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public final Builder sourceLocation(String sourceLocation) {
            this.sourceLocation = sourceLocation;
            return this;
        }

        public final void setSourceLocation(String sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        public SourceBuildInformation build() {
            return new SourceBuildInformation(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SourceBuildInformation> {
        public Builder sourceType(String var1);

        public Builder sourceType(SourceType var1);

        public Builder sourceRepository(String var1);

        public Builder sourceRepository(SourceRepository var1);

        public Builder sourceLocation(String var1);
    }
}

