/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Date;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.elasticbeanstalk.model.ActionStatus;
import software.amazon.awssdk.services.elasticbeanstalk.model.ActionType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ManagedAction
implements ToCopyableBuilder<Builder, ManagedAction> {
    private final String actionId;
    private final String actionDescription;
    private final String actionType;
    private final String status;
    private final Date windowStartTime;

    private ManagedAction(BuilderImpl builder) {
        this.actionId = builder.actionId;
        this.actionDescription = builder.actionDescription;
        this.actionType = builder.actionType;
        this.status = builder.status;
        this.windowStartTime = builder.windowStartTime;
    }

    public String actionId() {
        return this.actionId;
    }

    public String actionDescription() {
        return this.actionDescription;
    }

    public String actionType() {
        return this.actionType;
    }

    public String status() {
        return this.status;
    }

    public Date windowStartTime() {
        return this.windowStartTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.actionId() == null ? 0 : this.actionId().hashCode());
        hashCode = 31 * hashCode + (this.actionDescription() == null ? 0 : this.actionDescription().hashCode());
        hashCode = 31 * hashCode + (this.actionType() == null ? 0 : this.actionType().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.windowStartTime() == null ? 0 : this.windowStartTime().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedAction)) {
            return false;
        }
        ManagedAction other = (ManagedAction)obj;
        if (other.actionId() == null ^ this.actionId() == null) {
            return false;
        }
        if (other.actionId() != null && !other.actionId().equals(this.actionId())) {
            return false;
        }
        if (other.actionDescription() == null ^ this.actionDescription() == null) {
            return false;
        }
        if (other.actionDescription() != null && !other.actionDescription().equals(this.actionDescription())) {
            return false;
        }
        if (other.actionType() == null ^ this.actionType() == null) {
            return false;
        }
        if (other.actionType() != null && !other.actionType().equals(this.actionType())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.windowStartTime() == null ^ this.windowStartTime() == null) {
            return false;
        }
        return other.windowStartTime() == null || other.windowStartTime().equals(this.windowStartTime());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.actionId() != null) {
            sb.append("ActionId: ").append(this.actionId()).append(",");
        }
        if (this.actionDescription() != null) {
            sb.append("ActionDescription: ").append(this.actionDescription()).append(",");
        }
        if (this.actionType() != null) {
            sb.append("ActionType: ").append(this.actionType()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.windowStartTime() != null) {
            sb.append("WindowStartTime: ").append(this.windowStartTime()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String actionId;
        private String actionDescription;
        private String actionType;
        private String status;
        private Date windowStartTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ManagedAction model) {
            this.setActionId(model.actionId);
            this.setActionDescription(model.actionDescription);
            this.setActionType(model.actionType);
            this.setStatus(model.status);
            this.setWindowStartTime(model.windowStartTime);
        }

        public final String getActionId() {
            return this.actionId;
        }

        @Override
        public final Builder actionId(String actionId) {
            this.actionId = actionId;
            return this;
        }

        public final void setActionId(String actionId) {
            this.actionId = actionId;
        }

        public final String getActionDescription() {
            return this.actionDescription;
        }

        @Override
        public final Builder actionDescription(String actionDescription) {
            this.actionDescription = actionDescription;
            return this;
        }

        public final void setActionDescription(String actionDescription) {
            this.actionDescription = actionDescription;
        }

        public final String getActionType() {
            return this.actionType;
        }

        @Override
        public final Builder actionType(String actionType) {
            this.actionType = actionType;
            return this;
        }

        @Override
        public final Builder actionType(ActionType actionType) {
            this.actionType(actionType.toString());
            return this;
        }

        public final void setActionType(String actionType) {
            this.actionType = actionType;
        }

        public final void setActionType(ActionType actionType) {
            this.actionType(actionType.toString());
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ActionStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final void setStatus(ActionStatus status) {
            this.status(status.toString());
        }

        public final Date getWindowStartTime() {
            return this.windowStartTime;
        }

        @Override
        public final Builder windowStartTime(Date windowStartTime) {
            this.windowStartTime = StandardMemberCopier.copy((Date)windowStartTime);
            return this;
        }

        public final void setWindowStartTime(Date windowStartTime) {
            this.windowStartTime = StandardMemberCopier.copy((Date)windowStartTime);
        }

        public ManagedAction build() {
            return new ManagedAction(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ManagedAction> {
        public Builder actionId(String var1);

        public Builder actionDescription(String var1);

        public Builder actionType(String var1);

        public Builder actionType(ActionType var1);

        public Builder status(String var1);

        public Builder status(ActionStatus var1);

        public Builder windowStartTime(Date var1);
    }
}

