/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.elasticbeanstalk.model.PlatformSummary;
import software.amazon.awssdk.services.elasticbeanstalk.model.PlatformSummaryListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListPlatformVersionsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListPlatformVersionsResponse> {
    private final List<PlatformSummary> platformSummaryList;
    private final String nextToken;

    private ListPlatformVersionsResponse(BuilderImpl builder) {
        this.platformSummaryList = builder.platformSummaryList;
        this.nextToken = builder.nextToken;
    }

    public List<PlatformSummary> platformSummaryList() {
        return this.platformSummaryList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.platformSummaryList() == null ? 0 : this.platformSummaryList().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPlatformVersionsResponse)) {
            return false;
        }
        ListPlatformVersionsResponse other = (ListPlatformVersionsResponse)((Object)obj);
        if (other.platformSummaryList() == null ^ this.platformSummaryList() == null) {
            return false;
        }
        if (other.platformSummaryList() != null && !other.platformSummaryList().equals(this.platformSummaryList())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.platformSummaryList() != null) {
            sb.append("PlatformSummaryList: ").append(this.platformSummaryList()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<PlatformSummary> platformSummaryList = new SdkInternalList();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPlatformVersionsResponse model) {
            this.setPlatformSummaryList(model.platformSummaryList);
            this.setNextToken(model.nextToken);
        }

        public final Collection<PlatformSummary> getPlatformSummaryList() {
            return this.platformSummaryList;
        }

        @Override
        public final Builder platformSummaryList(Collection<PlatformSummary> platformSummaryList) {
            this.platformSummaryList = PlatformSummaryListCopier.copy(platformSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platformSummaryList(PlatformSummary ... platformSummaryList) {
            if (this.platformSummaryList == null) {
                this.platformSummaryList = new SdkInternalList(platformSummaryList.length);
            }
            for (PlatformSummary e : platformSummaryList) {
                this.platformSummaryList.add(e);
            }
            return this;
        }

        public final void setPlatformSummaryList(Collection<PlatformSummary> platformSummaryList) {
            this.platformSummaryList = PlatformSummaryListCopier.copy(platformSummaryList);
        }

        @SafeVarargs
        public final void setPlatformSummaryList(PlatformSummary ... platformSummaryList) {
            if (this.platformSummaryList == null) {
                this.platformSummaryList = new SdkInternalList(platformSummaryList.length);
            }
            for (PlatformSummary e : platformSummaryList) {
                this.platformSummaryList.add(e);
            }
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListPlatformVersionsResponse build() {
            return new ListPlatformVersionsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListPlatformVersionsResponse> {
        public Builder platformSummaryList(Collection<PlatformSummary> var1);

        public Builder platformSummaryList(PlatformSummary ... var1);

        public Builder nextToken(String var1);
    }
}

