/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Date;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.elasticbeanstalk.model.EventSeverity;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EventDescription
implements ToCopyableBuilder<Builder, EventDescription> {
    private final Date eventDate;
    private final String message;
    private final String applicationName;
    private final String versionLabel;
    private final String templateName;
    private final String environmentName;
    private final String platformArn;
    private final String requestId;
    private final String severity;

    private EventDescription(BuilderImpl builder) {
        this.eventDate = builder.eventDate;
        this.message = builder.message;
        this.applicationName = builder.applicationName;
        this.versionLabel = builder.versionLabel;
        this.templateName = builder.templateName;
        this.environmentName = builder.environmentName;
        this.platformArn = builder.platformArn;
        this.requestId = builder.requestId;
        this.severity = builder.severity;
    }

    public Date eventDate() {
        return this.eventDate;
    }

    public String message() {
        return this.message;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public String versionLabel() {
        return this.versionLabel;
    }

    public String templateName() {
        return this.templateName;
    }

    public String environmentName() {
        return this.environmentName;
    }

    public String platformArn() {
        return this.platformArn;
    }

    public String requestId() {
        return this.requestId;
    }

    public String severity() {
        return this.severity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.eventDate() == null ? 0 : this.eventDate().hashCode());
        hashCode = 31 * hashCode + (this.message() == null ? 0 : this.message().hashCode());
        hashCode = 31 * hashCode + (this.applicationName() == null ? 0 : this.applicationName().hashCode());
        hashCode = 31 * hashCode + (this.versionLabel() == null ? 0 : this.versionLabel().hashCode());
        hashCode = 31 * hashCode + (this.templateName() == null ? 0 : this.templateName().hashCode());
        hashCode = 31 * hashCode + (this.environmentName() == null ? 0 : this.environmentName().hashCode());
        hashCode = 31 * hashCode + (this.platformArn() == null ? 0 : this.platformArn().hashCode());
        hashCode = 31 * hashCode + (this.requestId() == null ? 0 : this.requestId().hashCode());
        hashCode = 31 * hashCode + (this.severity() == null ? 0 : this.severity().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventDescription)) {
            return false;
        }
        EventDescription other = (EventDescription)obj;
        if (other.eventDate() == null ^ this.eventDate() == null) {
            return false;
        }
        if (other.eventDate() != null && !other.eventDate().equals(this.eventDate())) {
            return false;
        }
        if (other.message() == null ^ this.message() == null) {
            return false;
        }
        if (other.message() != null && !other.message().equals(this.message())) {
            return false;
        }
        if (other.applicationName() == null ^ this.applicationName() == null) {
            return false;
        }
        if (other.applicationName() != null && !other.applicationName().equals(this.applicationName())) {
            return false;
        }
        if (other.versionLabel() == null ^ this.versionLabel() == null) {
            return false;
        }
        if (other.versionLabel() != null && !other.versionLabel().equals(this.versionLabel())) {
            return false;
        }
        if (other.templateName() == null ^ this.templateName() == null) {
            return false;
        }
        if (other.templateName() != null && !other.templateName().equals(this.templateName())) {
            return false;
        }
        if (other.environmentName() == null ^ this.environmentName() == null) {
            return false;
        }
        if (other.environmentName() != null && !other.environmentName().equals(this.environmentName())) {
            return false;
        }
        if (other.platformArn() == null ^ this.platformArn() == null) {
            return false;
        }
        if (other.platformArn() != null && !other.platformArn().equals(this.platformArn())) {
            return false;
        }
        if (other.requestId() == null ^ this.requestId() == null) {
            return false;
        }
        if (other.requestId() != null && !other.requestId().equals(this.requestId())) {
            return false;
        }
        if (other.severity() == null ^ this.severity() == null) {
            return false;
        }
        return other.severity() == null || other.severity().equals(this.severity());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.eventDate() != null) {
            sb.append("EventDate: ").append(this.eventDate()).append(",");
        }
        if (this.message() != null) {
            sb.append("Message: ").append(this.message()).append(",");
        }
        if (this.applicationName() != null) {
            sb.append("ApplicationName: ").append(this.applicationName()).append(",");
        }
        if (this.versionLabel() != null) {
            sb.append("VersionLabel: ").append(this.versionLabel()).append(",");
        }
        if (this.templateName() != null) {
            sb.append("TemplateName: ").append(this.templateName()).append(",");
        }
        if (this.environmentName() != null) {
            sb.append("EnvironmentName: ").append(this.environmentName()).append(",");
        }
        if (this.platformArn() != null) {
            sb.append("PlatformArn: ").append(this.platformArn()).append(",");
        }
        if (this.requestId() != null) {
            sb.append("RequestId: ").append(this.requestId()).append(",");
        }
        if (this.severity() != null) {
            sb.append("Severity: ").append(this.severity()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Date eventDate;
        private String message;
        private String applicationName;
        private String versionLabel;
        private String templateName;
        private String environmentName;
        private String platformArn;
        private String requestId;
        private String severity;

        private BuilderImpl() {
        }

        private BuilderImpl(EventDescription model) {
            this.setEventDate(model.eventDate);
            this.setMessage(model.message);
            this.setApplicationName(model.applicationName);
            this.setVersionLabel(model.versionLabel);
            this.setTemplateName(model.templateName);
            this.setEnvironmentName(model.environmentName);
            this.setPlatformArn(model.platformArn);
            this.setRequestId(model.requestId);
            this.setSeverity(model.severity);
        }

        public final Date getEventDate() {
            return this.eventDate;
        }

        @Override
        public final Builder eventDate(Date eventDate) {
            this.eventDate = StandardMemberCopier.copy((Date)eventDate);
            return this;
        }

        public final void setEventDate(Date eventDate) {
            this.eventDate = StandardMemberCopier.copy((Date)eventDate);
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getVersionLabel() {
            return this.versionLabel;
        }

        @Override
        public final Builder versionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
            return this;
        }

        public final void setVersionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
        }

        public final String getTemplateName() {
            return this.templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        public final String getEnvironmentName() {
            return this.environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        public final String getPlatformArn() {
            return this.platformArn;
        }

        @Override
        public final Builder platformArn(String platformArn) {
            this.platformArn = platformArn;
            return this;
        }

        public final void setPlatformArn(String platformArn) {
            this.platformArn = platformArn;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public final String getSeverity() {
            return this.severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        @Override
        public final Builder severity(EventSeverity severity) {
            this.severity(severity.toString());
            return this;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        public final void setSeverity(EventSeverity severity) {
            this.severity(severity.toString());
        }

        public EventDescription build() {
            return new EventDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EventDescription> {
        public Builder eventDate(Date var1);

        public Builder message(String var1);

        public Builder applicationName(String var1);

        public Builder versionLabel(String var1);

        public Builder templateName(String var1);

        public Builder environmentName(String var1);

        public Builder platformArn(String var1);

        public Builder requestId(String var1);

        public Builder severity(String var1);

        public Builder severity(EventSeverity var1);
    }
}

