/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentIdListCopier;
import software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentNamesListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeEnvironmentsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeEnvironmentsRequest> {
    private final String applicationName;
    private final String versionLabel;
    private final List<String> environmentIds;
    private final List<String> environmentNames;
    private final Boolean includeDeleted;
    private final Date includedDeletedBackTo;

    private DescribeEnvironmentsRequest(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.versionLabel = builder.versionLabel;
        this.environmentIds = builder.environmentIds;
        this.environmentNames = builder.environmentNames;
        this.includeDeleted = builder.includeDeleted;
        this.includedDeletedBackTo = builder.includedDeletedBackTo;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public String versionLabel() {
        return this.versionLabel;
    }

    public List<String> environmentIds() {
        return this.environmentIds;
    }

    public List<String> environmentNames() {
        return this.environmentNames;
    }

    public Boolean includeDeleted() {
        return this.includeDeleted;
    }

    public Date includedDeletedBackTo() {
        return this.includedDeletedBackTo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.applicationName() == null ? 0 : this.applicationName().hashCode());
        hashCode = 31 * hashCode + (this.versionLabel() == null ? 0 : this.versionLabel().hashCode());
        hashCode = 31 * hashCode + (this.environmentIds() == null ? 0 : this.environmentIds().hashCode());
        hashCode = 31 * hashCode + (this.environmentNames() == null ? 0 : this.environmentNames().hashCode());
        hashCode = 31 * hashCode + (this.includeDeleted() == null ? 0 : this.includeDeleted().hashCode());
        hashCode = 31 * hashCode + (this.includedDeletedBackTo() == null ? 0 : this.includedDeletedBackTo().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEnvironmentsRequest)) {
            return false;
        }
        DescribeEnvironmentsRequest other = (DescribeEnvironmentsRequest)((Object)obj);
        if (other.applicationName() == null ^ this.applicationName() == null) {
            return false;
        }
        if (other.applicationName() != null && !other.applicationName().equals(this.applicationName())) {
            return false;
        }
        if (other.versionLabel() == null ^ this.versionLabel() == null) {
            return false;
        }
        if (other.versionLabel() != null && !other.versionLabel().equals(this.versionLabel())) {
            return false;
        }
        if (other.environmentIds() == null ^ this.environmentIds() == null) {
            return false;
        }
        if (other.environmentIds() != null && !other.environmentIds().equals(this.environmentIds())) {
            return false;
        }
        if (other.environmentNames() == null ^ this.environmentNames() == null) {
            return false;
        }
        if (other.environmentNames() != null && !other.environmentNames().equals(this.environmentNames())) {
            return false;
        }
        if (other.includeDeleted() == null ^ this.includeDeleted() == null) {
            return false;
        }
        if (other.includeDeleted() != null && !other.includeDeleted().equals(this.includeDeleted())) {
            return false;
        }
        if (other.includedDeletedBackTo() == null ^ this.includedDeletedBackTo() == null) {
            return false;
        }
        return other.includedDeletedBackTo() == null || other.includedDeletedBackTo().equals(this.includedDeletedBackTo());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.applicationName() != null) {
            sb.append("ApplicationName: ").append(this.applicationName()).append(",");
        }
        if (this.versionLabel() != null) {
            sb.append("VersionLabel: ").append(this.versionLabel()).append(",");
        }
        if (this.environmentIds() != null) {
            sb.append("EnvironmentIds: ").append(this.environmentIds()).append(",");
        }
        if (this.environmentNames() != null) {
            sb.append("EnvironmentNames: ").append(this.environmentNames()).append(",");
        }
        if (this.includeDeleted() != null) {
            sb.append("IncludeDeleted: ").append(this.includeDeleted()).append(",");
        }
        if (this.includedDeletedBackTo() != null) {
            sb.append("IncludedDeletedBackTo: ").append(this.includedDeletedBackTo()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String applicationName;
        private String versionLabel;
        private List<String> environmentIds = new SdkInternalList();
        private List<String> environmentNames = new SdkInternalList();
        private Boolean includeDeleted;
        private Date includedDeletedBackTo;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEnvironmentsRequest model) {
            this.setApplicationName(model.applicationName);
            this.setVersionLabel(model.versionLabel);
            this.setEnvironmentIds(model.environmentIds);
            this.setEnvironmentNames(model.environmentNames);
            this.setIncludeDeleted(model.includeDeleted);
            this.setIncludedDeletedBackTo(model.includedDeletedBackTo);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getVersionLabel() {
            return this.versionLabel;
        }

        @Override
        public final Builder versionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
            return this;
        }

        public final void setVersionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
        }

        public final Collection<String> getEnvironmentIds() {
            return this.environmentIds;
        }

        @Override
        public final Builder environmentIds(Collection<String> environmentIds) {
            this.environmentIds = EnvironmentIdListCopier.copy(environmentIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentIds(String ... environmentIds) {
            if (this.environmentIds == null) {
                this.environmentIds = new SdkInternalList(environmentIds.length);
            }
            for (String e : environmentIds) {
                this.environmentIds.add(e);
            }
            return this;
        }

        public final void setEnvironmentIds(Collection<String> environmentIds) {
            this.environmentIds = EnvironmentIdListCopier.copy(environmentIds);
        }

        @SafeVarargs
        public final void setEnvironmentIds(String ... environmentIds) {
            if (this.environmentIds == null) {
                this.environmentIds = new SdkInternalList(environmentIds.length);
            }
            for (String e : environmentIds) {
                this.environmentIds.add(e);
            }
        }

        public final Collection<String> getEnvironmentNames() {
            return this.environmentNames;
        }

        @Override
        public final Builder environmentNames(Collection<String> environmentNames) {
            this.environmentNames = EnvironmentNamesListCopier.copy(environmentNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentNames(String ... environmentNames) {
            if (this.environmentNames == null) {
                this.environmentNames = new SdkInternalList(environmentNames.length);
            }
            for (String e : environmentNames) {
                this.environmentNames.add(e);
            }
            return this;
        }

        public final void setEnvironmentNames(Collection<String> environmentNames) {
            this.environmentNames = EnvironmentNamesListCopier.copy(environmentNames);
        }

        @SafeVarargs
        public final void setEnvironmentNames(String ... environmentNames) {
            if (this.environmentNames == null) {
                this.environmentNames = new SdkInternalList(environmentNames.length);
            }
            for (String e : environmentNames) {
                this.environmentNames.add(e);
            }
        }

        public final Boolean getIncludeDeleted() {
            return this.includeDeleted;
        }

        @Override
        public final Builder includeDeleted(Boolean includeDeleted) {
            this.includeDeleted = includeDeleted;
            return this;
        }

        public final void setIncludeDeleted(Boolean includeDeleted) {
            this.includeDeleted = includeDeleted;
        }

        public final Date getIncludedDeletedBackTo() {
            return this.includedDeletedBackTo;
        }

        @Override
        public final Builder includedDeletedBackTo(Date includedDeletedBackTo) {
            this.includedDeletedBackTo = StandardMemberCopier.copy((Date)includedDeletedBackTo);
            return this;
        }

        public final void setIncludedDeletedBackTo(Date includedDeletedBackTo) {
            this.includedDeletedBackTo = StandardMemberCopier.copy((Date)includedDeletedBackTo);
        }

        public DescribeEnvironmentsRequest build() {
            return new DescribeEnvironmentsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeEnvironmentsRequest> {
        public Builder applicationName(String var1);

        public Builder versionLabel(String var1);

        public Builder environmentIds(Collection<String> var1);

        public Builder environmentIds(String ... var1);

        public Builder environmentNames(Collection<String> var1);

        public Builder environmentNames(String ... var1);

        public Builder includeDeleted(Boolean var1);

        public Builder includedDeletedBackTo(Date var1);
    }
}

