/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import software.amazon.awssdk.services.elasticbeanstalk.model.Latency;
import software.amazon.awssdk.services.elasticbeanstalk.model.StatusCodes;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ApplicationMetrics
implements ToCopyableBuilder<Builder, ApplicationMetrics> {
    private final Integer duration;
    private final Integer requestCount;
    private final StatusCodes statusCodes;
    private final Latency latency;

    private ApplicationMetrics(BuilderImpl builder) {
        this.duration = builder.duration;
        this.requestCount = builder.requestCount;
        this.statusCodes = builder.statusCodes;
        this.latency = builder.latency;
    }

    public Integer duration() {
        return this.duration;
    }

    public Integer requestCount() {
        return this.requestCount;
    }

    public StatusCodes statusCodes() {
        return this.statusCodes;
    }

    public Latency latency() {
        return this.latency;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.duration() == null ? 0 : this.duration().hashCode());
        hashCode = 31 * hashCode + (this.requestCount() == null ? 0 : this.requestCount().hashCode());
        hashCode = 31 * hashCode + (this.statusCodes() == null ? 0 : this.statusCodes().hashCode());
        hashCode = 31 * hashCode + (this.latency() == null ? 0 : this.latency().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationMetrics)) {
            return false;
        }
        ApplicationMetrics other = (ApplicationMetrics)obj;
        if (other.duration() == null ^ this.duration() == null) {
            return false;
        }
        if (other.duration() != null && !other.duration().equals(this.duration())) {
            return false;
        }
        if (other.requestCount() == null ^ this.requestCount() == null) {
            return false;
        }
        if (other.requestCount() != null && !other.requestCount().equals(this.requestCount())) {
            return false;
        }
        if (other.statusCodes() == null ^ this.statusCodes() == null) {
            return false;
        }
        if (other.statusCodes() != null && !other.statusCodes().equals(this.statusCodes())) {
            return false;
        }
        if (other.latency() == null ^ this.latency() == null) {
            return false;
        }
        return other.latency() == null || other.latency().equals(this.latency());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.duration() != null) {
            sb.append("Duration: ").append(this.duration()).append(",");
        }
        if (this.requestCount() != null) {
            sb.append("RequestCount: ").append(this.requestCount()).append(",");
        }
        if (this.statusCodes() != null) {
            sb.append("StatusCodes: ").append(this.statusCodes()).append(",");
        }
        if (this.latency() != null) {
            sb.append("Latency: ").append(this.latency()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Integer duration;
        private Integer requestCount;
        private StatusCodes statusCodes;
        private Latency latency;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationMetrics model) {
            this.setDuration(model.duration);
            this.setRequestCount(model.requestCount);
            this.setStatusCodes(model.statusCodes);
            this.setLatency(model.latency);
        }

        public final Integer getDuration() {
            return this.duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        public final Integer getRequestCount() {
            return this.requestCount;
        }

        @Override
        public final Builder requestCount(Integer requestCount) {
            this.requestCount = requestCount;
            return this;
        }

        public final void setRequestCount(Integer requestCount) {
            this.requestCount = requestCount;
        }

        public final StatusCodes getStatusCodes() {
            return this.statusCodes;
        }

        @Override
        public final Builder statusCodes(StatusCodes statusCodes) {
            this.statusCodes = statusCodes;
            return this;
        }

        public final void setStatusCodes(StatusCodes statusCodes) {
            this.statusCodes = statusCodes;
        }

        public final Latency getLatency() {
            return this.latency;
        }

        @Override
        public final Builder latency(Latency latency) {
            this.latency = latency;
            return this;
        }

        public final void setLatency(Latency latency) {
            this.latency = latency;
        }

        public ApplicationMetrics build() {
            return new ApplicationMetrics(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ApplicationMetrics> {
        public Builder duration(Integer var1);

        public Builder requestCount(Integer var1);

        public Builder statusCodes(StatusCodes var1);

        public Builder latency(Latency var1);
    }
}

