/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elasticache.ElastiCacheAsyncClient;
import software.amazon.awssdk.services.elasticache.internal.UserAgentUtils;
import software.amazon.awssdk.services.elasticache.model.CacheCluster;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheClustersRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheClustersResponse;

public class DescribeCacheClustersPublisher
implements SdkPublisher<DescribeCacheClustersResponse> {
    private final ElastiCacheAsyncClient client;
    private final DescribeCacheClustersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeCacheClustersPublisher(ElastiCacheAsyncClient client, DescribeCacheClustersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeCacheClustersPublisher(ElastiCacheAsyncClient client, DescribeCacheClustersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeCacheClustersResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeCacheClustersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CacheCluster> cacheClusters() {
        Function<DescribeCacheClustersResponse, Iterator> getIterator = response -> {
            if (response != null && response.cacheClusters() != null) {
                return response.cacheClusters().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeCacheClustersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeCacheClustersResponseFetcher
    implements AsyncPageFetcher<DescribeCacheClustersResponse> {
        private DescribeCacheClustersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeCacheClustersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeCacheClustersResponse> nextPage(DescribeCacheClustersResponse previousPage) {
            if (previousPage == null) {
                return DescribeCacheClustersPublisher.this.client.describeCacheClusters(DescribeCacheClustersPublisher.this.firstRequest);
            }
            return DescribeCacheClustersPublisher.this.client.describeCacheClusters((DescribeCacheClustersRequest)((Object)DescribeCacheClustersPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

