/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A parameter that has a different value for each cache node type it is applied to. For example, in a Redis cluster, a
 * <code>cache.m1.large</code> cache node type would have a larger <code>maxmemory</code> value than a
 * <code>cache.m1.small</code> type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CacheNodeTypeSpecificParameter implements SdkPojo, Serializable,
        ToCopyableBuilder<CacheNodeTypeSpecificParameter.Builder, CacheNodeTypeSpecificParameter> {
    private static final SdkField<String> PARAMETER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParameterName").getter(getter(CacheNodeTypeSpecificParameter::parameterName))
            .setter(setter(Builder::parameterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CacheNodeTypeSpecificParameter::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Source")
            .getter(getter(CacheNodeTypeSpecificParameter::source)).setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()).build();

    private static final SdkField<String> DATA_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataType").getter(getter(CacheNodeTypeSpecificParameter::dataType)).setter(setter(Builder::dataType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataType").build()).build();

    private static final SdkField<String> ALLOWED_VALUES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AllowedValues").getter(getter(CacheNodeTypeSpecificParameter::allowedValues))
            .setter(setter(Builder::allowedValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedValues").build()).build();

    private static final SdkField<Boolean> IS_MODIFIABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsModifiable").getter(getter(CacheNodeTypeSpecificParameter::isModifiable))
            .setter(setter(Builder::isModifiable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsModifiable").build()).build();

    private static final SdkField<String> MINIMUM_ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MinimumEngineVersion").getter(getter(CacheNodeTypeSpecificParameter::minimumEngineVersion))
            .setter(setter(Builder::minimumEngineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumEngineVersion").build())
            .build();

    private static final SdkField<List<CacheNodeTypeSpecificValue>> CACHE_NODE_TYPE_SPECIFIC_VALUES_FIELD = SdkField
            .<List<CacheNodeTypeSpecificValue>> builder(MarshallingType.LIST)
            .memberName("CacheNodeTypeSpecificValues")
            .getter(getter(CacheNodeTypeSpecificParameter::cacheNodeTypeSpecificValues))
            .setter(setter(Builder::cacheNodeTypeSpecificValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheNodeTypeSpecificValues")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName("CacheNodeTypeSpecificValue")
                            .memberFieldInfo(
                                    SdkField.<CacheNodeTypeSpecificValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(CacheNodeTypeSpecificValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("CacheNodeTypeSpecificValue").build()).build()).build())
            .build();

    private static final SdkField<String> CHANGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChangeType").getter(getter(CacheNodeTypeSpecificParameter::changeTypeAsString))
            .setter(setter(Builder::changeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARAMETER_NAME_FIELD,
            DESCRIPTION_FIELD, SOURCE_FIELD, DATA_TYPE_FIELD, ALLOWED_VALUES_FIELD, IS_MODIFIABLE_FIELD,
            MINIMUM_ENGINE_VERSION_FIELD, CACHE_NODE_TYPE_SPECIFIC_VALUES_FIELD, CHANGE_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String parameterName;

    private final String description;

    private final String source;

    private final String dataType;

    private final String allowedValues;

    private final Boolean isModifiable;

    private final String minimumEngineVersion;

    private final List<CacheNodeTypeSpecificValue> cacheNodeTypeSpecificValues;

    private final String changeType;

    private CacheNodeTypeSpecificParameter(BuilderImpl builder) {
        this.parameterName = builder.parameterName;
        this.description = builder.description;
        this.source = builder.source;
        this.dataType = builder.dataType;
        this.allowedValues = builder.allowedValues;
        this.isModifiable = builder.isModifiable;
        this.minimumEngineVersion = builder.minimumEngineVersion;
        this.cacheNodeTypeSpecificValues = builder.cacheNodeTypeSpecificValues;
        this.changeType = builder.changeType;
    }

    /**
     * <p>
     * The name of the parameter.
     * </p>
     * 
     * @return The name of the parameter.
     */
    public final String parameterName() {
        return parameterName;
    }

    /**
     * <p>
     * A description of the parameter.
     * </p>
     * 
     * @return A description of the parameter.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The source of the parameter value.
     * </p>
     * 
     * @return The source of the parameter value.
     */
    public final String source() {
        return source;
    }

    /**
     * <p>
     * The valid data type for the parameter.
     * </p>
     * 
     * @return The valid data type for the parameter.
     */
    public final String dataType() {
        return dataType;
    }

    /**
     * <p>
     * The valid range of values for the parameter.
     * </p>
     * 
     * @return The valid range of values for the parameter.
     */
    public final String allowedValues() {
        return allowedValues;
    }

    /**
     * <p>
     * Indicates whether (<code>true</code>) or not (<code>false</code>) the parameter can be modified. Some parameters
     * have security or operational implications that prevent them from being changed.
     * </p>
     * 
     * @return Indicates whether (<code>true</code>) or not (<code>false</code>) the parameter can be modified. Some
     *         parameters have security or operational implications that prevent them from being changed.
     */
    public final Boolean isModifiable() {
        return isModifiable;
    }

    /**
     * <p>
     * The earliest cache engine version to which the parameter can apply.
     * </p>
     * 
     * @return The earliest cache engine version to which the parameter can apply.
     */
    public final String minimumEngineVersion() {
        return minimumEngineVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the CacheNodeTypeSpecificValues property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCacheNodeTypeSpecificValues() {
        return cacheNodeTypeSpecificValues != null && !(cacheNodeTypeSpecificValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of cache node types and their corresponding values for this parameter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCacheNodeTypeSpecificValues} method.
     * </p>
     * 
     * @return A list of cache node types and their corresponding values for this parameter.
     */
    public final List<CacheNodeTypeSpecificValue> cacheNodeTypeSpecificValues() {
        return cacheNodeTypeSpecificValues;
    }

    /**
     * <p>
     * Indicates whether a change to the parameter is applied immediately or requires a reboot for the change to be
     * applied. You can force a reboot or wait until the next maintenance window's reboot. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.Rebooting.html">Rebooting a
     * Cluster</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #changeType} will
     * return {@link ChangeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #changeTypeAsString}.
     * </p>
     * 
     * @return Indicates whether a change to the parameter is applied immediately or requires a reboot for the change to
     *         be applied. You can force a reboot or wait until the next maintenance window's reboot. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.Rebooting.html">Rebooting a
     *         Cluster</a>.
     * @see ChangeType
     */
    public final ChangeType changeType() {
        return ChangeType.fromValue(changeType);
    }

    /**
     * <p>
     * Indicates whether a change to the parameter is applied immediately or requires a reboot for the change to be
     * applied. You can force a reboot or wait until the next maintenance window's reboot. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.Rebooting.html">Rebooting a
     * Cluster</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #changeType} will
     * return {@link ChangeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #changeTypeAsString}.
     * </p>
     * 
     * @return Indicates whether a change to the parameter is applied immediately or requires a reboot for the change to
     *         be applied. You can force a reboot or wait until the next maintenance window's reboot. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.Rebooting.html">Rebooting a
     *         Cluster</a>.
     * @see ChangeType
     */
    public final String changeTypeAsString() {
        return changeType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(parameterName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(dataType());
        hashCode = 31 * hashCode + Objects.hashCode(allowedValues());
        hashCode = 31 * hashCode + Objects.hashCode(isModifiable());
        hashCode = 31 * hashCode + Objects.hashCode(minimumEngineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hasCacheNodeTypeSpecificValues() ? cacheNodeTypeSpecificValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(changeTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CacheNodeTypeSpecificParameter)) {
            return false;
        }
        CacheNodeTypeSpecificParameter other = (CacheNodeTypeSpecificParameter) obj;
        return Objects.equals(parameterName(), other.parameterName()) && Objects.equals(description(), other.description())
                && Objects.equals(source(), other.source()) && Objects.equals(dataType(), other.dataType())
                && Objects.equals(allowedValues(), other.allowedValues()) && Objects.equals(isModifiable(), other.isModifiable())
                && Objects.equals(minimumEngineVersion(), other.minimumEngineVersion())
                && hasCacheNodeTypeSpecificValues() == other.hasCacheNodeTypeSpecificValues()
                && Objects.equals(cacheNodeTypeSpecificValues(), other.cacheNodeTypeSpecificValues())
                && Objects.equals(changeTypeAsString(), other.changeTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CacheNodeTypeSpecificParameter").add("ParameterName", parameterName())
                .add("Description", description()).add("Source", source()).add("DataType", dataType())
                .add("AllowedValues", allowedValues()).add("IsModifiable", isModifiable())
                .add("MinimumEngineVersion", minimumEngineVersion())
                .add("CacheNodeTypeSpecificValues", hasCacheNodeTypeSpecificValues() ? cacheNodeTypeSpecificValues() : null)
                .add("ChangeType", changeTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ParameterName":
            return Optional.ofNullable(clazz.cast(parameterName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        case "DataType":
            return Optional.ofNullable(clazz.cast(dataType()));
        case "AllowedValues":
            return Optional.ofNullable(clazz.cast(allowedValues()));
        case "IsModifiable":
            return Optional.ofNullable(clazz.cast(isModifiable()));
        case "MinimumEngineVersion":
            return Optional.ofNullable(clazz.cast(minimumEngineVersion()));
        case "CacheNodeTypeSpecificValues":
            return Optional.ofNullable(clazz.cast(cacheNodeTypeSpecificValues()));
        case "ChangeType":
            return Optional.ofNullable(clazz.cast(changeTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CacheNodeTypeSpecificParameter, T> g) {
        return obj -> g.apply((CacheNodeTypeSpecificParameter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CacheNodeTypeSpecificParameter> {
        /**
         * <p>
         * The name of the parameter.
         * </p>
         * 
         * @param parameterName
         *        The name of the parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterName(String parameterName);

        /**
         * <p>
         * A description of the parameter.
         * </p>
         * 
         * @param description
         *        A description of the parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The source of the parameter value.
         * </p>
         * 
         * @param source
         *        The source of the parameter value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(String source);

        /**
         * <p>
         * The valid data type for the parameter.
         * </p>
         * 
         * @param dataType
         *        The valid data type for the parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataType(String dataType);

        /**
         * <p>
         * The valid range of values for the parameter.
         * </p>
         * 
         * @param allowedValues
         *        The valid range of values for the parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedValues(String allowedValues);

        /**
         * <p>
         * Indicates whether (<code>true</code>) or not (<code>false</code>) the parameter can be modified. Some
         * parameters have security or operational implications that prevent them from being changed.
         * </p>
         * 
         * @param isModifiable
         *        Indicates whether (<code>true</code>) or not (<code>false</code>) the parameter can be modified. Some
         *        parameters have security or operational implications that prevent them from being changed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isModifiable(Boolean isModifiable);

        /**
         * <p>
         * The earliest cache engine version to which the parameter can apply.
         * </p>
         * 
         * @param minimumEngineVersion
         *        The earliest cache engine version to which the parameter can apply.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumEngineVersion(String minimumEngineVersion);

        /**
         * <p>
         * A list of cache node types and their corresponding values for this parameter.
         * </p>
         * 
         * @param cacheNodeTypeSpecificValues
         *        A list of cache node types and their corresponding values for this parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheNodeTypeSpecificValues(Collection<CacheNodeTypeSpecificValue> cacheNodeTypeSpecificValues);

        /**
         * <p>
         * A list of cache node types and their corresponding values for this parameter.
         * </p>
         * 
         * @param cacheNodeTypeSpecificValues
         *        A list of cache node types and their corresponding values for this parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheNodeTypeSpecificValues(CacheNodeTypeSpecificValue... cacheNodeTypeSpecificValues);

        /**
         * <p>
         * A list of cache node types and their corresponding values for this parameter.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.elasticache.model.CacheNodeTypeSpecificValue.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.elasticache.model.CacheNodeTypeSpecificValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.elasticache.model.CacheNodeTypeSpecificValue.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #cacheNodeTypeSpecificValues(List<CacheNodeTypeSpecificValue>)}.
         * 
         * @param cacheNodeTypeSpecificValues
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.elasticache.model.CacheNodeTypeSpecificValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cacheNodeTypeSpecificValues(java.util.Collection<CacheNodeTypeSpecificValue>)
         */
        Builder cacheNodeTypeSpecificValues(Consumer<CacheNodeTypeSpecificValue.Builder>... cacheNodeTypeSpecificValues);

        /**
         * <p>
         * Indicates whether a change to the parameter is applied immediately or requires a reboot for the change to be
         * applied. You can force a reboot or wait until the next maintenance window's reboot. For more information, see
         * <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.Rebooting.html">Rebooting a
         * Cluster</a>.
         * </p>
         * 
         * @param changeType
         *        Indicates whether a change to the parameter is applied immediately or requires a reboot for the change
         *        to be applied. You can force a reboot or wait until the next maintenance window's reboot. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.Rebooting.html">Rebooting a
         *        Cluster</a>.
         * @see ChangeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeType
         */
        Builder changeType(String changeType);

        /**
         * <p>
         * Indicates whether a change to the parameter is applied immediately or requires a reboot for the change to be
         * applied. You can force a reboot or wait until the next maintenance window's reboot. For more information, see
         * <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.Rebooting.html">Rebooting a
         * Cluster</a>.
         * </p>
         * 
         * @param changeType
         *        Indicates whether a change to the parameter is applied immediately or requires a reboot for the change
         *        to be applied. You can force a reboot or wait until the next maintenance window's reboot. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.Rebooting.html">Rebooting a
         *        Cluster</a>.
         * @see ChangeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeType
         */
        Builder changeType(ChangeType changeType);
    }

    static final class BuilderImpl implements Builder {
        private String parameterName;

        private String description;

        private String source;

        private String dataType;

        private String allowedValues;

        private Boolean isModifiable;

        private String minimumEngineVersion;

        private List<CacheNodeTypeSpecificValue> cacheNodeTypeSpecificValues = DefaultSdkAutoConstructList.getInstance();

        private String changeType;

        private BuilderImpl() {
        }

        private BuilderImpl(CacheNodeTypeSpecificParameter model) {
            parameterName(model.parameterName);
            description(model.description);
            source(model.source);
            dataType(model.dataType);
            allowedValues(model.allowedValues);
            isModifiable(model.isModifiable);
            minimumEngineVersion(model.minimumEngineVersion);
            cacheNodeTypeSpecificValues(model.cacheNodeTypeSpecificValues);
            changeType(model.changeType);
        }

        public final String getParameterName() {
            return parameterName;
        }

        public final void setParameterName(String parameterName) {
            this.parameterName = parameterName;
        }

        @Override
        public final Builder parameterName(String parameterName) {
            this.parameterName = parameterName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getSource() {
            return source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final String getDataType() {
            return dataType;
        }

        public final void setDataType(String dataType) {
            this.dataType = dataType;
        }

        @Override
        public final Builder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        public final String getAllowedValues() {
            return allowedValues;
        }

        public final void setAllowedValues(String allowedValues) {
            this.allowedValues = allowedValues;
        }

        @Override
        public final Builder allowedValues(String allowedValues) {
            this.allowedValues = allowedValues;
            return this;
        }

        public final Boolean getIsModifiable() {
            return isModifiable;
        }

        public final void setIsModifiable(Boolean isModifiable) {
            this.isModifiable = isModifiable;
        }

        @Override
        public final Builder isModifiable(Boolean isModifiable) {
            this.isModifiable = isModifiable;
            return this;
        }

        public final String getMinimumEngineVersion() {
            return minimumEngineVersion;
        }

        public final void setMinimumEngineVersion(String minimumEngineVersion) {
            this.minimumEngineVersion = minimumEngineVersion;
        }

        @Override
        public final Builder minimumEngineVersion(String minimumEngineVersion) {
            this.minimumEngineVersion = minimumEngineVersion;
            return this;
        }

        public final List<CacheNodeTypeSpecificValue.Builder> getCacheNodeTypeSpecificValues() {
            List<CacheNodeTypeSpecificValue.Builder> result = CacheNodeTypeSpecificValueListCopier
                    .copyToBuilder(this.cacheNodeTypeSpecificValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCacheNodeTypeSpecificValues(
                Collection<CacheNodeTypeSpecificValue.BuilderImpl> cacheNodeTypeSpecificValues) {
            this.cacheNodeTypeSpecificValues = CacheNodeTypeSpecificValueListCopier.copyFromBuilder(cacheNodeTypeSpecificValues);
        }

        @Override
        public final Builder cacheNodeTypeSpecificValues(Collection<CacheNodeTypeSpecificValue> cacheNodeTypeSpecificValues) {
            this.cacheNodeTypeSpecificValues = CacheNodeTypeSpecificValueListCopier.copy(cacheNodeTypeSpecificValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheNodeTypeSpecificValues(CacheNodeTypeSpecificValue... cacheNodeTypeSpecificValues) {
            cacheNodeTypeSpecificValues(Arrays.asList(cacheNodeTypeSpecificValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheNodeTypeSpecificValues(
                Consumer<CacheNodeTypeSpecificValue.Builder>... cacheNodeTypeSpecificValues) {
            cacheNodeTypeSpecificValues(Stream.of(cacheNodeTypeSpecificValues)
                    .map(c -> CacheNodeTypeSpecificValue.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getChangeType() {
            return changeType;
        }

        public final void setChangeType(String changeType) {
            this.changeType = changeType;
        }

        @Override
        public final Builder changeType(String changeType) {
            this.changeType = changeType;
            return this;
        }

        @Override
        public final Builder changeType(ChangeType changeType) {
            this.changeType(changeType == null ? null : changeType.toString());
            return this;
        }

        @Override
        public CacheNodeTypeSpecificParameter build() {
            return new CacheNodeTypeSpecificParameter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
