/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elasticache.ElastiCacheAsyncClient;
import software.amazon.awssdk.services.elasticache.model.DescribeGlobalReplicationGroupsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeGlobalReplicationGroupsResponse;
import software.amazon.awssdk.services.elasticache.model.GlobalReplicationGroup;

public class DescribeGlobalReplicationGroupsPublisher
implements SdkPublisher<DescribeGlobalReplicationGroupsResponse> {
    private final ElastiCacheAsyncClient client;
    private final DescribeGlobalReplicationGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeGlobalReplicationGroupsPublisher(ElastiCacheAsyncClient client, DescribeGlobalReplicationGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeGlobalReplicationGroupsPublisher(ElastiCacheAsyncClient client, DescribeGlobalReplicationGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeGlobalReplicationGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeGlobalReplicationGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<GlobalReplicationGroup> globalReplicationGroups() {
        Function<DescribeGlobalReplicationGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.globalReplicationGroups() != null) {
                return response.globalReplicationGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeGlobalReplicationGroupsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeGlobalReplicationGroupsResponseFetcher
    implements AsyncPageFetcher<DescribeGlobalReplicationGroupsResponse> {
        private DescribeGlobalReplicationGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeGlobalReplicationGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeGlobalReplicationGroupsResponse> nextPage(DescribeGlobalReplicationGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeGlobalReplicationGroupsPublisher.this.client.describeGlobalReplicationGroups(DescribeGlobalReplicationGroupsPublisher.this.firstRequest);
            }
            return DescribeGlobalReplicationGroupsPublisher.this.client.describeGlobalReplicationGroups((DescribeGlobalReplicationGroupsRequest)((Object)DescribeGlobalReplicationGroupsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

