/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheRequest;
import software.amazon.awssdk.services.elasticache.model.SubnetIdentifierListCopier;
import software.amazon.awssdk.services.elasticache.model.Tag;
import software.amazon.awssdk.services.elasticache.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCacheSubnetGroupRequest
extends ElastiCacheRequest
implements ToCopyableBuilder<Builder, CreateCacheSubnetGroupRequest> {
    private static final SdkField<String> CACHE_SUBNET_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CacheSubnetGroupName").getter(CreateCacheSubnetGroupRequest.getter(CreateCacheSubnetGroupRequest::cacheSubnetGroupName)).setter(CreateCacheSubnetGroupRequest.setter(Builder::cacheSubnetGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheSubnetGroupName").build()}).build();
    private static final SdkField<String> CACHE_SUBNET_GROUP_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CacheSubnetGroupDescription").getter(CreateCacheSubnetGroupRequest.getter(CreateCacheSubnetGroupRequest::cacheSubnetGroupDescription)).setter(CreateCacheSubnetGroupRequest.setter(Builder::cacheSubnetGroupDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheSubnetGroupDescription").build()}).build();
    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubnetIds").getter(CreateCacheSubnetGroupRequest.getter(CreateCacheSubnetGroupRequest::subnetIds)).setter(CreateCacheSubnetGroupRequest.setter(Builder::subnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIds").build(), ListTrait.builder().memberLocationName("SubnetIdentifier").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIdentifier").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateCacheSubnetGroupRequest.getter(CreateCacheSubnetGroupRequest::tags)).setter(CreateCacheSubnetGroupRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName("Tag").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tag").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CACHE_SUBNET_GROUP_NAME_FIELD, CACHE_SUBNET_GROUP_DESCRIPTION_FIELD, SUBNET_IDS_FIELD, TAGS_FIELD));
    private final String cacheSubnetGroupName;
    private final String cacheSubnetGroupDescription;
    private final List<String> subnetIds;
    private final List<Tag> tags;

    private CreateCacheSubnetGroupRequest(BuilderImpl builder) {
        super(builder);
        this.cacheSubnetGroupName = builder.cacheSubnetGroupName;
        this.cacheSubnetGroupDescription = builder.cacheSubnetGroupDescription;
        this.subnetIds = builder.subnetIds;
        this.tags = builder.tags;
    }

    public final String cacheSubnetGroupName() {
        return this.cacheSubnetGroupName;
    }

    public final String cacheSubnetGroupDescription() {
        return this.cacheSubnetGroupDescription;
    }

    public final boolean hasSubnetIds() {
        return this.subnetIds != null && !(this.subnetIds instanceof SdkAutoConstructList);
    }

    public final List<String> subnetIds() {
        return this.subnetIds;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheSubnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheSubnetGroupDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnetIds() ? this.subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCacheSubnetGroupRequest)) {
            return false;
        }
        CreateCacheSubnetGroupRequest other = (CreateCacheSubnetGroupRequest)((Object)obj);
        return Objects.equals(this.cacheSubnetGroupName(), other.cacheSubnetGroupName()) && Objects.equals(this.cacheSubnetGroupDescription(), other.cacheSubnetGroupDescription()) && this.hasSubnetIds() == other.hasSubnetIds() && Objects.equals(this.subnetIds(), other.subnetIds()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateCacheSubnetGroupRequest").add("CacheSubnetGroupName", (Object)this.cacheSubnetGroupName()).add("CacheSubnetGroupDescription", (Object)this.cacheSubnetGroupDescription()).add("SubnetIds", this.hasSubnetIds() ? this.subnetIds() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CacheSubnetGroupName": {
                return Optional.ofNullable(clazz.cast(this.cacheSubnetGroupName()));
            }
            case "CacheSubnetGroupDescription": {
                return Optional.ofNullable(clazz.cast(this.cacheSubnetGroupDescription()));
            }
            case "SubnetIds": {
                return Optional.ofNullable(clazz.cast(this.subnetIds()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCacheSubnetGroupRequest, T> g) {
        return obj -> g.apply((CreateCacheSubnetGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElastiCacheRequest.BuilderImpl
    implements Builder {
        private String cacheSubnetGroupName;
        private String cacheSubnetGroupDescription;
        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCacheSubnetGroupRequest model) {
            super(model);
            this.cacheSubnetGroupName(model.cacheSubnetGroupName);
            this.cacheSubnetGroupDescription(model.cacheSubnetGroupDescription);
            this.subnetIds(model.subnetIds);
            this.tags(model.tags);
        }

        public final String getCacheSubnetGroupName() {
            return this.cacheSubnetGroupName;
        }

        public final void setCacheSubnetGroupName(String cacheSubnetGroupName) {
            this.cacheSubnetGroupName = cacheSubnetGroupName;
        }

        @Override
        @Transient
        public final Builder cacheSubnetGroupName(String cacheSubnetGroupName) {
            this.cacheSubnetGroupName = cacheSubnetGroupName;
            return this;
        }

        public final String getCacheSubnetGroupDescription() {
            return this.cacheSubnetGroupDescription;
        }

        public final void setCacheSubnetGroupDescription(String cacheSubnetGroupDescription) {
            this.cacheSubnetGroupDescription = cacheSubnetGroupDescription;
        }

        @Override
        @Transient
        public final Builder cacheSubnetGroupDescription(String cacheSubnetGroupDescription) {
            this.cacheSubnetGroupDescription = cacheSubnetGroupDescription;
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (this.subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdentifierListCopier.copy(subnetIds);
        }

        @Override
        @Transient
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdentifierListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCacheSubnetGroupRequest build() {
            return new CreateCacheSubnetGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElastiCacheRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCacheSubnetGroupRequest> {
        public Builder cacheSubnetGroupName(String var1);

        public Builder cacheSubnetGroupDescription(String var1);

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

