/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyUserGroupRequest extends ElastiCacheRequest implements
        ToCopyableBuilder<ModifyUserGroupRequest.Builder, ModifyUserGroupRequest> {
    private static final SdkField<String> USER_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserGroupId").getter(getter(ModifyUserGroupRequest::userGroupId)).setter(setter(Builder::userGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserGroupId").build()).build();

    private static final SdkField<List<String>> USER_IDS_TO_ADD_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("UserIdsToAdd")
            .getter(getter(ModifyUserGroupRequest::userIdsToAdd))
            .setter(setter(Builder::userIdsToAdd))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserIdsToAdd").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> USER_IDS_TO_REMOVE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("UserIdsToRemove")
            .getter(getter(ModifyUserGroupRequest::userIdsToRemove))
            .setter(setter(Builder::userIdsToRemove))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserIdsToRemove").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_GROUP_ID_FIELD,
            USER_IDS_TO_ADD_FIELD, USER_IDS_TO_REMOVE_FIELD));

    private final String userGroupId;

    private final List<String> userIdsToAdd;

    private final List<String> userIdsToRemove;

    private ModifyUserGroupRequest(BuilderImpl builder) {
        super(builder);
        this.userGroupId = builder.userGroupId;
        this.userIdsToAdd = builder.userIdsToAdd;
        this.userIdsToRemove = builder.userIdsToRemove;
    }

    /**
     * <p>
     * The ID of the user group.
     * </p>
     * 
     * @return The ID of the user group.
     */
    public final String userGroupId() {
        return userGroupId;
    }

    /**
     * Returns true if the UserIdsToAdd property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasUserIdsToAdd() {
        return userIdsToAdd != null && !(userIdsToAdd instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of user IDs to add to the user group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUserIdsToAdd()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of user IDs to add to the user group.
     */
    public final List<String> userIdsToAdd() {
        return userIdsToAdd;
    }

    /**
     * Returns true if the UserIdsToRemove property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasUserIdsToRemove() {
        return userIdsToRemove != null && !(userIdsToRemove instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of user IDs to remove from the user group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUserIdsToRemove()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of user IDs to remove from the user group.
     */
    public final List<String> userIdsToRemove() {
        return userIdsToRemove;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(userGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(hasUserIdsToAdd() ? userIdsToAdd() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUserIdsToRemove() ? userIdsToRemove() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyUserGroupRequest)) {
            return false;
        }
        ModifyUserGroupRequest other = (ModifyUserGroupRequest) obj;
        return Objects.equals(userGroupId(), other.userGroupId()) && hasUserIdsToAdd() == other.hasUserIdsToAdd()
                && Objects.equals(userIdsToAdd(), other.userIdsToAdd()) && hasUserIdsToRemove() == other.hasUserIdsToRemove()
                && Objects.equals(userIdsToRemove(), other.userIdsToRemove());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyUserGroupRequest").add("UserGroupId", userGroupId())
                .add("UserIdsToAdd", hasUserIdsToAdd() ? userIdsToAdd() : null)
                .add("UserIdsToRemove", hasUserIdsToRemove() ? userIdsToRemove() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserGroupId":
            return Optional.ofNullable(clazz.cast(userGroupId()));
        case "UserIdsToAdd":
            return Optional.ofNullable(clazz.cast(userIdsToAdd()));
        case "UserIdsToRemove":
            return Optional.ofNullable(clazz.cast(userIdsToRemove()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyUserGroupRequest, T> g) {
        return obj -> g.apply((ModifyUserGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElastiCacheRequest.Builder, SdkPojo, CopyableBuilder<Builder, ModifyUserGroupRequest> {
        /**
         * <p>
         * The ID of the user group.
         * </p>
         * 
         * @param userGroupId
         *        The ID of the user group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userGroupId(String userGroupId);

        /**
         * <p>
         * The list of user IDs to add to the user group.
         * </p>
         * 
         * @param userIdsToAdd
         *        The list of user IDs to add to the user group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userIdsToAdd(Collection<String> userIdsToAdd);

        /**
         * <p>
         * The list of user IDs to add to the user group.
         * </p>
         * 
         * @param userIdsToAdd
         *        The list of user IDs to add to the user group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userIdsToAdd(String... userIdsToAdd);

        /**
         * <p>
         * The list of user IDs to remove from the user group.
         * </p>
         * 
         * @param userIdsToRemove
         *        The list of user IDs to remove from the user group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userIdsToRemove(Collection<String> userIdsToRemove);

        /**
         * <p>
         * The list of user IDs to remove from the user group.
         * </p>
         * 
         * @param userIdsToRemove
         *        The list of user IDs to remove from the user group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userIdsToRemove(String... userIdsToRemove);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElastiCacheRequest.BuilderImpl implements Builder {
        private String userGroupId;

        private List<String> userIdsToAdd = DefaultSdkAutoConstructList.getInstance();

        private List<String> userIdsToRemove = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyUserGroupRequest model) {
            super(model);
            userGroupId(model.userGroupId);
            userIdsToAdd(model.userIdsToAdd);
            userIdsToRemove(model.userIdsToRemove);
        }

        public final String getUserGroupId() {
            return userGroupId;
        }

        @Override
        public final Builder userGroupId(String userGroupId) {
            this.userGroupId = userGroupId;
            return this;
        }

        public final void setUserGroupId(String userGroupId) {
            this.userGroupId = userGroupId;
        }

        public final Collection<String> getUserIdsToAdd() {
            if (userIdsToAdd instanceof SdkAutoConstructList) {
                return null;
            }
            return userIdsToAdd;
        }

        @Override
        public final Builder userIdsToAdd(Collection<String> userIdsToAdd) {
            this.userIdsToAdd = UserIdListInputCopier.copy(userIdsToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userIdsToAdd(String... userIdsToAdd) {
            userIdsToAdd(Arrays.asList(userIdsToAdd));
            return this;
        }

        public final void setUserIdsToAdd(Collection<String> userIdsToAdd) {
            this.userIdsToAdd = UserIdListInputCopier.copy(userIdsToAdd);
        }

        public final Collection<String> getUserIdsToRemove() {
            if (userIdsToRemove instanceof SdkAutoConstructList) {
                return null;
            }
            return userIdsToRemove;
        }

        @Override
        public final Builder userIdsToRemove(Collection<String> userIdsToRemove) {
            this.userIdsToRemove = UserIdListInputCopier.copy(userIdsToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userIdsToRemove(String... userIdsToRemove) {
            userIdsToRemove(Arrays.asList(userIdsToRemove));
            return this;
        }

        public final void setUserIdsToRemove(Collection<String> userIdsToRemove) {
            this.userIdsToRemove = UserIdListInputCopier.copy(userIdsToRemove);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyUserGroupRequest build() {
            return new ModifyUserGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
