/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The name of the Global Datastore and role of this replication group in the Global Datastore.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GlobalReplicationGroupInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<GlobalReplicationGroupInfo.Builder, GlobalReplicationGroupInfo> {
    private static final SdkField<String> GLOBAL_REPLICATION_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GlobalReplicationGroupId").getter(getter(GlobalReplicationGroupInfo::globalReplicationGroupId))
            .setter(setter(Builder::globalReplicationGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalReplicationGroupId").build())
            .build();

    private static final SdkField<String> GLOBAL_REPLICATION_GROUP_MEMBER_ROLE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("GlobalReplicationGroupMemberRole")
            .getter(getter(GlobalReplicationGroupInfo::globalReplicationGroupMemberRole))
            .setter(setter(Builder::globalReplicationGroupMemberRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalReplicationGroupMemberRole")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            GLOBAL_REPLICATION_GROUP_ID_FIELD, GLOBAL_REPLICATION_GROUP_MEMBER_ROLE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String globalReplicationGroupId;

    private final String globalReplicationGroupMemberRole;

    private GlobalReplicationGroupInfo(BuilderImpl builder) {
        this.globalReplicationGroupId = builder.globalReplicationGroupId;
        this.globalReplicationGroupMemberRole = builder.globalReplicationGroupMemberRole;
    }

    /**
     * <p>
     * The name of the Global Datastore
     * </p>
     * 
     * @return The name of the Global Datastore
     */
    public final String globalReplicationGroupId() {
        return globalReplicationGroupId;
    }

    /**
     * <p>
     * The role of the replication group in a Global Datastore. Can be primary or secondary.
     * </p>
     * 
     * @return The role of the replication group in a Global Datastore. Can be primary or secondary.
     */
    public final String globalReplicationGroupMemberRole() {
        return globalReplicationGroupMemberRole;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(globalReplicationGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(globalReplicationGroupMemberRole());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GlobalReplicationGroupInfo)) {
            return false;
        }
        GlobalReplicationGroupInfo other = (GlobalReplicationGroupInfo) obj;
        return Objects.equals(globalReplicationGroupId(), other.globalReplicationGroupId())
                && Objects.equals(globalReplicationGroupMemberRole(), other.globalReplicationGroupMemberRole());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GlobalReplicationGroupInfo").add("GlobalReplicationGroupId", globalReplicationGroupId())
                .add("GlobalReplicationGroupMemberRole", globalReplicationGroupMemberRole()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GlobalReplicationGroupId":
            return Optional.ofNullable(clazz.cast(globalReplicationGroupId()));
        case "GlobalReplicationGroupMemberRole":
            return Optional.ofNullable(clazz.cast(globalReplicationGroupMemberRole()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GlobalReplicationGroupInfo, T> g) {
        return obj -> g.apply((GlobalReplicationGroupInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GlobalReplicationGroupInfo> {
        /**
         * <p>
         * The name of the Global Datastore
         * </p>
         * 
         * @param globalReplicationGroupId
         *        The name of the Global Datastore
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalReplicationGroupId(String globalReplicationGroupId);

        /**
         * <p>
         * The role of the replication group in a Global Datastore. Can be primary or secondary.
         * </p>
         * 
         * @param globalReplicationGroupMemberRole
         *        The role of the replication group in a Global Datastore. Can be primary or secondary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalReplicationGroupMemberRole(String globalReplicationGroupMemberRole);
    }

    static final class BuilderImpl implements Builder {
        private String globalReplicationGroupId;

        private String globalReplicationGroupMemberRole;

        private BuilderImpl() {
        }

        private BuilderImpl(GlobalReplicationGroupInfo model) {
            globalReplicationGroupId(model.globalReplicationGroupId);
            globalReplicationGroupMemberRole(model.globalReplicationGroupMemberRole);
        }

        public final String getGlobalReplicationGroupId() {
            return globalReplicationGroupId;
        }

        @Override
        public final Builder globalReplicationGroupId(String globalReplicationGroupId) {
            this.globalReplicationGroupId = globalReplicationGroupId;
            return this;
        }

        public final void setGlobalReplicationGroupId(String globalReplicationGroupId) {
            this.globalReplicationGroupId = globalReplicationGroupId;
        }

        public final String getGlobalReplicationGroupMemberRole() {
            return globalReplicationGroupMemberRole;
        }

        @Override
        public final Builder globalReplicationGroupMemberRole(String globalReplicationGroupMemberRole) {
            this.globalReplicationGroupMemberRole = globalReplicationGroupMemberRole;
            return this;
        }

        public final void setGlobalReplicationGroupMemberRole(String globalReplicationGroupMemberRole) {
            this.globalReplicationGroupMemberRole = globalReplicationGroupMemberRole;
        }

        @Override
        public GlobalReplicationGroupInfo build() {
            return new GlobalReplicationGroupInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
