/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>DescribeEngineDefaultParameters</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EngineDefaults implements SdkPojo, Serializable, ToCopyableBuilder<EngineDefaults.Builder, EngineDefaults> {
    private static final SdkField<String> CACHE_PARAMETER_GROUP_FAMILY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CacheParameterGroupFamily").getter(getter(EngineDefaults::cacheParameterGroupFamily))
            .setter(setter(Builder::cacheParameterGroupFamily))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheParameterGroupFamily").build())
            .build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(EngineDefaults::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<List<Parameter>> PARAMETERS_FIELD = SdkField
            .<List<Parameter>> builder(MarshallingType.LIST)
            .memberName("Parameters")
            .getter(getter(EngineDefaults::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Parameter")
                            .memberFieldInfo(
                                    SdkField.<Parameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Parameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Parameter").build()).build()).build()).build();

    private static final SdkField<List<CacheNodeTypeSpecificParameter>> CACHE_NODE_TYPE_SPECIFIC_PARAMETERS_FIELD = SdkField
            .<List<CacheNodeTypeSpecificParameter>> builder(MarshallingType.LIST)
            .memberName("CacheNodeTypeSpecificParameters")
            .getter(getter(EngineDefaults::cacheNodeTypeSpecificParameters))
            .setter(setter(Builder::cacheNodeTypeSpecificParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheNodeTypeSpecificParameters")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName("CacheNodeTypeSpecificParameter")
                            .memberFieldInfo(
                                    SdkField.<CacheNodeTypeSpecificParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(CacheNodeTypeSpecificParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("CacheNodeTypeSpecificParameter").build()).build()).build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CACHE_PARAMETER_GROUP_FAMILY_FIELD, MARKER_FIELD, PARAMETERS_FIELD, CACHE_NODE_TYPE_SPECIFIC_PARAMETERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String cacheParameterGroupFamily;

    private final String marker;

    private final List<Parameter> parameters;

    private final List<CacheNodeTypeSpecificParameter> cacheNodeTypeSpecificParameters;

    private EngineDefaults(BuilderImpl builder) {
        this.cacheParameterGroupFamily = builder.cacheParameterGroupFamily;
        this.marker = builder.marker;
        this.parameters = builder.parameters;
        this.cacheNodeTypeSpecificParameters = builder.cacheNodeTypeSpecificParameters;
    }

    /**
     * <p>
     * Specifies the name of the cache parameter group family to which the engine default parameters apply.
     * </p>
     * <p>
     * Valid values are: <code>memcached1.4</code> | <code>memcached1.5</code> | <code>memcached1.6</code> |
     * <code>redis2.6</code> | <code>redis2.8</code> | <code>redis3.2</code> | <code>redis4.0</code> |
     * <code>redis5.0</code> | <code>redis6.x</code> |
     * </p>
     * 
     * @return Specifies the name of the cache parameter group family to which the engine default parameters apply.</p>
     *         <p>
     *         Valid values are: <code>memcached1.4</code> | <code>memcached1.5</code> | <code>memcached1.6</code> |
     *         <code>redis2.6</code> | <code>redis2.8</code> | <code>redis3.2</code> | <code>redis4.0</code> |
     *         <code>redis5.0</code> | <code>redis6.x</code> |
     */
    public final String cacheParameterGroupFamily() {
        return cacheParameterGroupFamily;
    }

    /**
     * <p>
     * Provides an identifier to allow retrieval of paginated results.
     * </p>
     * 
     * @return Provides an identifier to allow retrieval of paginated results.
     */
    public final String marker() {
        return marker;
    }

    /**
     * Returns true if the Parameters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains a list of engine default parameters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasParameters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Contains a list of engine default parameters.
     */
    public final List<Parameter> parameters() {
        return parameters;
    }

    /**
     * Returns true if the CacheNodeTypeSpecificParameters property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public final boolean hasCacheNodeTypeSpecificParameters() {
        return cacheNodeTypeSpecificParameters != null && !(cacheNodeTypeSpecificParameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of parameters specific to a particular cache node type. Each element in the list contains detailed
     * information about one parameter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCacheNodeTypeSpecificParameters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of parameters specific to a particular cache node type. Each element in the list contains detailed
     *         information about one parameter.
     */
    public final List<CacheNodeTypeSpecificParameter> cacheNodeTypeSpecificParameters() {
        return cacheNodeTypeSpecificParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cacheParameterGroupFamily());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasCacheNodeTypeSpecificParameters() ? cacheNodeTypeSpecificParameters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EngineDefaults)) {
            return false;
        }
        EngineDefaults other = (EngineDefaults) obj;
        return Objects.equals(cacheParameterGroupFamily(), other.cacheParameterGroupFamily())
                && Objects.equals(marker(), other.marker()) && hasParameters() == other.hasParameters()
                && Objects.equals(parameters(), other.parameters())
                && hasCacheNodeTypeSpecificParameters() == other.hasCacheNodeTypeSpecificParameters()
                && Objects.equals(cacheNodeTypeSpecificParameters(), other.cacheNodeTypeSpecificParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("EngineDefaults")
                .add("CacheParameterGroupFamily", cacheParameterGroupFamily())
                .add("Marker", marker())
                .add("Parameters", hasParameters() ? parameters() : null)
                .add("CacheNodeTypeSpecificParameters",
                        hasCacheNodeTypeSpecificParameters() ? cacheNodeTypeSpecificParameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CacheParameterGroupFamily":
            return Optional.ofNullable(clazz.cast(cacheParameterGroupFamily()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "CacheNodeTypeSpecificParameters":
            return Optional.ofNullable(clazz.cast(cacheNodeTypeSpecificParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EngineDefaults, T> g) {
        return obj -> g.apply((EngineDefaults) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EngineDefaults> {
        /**
         * <p>
         * Specifies the name of the cache parameter group family to which the engine default parameters apply.
         * </p>
         * <p>
         * Valid values are: <code>memcached1.4</code> | <code>memcached1.5</code> | <code>memcached1.6</code> |
         * <code>redis2.6</code> | <code>redis2.8</code> | <code>redis3.2</code> | <code>redis4.0</code> |
         * <code>redis5.0</code> | <code>redis6.x</code> |
         * </p>
         * 
         * @param cacheParameterGroupFamily
         *        Specifies the name of the cache parameter group family to which the engine default parameters
         *        apply.</p>
         *        <p>
         *        Valid values are: <code>memcached1.4</code> | <code>memcached1.5</code> | <code>memcached1.6</code> |
         *        <code>redis2.6</code> | <code>redis2.8</code> | <code>redis3.2</code> | <code>redis4.0</code> |
         *        <code>redis5.0</code> | <code>redis6.x</code> |
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheParameterGroupFamily(String cacheParameterGroupFamily);

        /**
         * <p>
         * Provides an identifier to allow retrieval of paginated results.
         * </p>
         * 
         * @param marker
         *        Provides an identifier to allow retrieval of paginated results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * Contains a list of engine default parameters.
         * </p>
         * 
         * @param parameters
         *        Contains a list of engine default parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Collection<Parameter> parameters);

        /**
         * <p>
         * Contains a list of engine default parameters.
         * </p>
         * 
         * @param parameters
         *        Contains a list of engine default parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Parameter... parameters);

        /**
         * <p>
         * Contains a list of engine default parameters.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Parameter>.Builder} avoiding the need to
         * create one manually via {@link List<Parameter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Parameter>.Builder#build()} is called immediately and its
         * result is passed to {@link #parameters(List<Parameter>)}.
         * 
         * @param parameters
         *        a consumer that will call methods on {@link List<Parameter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameters(List<Parameter>)
         */
        Builder parameters(Consumer<Parameter.Builder>... parameters);

        /**
         * <p>
         * A list of parameters specific to a particular cache node type. Each element in the list contains detailed
         * information about one parameter.
         * </p>
         * 
         * @param cacheNodeTypeSpecificParameters
         *        A list of parameters specific to a particular cache node type. Each element in the list contains
         *        detailed information about one parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheNodeTypeSpecificParameters(Collection<CacheNodeTypeSpecificParameter> cacheNodeTypeSpecificParameters);

        /**
         * <p>
         * A list of parameters specific to a particular cache node type. Each element in the list contains detailed
         * information about one parameter.
         * </p>
         * 
         * @param cacheNodeTypeSpecificParameters
         *        A list of parameters specific to a particular cache node type. Each element in the list contains
         *        detailed information about one parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheNodeTypeSpecificParameters(CacheNodeTypeSpecificParameter... cacheNodeTypeSpecificParameters);

        /**
         * <p>
         * A list of parameters specific to a particular cache node type. Each element in the list contains detailed
         * information about one parameter.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CacheNodeTypeSpecificParameter>.Builder}
         * avoiding the need to create one manually via {@link List<CacheNodeTypeSpecificParameter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CacheNodeTypeSpecificParameter>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #cacheNodeTypeSpecificParameters(List<CacheNodeTypeSpecificParameter>)}.
         * 
         * @param cacheNodeTypeSpecificParameters
         *        a consumer that will call methods on {@link List<CacheNodeTypeSpecificParameter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cacheNodeTypeSpecificParameters(List<CacheNodeTypeSpecificParameter>)
         */
        Builder cacheNodeTypeSpecificParameters(
                Consumer<CacheNodeTypeSpecificParameter.Builder>... cacheNodeTypeSpecificParameters);
    }

    static final class BuilderImpl implements Builder {
        private String cacheParameterGroupFamily;

        private String marker;

        private List<Parameter> parameters = DefaultSdkAutoConstructList.getInstance();

        private List<CacheNodeTypeSpecificParameter> cacheNodeTypeSpecificParameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EngineDefaults model) {
            cacheParameterGroupFamily(model.cacheParameterGroupFamily);
            marker(model.marker);
            parameters(model.parameters);
            cacheNodeTypeSpecificParameters(model.cacheNodeTypeSpecificParameters);
        }

        public final String getCacheParameterGroupFamily() {
            return cacheParameterGroupFamily;
        }

        @Override
        public final Builder cacheParameterGroupFamily(String cacheParameterGroupFamily) {
            this.cacheParameterGroupFamily = cacheParameterGroupFamily;
            return this;
        }

        public final void setCacheParameterGroupFamily(String cacheParameterGroupFamily) {
            this.cacheParameterGroupFamily = cacheParameterGroupFamily;
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<Parameter.Builder> getParameters() {
            if (parameters instanceof SdkAutoConstructList) {
                return null;
            }
            return parameters != null ? parameters.stream().map(Parameter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parameters(Collection<Parameter> parameters) {
            this.parameters = ParametersListCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Parameter... parameters) {
            parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<Parameter.Builder>... parameters) {
            parameters(Stream.of(parameters).map(c -> Parameter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setParameters(Collection<Parameter.BuilderImpl> parameters) {
            this.parameters = ParametersListCopier.copyFromBuilder(parameters);
        }

        public final Collection<CacheNodeTypeSpecificParameter.Builder> getCacheNodeTypeSpecificParameters() {
            if (cacheNodeTypeSpecificParameters instanceof SdkAutoConstructList) {
                return null;
            }
            return cacheNodeTypeSpecificParameters != null ? cacheNodeTypeSpecificParameters.stream()
                    .map(CacheNodeTypeSpecificParameter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder cacheNodeTypeSpecificParameters(
                Collection<CacheNodeTypeSpecificParameter> cacheNodeTypeSpecificParameters) {
            this.cacheNodeTypeSpecificParameters = CacheNodeTypeSpecificParametersListCopier
                    .copy(cacheNodeTypeSpecificParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheNodeTypeSpecificParameters(CacheNodeTypeSpecificParameter... cacheNodeTypeSpecificParameters) {
            cacheNodeTypeSpecificParameters(Arrays.asList(cacheNodeTypeSpecificParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheNodeTypeSpecificParameters(
                Consumer<CacheNodeTypeSpecificParameter.Builder>... cacheNodeTypeSpecificParameters) {
            cacheNodeTypeSpecificParameters(Stream.of(cacheNodeTypeSpecificParameters)
                    .map(c -> CacheNodeTypeSpecificParameter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCacheNodeTypeSpecificParameters(
                Collection<CacheNodeTypeSpecificParameter.BuilderImpl> cacheNodeTypeSpecificParameters) {
            this.cacheNodeTypeSpecificParameters = CacheNodeTypeSpecificParametersListCopier
                    .copyFromBuilder(cacheNodeTypeSpecificParameters);
        }

        @Override
        public EngineDefaults build() {
            return new EngineDefaults(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
