/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DecreaseNodeGroupsInGlobalReplicationGroupRequest extends ElastiCacheRequest
        implements
        ToCopyableBuilder<DecreaseNodeGroupsInGlobalReplicationGroupRequest.Builder, DecreaseNodeGroupsInGlobalReplicationGroupRequest> {
    private static final SdkField<String> GLOBAL_REPLICATION_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GlobalReplicationGroupId")
            .getter(getter(DecreaseNodeGroupsInGlobalReplicationGroupRequest::globalReplicationGroupId))
            .setter(setter(Builder::globalReplicationGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalReplicationGroupId").build())
            .build();

    private static final SdkField<Integer> NODE_GROUP_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NodeGroupCount").getter(getter(DecreaseNodeGroupsInGlobalReplicationGroupRequest::nodeGroupCount))
            .setter(setter(Builder::nodeGroupCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeGroupCount").build()).build();

    private static final SdkField<List<String>> GLOBAL_NODE_GROUPS_TO_REMOVE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("GlobalNodeGroupsToRemove")
            .getter(getter(DecreaseNodeGroupsInGlobalReplicationGroupRequest::globalNodeGroupsToRemove))
            .setter(setter(Builder::globalNodeGroupsToRemove))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalNodeGroupsToRemove").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("GlobalNodeGroupId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("GlobalNodeGroupId").build()).build()).build()).build();

    private static final SdkField<List<String>> GLOBAL_NODE_GROUPS_TO_RETAIN_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("GlobalNodeGroupsToRetain")
            .getter(getter(DecreaseNodeGroupsInGlobalReplicationGroupRequest::globalNodeGroupsToRetain))
            .setter(setter(Builder::globalNodeGroupsToRetain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalNodeGroupsToRetain").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("GlobalNodeGroupId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("GlobalNodeGroupId").build()).build()).build()).build();

    private static final SdkField<Boolean> APPLY_IMMEDIATELY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ApplyImmediately").getter(getter(DecreaseNodeGroupsInGlobalReplicationGroupRequest::applyImmediately))
            .setter(setter(Builder::applyImmediately))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplyImmediately").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            GLOBAL_REPLICATION_GROUP_ID_FIELD, NODE_GROUP_COUNT_FIELD, GLOBAL_NODE_GROUPS_TO_REMOVE_FIELD,
            GLOBAL_NODE_GROUPS_TO_RETAIN_FIELD, APPLY_IMMEDIATELY_FIELD));

    private final String globalReplicationGroupId;

    private final Integer nodeGroupCount;

    private final List<String> globalNodeGroupsToRemove;

    private final List<String> globalNodeGroupsToRetain;

    private final Boolean applyImmediately;

    private DecreaseNodeGroupsInGlobalReplicationGroupRequest(BuilderImpl builder) {
        super(builder);
        this.globalReplicationGroupId = builder.globalReplicationGroupId;
        this.nodeGroupCount = builder.nodeGroupCount;
        this.globalNodeGroupsToRemove = builder.globalNodeGroupsToRemove;
        this.globalNodeGroupsToRetain = builder.globalNodeGroupsToRetain;
        this.applyImmediately = builder.applyImmediately;
    }

    /**
     * <p>
     * The name of the Global Datastore
     * </p>
     * 
     * @return The name of the Global Datastore
     */
    public final String globalReplicationGroupId() {
        return globalReplicationGroupId;
    }

    /**
     * <p>
     * The number of node groups (shards) that results from the modification of the shard configuration
     * </p>
     * 
     * @return The number of node groups (shards) that results from the modification of the shard configuration
     */
    public final Integer nodeGroupCount() {
        return nodeGroupCount;
    }

    /**
     * Returns true if the GlobalNodeGroupsToRemove property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasGlobalNodeGroupsToRemove() {
        return globalNodeGroupsToRemove != null && !(globalNodeGroupsToRemove instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * If the value of NodeGroupCount is less than the current number of node groups (shards), then either
     * NodeGroupsToRemove or NodeGroupsToRetain is required. NodeGroupsToRemove is a list of NodeGroupIds to remove from
     * the cluster. ElastiCache for Redis will attempt to remove all node groups listed by NodeGroupsToRemove from the
     * cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasGlobalNodeGroupsToRemove()} to see if a value was sent in this field.
     * </p>
     * 
     * @return If the value of NodeGroupCount is less than the current number of node groups (shards), then either
     *         NodeGroupsToRemove or NodeGroupsToRetain is required. NodeGroupsToRemove is a list of NodeGroupIds to
     *         remove from the cluster. ElastiCache for Redis will attempt to remove all node groups listed by
     *         NodeGroupsToRemove from the cluster.
     */
    public final List<String> globalNodeGroupsToRemove() {
        return globalNodeGroupsToRemove;
    }

    /**
     * Returns true if the GlobalNodeGroupsToRetain property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasGlobalNodeGroupsToRetain() {
        return globalNodeGroupsToRetain != null && !(globalNodeGroupsToRetain instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * If the value of NodeGroupCount is less than the current number of node groups (shards), then either
     * NodeGroupsToRemove or NodeGroupsToRetain is required. NodeGroupsToRemove is a list of NodeGroupIds to remove from
     * the cluster. ElastiCache for Redis will attempt to remove all node groups listed by NodeGroupsToRemove from the
     * cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasGlobalNodeGroupsToRetain()} to see if a value was sent in this field.
     * </p>
     * 
     * @return If the value of NodeGroupCount is less than the current number of node groups (shards), then either
     *         NodeGroupsToRemove or NodeGroupsToRetain is required. NodeGroupsToRemove is a list of NodeGroupIds to
     *         remove from the cluster. ElastiCache for Redis will attempt to remove all node groups listed by
     *         NodeGroupsToRemove from the cluster.
     */
    public final List<String> globalNodeGroupsToRetain() {
        return globalNodeGroupsToRetain;
    }

    /**
     * <p>
     * Indicates that the shard reconfiguration process begins immediately. At present, the only permitted value for
     * this parameter is true.
     * </p>
     * 
     * @return Indicates that the shard reconfiguration process begins immediately. At present, the only permitted value
     *         for this parameter is true.
     */
    public final Boolean applyImmediately() {
        return applyImmediately;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(globalReplicationGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(nodeGroupCount());
        hashCode = 31 * hashCode + Objects.hashCode(hasGlobalNodeGroupsToRemove() ? globalNodeGroupsToRemove() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasGlobalNodeGroupsToRetain() ? globalNodeGroupsToRetain() : null);
        hashCode = 31 * hashCode + Objects.hashCode(applyImmediately());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DecreaseNodeGroupsInGlobalReplicationGroupRequest)) {
            return false;
        }
        DecreaseNodeGroupsInGlobalReplicationGroupRequest other = (DecreaseNodeGroupsInGlobalReplicationGroupRequest) obj;
        return Objects.equals(globalReplicationGroupId(), other.globalReplicationGroupId())
                && Objects.equals(nodeGroupCount(), other.nodeGroupCount())
                && hasGlobalNodeGroupsToRemove() == other.hasGlobalNodeGroupsToRemove()
                && Objects.equals(globalNodeGroupsToRemove(), other.globalNodeGroupsToRemove())
                && hasGlobalNodeGroupsToRetain() == other.hasGlobalNodeGroupsToRetain()
                && Objects.equals(globalNodeGroupsToRetain(), other.globalNodeGroupsToRetain())
                && Objects.equals(applyImmediately(), other.applyImmediately());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DecreaseNodeGroupsInGlobalReplicationGroupRequest")
                .add("GlobalReplicationGroupId", globalReplicationGroupId()).add("NodeGroupCount", nodeGroupCount())
                .add("GlobalNodeGroupsToRemove", hasGlobalNodeGroupsToRemove() ? globalNodeGroupsToRemove() : null)
                .add("GlobalNodeGroupsToRetain", hasGlobalNodeGroupsToRetain() ? globalNodeGroupsToRetain() : null)
                .add("ApplyImmediately", applyImmediately()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GlobalReplicationGroupId":
            return Optional.ofNullable(clazz.cast(globalReplicationGroupId()));
        case "NodeGroupCount":
            return Optional.ofNullable(clazz.cast(nodeGroupCount()));
        case "GlobalNodeGroupsToRemove":
            return Optional.ofNullable(clazz.cast(globalNodeGroupsToRemove()));
        case "GlobalNodeGroupsToRetain":
            return Optional.ofNullable(clazz.cast(globalNodeGroupsToRetain()));
        case "ApplyImmediately":
            return Optional.ofNullable(clazz.cast(applyImmediately()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DecreaseNodeGroupsInGlobalReplicationGroupRequest, T> g) {
        return obj -> g.apply((DecreaseNodeGroupsInGlobalReplicationGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElastiCacheRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DecreaseNodeGroupsInGlobalReplicationGroupRequest> {
        /**
         * <p>
         * The name of the Global Datastore
         * </p>
         * 
         * @param globalReplicationGroupId
         *        The name of the Global Datastore
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalReplicationGroupId(String globalReplicationGroupId);

        /**
         * <p>
         * The number of node groups (shards) that results from the modification of the shard configuration
         * </p>
         * 
         * @param nodeGroupCount
         *        The number of node groups (shards) that results from the modification of the shard configuration
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeGroupCount(Integer nodeGroupCount);

        /**
         * <p>
         * If the value of NodeGroupCount is less than the current number of node groups (shards), then either
         * NodeGroupsToRemove or NodeGroupsToRetain is required. NodeGroupsToRemove is a list of NodeGroupIds to remove
         * from the cluster. ElastiCache for Redis will attempt to remove all node groups listed by NodeGroupsToRemove
         * from the cluster.
         * </p>
         * 
         * @param globalNodeGroupsToRemove
         *        If the value of NodeGroupCount is less than the current number of node groups (shards), then either
         *        NodeGroupsToRemove or NodeGroupsToRetain is required. NodeGroupsToRemove is a list of NodeGroupIds to
         *        remove from the cluster. ElastiCache for Redis will attempt to remove all node groups listed by
         *        NodeGroupsToRemove from the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalNodeGroupsToRemove(Collection<String> globalNodeGroupsToRemove);

        /**
         * <p>
         * If the value of NodeGroupCount is less than the current number of node groups (shards), then either
         * NodeGroupsToRemove or NodeGroupsToRetain is required. NodeGroupsToRemove is a list of NodeGroupIds to remove
         * from the cluster. ElastiCache for Redis will attempt to remove all node groups listed by NodeGroupsToRemove
         * from the cluster.
         * </p>
         * 
         * @param globalNodeGroupsToRemove
         *        If the value of NodeGroupCount is less than the current number of node groups (shards), then either
         *        NodeGroupsToRemove or NodeGroupsToRetain is required. NodeGroupsToRemove is a list of NodeGroupIds to
         *        remove from the cluster. ElastiCache for Redis will attempt to remove all node groups listed by
         *        NodeGroupsToRemove from the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalNodeGroupsToRemove(String... globalNodeGroupsToRemove);

        /**
         * <p>
         * If the value of NodeGroupCount is less than the current number of node groups (shards), then either
         * NodeGroupsToRemove or NodeGroupsToRetain is required. NodeGroupsToRemove is a list of NodeGroupIds to remove
         * from the cluster. ElastiCache for Redis will attempt to remove all node groups listed by NodeGroupsToRemove
         * from the cluster.
         * </p>
         * 
         * @param globalNodeGroupsToRetain
         *        If the value of NodeGroupCount is less than the current number of node groups (shards), then either
         *        NodeGroupsToRemove or NodeGroupsToRetain is required. NodeGroupsToRemove is a list of NodeGroupIds to
         *        remove from the cluster. ElastiCache for Redis will attempt to remove all node groups listed by
         *        NodeGroupsToRemove from the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalNodeGroupsToRetain(Collection<String> globalNodeGroupsToRetain);

        /**
         * <p>
         * If the value of NodeGroupCount is less than the current number of node groups (shards), then either
         * NodeGroupsToRemove or NodeGroupsToRetain is required. NodeGroupsToRemove is a list of NodeGroupIds to remove
         * from the cluster. ElastiCache for Redis will attempt to remove all node groups listed by NodeGroupsToRemove
         * from the cluster.
         * </p>
         * 
         * @param globalNodeGroupsToRetain
         *        If the value of NodeGroupCount is less than the current number of node groups (shards), then either
         *        NodeGroupsToRemove or NodeGroupsToRetain is required. NodeGroupsToRemove is a list of NodeGroupIds to
         *        remove from the cluster. ElastiCache for Redis will attempt to remove all node groups listed by
         *        NodeGroupsToRemove from the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalNodeGroupsToRetain(String... globalNodeGroupsToRetain);

        /**
         * <p>
         * Indicates that the shard reconfiguration process begins immediately. At present, the only permitted value for
         * this parameter is true.
         * </p>
         * 
         * @param applyImmediately
         *        Indicates that the shard reconfiguration process begins immediately. At present, the only permitted
         *        value for this parameter is true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applyImmediately(Boolean applyImmediately);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElastiCacheRequest.BuilderImpl implements Builder {
        private String globalReplicationGroupId;

        private Integer nodeGroupCount;

        private List<String> globalNodeGroupsToRemove = DefaultSdkAutoConstructList.getInstance();

        private List<String> globalNodeGroupsToRetain = DefaultSdkAutoConstructList.getInstance();

        private Boolean applyImmediately;

        private BuilderImpl() {
        }

        private BuilderImpl(DecreaseNodeGroupsInGlobalReplicationGroupRequest model) {
            super(model);
            globalReplicationGroupId(model.globalReplicationGroupId);
            nodeGroupCount(model.nodeGroupCount);
            globalNodeGroupsToRemove(model.globalNodeGroupsToRemove);
            globalNodeGroupsToRetain(model.globalNodeGroupsToRetain);
            applyImmediately(model.applyImmediately);
        }

        public final String getGlobalReplicationGroupId() {
            return globalReplicationGroupId;
        }

        @Override
        public final Builder globalReplicationGroupId(String globalReplicationGroupId) {
            this.globalReplicationGroupId = globalReplicationGroupId;
            return this;
        }

        public final void setGlobalReplicationGroupId(String globalReplicationGroupId) {
            this.globalReplicationGroupId = globalReplicationGroupId;
        }

        public final Integer getNodeGroupCount() {
            return nodeGroupCount;
        }

        @Override
        public final Builder nodeGroupCount(Integer nodeGroupCount) {
            this.nodeGroupCount = nodeGroupCount;
            return this;
        }

        public final void setNodeGroupCount(Integer nodeGroupCount) {
            this.nodeGroupCount = nodeGroupCount;
        }

        public final Collection<String> getGlobalNodeGroupsToRemove() {
            if (globalNodeGroupsToRemove instanceof SdkAutoConstructList) {
                return null;
            }
            return globalNodeGroupsToRemove;
        }

        @Override
        public final Builder globalNodeGroupsToRemove(Collection<String> globalNodeGroupsToRemove) {
            this.globalNodeGroupsToRemove = GlobalNodeGroupIdListCopier.copy(globalNodeGroupsToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalNodeGroupsToRemove(String... globalNodeGroupsToRemove) {
            globalNodeGroupsToRemove(Arrays.asList(globalNodeGroupsToRemove));
            return this;
        }

        public final void setGlobalNodeGroupsToRemove(Collection<String> globalNodeGroupsToRemove) {
            this.globalNodeGroupsToRemove = GlobalNodeGroupIdListCopier.copy(globalNodeGroupsToRemove);
        }

        public final Collection<String> getGlobalNodeGroupsToRetain() {
            if (globalNodeGroupsToRetain instanceof SdkAutoConstructList) {
                return null;
            }
            return globalNodeGroupsToRetain;
        }

        @Override
        public final Builder globalNodeGroupsToRetain(Collection<String> globalNodeGroupsToRetain) {
            this.globalNodeGroupsToRetain = GlobalNodeGroupIdListCopier.copy(globalNodeGroupsToRetain);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalNodeGroupsToRetain(String... globalNodeGroupsToRetain) {
            globalNodeGroupsToRetain(Arrays.asList(globalNodeGroupsToRetain));
            return this;
        }

        public final void setGlobalNodeGroupsToRetain(Collection<String> globalNodeGroupsToRetain) {
            this.globalNodeGroupsToRetain = GlobalNodeGroupIdListCopier.copy(globalNodeGroupsToRetain);
        }

        public final Boolean getApplyImmediately() {
            return applyImmediately;
        }

        @Override
        public final Builder applyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
            return this;
        }

        public final void setApplyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DecreaseNodeGroupsInGlobalReplicationGroupRequest build() {
            return new DecreaseNodeGroupsInGlobalReplicationGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
