/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateUserRequest extends ElastiCacheRequest implements
        ToCopyableBuilder<CreateUserRequest.Builder, CreateUserRequest> {
    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("UserId")
            .getter(getter(CreateUserRequest::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()).build();

    private static final SdkField<String> USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserName").getter(getter(CreateUserRequest::userName)).setter(setter(Builder::userName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()).build();

    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Engine")
            .getter(getter(CreateUserRequest::engine)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()).build();

    private static final SdkField<List<String>> PASSWORDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Passwords")
            .getter(getter(CreateUserRequest::passwords))
            .setter(setter(Builder::passwords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Passwords").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ACCESS_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccessString").getter(getter(CreateUserRequest::accessString)).setter(setter(Builder::accessString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessString").build()).build();

    private static final SdkField<Boolean> NO_PASSWORD_REQUIRED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("NoPasswordRequired").getter(getter(CreateUserRequest::noPasswordRequired))
            .setter(setter(Builder::noPasswordRequired))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NoPasswordRequired").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_ID_FIELD,
            USER_NAME_FIELD, ENGINE_FIELD, PASSWORDS_FIELD, ACCESS_STRING_FIELD, NO_PASSWORD_REQUIRED_FIELD));

    private final String userId;

    private final String userName;

    private final String engine;

    private final List<String> passwords;

    private final String accessString;

    private final Boolean noPasswordRequired;

    private CreateUserRequest(BuilderImpl builder) {
        super(builder);
        this.userId = builder.userId;
        this.userName = builder.userName;
        this.engine = builder.engine;
        this.passwords = builder.passwords;
        this.accessString = builder.accessString;
        this.noPasswordRequired = builder.noPasswordRequired;
    }

    /**
     * <p>
     * The ID of the user.
     * </p>
     * 
     * @return The ID of the user.
     */
    public final String userId() {
        return userId;
    }

    /**
     * <p>
     * The username of the user.
     * </p>
     * 
     * @return The username of the user.
     */
    public final String userName() {
        return userName;
    }

    /**
     * <p>
     * The current supported value is Redis.
     * </p>
     * 
     * @return The current supported value is Redis.
     */
    public final String engine() {
        return engine;
    }

    /**
     * Returns true if the Passwords property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasPasswords() {
        return passwords != null && !(passwords instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Passwords used for this user. You can create up to two passwords for each user.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPasswords()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Passwords used for this user. You can create up to two passwords for each user.
     */
    public final List<String> passwords() {
        return passwords;
    }

    /**
     * <p>
     * Access permissions string used for this user.
     * </p>
     * 
     * @return Access permissions string used for this user.
     */
    public final String accessString() {
        return accessString;
    }

    /**
     * <p>
     * Indicates a password is not required for this user.
     * </p>
     * 
     * @return Indicates a password is not required for this user.
     */
    public final Boolean noPasswordRequired() {
        return noPasswordRequired;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(userName());
        hashCode = 31 * hashCode + Objects.hashCode(engine());
        hashCode = 31 * hashCode + Objects.hashCode(hasPasswords() ? passwords() : null);
        hashCode = 31 * hashCode + Objects.hashCode(accessString());
        hashCode = 31 * hashCode + Objects.hashCode(noPasswordRequired());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateUserRequest)) {
            return false;
        }
        CreateUserRequest other = (CreateUserRequest) obj;
        return Objects.equals(userId(), other.userId()) && Objects.equals(userName(), other.userName())
                && Objects.equals(engine(), other.engine()) && hasPasswords() == other.hasPasswords()
                && Objects.equals(passwords(), other.passwords()) && Objects.equals(accessString(), other.accessString())
                && Objects.equals(noPasswordRequired(), other.noPasswordRequired());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateUserRequest").add("UserId", userId()).add("UserName", userName()).add("Engine", engine())
                .add("Passwords", hasPasswords() ? passwords() : null).add("AccessString", accessString())
                .add("NoPasswordRequired", noPasswordRequired()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "UserName":
            return Optional.ofNullable(clazz.cast(userName()));
        case "Engine":
            return Optional.ofNullable(clazz.cast(engine()));
        case "Passwords":
            return Optional.ofNullable(clazz.cast(passwords()));
        case "AccessString":
            return Optional.ofNullable(clazz.cast(accessString()));
        case "NoPasswordRequired":
            return Optional.ofNullable(clazz.cast(noPasswordRequired()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateUserRequest, T> g) {
        return obj -> g.apply((CreateUserRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElastiCacheRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateUserRequest> {
        /**
         * <p>
         * The ID of the user.
         * </p>
         * 
         * @param userId
         *        The ID of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * The username of the user.
         * </p>
         * 
         * @param userName
         *        The username of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userName(String userName);

        /**
         * <p>
         * The current supported value is Redis.
         * </p>
         * 
         * @param engine
         *        The current supported value is Redis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engine(String engine);

        /**
         * <p>
         * Passwords used for this user. You can create up to two passwords for each user.
         * </p>
         * 
         * @param passwords
         *        Passwords used for this user. You can create up to two passwords for each user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder passwords(Collection<String> passwords);

        /**
         * <p>
         * Passwords used for this user. You can create up to two passwords for each user.
         * </p>
         * 
         * @param passwords
         *        Passwords used for this user. You can create up to two passwords for each user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder passwords(String... passwords);

        /**
         * <p>
         * Access permissions string used for this user.
         * </p>
         * 
         * @param accessString
         *        Access permissions string used for this user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessString(String accessString);

        /**
         * <p>
         * Indicates a password is not required for this user.
         * </p>
         * 
         * @param noPasswordRequired
         *        Indicates a password is not required for this user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noPasswordRequired(Boolean noPasswordRequired);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElastiCacheRequest.BuilderImpl implements Builder {
        private String userId;

        private String userName;

        private String engine;

        private List<String> passwords = DefaultSdkAutoConstructList.getInstance();

        private String accessString;

        private Boolean noPasswordRequired;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateUserRequest model) {
            super(model);
            userId(model.userId);
            userName(model.userName);
            engine(model.engine);
            passwords(model.passwords);
            accessString(model.accessString);
            noPasswordRequired(model.noPasswordRequired);
        }

        public final String getUserId() {
            return userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        public final String getUserName() {
            return userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getEngine() {
            return engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final Collection<String> getPasswords() {
            if (passwords instanceof SdkAutoConstructList) {
                return null;
            }
            return passwords;
        }

        @Override
        public final Builder passwords(Collection<String> passwords) {
            this.passwords = PasswordListInputCopier.copy(passwords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder passwords(String... passwords) {
            passwords(Arrays.asList(passwords));
            return this;
        }

        public final void setPasswords(Collection<String> passwords) {
            this.passwords = PasswordListInputCopier.copy(passwords);
        }

        public final String getAccessString() {
            return accessString;
        }

        @Override
        public final Builder accessString(String accessString) {
            this.accessString = accessString;
            return this;
        }

        public final void setAccessString(String accessString) {
            this.accessString = accessString;
        }

        public final Boolean getNoPasswordRequired() {
            return noPasswordRequired;
        }

        @Override
        public final Builder noPasswordRequired(Boolean noPasswordRequired) {
            this.noPasswordRequired = noPasswordRequired;
            return this;
        }

        public final void setNoPasswordRequired(Boolean noPasswordRequired) {
            this.noPasswordRequired = noPasswordRequired;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateUserRequest build() {
            return new CreateUserRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
