/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a <code>CopySnapshotMessage</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CopySnapshotRequest extends ElastiCacheRequest implements
        ToCopyableBuilder<CopySnapshotRequest.Builder, CopySnapshotRequest> {
    private static final SdkField<String> SOURCE_SNAPSHOT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceSnapshotName").getter(getter(CopySnapshotRequest::sourceSnapshotName))
            .setter(setter(Builder::sourceSnapshotName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceSnapshotName").build())
            .build();

    private static final SdkField<String> TARGET_SNAPSHOT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetSnapshotName").getter(getter(CopySnapshotRequest::targetSnapshotName))
            .setter(setter(Builder::targetSnapshotName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetSnapshotName").build())
            .build();

    private static final SdkField<String> TARGET_BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetBucket").getter(getter(CopySnapshotRequest::targetBucket)).setter(setter(Builder::targetBucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetBucket").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(CopySnapshotRequest::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_SNAPSHOT_NAME_FIELD,
            TARGET_SNAPSHOT_NAME_FIELD, TARGET_BUCKET_FIELD, KMS_KEY_ID_FIELD));

    private final String sourceSnapshotName;

    private final String targetSnapshotName;

    private final String targetBucket;

    private final String kmsKeyId;

    private CopySnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.sourceSnapshotName = builder.sourceSnapshotName;
        this.targetSnapshotName = builder.targetSnapshotName;
        this.targetBucket = builder.targetBucket;
        this.kmsKeyId = builder.kmsKeyId;
    }

    /**
     * <p>
     * The name of an existing snapshot from which to make a copy.
     * </p>
     * 
     * @return The name of an existing snapshot from which to make a copy.
     */
    public final String sourceSnapshotName() {
        return sourceSnapshotName;
    }

    /**
     * <p>
     * A name for the snapshot copy. ElastiCache does not permit overwriting a snapshot, therefore this name must be
     * unique within its context - ElastiCache or an Amazon S3 bucket if exporting.
     * </p>
     * 
     * @return A name for the snapshot copy. ElastiCache does not permit overwriting a snapshot, therefore this name
     *         must be unique within its context - ElastiCache or an Amazon S3 bucket if exporting.
     */
    public final String targetSnapshotName() {
        return targetSnapshotName;
    }

    /**
     * <p>
     * The Amazon S3 bucket to which the snapshot is exported. This parameter is used only when exporting a snapshot for
     * external access.
     * </p>
     * <p>
     * When using this parameter to export a snapshot, be sure Amazon ElastiCache has the needed permissions to this S3
     * bucket. For more information, see <a href=
     * "http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-grant-access"
     * >Step 2: Grant ElastiCache Access to Your Amazon S3 Bucket</a> in the <i>Amazon ElastiCache User Guide</i>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Snapshots.Exporting.html">Exporting a
     * Snapshot</a> in the <i>Amazon ElastiCache User Guide</i>.
     * </p>
     * 
     * @return The Amazon S3 bucket to which the snapshot is exported. This parameter is used only when exporting a
     *         snapshot for external access.</p>
     *         <p>
     *         When using this parameter to export a snapshot, be sure Amazon ElastiCache has the needed permissions to
     *         this S3 bucket. For more information, see <a href=
     *         "http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-grant-access"
     *         >Step 2: Grant ElastiCache Access to Your Amazon S3 Bucket</a> in the <i>Amazon ElastiCache User
     *         Guide</i>.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Snapshots.Exporting.html">Exporting a
     *         Snapshot</a> in the <i>Amazon ElastiCache User Guide</i>.
     */
    public final String targetBucket() {
        return targetBucket;
    }

    /**
     * <p>
     * The ID of the KMS key used to encrypt the target snapshot.
     * </p>
     * 
     * @return The ID of the KMS key used to encrypt the target snapshot.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sourceSnapshotName());
        hashCode = 31 * hashCode + Objects.hashCode(targetSnapshotName());
        hashCode = 31 * hashCode + Objects.hashCode(targetBucket());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopySnapshotRequest)) {
            return false;
        }
        CopySnapshotRequest other = (CopySnapshotRequest) obj;
        return Objects.equals(sourceSnapshotName(), other.sourceSnapshotName())
                && Objects.equals(targetSnapshotName(), other.targetSnapshotName())
                && Objects.equals(targetBucket(), other.targetBucket()) && Objects.equals(kmsKeyId(), other.kmsKeyId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CopySnapshotRequest").add("SourceSnapshotName", sourceSnapshotName())
                .add("TargetSnapshotName", targetSnapshotName()).add("TargetBucket", targetBucket()).add("KmsKeyId", kmsKeyId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceSnapshotName":
            return Optional.ofNullable(clazz.cast(sourceSnapshotName()));
        case "TargetSnapshotName":
            return Optional.ofNullable(clazz.cast(targetSnapshotName()));
        case "TargetBucket":
            return Optional.ofNullable(clazz.cast(targetBucket()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CopySnapshotRequest, T> g) {
        return obj -> g.apply((CopySnapshotRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElastiCacheRequest.Builder, SdkPojo, CopyableBuilder<Builder, CopySnapshotRequest> {
        /**
         * <p>
         * The name of an existing snapshot from which to make a copy.
         * </p>
         * 
         * @param sourceSnapshotName
         *        The name of an existing snapshot from which to make a copy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceSnapshotName(String sourceSnapshotName);

        /**
         * <p>
         * A name for the snapshot copy. ElastiCache does not permit overwriting a snapshot, therefore this name must be
         * unique within its context - ElastiCache or an Amazon S3 bucket if exporting.
         * </p>
         * 
         * @param targetSnapshotName
         *        A name for the snapshot copy. ElastiCache does not permit overwriting a snapshot, therefore this name
         *        must be unique within its context - ElastiCache or an Amazon S3 bucket if exporting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetSnapshotName(String targetSnapshotName);

        /**
         * <p>
         * The Amazon S3 bucket to which the snapshot is exported. This parameter is used only when exporting a snapshot
         * for external access.
         * </p>
         * <p>
         * When using this parameter to export a snapshot, be sure Amazon ElastiCache has the needed permissions to this
         * S3 bucket. For more information, see <a href=
         * "http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-grant-access"
         * >Step 2: Grant ElastiCache Access to Your Amazon S3 Bucket</a> in the <i>Amazon ElastiCache User Guide</i>.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Snapshots.Exporting.html">Exporting a
         * Snapshot</a> in the <i>Amazon ElastiCache User Guide</i>.
         * </p>
         * 
         * @param targetBucket
         *        The Amazon S3 bucket to which the snapshot is exported. This parameter is used only when exporting a
         *        snapshot for external access.</p>
         *        <p>
         *        When using this parameter to export a snapshot, be sure Amazon ElastiCache has the needed permissions
         *        to this S3 bucket. For more information, see <a href=
         *        "http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-grant-access"
         *        >Step 2: Grant ElastiCache Access to Your Amazon S3 Bucket</a> in the <i>Amazon ElastiCache User
         *        Guide</i>.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Snapshots.Exporting.html">Exporting
         *        a Snapshot</a> in the <i>Amazon ElastiCache User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetBucket(String targetBucket);

        /**
         * <p>
         * The ID of the KMS key used to encrypt the target snapshot.
         * </p>
         * 
         * @param kmsKeyId
         *        The ID of the KMS key used to encrypt the target snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElastiCacheRequest.BuilderImpl implements Builder {
        private String sourceSnapshotName;

        private String targetSnapshotName;

        private String targetBucket;

        private String kmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(CopySnapshotRequest model) {
            super(model);
            sourceSnapshotName(model.sourceSnapshotName);
            targetSnapshotName(model.targetSnapshotName);
            targetBucket(model.targetBucket);
            kmsKeyId(model.kmsKeyId);
        }

        public final String getSourceSnapshotName() {
            return sourceSnapshotName;
        }

        @Override
        public final Builder sourceSnapshotName(String sourceSnapshotName) {
            this.sourceSnapshotName = sourceSnapshotName;
            return this;
        }

        public final void setSourceSnapshotName(String sourceSnapshotName) {
            this.sourceSnapshotName = sourceSnapshotName;
        }

        public final String getTargetSnapshotName() {
            return targetSnapshotName;
        }

        @Override
        public final Builder targetSnapshotName(String targetSnapshotName) {
            this.targetSnapshotName = targetSnapshotName;
            return this;
        }

        public final void setTargetSnapshotName(String targetSnapshotName) {
            this.targetSnapshotName = targetSnapshotName;
        }

        public final String getTargetBucket() {
            return targetBucket;
        }

        @Override
        public final Builder targetBucket(String targetBucket) {
            this.targetBucket = targetBucket;
            return this;
        }

        public final void setTargetBucket(String targetBucket) {
            this.targetBucket = targetBucket;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CopySnapshotRequest build() {
            return new CopySnapshotRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
