/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticache.model.PreferredAvailabilityZoneListCopier;
import software.amazon.awssdk.services.elasticache.model.PreferredOutpostArnListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfigureShard
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConfigureShard> {
    private static final SdkField<String> NODE_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NodeGroupId").getter(ConfigureShard.getter(ConfigureShard::nodeGroupId)).setter(ConfigureShard.setter(Builder::nodeGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeGroupId").build()}).build();
    private static final SdkField<Integer> NEW_REPLICA_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NewReplicaCount").getter(ConfigureShard.getter(ConfigureShard::newReplicaCount)).setter(ConfigureShard.setter(Builder::newReplicaCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewReplicaCount").build()}).build();
    private static final SdkField<List<String>> PREFERRED_AVAILABILITY_ZONES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PreferredAvailabilityZones").getter(ConfigureShard.getter(ConfigureShard::preferredAvailabilityZones)).setter(ConfigureShard.setter(Builder::preferredAvailabilityZones)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredAvailabilityZones").build(), ListTrait.builder().memberLocationName("PreferredAvailabilityZone").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredAvailabilityZone").build()}).build()).build()}).build();
    private static final SdkField<List<String>> PREFERRED_OUTPOST_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PreferredOutpostArns").getter(ConfigureShard.getter(ConfigureShard::preferredOutpostArns)).setter(ConfigureShard.setter(Builder::preferredOutpostArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredOutpostArns").build(), ListTrait.builder().memberLocationName("PreferredOutpostArn").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredOutpostArn").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NODE_GROUP_ID_FIELD, NEW_REPLICA_COUNT_FIELD, PREFERRED_AVAILABILITY_ZONES_FIELD, PREFERRED_OUTPOST_ARNS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String nodeGroupId;
    private final Integer newReplicaCount;
    private final List<String> preferredAvailabilityZones;
    private final List<String> preferredOutpostArns;

    private ConfigureShard(BuilderImpl builder) {
        this.nodeGroupId = builder.nodeGroupId;
        this.newReplicaCount = builder.newReplicaCount;
        this.preferredAvailabilityZones = builder.preferredAvailabilityZones;
        this.preferredOutpostArns = builder.preferredOutpostArns;
    }

    public String nodeGroupId() {
        return this.nodeGroupId;
    }

    public Integer newReplicaCount() {
        return this.newReplicaCount;
    }

    public boolean hasPreferredAvailabilityZones() {
        return this.preferredAvailabilityZones != null && !(this.preferredAvailabilityZones instanceof SdkAutoConstructList);
    }

    public List<String> preferredAvailabilityZones() {
        return this.preferredAvailabilityZones;
    }

    public boolean hasPreferredOutpostArns() {
        return this.preferredOutpostArns != null && !(this.preferredOutpostArns instanceof SdkAutoConstructList);
    }

    public List<String> preferredOutpostArns() {
        return this.preferredOutpostArns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.newReplicaCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredAvailabilityZones());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredOutpostArns());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigureShard)) {
            return false;
        }
        ConfigureShard other = (ConfigureShard)obj;
        return Objects.equals(this.nodeGroupId(), other.nodeGroupId()) && Objects.equals(this.newReplicaCount(), other.newReplicaCount()) && Objects.equals(this.preferredAvailabilityZones(), other.preferredAvailabilityZones()) && Objects.equals(this.preferredOutpostArns(), other.preferredOutpostArns());
    }

    public String toString() {
        return ToString.builder((String)"ConfigureShard").add("NodeGroupId", (Object)this.nodeGroupId()).add("NewReplicaCount", (Object)this.newReplicaCount()).add("PreferredAvailabilityZones", this.preferredAvailabilityZones()).add("PreferredOutpostArns", this.preferredOutpostArns()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NodeGroupId": {
                return Optional.ofNullable(clazz.cast(this.nodeGroupId()));
            }
            case "NewReplicaCount": {
                return Optional.ofNullable(clazz.cast(this.newReplicaCount()));
            }
            case "PreferredAvailabilityZones": {
                return Optional.ofNullable(clazz.cast(this.preferredAvailabilityZones()));
            }
            case "PreferredOutpostArns": {
                return Optional.ofNullable(clazz.cast(this.preferredOutpostArns()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConfigureShard, T> g) {
        return obj -> g.apply((ConfigureShard)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String nodeGroupId;
        private Integer newReplicaCount;
        private List<String> preferredAvailabilityZones = DefaultSdkAutoConstructList.getInstance();
        private List<String> preferredOutpostArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigureShard model) {
            this.nodeGroupId(model.nodeGroupId);
            this.newReplicaCount(model.newReplicaCount);
            this.preferredAvailabilityZones(model.preferredAvailabilityZones);
            this.preferredOutpostArns(model.preferredOutpostArns);
        }

        public final String getNodeGroupId() {
            return this.nodeGroupId;
        }

        @Override
        public final Builder nodeGroupId(String nodeGroupId) {
            this.nodeGroupId = nodeGroupId;
            return this;
        }

        public final void setNodeGroupId(String nodeGroupId) {
            this.nodeGroupId = nodeGroupId;
        }

        public final Integer getNewReplicaCount() {
            return this.newReplicaCount;
        }

        @Override
        public final Builder newReplicaCount(Integer newReplicaCount) {
            this.newReplicaCount = newReplicaCount;
            return this;
        }

        public final void setNewReplicaCount(Integer newReplicaCount) {
            this.newReplicaCount = newReplicaCount;
        }

        public final Collection<String> getPreferredAvailabilityZones() {
            return this.preferredAvailabilityZones;
        }

        @Override
        public final Builder preferredAvailabilityZones(Collection<String> preferredAvailabilityZones) {
            this.preferredAvailabilityZones = PreferredAvailabilityZoneListCopier.copy(preferredAvailabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder preferredAvailabilityZones(String ... preferredAvailabilityZones) {
            this.preferredAvailabilityZones(Arrays.asList(preferredAvailabilityZones));
            return this;
        }

        public final void setPreferredAvailabilityZones(Collection<String> preferredAvailabilityZones) {
            this.preferredAvailabilityZones = PreferredAvailabilityZoneListCopier.copy(preferredAvailabilityZones);
        }

        public final Collection<String> getPreferredOutpostArns() {
            return this.preferredOutpostArns;
        }

        @Override
        public final Builder preferredOutpostArns(Collection<String> preferredOutpostArns) {
            this.preferredOutpostArns = PreferredOutpostArnListCopier.copy(preferredOutpostArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder preferredOutpostArns(String ... preferredOutpostArns) {
            this.preferredOutpostArns(Arrays.asList(preferredOutpostArns));
            return this;
        }

        public final void setPreferredOutpostArns(Collection<String> preferredOutpostArns) {
            this.preferredOutpostArns = PreferredOutpostArnListCopier.copy(preferredOutpostArns);
        }

        public ConfigureShard build() {
            return new ConfigureShard(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConfigureShard> {
        public Builder nodeGroupId(String var1);

        public Builder newReplicaCount(Integer var1);

        public Builder preferredAvailabilityZones(Collection<String> var1);

        public Builder preferredAvailabilityZones(String ... var1);

        public Builder preferredOutpostArns(Collection<String> var1);

        public Builder preferredOutpostArns(String ... var1);
    }
}

