/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticache.model.AvailabilityZonesListCopier;
import software.amazon.awssdk.services.elasticache.model.OutpostArnsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NodeGroupConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NodeGroupConfiguration> {
    private static final SdkField<String> NODE_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NodeGroupId").getter(NodeGroupConfiguration.getter(NodeGroupConfiguration::nodeGroupId)).setter(NodeGroupConfiguration.setter(Builder::nodeGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeGroupId").build()}).build();
    private static final SdkField<String> SLOTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Slots").getter(NodeGroupConfiguration.getter(NodeGroupConfiguration::slots)).setter(NodeGroupConfiguration.setter(Builder::slots)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Slots").build()}).build();
    private static final SdkField<Integer> REPLICA_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ReplicaCount").getter(NodeGroupConfiguration.getter(NodeGroupConfiguration::replicaCount)).setter(NodeGroupConfiguration.setter(Builder::replicaCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicaCount").build()}).build();
    private static final SdkField<String> PRIMARY_AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrimaryAvailabilityZone").getter(NodeGroupConfiguration.getter(NodeGroupConfiguration::primaryAvailabilityZone)).setter(NodeGroupConfiguration.setter(Builder::primaryAvailabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryAvailabilityZone").build()}).build();
    private static final SdkField<List<String>> REPLICA_AVAILABILITY_ZONES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReplicaAvailabilityZones").getter(NodeGroupConfiguration.getter(NodeGroupConfiguration::replicaAvailabilityZones)).setter(NodeGroupConfiguration.setter(Builder::replicaAvailabilityZones)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicaAvailabilityZones").build(), ListTrait.builder().memberLocationName("AvailabilityZone").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()}).build()).build()}).build();
    private static final SdkField<String> PRIMARY_OUTPOST_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrimaryOutpostArn").getter(NodeGroupConfiguration.getter(NodeGroupConfiguration::primaryOutpostArn)).setter(NodeGroupConfiguration.setter(Builder::primaryOutpostArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryOutpostArn").build()}).build();
    private static final SdkField<List<String>> REPLICA_OUTPOST_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReplicaOutpostArns").getter(NodeGroupConfiguration.getter(NodeGroupConfiguration::replicaOutpostArns)).setter(NodeGroupConfiguration.setter(Builder::replicaOutpostArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicaOutpostArns").build(), ListTrait.builder().memberLocationName("OutpostArn").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostArn").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NODE_GROUP_ID_FIELD, SLOTS_FIELD, REPLICA_COUNT_FIELD, PRIMARY_AVAILABILITY_ZONE_FIELD, REPLICA_AVAILABILITY_ZONES_FIELD, PRIMARY_OUTPOST_ARN_FIELD, REPLICA_OUTPOST_ARNS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String nodeGroupId;
    private final String slots;
    private final Integer replicaCount;
    private final String primaryAvailabilityZone;
    private final List<String> replicaAvailabilityZones;
    private final String primaryOutpostArn;
    private final List<String> replicaOutpostArns;

    private NodeGroupConfiguration(BuilderImpl builder) {
        this.nodeGroupId = builder.nodeGroupId;
        this.slots = builder.slots;
        this.replicaCount = builder.replicaCount;
        this.primaryAvailabilityZone = builder.primaryAvailabilityZone;
        this.replicaAvailabilityZones = builder.replicaAvailabilityZones;
        this.primaryOutpostArn = builder.primaryOutpostArn;
        this.replicaOutpostArns = builder.replicaOutpostArns;
    }

    public String nodeGroupId() {
        return this.nodeGroupId;
    }

    public String slots() {
        return this.slots;
    }

    public Integer replicaCount() {
        return this.replicaCount;
    }

    public String primaryAvailabilityZone() {
        return this.primaryAvailabilityZone;
    }

    public boolean hasReplicaAvailabilityZones() {
        return this.replicaAvailabilityZones != null && !(this.replicaAvailabilityZones instanceof SdkAutoConstructList);
    }

    public List<String> replicaAvailabilityZones() {
        return this.replicaAvailabilityZones;
    }

    public String primaryOutpostArn() {
        return this.primaryOutpostArn;
    }

    public boolean hasReplicaOutpostArns() {
        return this.replicaOutpostArns != null && !(this.replicaOutpostArns instanceof SdkAutoConstructList);
    }

    public List<String> replicaOutpostArns() {
        return this.replicaOutpostArns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.slots());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicaCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryAvailabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicaAvailabilityZones());
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryOutpostArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicaOutpostArns());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeGroupConfiguration)) {
            return false;
        }
        NodeGroupConfiguration other = (NodeGroupConfiguration)obj;
        return Objects.equals(this.nodeGroupId(), other.nodeGroupId()) && Objects.equals(this.slots(), other.slots()) && Objects.equals(this.replicaCount(), other.replicaCount()) && Objects.equals(this.primaryAvailabilityZone(), other.primaryAvailabilityZone()) && Objects.equals(this.replicaAvailabilityZones(), other.replicaAvailabilityZones()) && Objects.equals(this.primaryOutpostArn(), other.primaryOutpostArn()) && Objects.equals(this.replicaOutpostArns(), other.replicaOutpostArns());
    }

    public String toString() {
        return ToString.builder((String)"NodeGroupConfiguration").add("NodeGroupId", (Object)this.nodeGroupId()).add("Slots", (Object)this.slots()).add("ReplicaCount", (Object)this.replicaCount()).add("PrimaryAvailabilityZone", (Object)this.primaryAvailabilityZone()).add("ReplicaAvailabilityZones", this.replicaAvailabilityZones()).add("PrimaryOutpostArn", (Object)this.primaryOutpostArn()).add("ReplicaOutpostArns", this.replicaOutpostArns()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NodeGroupId": {
                return Optional.ofNullable(clazz.cast(this.nodeGroupId()));
            }
            case "Slots": {
                return Optional.ofNullable(clazz.cast(this.slots()));
            }
            case "ReplicaCount": {
                return Optional.ofNullable(clazz.cast(this.replicaCount()));
            }
            case "PrimaryAvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.primaryAvailabilityZone()));
            }
            case "ReplicaAvailabilityZones": {
                return Optional.ofNullable(clazz.cast(this.replicaAvailabilityZones()));
            }
            case "PrimaryOutpostArn": {
                return Optional.ofNullable(clazz.cast(this.primaryOutpostArn()));
            }
            case "ReplicaOutpostArns": {
                return Optional.ofNullable(clazz.cast(this.replicaOutpostArns()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NodeGroupConfiguration, T> g) {
        return obj -> g.apply((NodeGroupConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String nodeGroupId;
        private String slots;
        private Integer replicaCount;
        private String primaryAvailabilityZone;
        private List<String> replicaAvailabilityZones = DefaultSdkAutoConstructList.getInstance();
        private String primaryOutpostArn;
        private List<String> replicaOutpostArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(NodeGroupConfiguration model) {
            this.nodeGroupId(model.nodeGroupId);
            this.slots(model.slots);
            this.replicaCount(model.replicaCount);
            this.primaryAvailabilityZone(model.primaryAvailabilityZone);
            this.replicaAvailabilityZones(model.replicaAvailabilityZones);
            this.primaryOutpostArn(model.primaryOutpostArn);
            this.replicaOutpostArns(model.replicaOutpostArns);
        }

        public final String getNodeGroupId() {
            return this.nodeGroupId;
        }

        @Override
        public final Builder nodeGroupId(String nodeGroupId) {
            this.nodeGroupId = nodeGroupId;
            return this;
        }

        public final void setNodeGroupId(String nodeGroupId) {
            this.nodeGroupId = nodeGroupId;
        }

        public final String getSlots() {
            return this.slots;
        }

        @Override
        public final Builder slots(String slots) {
            this.slots = slots;
            return this;
        }

        public final void setSlots(String slots) {
            this.slots = slots;
        }

        public final Integer getReplicaCount() {
            return this.replicaCount;
        }

        @Override
        public final Builder replicaCount(Integer replicaCount) {
            this.replicaCount = replicaCount;
            return this;
        }

        public final void setReplicaCount(Integer replicaCount) {
            this.replicaCount = replicaCount;
        }

        public final String getPrimaryAvailabilityZone() {
            return this.primaryAvailabilityZone;
        }

        @Override
        public final Builder primaryAvailabilityZone(String primaryAvailabilityZone) {
            this.primaryAvailabilityZone = primaryAvailabilityZone;
            return this;
        }

        public final void setPrimaryAvailabilityZone(String primaryAvailabilityZone) {
            this.primaryAvailabilityZone = primaryAvailabilityZone;
        }

        public final Collection<String> getReplicaAvailabilityZones() {
            return this.replicaAvailabilityZones;
        }

        @Override
        public final Builder replicaAvailabilityZones(Collection<String> replicaAvailabilityZones) {
            this.replicaAvailabilityZones = AvailabilityZonesListCopier.copy(replicaAvailabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicaAvailabilityZones(String ... replicaAvailabilityZones) {
            this.replicaAvailabilityZones(Arrays.asList(replicaAvailabilityZones));
            return this;
        }

        public final void setReplicaAvailabilityZones(Collection<String> replicaAvailabilityZones) {
            this.replicaAvailabilityZones = AvailabilityZonesListCopier.copy(replicaAvailabilityZones);
        }

        public final String getPrimaryOutpostArn() {
            return this.primaryOutpostArn;
        }

        @Override
        public final Builder primaryOutpostArn(String primaryOutpostArn) {
            this.primaryOutpostArn = primaryOutpostArn;
            return this;
        }

        public final void setPrimaryOutpostArn(String primaryOutpostArn) {
            this.primaryOutpostArn = primaryOutpostArn;
        }

        public final Collection<String> getReplicaOutpostArns() {
            return this.replicaOutpostArns;
        }

        @Override
        public final Builder replicaOutpostArns(Collection<String> replicaOutpostArns) {
            this.replicaOutpostArns = OutpostArnsListCopier.copy(replicaOutpostArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicaOutpostArns(String ... replicaOutpostArns) {
            this.replicaOutpostArns(Arrays.asList(replicaOutpostArns));
            return this;
        }

        public final void setReplicaOutpostArns(Collection<String> replicaOutpostArns) {
            this.replicaOutpostArns = OutpostArnsListCopier.copy(replicaOutpostArns);
        }

        public NodeGroupConfiguration build() {
            return new NodeGroupConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NodeGroupConfiguration> {
        public Builder nodeGroupId(String var1);

        public Builder slots(String var1);

        public Builder replicaCount(Integer var1);

        public Builder primaryAvailabilityZone(String var1);

        public Builder replicaAvailabilityZones(Collection<String> var1);

        public Builder replicaAvailabilityZones(String ... var1);

        public Builder primaryOutpostArn(String var1);

        public Builder replicaOutpostArns(Collection<String> var1);

        public Builder replicaOutpostArns(String ... var1);
    }
}

