/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticache.model.CacheNodeUpdateStatus;
import software.amazon.awssdk.services.elasticache.model.CacheNodeUpdateStatusListCopier;
import software.amazon.awssdk.services.elasticache.model.NodeGroupUpdateStatus;
import software.amazon.awssdk.services.elasticache.model.NodeGroupUpdateStatusListCopier;
import software.amazon.awssdk.services.elasticache.model.ServiceUpdateSeverity;
import software.amazon.awssdk.services.elasticache.model.ServiceUpdateStatus;
import software.amazon.awssdk.services.elasticache.model.ServiceUpdateType;
import software.amazon.awssdk.services.elasticache.model.SlaMet;
import software.amazon.awssdk.services.elasticache.model.UpdateActionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UpdateAction> {
    private static final SdkField<String> REPLICATION_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicationGroupId").getter(UpdateAction.getter(UpdateAction::replicationGroupId)).setter(UpdateAction.setter(Builder::replicationGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationGroupId").build()}).build();
    private static final SdkField<String> CACHE_CLUSTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CacheClusterId").getter(UpdateAction.getter(UpdateAction::cacheClusterId)).setter(UpdateAction.setter(Builder::cacheClusterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheClusterId").build()}).build();
    private static final SdkField<String> SERVICE_UPDATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceUpdateName").getter(UpdateAction.getter(UpdateAction::serviceUpdateName)).setter(UpdateAction.setter(Builder::serviceUpdateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceUpdateName").build()}).build();
    private static final SdkField<Instant> SERVICE_UPDATE_RELEASE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ServiceUpdateReleaseDate").getter(UpdateAction.getter(UpdateAction::serviceUpdateReleaseDate)).setter(UpdateAction.setter(Builder::serviceUpdateReleaseDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceUpdateReleaseDate").build()}).build();
    private static final SdkField<String> SERVICE_UPDATE_SEVERITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceUpdateSeverity").getter(UpdateAction.getter(UpdateAction::serviceUpdateSeverityAsString)).setter(UpdateAction.setter(Builder::serviceUpdateSeverity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceUpdateSeverity").build()}).build();
    private static final SdkField<String> SERVICE_UPDATE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceUpdateStatus").getter(UpdateAction.getter(UpdateAction::serviceUpdateStatusAsString)).setter(UpdateAction.setter(Builder::serviceUpdateStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceUpdateStatus").build()}).build();
    private static final SdkField<Instant> SERVICE_UPDATE_RECOMMENDED_APPLY_BY_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ServiceUpdateRecommendedApplyByDate").getter(UpdateAction.getter(UpdateAction::serviceUpdateRecommendedApplyByDate)).setter(UpdateAction.setter(Builder::serviceUpdateRecommendedApplyByDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceUpdateRecommendedApplyByDate").build()}).build();
    private static final SdkField<String> SERVICE_UPDATE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceUpdateType").getter(UpdateAction.getter(UpdateAction::serviceUpdateTypeAsString)).setter(UpdateAction.setter(Builder::serviceUpdateType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceUpdateType").build()}).build();
    private static final SdkField<Instant> UPDATE_ACTION_AVAILABLE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdateActionAvailableDate").getter(UpdateAction.getter(UpdateAction::updateActionAvailableDate)).setter(UpdateAction.setter(Builder::updateActionAvailableDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateActionAvailableDate").build()}).build();
    private static final SdkField<String> UPDATE_ACTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UpdateActionStatus").getter(UpdateAction.getter(UpdateAction::updateActionStatusAsString)).setter(UpdateAction.setter(Builder::updateActionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateActionStatus").build()}).build();
    private static final SdkField<String> NODES_UPDATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NodesUpdated").getter(UpdateAction.getter(UpdateAction::nodesUpdated)).setter(UpdateAction.setter(Builder::nodesUpdated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodesUpdated").build()}).build();
    private static final SdkField<Instant> UPDATE_ACTION_STATUS_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdateActionStatusModifiedDate").getter(UpdateAction.getter(UpdateAction::updateActionStatusModifiedDate)).setter(UpdateAction.setter(Builder::updateActionStatusModifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateActionStatusModifiedDate").build()}).build();
    private static final SdkField<String> SLA_MET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SlaMet").getter(UpdateAction.getter(UpdateAction::slaMetAsString)).setter(UpdateAction.setter(Builder::slaMet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SlaMet").build()}).build();
    private static final SdkField<List<NodeGroupUpdateStatus>> NODE_GROUP_UPDATE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NodeGroupUpdateStatus").getter(UpdateAction.getter(UpdateAction::nodeGroupUpdateStatus)).setter(UpdateAction.setter(Builder::nodeGroupUpdateStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeGroupUpdateStatus").build(), ListTrait.builder().memberLocationName("NodeGroupUpdateStatus").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NodeGroupUpdateStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeGroupUpdateStatus").build()}).build()).build()}).build();
    private static final SdkField<List<CacheNodeUpdateStatus>> CACHE_NODE_UPDATE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CacheNodeUpdateStatus").getter(UpdateAction.getter(UpdateAction::cacheNodeUpdateStatus)).setter(UpdateAction.setter(Builder::cacheNodeUpdateStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheNodeUpdateStatus").build(), ListTrait.builder().memberLocationName("CacheNodeUpdateStatus").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CacheNodeUpdateStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheNodeUpdateStatus").build()}).build()).build()}).build();
    private static final SdkField<String> ESTIMATED_UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EstimatedUpdateTime").getter(UpdateAction.getter(UpdateAction::estimatedUpdateTime)).setter(UpdateAction.setter(Builder::estimatedUpdateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedUpdateTime").build()}).build();
    private static final SdkField<String> ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Engine").getter(UpdateAction.getter(UpdateAction::engine)).setter(UpdateAction.setter(Builder::engine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_GROUP_ID_FIELD, CACHE_CLUSTER_ID_FIELD, SERVICE_UPDATE_NAME_FIELD, SERVICE_UPDATE_RELEASE_DATE_FIELD, SERVICE_UPDATE_SEVERITY_FIELD, SERVICE_UPDATE_STATUS_FIELD, SERVICE_UPDATE_RECOMMENDED_APPLY_BY_DATE_FIELD, SERVICE_UPDATE_TYPE_FIELD, UPDATE_ACTION_AVAILABLE_DATE_FIELD, UPDATE_ACTION_STATUS_FIELD, NODES_UPDATED_FIELD, UPDATE_ACTION_STATUS_MODIFIED_DATE_FIELD, SLA_MET_FIELD, NODE_GROUP_UPDATE_STATUS_FIELD, CACHE_NODE_UPDATE_STATUS_FIELD, ESTIMATED_UPDATE_TIME_FIELD, ENGINE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String replicationGroupId;
    private final String cacheClusterId;
    private final String serviceUpdateName;
    private final Instant serviceUpdateReleaseDate;
    private final String serviceUpdateSeverity;
    private final String serviceUpdateStatus;
    private final Instant serviceUpdateRecommendedApplyByDate;
    private final String serviceUpdateType;
    private final Instant updateActionAvailableDate;
    private final String updateActionStatus;
    private final String nodesUpdated;
    private final Instant updateActionStatusModifiedDate;
    private final String slaMet;
    private final List<NodeGroupUpdateStatus> nodeGroupUpdateStatus;
    private final List<CacheNodeUpdateStatus> cacheNodeUpdateStatus;
    private final String estimatedUpdateTime;
    private final String engine;

    private UpdateAction(BuilderImpl builder) {
        this.replicationGroupId = builder.replicationGroupId;
        this.cacheClusterId = builder.cacheClusterId;
        this.serviceUpdateName = builder.serviceUpdateName;
        this.serviceUpdateReleaseDate = builder.serviceUpdateReleaseDate;
        this.serviceUpdateSeverity = builder.serviceUpdateSeverity;
        this.serviceUpdateStatus = builder.serviceUpdateStatus;
        this.serviceUpdateRecommendedApplyByDate = builder.serviceUpdateRecommendedApplyByDate;
        this.serviceUpdateType = builder.serviceUpdateType;
        this.updateActionAvailableDate = builder.updateActionAvailableDate;
        this.updateActionStatus = builder.updateActionStatus;
        this.nodesUpdated = builder.nodesUpdated;
        this.updateActionStatusModifiedDate = builder.updateActionStatusModifiedDate;
        this.slaMet = builder.slaMet;
        this.nodeGroupUpdateStatus = builder.nodeGroupUpdateStatus;
        this.cacheNodeUpdateStatus = builder.cacheNodeUpdateStatus;
        this.estimatedUpdateTime = builder.estimatedUpdateTime;
        this.engine = builder.engine;
    }

    public String replicationGroupId() {
        return this.replicationGroupId;
    }

    public String cacheClusterId() {
        return this.cacheClusterId;
    }

    public String serviceUpdateName() {
        return this.serviceUpdateName;
    }

    public Instant serviceUpdateReleaseDate() {
        return this.serviceUpdateReleaseDate;
    }

    public ServiceUpdateSeverity serviceUpdateSeverity() {
        return ServiceUpdateSeverity.fromValue(this.serviceUpdateSeverity);
    }

    public String serviceUpdateSeverityAsString() {
        return this.serviceUpdateSeverity;
    }

    public ServiceUpdateStatus serviceUpdateStatus() {
        return ServiceUpdateStatus.fromValue(this.serviceUpdateStatus);
    }

    public String serviceUpdateStatusAsString() {
        return this.serviceUpdateStatus;
    }

    public Instant serviceUpdateRecommendedApplyByDate() {
        return this.serviceUpdateRecommendedApplyByDate;
    }

    public ServiceUpdateType serviceUpdateType() {
        return ServiceUpdateType.fromValue(this.serviceUpdateType);
    }

    public String serviceUpdateTypeAsString() {
        return this.serviceUpdateType;
    }

    public Instant updateActionAvailableDate() {
        return this.updateActionAvailableDate;
    }

    public UpdateActionStatus updateActionStatus() {
        return UpdateActionStatus.fromValue(this.updateActionStatus);
    }

    public String updateActionStatusAsString() {
        return this.updateActionStatus;
    }

    public String nodesUpdated() {
        return this.nodesUpdated;
    }

    public Instant updateActionStatusModifiedDate() {
        return this.updateActionStatusModifiedDate;
    }

    public SlaMet slaMet() {
        return SlaMet.fromValue(this.slaMet);
    }

    public String slaMetAsString() {
        return this.slaMet;
    }

    public boolean hasNodeGroupUpdateStatus() {
        return this.nodeGroupUpdateStatus != null && !(this.nodeGroupUpdateStatus instanceof SdkAutoConstructList);
    }

    public List<NodeGroupUpdateStatus> nodeGroupUpdateStatus() {
        return this.nodeGroupUpdateStatus;
    }

    public boolean hasCacheNodeUpdateStatus() {
        return this.cacheNodeUpdateStatus != null && !(this.cacheNodeUpdateStatus instanceof SdkAutoConstructList);
    }

    public List<CacheNodeUpdateStatus> cacheNodeUpdateStatus() {
        return this.cacheNodeUpdateStatus;
    }

    public String estimatedUpdateTime() {
        return this.estimatedUpdateTime;
    }

    public String engine() {
        return this.engine;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceUpdateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceUpdateReleaseDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceUpdateSeverityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceUpdateStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceUpdateRecommendedApplyByDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceUpdateTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateActionAvailableDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateActionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodesUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateActionStatusModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.slaMetAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeGroupUpdateStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheNodeUpdateStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedUpdateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAction)) {
            return false;
        }
        UpdateAction other = (UpdateAction)obj;
        return Objects.equals(this.replicationGroupId(), other.replicationGroupId()) && Objects.equals(this.cacheClusterId(), other.cacheClusterId()) && Objects.equals(this.serviceUpdateName(), other.serviceUpdateName()) && Objects.equals(this.serviceUpdateReleaseDate(), other.serviceUpdateReleaseDate()) && Objects.equals(this.serviceUpdateSeverityAsString(), other.serviceUpdateSeverityAsString()) && Objects.equals(this.serviceUpdateStatusAsString(), other.serviceUpdateStatusAsString()) && Objects.equals(this.serviceUpdateRecommendedApplyByDate(), other.serviceUpdateRecommendedApplyByDate()) && Objects.equals(this.serviceUpdateTypeAsString(), other.serviceUpdateTypeAsString()) && Objects.equals(this.updateActionAvailableDate(), other.updateActionAvailableDate()) && Objects.equals(this.updateActionStatusAsString(), other.updateActionStatusAsString()) && Objects.equals(this.nodesUpdated(), other.nodesUpdated()) && Objects.equals(this.updateActionStatusModifiedDate(), other.updateActionStatusModifiedDate()) && Objects.equals(this.slaMetAsString(), other.slaMetAsString()) && Objects.equals(this.nodeGroupUpdateStatus(), other.nodeGroupUpdateStatus()) && Objects.equals(this.cacheNodeUpdateStatus(), other.cacheNodeUpdateStatus()) && Objects.equals(this.estimatedUpdateTime(), other.estimatedUpdateTime()) && Objects.equals(this.engine(), other.engine());
    }

    public String toString() {
        return ToString.builder((String)"UpdateAction").add("ReplicationGroupId", (Object)this.replicationGroupId()).add("CacheClusterId", (Object)this.cacheClusterId()).add("ServiceUpdateName", (Object)this.serviceUpdateName()).add("ServiceUpdateReleaseDate", (Object)this.serviceUpdateReleaseDate()).add("ServiceUpdateSeverity", (Object)this.serviceUpdateSeverityAsString()).add("ServiceUpdateStatus", (Object)this.serviceUpdateStatusAsString()).add("ServiceUpdateRecommendedApplyByDate", (Object)this.serviceUpdateRecommendedApplyByDate()).add("ServiceUpdateType", (Object)this.serviceUpdateTypeAsString()).add("UpdateActionAvailableDate", (Object)this.updateActionAvailableDate()).add("UpdateActionStatus", (Object)this.updateActionStatusAsString()).add("NodesUpdated", (Object)this.nodesUpdated()).add("UpdateActionStatusModifiedDate", (Object)this.updateActionStatusModifiedDate()).add("SlaMet", (Object)this.slaMetAsString()).add("NodeGroupUpdateStatus", this.nodeGroupUpdateStatus()).add("CacheNodeUpdateStatus", this.cacheNodeUpdateStatus()).add("EstimatedUpdateTime", (Object)this.estimatedUpdateTime()).add("Engine", (Object)this.engine()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReplicationGroupId": {
                return Optional.ofNullable(clazz.cast(this.replicationGroupId()));
            }
            case "CacheClusterId": {
                return Optional.ofNullable(clazz.cast(this.cacheClusterId()));
            }
            case "ServiceUpdateName": {
                return Optional.ofNullable(clazz.cast(this.serviceUpdateName()));
            }
            case "ServiceUpdateReleaseDate": {
                return Optional.ofNullable(clazz.cast(this.serviceUpdateReleaseDate()));
            }
            case "ServiceUpdateSeverity": {
                return Optional.ofNullable(clazz.cast(this.serviceUpdateSeverityAsString()));
            }
            case "ServiceUpdateStatus": {
                return Optional.ofNullable(clazz.cast(this.serviceUpdateStatusAsString()));
            }
            case "ServiceUpdateRecommendedApplyByDate": {
                return Optional.ofNullable(clazz.cast(this.serviceUpdateRecommendedApplyByDate()));
            }
            case "ServiceUpdateType": {
                return Optional.ofNullable(clazz.cast(this.serviceUpdateTypeAsString()));
            }
            case "UpdateActionAvailableDate": {
                return Optional.ofNullable(clazz.cast(this.updateActionAvailableDate()));
            }
            case "UpdateActionStatus": {
                return Optional.ofNullable(clazz.cast(this.updateActionStatusAsString()));
            }
            case "NodesUpdated": {
                return Optional.ofNullable(clazz.cast(this.nodesUpdated()));
            }
            case "UpdateActionStatusModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.updateActionStatusModifiedDate()));
            }
            case "SlaMet": {
                return Optional.ofNullable(clazz.cast(this.slaMetAsString()));
            }
            case "NodeGroupUpdateStatus": {
                return Optional.ofNullable(clazz.cast(this.nodeGroupUpdateStatus()));
            }
            case "CacheNodeUpdateStatus": {
                return Optional.ofNullable(clazz.cast(this.cacheNodeUpdateStatus()));
            }
            case "EstimatedUpdateTime": {
                return Optional.ofNullable(clazz.cast(this.estimatedUpdateTime()));
            }
            case "Engine": {
                return Optional.ofNullable(clazz.cast(this.engine()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAction, T> g) {
        return obj -> g.apply((UpdateAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String replicationGroupId;
        private String cacheClusterId;
        private String serviceUpdateName;
        private Instant serviceUpdateReleaseDate;
        private String serviceUpdateSeverity;
        private String serviceUpdateStatus;
        private Instant serviceUpdateRecommendedApplyByDate;
        private String serviceUpdateType;
        private Instant updateActionAvailableDate;
        private String updateActionStatus;
        private String nodesUpdated;
        private Instant updateActionStatusModifiedDate;
        private String slaMet;
        private List<NodeGroupUpdateStatus> nodeGroupUpdateStatus = DefaultSdkAutoConstructList.getInstance();
        private List<CacheNodeUpdateStatus> cacheNodeUpdateStatus = DefaultSdkAutoConstructList.getInstance();
        private String estimatedUpdateTime;
        private String engine;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAction model) {
            this.replicationGroupId(model.replicationGroupId);
            this.cacheClusterId(model.cacheClusterId);
            this.serviceUpdateName(model.serviceUpdateName);
            this.serviceUpdateReleaseDate(model.serviceUpdateReleaseDate);
            this.serviceUpdateSeverity(model.serviceUpdateSeverity);
            this.serviceUpdateStatus(model.serviceUpdateStatus);
            this.serviceUpdateRecommendedApplyByDate(model.serviceUpdateRecommendedApplyByDate);
            this.serviceUpdateType(model.serviceUpdateType);
            this.updateActionAvailableDate(model.updateActionAvailableDate);
            this.updateActionStatus(model.updateActionStatus);
            this.nodesUpdated(model.nodesUpdated);
            this.updateActionStatusModifiedDate(model.updateActionStatusModifiedDate);
            this.slaMet(model.slaMet);
            this.nodeGroupUpdateStatus(model.nodeGroupUpdateStatus);
            this.cacheNodeUpdateStatus(model.cacheNodeUpdateStatus);
            this.estimatedUpdateTime(model.estimatedUpdateTime);
            this.engine(model.engine);
        }

        public final String getReplicationGroupId() {
            return this.replicationGroupId;
        }

        @Override
        public final Builder replicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
            return this;
        }

        public final void setReplicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
        }

        public final String getCacheClusterId() {
            return this.cacheClusterId;
        }

        @Override
        public final Builder cacheClusterId(String cacheClusterId) {
            this.cacheClusterId = cacheClusterId;
            return this;
        }

        public final void setCacheClusterId(String cacheClusterId) {
            this.cacheClusterId = cacheClusterId;
        }

        public final String getServiceUpdateName() {
            return this.serviceUpdateName;
        }

        @Override
        public final Builder serviceUpdateName(String serviceUpdateName) {
            this.serviceUpdateName = serviceUpdateName;
            return this;
        }

        public final void setServiceUpdateName(String serviceUpdateName) {
            this.serviceUpdateName = serviceUpdateName;
        }

        public final Instant getServiceUpdateReleaseDate() {
            return this.serviceUpdateReleaseDate;
        }

        @Override
        public final Builder serviceUpdateReleaseDate(Instant serviceUpdateReleaseDate) {
            this.serviceUpdateReleaseDate = serviceUpdateReleaseDate;
            return this;
        }

        public final void setServiceUpdateReleaseDate(Instant serviceUpdateReleaseDate) {
            this.serviceUpdateReleaseDate = serviceUpdateReleaseDate;
        }

        public final String getServiceUpdateSeverity() {
            return this.serviceUpdateSeverity;
        }

        @Override
        public final Builder serviceUpdateSeverity(String serviceUpdateSeverity) {
            this.serviceUpdateSeverity = serviceUpdateSeverity;
            return this;
        }

        @Override
        public final Builder serviceUpdateSeverity(ServiceUpdateSeverity serviceUpdateSeverity) {
            this.serviceUpdateSeverity(serviceUpdateSeverity == null ? null : serviceUpdateSeverity.toString());
            return this;
        }

        public final void setServiceUpdateSeverity(String serviceUpdateSeverity) {
            this.serviceUpdateSeverity = serviceUpdateSeverity;
        }

        public final String getServiceUpdateStatus() {
            return this.serviceUpdateStatus;
        }

        @Override
        public final Builder serviceUpdateStatus(String serviceUpdateStatus) {
            this.serviceUpdateStatus = serviceUpdateStatus;
            return this;
        }

        @Override
        public final Builder serviceUpdateStatus(ServiceUpdateStatus serviceUpdateStatus) {
            this.serviceUpdateStatus(serviceUpdateStatus == null ? null : serviceUpdateStatus.toString());
            return this;
        }

        public final void setServiceUpdateStatus(String serviceUpdateStatus) {
            this.serviceUpdateStatus = serviceUpdateStatus;
        }

        public final Instant getServiceUpdateRecommendedApplyByDate() {
            return this.serviceUpdateRecommendedApplyByDate;
        }

        @Override
        public final Builder serviceUpdateRecommendedApplyByDate(Instant serviceUpdateRecommendedApplyByDate) {
            this.serviceUpdateRecommendedApplyByDate = serviceUpdateRecommendedApplyByDate;
            return this;
        }

        public final void setServiceUpdateRecommendedApplyByDate(Instant serviceUpdateRecommendedApplyByDate) {
            this.serviceUpdateRecommendedApplyByDate = serviceUpdateRecommendedApplyByDate;
        }

        public final String getServiceUpdateType() {
            return this.serviceUpdateType;
        }

        @Override
        public final Builder serviceUpdateType(String serviceUpdateType) {
            this.serviceUpdateType = serviceUpdateType;
            return this;
        }

        @Override
        public final Builder serviceUpdateType(ServiceUpdateType serviceUpdateType) {
            this.serviceUpdateType(serviceUpdateType == null ? null : serviceUpdateType.toString());
            return this;
        }

        public final void setServiceUpdateType(String serviceUpdateType) {
            this.serviceUpdateType = serviceUpdateType;
        }

        public final Instant getUpdateActionAvailableDate() {
            return this.updateActionAvailableDate;
        }

        @Override
        public final Builder updateActionAvailableDate(Instant updateActionAvailableDate) {
            this.updateActionAvailableDate = updateActionAvailableDate;
            return this;
        }

        public final void setUpdateActionAvailableDate(Instant updateActionAvailableDate) {
            this.updateActionAvailableDate = updateActionAvailableDate;
        }

        public final String getUpdateActionStatus() {
            return this.updateActionStatus;
        }

        @Override
        public final Builder updateActionStatus(String updateActionStatus) {
            this.updateActionStatus = updateActionStatus;
            return this;
        }

        @Override
        public final Builder updateActionStatus(UpdateActionStatus updateActionStatus) {
            this.updateActionStatus(updateActionStatus == null ? null : updateActionStatus.toString());
            return this;
        }

        public final void setUpdateActionStatus(String updateActionStatus) {
            this.updateActionStatus = updateActionStatus;
        }

        public final String getNodesUpdated() {
            return this.nodesUpdated;
        }

        @Override
        public final Builder nodesUpdated(String nodesUpdated) {
            this.nodesUpdated = nodesUpdated;
            return this;
        }

        public final void setNodesUpdated(String nodesUpdated) {
            this.nodesUpdated = nodesUpdated;
        }

        public final Instant getUpdateActionStatusModifiedDate() {
            return this.updateActionStatusModifiedDate;
        }

        @Override
        public final Builder updateActionStatusModifiedDate(Instant updateActionStatusModifiedDate) {
            this.updateActionStatusModifiedDate = updateActionStatusModifiedDate;
            return this;
        }

        public final void setUpdateActionStatusModifiedDate(Instant updateActionStatusModifiedDate) {
            this.updateActionStatusModifiedDate = updateActionStatusModifiedDate;
        }

        public final String getSlaMet() {
            return this.slaMet;
        }

        @Override
        public final Builder slaMet(String slaMet) {
            this.slaMet = slaMet;
            return this;
        }

        @Override
        public final Builder slaMet(SlaMet slaMet) {
            this.slaMet(slaMet == null ? null : slaMet.toString());
            return this;
        }

        public final void setSlaMet(String slaMet) {
            this.slaMet = slaMet;
        }

        public final Collection<NodeGroupUpdateStatus.Builder> getNodeGroupUpdateStatus() {
            return this.nodeGroupUpdateStatus != null ? (Collection)this.nodeGroupUpdateStatus.stream().map(NodeGroupUpdateStatus::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder nodeGroupUpdateStatus(Collection<NodeGroupUpdateStatus> nodeGroupUpdateStatus) {
            this.nodeGroupUpdateStatus = NodeGroupUpdateStatusListCopier.copy(nodeGroupUpdateStatus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeGroupUpdateStatus(NodeGroupUpdateStatus ... nodeGroupUpdateStatus) {
            this.nodeGroupUpdateStatus(Arrays.asList(nodeGroupUpdateStatus));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeGroupUpdateStatus(Consumer<NodeGroupUpdateStatus.Builder> ... nodeGroupUpdateStatus) {
            this.nodeGroupUpdateStatus(Stream.of(nodeGroupUpdateStatus).map(c -> (NodeGroupUpdateStatus)((NodeGroupUpdateStatus.Builder)NodeGroupUpdateStatus.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setNodeGroupUpdateStatus(Collection<NodeGroupUpdateStatus.BuilderImpl> nodeGroupUpdateStatus) {
            this.nodeGroupUpdateStatus = NodeGroupUpdateStatusListCopier.copyFromBuilder(nodeGroupUpdateStatus);
        }

        public final Collection<CacheNodeUpdateStatus.Builder> getCacheNodeUpdateStatus() {
            return this.cacheNodeUpdateStatus != null ? (Collection)this.cacheNodeUpdateStatus.stream().map(CacheNodeUpdateStatus::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder cacheNodeUpdateStatus(Collection<CacheNodeUpdateStatus> cacheNodeUpdateStatus) {
            this.cacheNodeUpdateStatus = CacheNodeUpdateStatusListCopier.copy(cacheNodeUpdateStatus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheNodeUpdateStatus(CacheNodeUpdateStatus ... cacheNodeUpdateStatus) {
            this.cacheNodeUpdateStatus(Arrays.asList(cacheNodeUpdateStatus));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheNodeUpdateStatus(Consumer<CacheNodeUpdateStatus.Builder> ... cacheNodeUpdateStatus) {
            this.cacheNodeUpdateStatus(Stream.of(cacheNodeUpdateStatus).map(c -> (CacheNodeUpdateStatus)((CacheNodeUpdateStatus.Builder)CacheNodeUpdateStatus.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCacheNodeUpdateStatus(Collection<CacheNodeUpdateStatus.BuilderImpl> cacheNodeUpdateStatus) {
            this.cacheNodeUpdateStatus = CacheNodeUpdateStatusListCopier.copyFromBuilder(cacheNodeUpdateStatus);
        }

        public final String getEstimatedUpdateTime() {
            return this.estimatedUpdateTime;
        }

        @Override
        public final Builder estimatedUpdateTime(String estimatedUpdateTime) {
            this.estimatedUpdateTime = estimatedUpdateTime;
            return this;
        }

        public final void setEstimatedUpdateTime(String estimatedUpdateTime) {
            this.estimatedUpdateTime = estimatedUpdateTime;
        }

        public final String getEngine() {
            return this.engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public UpdateAction build() {
            return new UpdateAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UpdateAction> {
        public Builder replicationGroupId(String var1);

        public Builder cacheClusterId(String var1);

        public Builder serviceUpdateName(String var1);

        public Builder serviceUpdateReleaseDate(Instant var1);

        public Builder serviceUpdateSeverity(String var1);

        public Builder serviceUpdateSeverity(ServiceUpdateSeverity var1);

        public Builder serviceUpdateStatus(String var1);

        public Builder serviceUpdateStatus(ServiceUpdateStatus var1);

        public Builder serviceUpdateRecommendedApplyByDate(Instant var1);

        public Builder serviceUpdateType(String var1);

        public Builder serviceUpdateType(ServiceUpdateType var1);

        public Builder updateActionAvailableDate(Instant var1);

        public Builder updateActionStatus(String var1);

        public Builder updateActionStatus(UpdateActionStatus var1);

        public Builder nodesUpdated(String var1);

        public Builder updateActionStatusModifiedDate(Instant var1);

        public Builder slaMet(String var1);

        public Builder slaMet(SlaMet var1);

        public Builder nodeGroupUpdateStatus(Collection<NodeGroupUpdateStatus> var1);

        public Builder nodeGroupUpdateStatus(NodeGroupUpdateStatus ... var1);

        public Builder nodeGroupUpdateStatus(Consumer<NodeGroupUpdateStatus.Builder> ... var1);

        public Builder cacheNodeUpdateStatus(Collection<CacheNodeUpdateStatus> var1);

        public Builder cacheNodeUpdateStatus(CacheNodeUpdateStatus ... var1);

        public Builder cacheNodeUpdateStatus(Consumer<CacheNodeUpdateStatus.Builder> ... var1);

        public Builder estimatedUpdateTime(String var1);

        public Builder engine(String var1);
    }
}

