/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheResponse;
import software.amazon.awssdk.services.elasticache.model.GlobalReplicationGroup;
import software.amazon.awssdk.services.elasticache.model.GlobalReplicationGroupListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeGlobalReplicationGroupsResponse
extends ElastiCacheResponse
implements ToCopyableBuilder<Builder, DescribeGlobalReplicationGroupsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeGlobalReplicationGroupsResponse.getter(DescribeGlobalReplicationGroupsResponse::marker)).setter(DescribeGlobalReplicationGroupsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<List<GlobalReplicationGroup>> GLOBAL_REPLICATION_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeGlobalReplicationGroupsResponse.getter(DescribeGlobalReplicationGroupsResponse::globalReplicationGroups)).setter(DescribeGlobalReplicationGroupsResponse.setter(Builder::globalReplicationGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalReplicationGroups").build(), ListTrait.builder().memberLocationName("GlobalReplicationGroup").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GlobalReplicationGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalReplicationGroup").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, GLOBAL_REPLICATION_GROUPS_FIELD));
    private final String marker;
    private final List<GlobalReplicationGroup> globalReplicationGroups;

    private DescribeGlobalReplicationGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.globalReplicationGroups = builder.globalReplicationGroups;
    }

    public String marker() {
        return this.marker;
    }

    public boolean hasGlobalReplicationGroups() {
        return this.globalReplicationGroups != null && !(this.globalReplicationGroups instanceof SdkAutoConstructList);
    }

    public List<GlobalReplicationGroup> globalReplicationGroups() {
        return this.globalReplicationGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.globalReplicationGroups());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeGlobalReplicationGroupsResponse)) {
            return false;
        }
        DescribeGlobalReplicationGroupsResponse other = (DescribeGlobalReplicationGroupsResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && Objects.equals(this.globalReplicationGroups(), other.globalReplicationGroups());
    }

    public String toString() {
        return ToString.builder((String)"DescribeGlobalReplicationGroupsResponse").add("Marker", (Object)this.marker()).add("GlobalReplicationGroups", this.globalReplicationGroups()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "GlobalReplicationGroups": {
                return Optional.ofNullable(clazz.cast(this.globalReplicationGroups()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeGlobalReplicationGroupsResponse, T> g) {
        return obj -> g.apply((DescribeGlobalReplicationGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElastiCacheResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<GlobalReplicationGroup> globalReplicationGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeGlobalReplicationGroupsResponse model) {
            super(model);
            this.marker(model.marker);
            this.globalReplicationGroups(model.globalReplicationGroups);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<GlobalReplicationGroup.Builder> getGlobalReplicationGroups() {
            return this.globalReplicationGroups != null ? (Collection)this.globalReplicationGroups.stream().map(GlobalReplicationGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder globalReplicationGroups(Collection<GlobalReplicationGroup> globalReplicationGroups) {
            this.globalReplicationGroups = GlobalReplicationGroupListCopier.copy(globalReplicationGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalReplicationGroups(GlobalReplicationGroup ... globalReplicationGroups) {
            this.globalReplicationGroups(Arrays.asList(globalReplicationGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalReplicationGroups(Consumer<GlobalReplicationGroup.Builder> ... globalReplicationGroups) {
            this.globalReplicationGroups(Stream.of(globalReplicationGroups).map(c -> (GlobalReplicationGroup)((GlobalReplicationGroup.Builder)GlobalReplicationGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGlobalReplicationGroups(Collection<GlobalReplicationGroup.BuilderImpl> globalReplicationGroups) {
            this.globalReplicationGroups = GlobalReplicationGroupListCopier.copyFromBuilder(globalReplicationGroups);
        }

        @Override
        public DescribeGlobalReplicationGroupsResponse build() {
            return new DescribeGlobalReplicationGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElastiCacheResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeGlobalReplicationGroupsResponse> {
        public Builder marker(String var1);

        public Builder globalReplicationGroups(Collection<GlobalReplicationGroup> var1);

        public Builder globalReplicationGroups(GlobalReplicationGroup ... var1);

        public Builder globalReplicationGroups(Consumer<GlobalReplicationGroup.Builder> ... var1);
    }
}

