/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartMigrationRequest extends ElastiCacheRequest implements
        ToCopyableBuilder<StartMigrationRequest.Builder, StartMigrationRequest> {
    private static final SdkField<String> REPLICATION_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartMigrationRequest::replicationGroupId)).setter(setter(Builder::replicationGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationGroupId").build())
            .build();

    private static final SdkField<List<CustomerNodeEndpoint>> CUSTOMER_NODE_ENDPOINT_LIST_FIELD = SdkField
            .<List<CustomerNodeEndpoint>> builder(MarshallingType.LIST)
            .getter(getter(StartMigrationRequest::customerNodeEndpointList))
            .setter(setter(Builder::customerNodeEndpointList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerNodeEndpointList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CustomerNodeEndpoint> builder(MarshallingType.SDK_POJO)
                                            .constructor(CustomerNodeEndpoint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_GROUP_ID_FIELD,
            CUSTOMER_NODE_ENDPOINT_LIST_FIELD));

    private final String replicationGroupId;

    private final List<CustomerNodeEndpoint> customerNodeEndpointList;

    private StartMigrationRequest(BuilderImpl builder) {
        super(builder);
        this.replicationGroupId = builder.replicationGroupId;
        this.customerNodeEndpointList = builder.customerNodeEndpointList;
    }

    /**
     * <p>
     * The ID of the replication group to which data should be migrated.
     * </p>
     * 
     * @return The ID of the replication group to which data should be migrated.
     */
    public String replicationGroupId() {
        return replicationGroupId;
    }

    /**
     * Returns true if the CustomerNodeEndpointList property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasCustomerNodeEndpointList() {
        return customerNodeEndpointList != null && !(customerNodeEndpointList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of endpoints from which data should be migrated. For Redis (cluster mode disabled), list should have only
     * one element.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCustomerNodeEndpointList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of endpoints from which data should be migrated. For Redis (cluster mode disabled), list should have
     *         only one element.
     */
    public List<CustomerNodeEndpoint> customerNodeEndpointList() {
        return customerNodeEndpointList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(replicationGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(customerNodeEndpointList());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartMigrationRequest)) {
            return false;
        }
        StartMigrationRequest other = (StartMigrationRequest) obj;
        return Objects.equals(replicationGroupId(), other.replicationGroupId())
                && Objects.equals(customerNodeEndpointList(), other.customerNodeEndpointList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("StartMigrationRequest").add("ReplicationGroupId", replicationGroupId())
                .add("CustomerNodeEndpointList", customerNodeEndpointList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReplicationGroupId":
            return Optional.ofNullable(clazz.cast(replicationGroupId()));
        case "CustomerNodeEndpointList":
            return Optional.ofNullable(clazz.cast(customerNodeEndpointList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartMigrationRequest, T> g) {
        return obj -> g.apply((StartMigrationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElastiCacheRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartMigrationRequest> {
        /**
         * <p>
         * The ID of the replication group to which data should be migrated.
         * </p>
         * 
         * @param replicationGroupId
         *        The ID of the replication group to which data should be migrated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationGroupId(String replicationGroupId);

        /**
         * <p>
         * List of endpoints from which data should be migrated. For Redis (cluster mode disabled), list should have
         * only one element.
         * </p>
         * 
         * @param customerNodeEndpointList
         *        List of endpoints from which data should be migrated. For Redis (cluster mode disabled), list should
         *        have only one element.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerNodeEndpointList(Collection<CustomerNodeEndpoint> customerNodeEndpointList);

        /**
         * <p>
         * List of endpoints from which data should be migrated. For Redis (cluster mode disabled), list should have
         * only one element.
         * </p>
         * 
         * @param customerNodeEndpointList
         *        List of endpoints from which data should be migrated. For Redis (cluster mode disabled), list should
         *        have only one element.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerNodeEndpointList(CustomerNodeEndpoint... customerNodeEndpointList);

        /**
         * <p>
         * List of endpoints from which data should be migrated. For Redis (cluster mode disabled), list should have
         * only one element.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CustomerNodeEndpoint>.Builder} avoiding the
         * need to create one manually via {@link List<CustomerNodeEndpoint>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CustomerNodeEndpoint>.Builder#build()} is called immediately
         * and its result is passed to {@link #customerNodeEndpointList(List<CustomerNodeEndpoint>)}.
         * 
         * @param customerNodeEndpointList
         *        a consumer that will call methods on {@link List<CustomerNodeEndpoint>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customerNodeEndpointList(List<CustomerNodeEndpoint>)
         */
        Builder customerNodeEndpointList(Consumer<CustomerNodeEndpoint.Builder>... customerNodeEndpointList);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElastiCacheRequest.BuilderImpl implements Builder {
        private String replicationGroupId;

        private List<CustomerNodeEndpoint> customerNodeEndpointList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartMigrationRequest model) {
            super(model);
            replicationGroupId(model.replicationGroupId);
            customerNodeEndpointList(model.customerNodeEndpointList);
        }

        public final String getReplicationGroupId() {
            return replicationGroupId;
        }

        @Override
        public final Builder replicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
            return this;
        }

        public final void setReplicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
        }

        public final Collection<CustomerNodeEndpoint.Builder> getCustomerNodeEndpointList() {
            return customerNodeEndpointList != null ? customerNodeEndpointList.stream().map(CustomerNodeEndpoint::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder customerNodeEndpointList(Collection<CustomerNodeEndpoint> customerNodeEndpointList) {
            this.customerNodeEndpointList = CustomerNodeEndpointListCopier.copy(customerNodeEndpointList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customerNodeEndpointList(CustomerNodeEndpoint... customerNodeEndpointList) {
            customerNodeEndpointList(Arrays.asList(customerNodeEndpointList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customerNodeEndpointList(Consumer<CustomerNodeEndpoint.Builder>... customerNodeEndpointList) {
            customerNodeEndpointList(Stream.of(customerNodeEndpointList)
                    .map(c -> CustomerNodeEndpoint.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCustomerNodeEndpointList(Collection<CustomerNodeEndpoint.BuilderImpl> customerNodeEndpointList) {
            this.customerNodeEndpointList = CustomerNodeEndpointListCopier.copyFromBuilder(customerNodeEndpointList);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartMigrationRequest build() {
            return new StartMigrationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
