/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An update that you can apply to your Redis clusters.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceUpdate implements SdkPojo, Serializable, ToCopyableBuilder<ServiceUpdate.Builder, ServiceUpdate> {
    private static final SdkField<String> SERVICE_UPDATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ServiceUpdate::serviceUpdateName)).setter(setter(Builder::serviceUpdateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceUpdateName").build()).build();

    private static final SdkField<Instant> SERVICE_UPDATE_RELEASE_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT).getter(getter(ServiceUpdate::serviceUpdateReleaseDate))
            .setter(setter(Builder::serviceUpdateReleaseDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceUpdateReleaseDate").build())
            .build();

    private static final SdkField<Instant> SERVICE_UPDATE_END_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ServiceUpdate::serviceUpdateEndDate)).setter(setter(Builder::serviceUpdateEndDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceUpdateEndDate").build())
            .build();

    private static final SdkField<String> SERVICE_UPDATE_SEVERITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ServiceUpdate::serviceUpdateSeverityAsString)).setter(setter(Builder::serviceUpdateSeverity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceUpdateSeverity").build())
            .build();

    private static final SdkField<Instant> SERVICE_UPDATE_RECOMMENDED_APPLY_BY_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ServiceUpdate::serviceUpdateRecommendedApplyByDate))
            .setter(setter(Builder::serviceUpdateRecommendedApplyByDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ServiceUpdateRecommendedApplyByDate").build()).build();

    private static final SdkField<String> SERVICE_UPDATE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ServiceUpdate::serviceUpdateStatusAsString)).setter(setter(Builder::serviceUpdateStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceUpdateStatus").build())
            .build();

    private static final SdkField<String> SERVICE_UPDATE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ServiceUpdate::serviceUpdateDescription)).setter(setter(Builder::serviceUpdateDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceUpdateDescription").build())
            .build();

    private static final SdkField<String> SERVICE_UPDATE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ServiceUpdate::serviceUpdateTypeAsString)).setter(setter(Builder::serviceUpdateType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceUpdateType").build()).build();

    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ServiceUpdate::engine)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ServiceUpdate::engineVersion)).setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<Boolean> AUTO_UPDATE_AFTER_RECOMMENDED_APPLY_BY_DATE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ServiceUpdate::autoUpdateAfterRecommendedApplyByDate))
            .setter(setter(Builder::autoUpdateAfterRecommendedApplyByDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("AutoUpdateAfterRecommendedApplyByDate").build()).build();

    private static final SdkField<String> ESTIMATED_UPDATE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ServiceUpdate::estimatedUpdateTime)).setter(setter(Builder::estimatedUpdateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedUpdateTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_UPDATE_NAME_FIELD,
            SERVICE_UPDATE_RELEASE_DATE_FIELD, SERVICE_UPDATE_END_DATE_FIELD, SERVICE_UPDATE_SEVERITY_FIELD,
            SERVICE_UPDATE_RECOMMENDED_APPLY_BY_DATE_FIELD, SERVICE_UPDATE_STATUS_FIELD, SERVICE_UPDATE_DESCRIPTION_FIELD,
            SERVICE_UPDATE_TYPE_FIELD, ENGINE_FIELD, ENGINE_VERSION_FIELD, AUTO_UPDATE_AFTER_RECOMMENDED_APPLY_BY_DATE_FIELD,
            ESTIMATED_UPDATE_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String serviceUpdateName;

    private final Instant serviceUpdateReleaseDate;

    private final Instant serviceUpdateEndDate;

    private final String serviceUpdateSeverity;

    private final Instant serviceUpdateRecommendedApplyByDate;

    private final String serviceUpdateStatus;

    private final String serviceUpdateDescription;

    private final String serviceUpdateType;

    private final String engine;

    private final String engineVersion;

    private final Boolean autoUpdateAfterRecommendedApplyByDate;

    private final String estimatedUpdateTime;

    private ServiceUpdate(BuilderImpl builder) {
        this.serviceUpdateName = builder.serviceUpdateName;
        this.serviceUpdateReleaseDate = builder.serviceUpdateReleaseDate;
        this.serviceUpdateEndDate = builder.serviceUpdateEndDate;
        this.serviceUpdateSeverity = builder.serviceUpdateSeverity;
        this.serviceUpdateRecommendedApplyByDate = builder.serviceUpdateRecommendedApplyByDate;
        this.serviceUpdateStatus = builder.serviceUpdateStatus;
        this.serviceUpdateDescription = builder.serviceUpdateDescription;
        this.serviceUpdateType = builder.serviceUpdateType;
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.autoUpdateAfterRecommendedApplyByDate = builder.autoUpdateAfterRecommendedApplyByDate;
        this.estimatedUpdateTime = builder.estimatedUpdateTime;
    }

    /**
     * <p>
     * The unique ID of the service update
     * </p>
     * 
     * @return The unique ID of the service update
     */
    public String serviceUpdateName() {
        return serviceUpdateName;
    }

    /**
     * <p>
     * The date when the service update is initially available
     * </p>
     * 
     * @return The date when the service update is initially available
     */
    public Instant serviceUpdateReleaseDate() {
        return serviceUpdateReleaseDate;
    }

    /**
     * <p>
     * The date after which the service update is no longer available
     * </p>
     * 
     * @return The date after which the service update is no longer available
     */
    public Instant serviceUpdateEndDate() {
        return serviceUpdateEndDate;
    }

    /**
     * <p>
     * The severity of the service update
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #serviceUpdateSeverity} will return {@link ServiceUpdateSeverity#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #serviceUpdateSeverityAsString}.
     * </p>
     * 
     * @return The severity of the service update
     * @see ServiceUpdateSeverity
     */
    public ServiceUpdateSeverity serviceUpdateSeverity() {
        return ServiceUpdateSeverity.fromValue(serviceUpdateSeverity);
    }

    /**
     * <p>
     * The severity of the service update
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #serviceUpdateSeverity} will return {@link ServiceUpdateSeverity#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #serviceUpdateSeverityAsString}.
     * </p>
     * 
     * @return The severity of the service update
     * @see ServiceUpdateSeverity
     */
    public String serviceUpdateSeverityAsString() {
        return serviceUpdateSeverity;
    }

    /**
     * <p>
     * The recommendend date to apply the service update in order to ensure compliance. For information on compliance,
     * see <a href=
     * "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/elasticache-compliance.html#elasticache-compliance-self-service"
     * >Self-Service Security Updates for Compliance</a>.
     * </p>
     * 
     * @return The recommendend date to apply the service update in order to ensure compliance. For information on
     *         compliance, see <a href=
     *         "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/elasticache-compliance.html#elasticache-compliance-self-service"
     *         >Self-Service Security Updates for Compliance</a>.
     */
    public Instant serviceUpdateRecommendedApplyByDate() {
        return serviceUpdateRecommendedApplyByDate;
    }

    /**
     * <p>
     * The status of the service update
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #serviceUpdateStatus} will return {@link ServiceUpdateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #serviceUpdateStatusAsString}.
     * </p>
     * 
     * @return The status of the service update
     * @see ServiceUpdateStatus
     */
    public ServiceUpdateStatus serviceUpdateStatus() {
        return ServiceUpdateStatus.fromValue(serviceUpdateStatus);
    }

    /**
     * <p>
     * The status of the service update
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #serviceUpdateStatus} will return {@link ServiceUpdateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #serviceUpdateStatusAsString}.
     * </p>
     * 
     * @return The status of the service update
     * @see ServiceUpdateStatus
     */
    public String serviceUpdateStatusAsString() {
        return serviceUpdateStatus;
    }

    /**
     * <p>
     * Provides details of the service update
     * </p>
     * 
     * @return Provides details of the service update
     */
    public String serviceUpdateDescription() {
        return serviceUpdateDescription;
    }

    /**
     * <p>
     * Reflects the nature of the service update
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serviceUpdateType}
     * will return {@link ServiceUpdateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #serviceUpdateTypeAsString}.
     * </p>
     * 
     * @return Reflects the nature of the service update
     * @see ServiceUpdateType
     */
    public ServiceUpdateType serviceUpdateType() {
        return ServiceUpdateType.fromValue(serviceUpdateType);
    }

    /**
     * <p>
     * Reflects the nature of the service update
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serviceUpdateType}
     * will return {@link ServiceUpdateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #serviceUpdateTypeAsString}.
     * </p>
     * 
     * @return Reflects the nature of the service update
     * @see ServiceUpdateType
     */
    public String serviceUpdateTypeAsString() {
        return serviceUpdateType;
    }

    /**
     * <p>
     * The Elasticache engine to which the update applies. Either Redis or Memcached
     * </p>
     * 
     * @return The Elasticache engine to which the update applies. Either Redis or Memcached
     */
    public String engine() {
        return engine;
    }

    /**
     * <p>
     * The Elasticache engine version to which the update applies. Either Redis or Memcached engine version
     * </p>
     * 
     * @return The Elasticache engine version to which the update applies. Either Redis or Memcached engine version
     */
    public String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * Indicates whether the service update will be automatically applied once the recommended apply-by date has
     * expired.
     * </p>
     * 
     * @return Indicates whether the service update will be automatically applied once the recommended apply-by date has
     *         expired.
     */
    public Boolean autoUpdateAfterRecommendedApplyByDate() {
        return autoUpdateAfterRecommendedApplyByDate;
    }

    /**
     * <p>
     * The estimated length of time the service update will take
     * </p>
     * 
     * @return The estimated length of time the service update will take
     */
    public String estimatedUpdateTime() {
        return estimatedUpdateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serviceUpdateName());
        hashCode = 31 * hashCode + Objects.hashCode(serviceUpdateReleaseDate());
        hashCode = 31 * hashCode + Objects.hashCode(serviceUpdateEndDate());
        hashCode = 31 * hashCode + Objects.hashCode(serviceUpdateSeverityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(serviceUpdateRecommendedApplyByDate());
        hashCode = 31 * hashCode + Objects.hashCode(serviceUpdateStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(serviceUpdateDescription());
        hashCode = 31 * hashCode + Objects.hashCode(serviceUpdateTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(engine());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(autoUpdateAfterRecommendedApplyByDate());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedUpdateTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceUpdate)) {
            return false;
        }
        ServiceUpdate other = (ServiceUpdate) obj;
        return Objects.equals(serviceUpdateName(), other.serviceUpdateName())
                && Objects.equals(serviceUpdateReleaseDate(), other.serviceUpdateReleaseDate())
                && Objects.equals(serviceUpdateEndDate(), other.serviceUpdateEndDate())
                && Objects.equals(serviceUpdateSeverityAsString(), other.serviceUpdateSeverityAsString())
                && Objects.equals(serviceUpdateRecommendedApplyByDate(), other.serviceUpdateRecommendedApplyByDate())
                && Objects.equals(serviceUpdateStatusAsString(), other.serviceUpdateStatusAsString())
                && Objects.equals(serviceUpdateDescription(), other.serviceUpdateDescription())
                && Objects.equals(serviceUpdateTypeAsString(), other.serviceUpdateTypeAsString())
                && Objects.equals(engine(), other.engine()) && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(autoUpdateAfterRecommendedApplyByDate(), other.autoUpdateAfterRecommendedApplyByDate())
                && Objects.equals(estimatedUpdateTime(), other.estimatedUpdateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ServiceUpdate").add("ServiceUpdateName", serviceUpdateName())
                .add("ServiceUpdateReleaseDate", serviceUpdateReleaseDate()).add("ServiceUpdateEndDate", serviceUpdateEndDate())
                .add("ServiceUpdateSeverity", serviceUpdateSeverityAsString())
                .add("ServiceUpdateRecommendedApplyByDate", serviceUpdateRecommendedApplyByDate())
                .add("ServiceUpdateStatus", serviceUpdateStatusAsString())
                .add("ServiceUpdateDescription", serviceUpdateDescription())
                .add("ServiceUpdateType", serviceUpdateTypeAsString()).add("Engine", engine())
                .add("EngineVersion", engineVersion())
                .add("AutoUpdateAfterRecommendedApplyByDate", autoUpdateAfterRecommendedApplyByDate())
                .add("EstimatedUpdateTime", estimatedUpdateTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceUpdateName":
            return Optional.ofNullable(clazz.cast(serviceUpdateName()));
        case "ServiceUpdateReleaseDate":
            return Optional.ofNullable(clazz.cast(serviceUpdateReleaseDate()));
        case "ServiceUpdateEndDate":
            return Optional.ofNullable(clazz.cast(serviceUpdateEndDate()));
        case "ServiceUpdateSeverity":
            return Optional.ofNullable(clazz.cast(serviceUpdateSeverityAsString()));
        case "ServiceUpdateRecommendedApplyByDate":
            return Optional.ofNullable(clazz.cast(serviceUpdateRecommendedApplyByDate()));
        case "ServiceUpdateStatus":
            return Optional.ofNullable(clazz.cast(serviceUpdateStatusAsString()));
        case "ServiceUpdateDescription":
            return Optional.ofNullable(clazz.cast(serviceUpdateDescription()));
        case "ServiceUpdateType":
            return Optional.ofNullable(clazz.cast(serviceUpdateTypeAsString()));
        case "Engine":
            return Optional.ofNullable(clazz.cast(engine()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "AutoUpdateAfterRecommendedApplyByDate":
            return Optional.ofNullable(clazz.cast(autoUpdateAfterRecommendedApplyByDate()));
        case "EstimatedUpdateTime":
            return Optional.ofNullable(clazz.cast(estimatedUpdateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServiceUpdate, T> g) {
        return obj -> g.apply((ServiceUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceUpdate> {
        /**
         * <p>
         * The unique ID of the service update
         * </p>
         * 
         * @param serviceUpdateName
         *        The unique ID of the service update
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceUpdateName(String serviceUpdateName);

        /**
         * <p>
         * The date when the service update is initially available
         * </p>
         * 
         * @param serviceUpdateReleaseDate
         *        The date when the service update is initially available
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceUpdateReleaseDate(Instant serviceUpdateReleaseDate);

        /**
         * <p>
         * The date after which the service update is no longer available
         * </p>
         * 
         * @param serviceUpdateEndDate
         *        The date after which the service update is no longer available
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceUpdateEndDate(Instant serviceUpdateEndDate);

        /**
         * <p>
         * The severity of the service update
         * </p>
         * 
         * @param serviceUpdateSeverity
         *        The severity of the service update
         * @see ServiceUpdateSeverity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceUpdateSeverity
         */
        Builder serviceUpdateSeverity(String serviceUpdateSeverity);

        /**
         * <p>
         * The severity of the service update
         * </p>
         * 
         * @param serviceUpdateSeverity
         *        The severity of the service update
         * @see ServiceUpdateSeverity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceUpdateSeverity
         */
        Builder serviceUpdateSeverity(ServiceUpdateSeverity serviceUpdateSeverity);

        /**
         * <p>
         * The recommendend date to apply the service update in order to ensure compliance. For information on
         * compliance, see <a href=
         * "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/elasticache-compliance.html#elasticache-compliance-self-service"
         * >Self-Service Security Updates for Compliance</a>.
         * </p>
         * 
         * @param serviceUpdateRecommendedApplyByDate
         *        The recommendend date to apply the service update in order to ensure compliance. For information on
         *        compliance, see <a href=
         *        "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/elasticache-compliance.html#elasticache-compliance-self-service"
         *        >Self-Service Security Updates for Compliance</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceUpdateRecommendedApplyByDate(Instant serviceUpdateRecommendedApplyByDate);

        /**
         * <p>
         * The status of the service update
         * </p>
         * 
         * @param serviceUpdateStatus
         *        The status of the service update
         * @see ServiceUpdateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceUpdateStatus
         */
        Builder serviceUpdateStatus(String serviceUpdateStatus);

        /**
         * <p>
         * The status of the service update
         * </p>
         * 
         * @param serviceUpdateStatus
         *        The status of the service update
         * @see ServiceUpdateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceUpdateStatus
         */
        Builder serviceUpdateStatus(ServiceUpdateStatus serviceUpdateStatus);

        /**
         * <p>
         * Provides details of the service update
         * </p>
         * 
         * @param serviceUpdateDescription
         *        Provides details of the service update
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceUpdateDescription(String serviceUpdateDescription);

        /**
         * <p>
         * Reflects the nature of the service update
         * </p>
         * 
         * @param serviceUpdateType
         *        Reflects the nature of the service update
         * @see ServiceUpdateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceUpdateType
         */
        Builder serviceUpdateType(String serviceUpdateType);

        /**
         * <p>
         * Reflects the nature of the service update
         * </p>
         * 
         * @param serviceUpdateType
         *        Reflects the nature of the service update
         * @see ServiceUpdateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceUpdateType
         */
        Builder serviceUpdateType(ServiceUpdateType serviceUpdateType);

        /**
         * <p>
         * The Elasticache engine to which the update applies. Either Redis or Memcached
         * </p>
         * 
         * @param engine
         *        The Elasticache engine to which the update applies. Either Redis or Memcached
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engine(String engine);

        /**
         * <p>
         * The Elasticache engine version to which the update applies. Either Redis or Memcached engine version
         * </p>
         * 
         * @param engineVersion
         *        The Elasticache engine version to which the update applies. Either Redis or Memcached engine version
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * Indicates whether the service update will be automatically applied once the recommended apply-by date has
         * expired.
         * </p>
         * 
         * @param autoUpdateAfterRecommendedApplyByDate
         *        Indicates whether the service update will be automatically applied once the recommended apply-by date
         *        has expired.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoUpdateAfterRecommendedApplyByDate(Boolean autoUpdateAfterRecommendedApplyByDate);

        /**
         * <p>
         * The estimated length of time the service update will take
         * </p>
         * 
         * @param estimatedUpdateTime
         *        The estimated length of time the service update will take
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedUpdateTime(String estimatedUpdateTime);
    }

    static final class BuilderImpl implements Builder {
        private String serviceUpdateName;

        private Instant serviceUpdateReleaseDate;

        private Instant serviceUpdateEndDate;

        private String serviceUpdateSeverity;

        private Instant serviceUpdateRecommendedApplyByDate;

        private String serviceUpdateStatus;

        private String serviceUpdateDescription;

        private String serviceUpdateType;

        private String engine;

        private String engineVersion;

        private Boolean autoUpdateAfterRecommendedApplyByDate;

        private String estimatedUpdateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceUpdate model) {
            serviceUpdateName(model.serviceUpdateName);
            serviceUpdateReleaseDate(model.serviceUpdateReleaseDate);
            serviceUpdateEndDate(model.serviceUpdateEndDate);
            serviceUpdateSeverity(model.serviceUpdateSeverity);
            serviceUpdateRecommendedApplyByDate(model.serviceUpdateRecommendedApplyByDate);
            serviceUpdateStatus(model.serviceUpdateStatus);
            serviceUpdateDescription(model.serviceUpdateDescription);
            serviceUpdateType(model.serviceUpdateType);
            engine(model.engine);
            engineVersion(model.engineVersion);
            autoUpdateAfterRecommendedApplyByDate(model.autoUpdateAfterRecommendedApplyByDate);
            estimatedUpdateTime(model.estimatedUpdateTime);
        }

        public final String getServiceUpdateName() {
            return serviceUpdateName;
        }

        @Override
        public final Builder serviceUpdateName(String serviceUpdateName) {
            this.serviceUpdateName = serviceUpdateName;
            return this;
        }

        public final void setServiceUpdateName(String serviceUpdateName) {
            this.serviceUpdateName = serviceUpdateName;
        }

        public final Instant getServiceUpdateReleaseDate() {
            return serviceUpdateReleaseDate;
        }

        @Override
        public final Builder serviceUpdateReleaseDate(Instant serviceUpdateReleaseDate) {
            this.serviceUpdateReleaseDate = serviceUpdateReleaseDate;
            return this;
        }

        public final void setServiceUpdateReleaseDate(Instant serviceUpdateReleaseDate) {
            this.serviceUpdateReleaseDate = serviceUpdateReleaseDate;
        }

        public final Instant getServiceUpdateEndDate() {
            return serviceUpdateEndDate;
        }

        @Override
        public final Builder serviceUpdateEndDate(Instant serviceUpdateEndDate) {
            this.serviceUpdateEndDate = serviceUpdateEndDate;
            return this;
        }

        public final void setServiceUpdateEndDate(Instant serviceUpdateEndDate) {
            this.serviceUpdateEndDate = serviceUpdateEndDate;
        }

        public final String getServiceUpdateSeverity() {
            return serviceUpdateSeverity;
        }

        @Override
        public final Builder serviceUpdateSeverity(String serviceUpdateSeverity) {
            this.serviceUpdateSeverity = serviceUpdateSeverity;
            return this;
        }

        @Override
        public final Builder serviceUpdateSeverity(ServiceUpdateSeverity serviceUpdateSeverity) {
            this.serviceUpdateSeverity(serviceUpdateSeverity == null ? null : serviceUpdateSeverity.toString());
            return this;
        }

        public final void setServiceUpdateSeverity(String serviceUpdateSeverity) {
            this.serviceUpdateSeverity = serviceUpdateSeverity;
        }

        public final Instant getServiceUpdateRecommendedApplyByDate() {
            return serviceUpdateRecommendedApplyByDate;
        }

        @Override
        public final Builder serviceUpdateRecommendedApplyByDate(Instant serviceUpdateRecommendedApplyByDate) {
            this.serviceUpdateRecommendedApplyByDate = serviceUpdateRecommendedApplyByDate;
            return this;
        }

        public final void setServiceUpdateRecommendedApplyByDate(Instant serviceUpdateRecommendedApplyByDate) {
            this.serviceUpdateRecommendedApplyByDate = serviceUpdateRecommendedApplyByDate;
        }

        public final String getServiceUpdateStatus() {
            return serviceUpdateStatus;
        }

        @Override
        public final Builder serviceUpdateStatus(String serviceUpdateStatus) {
            this.serviceUpdateStatus = serviceUpdateStatus;
            return this;
        }

        @Override
        public final Builder serviceUpdateStatus(ServiceUpdateStatus serviceUpdateStatus) {
            this.serviceUpdateStatus(serviceUpdateStatus == null ? null : serviceUpdateStatus.toString());
            return this;
        }

        public final void setServiceUpdateStatus(String serviceUpdateStatus) {
            this.serviceUpdateStatus = serviceUpdateStatus;
        }

        public final String getServiceUpdateDescription() {
            return serviceUpdateDescription;
        }

        @Override
        public final Builder serviceUpdateDescription(String serviceUpdateDescription) {
            this.serviceUpdateDescription = serviceUpdateDescription;
            return this;
        }

        public final void setServiceUpdateDescription(String serviceUpdateDescription) {
            this.serviceUpdateDescription = serviceUpdateDescription;
        }

        public final String getServiceUpdateType() {
            return serviceUpdateType;
        }

        @Override
        public final Builder serviceUpdateType(String serviceUpdateType) {
            this.serviceUpdateType = serviceUpdateType;
            return this;
        }

        @Override
        public final Builder serviceUpdateType(ServiceUpdateType serviceUpdateType) {
            this.serviceUpdateType(serviceUpdateType == null ? null : serviceUpdateType.toString());
            return this;
        }

        public final void setServiceUpdateType(String serviceUpdateType) {
            this.serviceUpdateType = serviceUpdateType;
        }

        public final String getEngine() {
            return engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final Boolean getAutoUpdateAfterRecommendedApplyByDate() {
            return autoUpdateAfterRecommendedApplyByDate;
        }

        @Override
        public final Builder autoUpdateAfterRecommendedApplyByDate(Boolean autoUpdateAfterRecommendedApplyByDate) {
            this.autoUpdateAfterRecommendedApplyByDate = autoUpdateAfterRecommendedApplyByDate;
            return this;
        }

        public final void setAutoUpdateAfterRecommendedApplyByDate(Boolean autoUpdateAfterRecommendedApplyByDate) {
            this.autoUpdateAfterRecommendedApplyByDate = autoUpdateAfterRecommendedApplyByDate;
        }

        public final String getEstimatedUpdateTime() {
            return estimatedUpdateTime;
        }

        @Override
        public final Builder estimatedUpdateTime(String estimatedUpdateTime) {
            this.estimatedUpdateTime = estimatedUpdateTime;
            return this;
        }

        public final void setEstimatedUpdateTime(String estimatedUpdateTime) {
            this.estimatedUpdateTime = estimatedUpdateTime;
        }

        @Override
        public ServiceUpdate build() {
            return new ServiceUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
