/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a <code>ResetCacheParameterGroup</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResetCacheParameterGroupRequest extends ElastiCacheRequest implements
        ToCopyableBuilder<ResetCacheParameterGroupRequest.Builder, ResetCacheParameterGroupRequest> {
    private static final SdkField<String> CACHE_PARAMETER_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResetCacheParameterGroupRequest::cacheParameterGroupName))
            .setter(setter(Builder::cacheParameterGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheParameterGroupName").build())
            .build();

    private static final SdkField<Boolean> RESET_ALL_PARAMETERS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ResetCacheParameterGroupRequest::resetAllParameters)).setter(setter(Builder::resetAllParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResetAllParameters").build())
            .build();

    private static final SdkField<List<ParameterNameValue>> PARAMETER_NAME_VALUES_FIELD = SdkField
            .<List<ParameterNameValue>> builder(MarshallingType.LIST)
            .getter(getter(ResetCacheParameterGroupRequest::parameterNameValues))
            .setter(setter(Builder::parameterNameValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterNameValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("ParameterNameValue")
                            .memberFieldInfo(
                                    SdkField.<ParameterNameValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(ParameterNameValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("ParameterNameValue").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CACHE_PARAMETER_GROUP_NAME_FIELD, RESET_ALL_PARAMETERS_FIELD, PARAMETER_NAME_VALUES_FIELD));

    private final String cacheParameterGroupName;

    private final Boolean resetAllParameters;

    private final List<ParameterNameValue> parameterNameValues;

    private ResetCacheParameterGroupRequest(BuilderImpl builder) {
        super(builder);
        this.cacheParameterGroupName = builder.cacheParameterGroupName;
        this.resetAllParameters = builder.resetAllParameters;
        this.parameterNameValues = builder.parameterNameValues;
    }

    /**
     * <p>
     * The name of the cache parameter group to reset.
     * </p>
     * 
     * @return The name of the cache parameter group to reset.
     */
    public String cacheParameterGroupName() {
        return cacheParameterGroupName;
    }

    /**
     * <p>
     * If <code>true</code>, all parameters in the cache parameter group are reset to their default values. If
     * <code>false</code>, only the parameters listed by <code>ParameterNameValues</code> are reset to their default
     * values.
     * </p>
     * <p>
     * Valid values: <code>true</code> | <code>false</code>
     * </p>
     * 
     * @return If <code>true</code>, all parameters in the cache parameter group are reset to their default values. If
     *         <code>false</code>, only the parameters listed by <code>ParameterNameValues</code> are reset to their
     *         default values.</p>
     *         <p>
     *         Valid values: <code>true</code> | <code>false</code>
     */
    public Boolean resetAllParameters() {
        return resetAllParameters;
    }

    /**
     * Returns true if the ParameterNameValues property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasParameterNameValues() {
        return parameterNameValues != null && !(parameterNameValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of parameter names to reset to their default values. If <code>ResetAllParameters</code> is
     * <code>true</code>, do not use <code>ParameterNameValues</code>. If <code>ResetAllParameters</code> is
     * <code>false</code>, you must specify the name of at least one parameter to reset.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasParameterNameValues()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of parameter names to reset to their default values. If <code>ResetAllParameters</code> is
     *         <code>true</code>, do not use <code>ParameterNameValues</code>. If <code>ResetAllParameters</code> is
     *         <code>false</code>, you must specify the name of at least one parameter to reset.
     */
    public List<ParameterNameValue> parameterNameValues() {
        return parameterNameValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cacheParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(resetAllParameters());
        hashCode = 31 * hashCode + Objects.hashCode(parameterNameValues());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResetCacheParameterGroupRequest)) {
            return false;
        }
        ResetCacheParameterGroupRequest other = (ResetCacheParameterGroupRequest) obj;
        return Objects.equals(cacheParameterGroupName(), other.cacheParameterGroupName())
                && Objects.equals(resetAllParameters(), other.resetAllParameters())
                && Objects.equals(parameterNameValues(), other.parameterNameValues());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ResetCacheParameterGroupRequest").add("CacheParameterGroupName", cacheParameterGroupName())
                .add("ResetAllParameters", resetAllParameters()).add("ParameterNameValues", parameterNameValues()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CacheParameterGroupName":
            return Optional.ofNullable(clazz.cast(cacheParameterGroupName()));
        case "ResetAllParameters":
            return Optional.ofNullable(clazz.cast(resetAllParameters()));
        case "ParameterNameValues":
            return Optional.ofNullable(clazz.cast(parameterNameValues()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResetCacheParameterGroupRequest, T> g) {
        return obj -> g.apply((ResetCacheParameterGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElastiCacheRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ResetCacheParameterGroupRequest> {
        /**
         * <p>
         * The name of the cache parameter group to reset.
         * </p>
         * 
         * @param cacheParameterGroupName
         *        The name of the cache parameter group to reset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheParameterGroupName(String cacheParameterGroupName);

        /**
         * <p>
         * If <code>true</code>, all parameters in the cache parameter group are reset to their default values. If
         * <code>false</code>, only the parameters listed by <code>ParameterNameValues</code> are reset to their default
         * values.
         * </p>
         * <p>
         * Valid values: <code>true</code> | <code>false</code>
         * </p>
         * 
         * @param resetAllParameters
         *        If <code>true</code>, all parameters in the cache parameter group are reset to their default values.
         *        If <code>false</code>, only the parameters listed by <code>ParameterNameValues</code> are reset to
         *        their default values.</p>
         *        <p>
         *        Valid values: <code>true</code> | <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resetAllParameters(Boolean resetAllParameters);

        /**
         * <p>
         * An array of parameter names to reset to their default values. If <code>ResetAllParameters</code> is
         * <code>true</code>, do not use <code>ParameterNameValues</code>. If <code>ResetAllParameters</code> is
         * <code>false</code>, you must specify the name of at least one parameter to reset.
         * </p>
         * 
         * @param parameterNameValues
         *        An array of parameter names to reset to their default values. If <code>ResetAllParameters</code> is
         *        <code>true</code>, do not use <code>ParameterNameValues</code>. If <code>ResetAllParameters</code> is
         *        <code>false</code>, you must specify the name of at least one parameter to reset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterNameValues(Collection<ParameterNameValue> parameterNameValues);

        /**
         * <p>
         * An array of parameter names to reset to their default values. If <code>ResetAllParameters</code> is
         * <code>true</code>, do not use <code>ParameterNameValues</code>. If <code>ResetAllParameters</code> is
         * <code>false</code>, you must specify the name of at least one parameter to reset.
         * </p>
         * 
         * @param parameterNameValues
         *        An array of parameter names to reset to their default values. If <code>ResetAllParameters</code> is
         *        <code>true</code>, do not use <code>ParameterNameValues</code>. If <code>ResetAllParameters</code> is
         *        <code>false</code>, you must specify the name of at least one parameter to reset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterNameValues(ParameterNameValue... parameterNameValues);

        /**
         * <p>
         * An array of parameter names to reset to their default values. If <code>ResetAllParameters</code> is
         * <code>true</code>, do not use <code>ParameterNameValues</code>. If <code>ResetAllParameters</code> is
         * <code>false</code>, you must specify the name of at least one parameter to reset.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ParameterNameValue>.Builder} avoiding the
         * need to create one manually via {@link List<ParameterNameValue>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ParameterNameValue>.Builder#build()} is called immediately
         * and its result is passed to {@link #parameterNameValues(List<ParameterNameValue>)}.
         * 
         * @param parameterNameValues
         *        a consumer that will call methods on {@link List<ParameterNameValue>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameterNameValues(List<ParameterNameValue>)
         */
        Builder parameterNameValues(Consumer<ParameterNameValue.Builder>... parameterNameValues);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElastiCacheRequest.BuilderImpl implements Builder {
        private String cacheParameterGroupName;

        private Boolean resetAllParameters;

        private List<ParameterNameValue> parameterNameValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResetCacheParameterGroupRequest model) {
            super(model);
            cacheParameterGroupName(model.cacheParameterGroupName);
            resetAllParameters(model.resetAllParameters);
            parameterNameValues(model.parameterNameValues);
        }

        public final String getCacheParameterGroupName() {
            return cacheParameterGroupName;
        }

        @Override
        public final Builder cacheParameterGroupName(String cacheParameterGroupName) {
            this.cacheParameterGroupName = cacheParameterGroupName;
            return this;
        }

        public final void setCacheParameterGroupName(String cacheParameterGroupName) {
            this.cacheParameterGroupName = cacheParameterGroupName;
        }

        public final Boolean getResetAllParameters() {
            return resetAllParameters;
        }

        @Override
        public final Builder resetAllParameters(Boolean resetAllParameters) {
            this.resetAllParameters = resetAllParameters;
            return this;
        }

        public final void setResetAllParameters(Boolean resetAllParameters) {
            this.resetAllParameters = resetAllParameters;
        }

        public final Collection<ParameterNameValue.Builder> getParameterNameValues() {
            return parameterNameValues != null ? parameterNameValues.stream().map(ParameterNameValue::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parameterNameValues(Collection<ParameterNameValue> parameterNameValues) {
            this.parameterNameValues = ParameterNameValueListCopier.copy(parameterNameValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterNameValues(ParameterNameValue... parameterNameValues) {
            parameterNameValues(Arrays.asList(parameterNameValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterNameValues(Consumer<ParameterNameValue.Builder>... parameterNameValues) {
            parameterNameValues(Stream.of(parameterNameValues).map(c -> ParameterNameValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setParameterNameValues(Collection<ParameterNameValue.BuilderImpl> parameterNameValues) {
            this.parameterNameValues = ParameterNameValueListCopier.copyFromBuilder(parameterNameValues);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ResetCacheParameterGroupRequest build() {
            return new ResetCacheParameterGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
