/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The settings to be applied to the Redis replication group, either immediately or during the next maintenance window.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReplicationGroupPendingModifiedValues implements SdkPojo, Serializable,
        ToCopyableBuilder<ReplicationGroupPendingModifiedValues.Builder, ReplicationGroupPendingModifiedValues> {
    private static final SdkField<String> PRIMARY_CLUSTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ReplicationGroupPendingModifiedValues::primaryClusterId)).setter(setter(Builder::primaryClusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryClusterId").build()).build();

    private static final SdkField<String> AUTOMATIC_FAILOVER_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ReplicationGroupPendingModifiedValues::automaticFailoverStatusAsString))
            .setter(setter(Builder::automaticFailoverStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomaticFailoverStatus").build())
            .build();

    private static final SdkField<ReshardingStatus> RESHARDING_FIELD = SdkField
            .<ReshardingStatus> builder(MarshallingType.SDK_POJO)
            .getter(getter(ReplicationGroupPendingModifiedValues::resharding)).setter(setter(Builder::resharding))
            .constructor(ReshardingStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resharding").build()).build();

    private static final SdkField<String> AUTH_TOKEN_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ReplicationGroupPendingModifiedValues::authTokenStatusAsString))
            .setter(setter(Builder::authTokenStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthTokenStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRIMARY_CLUSTER_ID_FIELD,
            AUTOMATIC_FAILOVER_STATUS_FIELD, RESHARDING_FIELD, AUTH_TOKEN_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String primaryClusterId;

    private final String automaticFailoverStatus;

    private final ReshardingStatus resharding;

    private final String authTokenStatus;

    private ReplicationGroupPendingModifiedValues(BuilderImpl builder) {
        this.primaryClusterId = builder.primaryClusterId;
        this.automaticFailoverStatus = builder.automaticFailoverStatus;
        this.resharding = builder.resharding;
        this.authTokenStatus = builder.authTokenStatus;
    }

    /**
     * <p>
     * The primary cluster ID that is applied immediately (if <code>--apply-immediately</code> was specified), or during
     * the next maintenance window.
     * </p>
     * 
     * @return The primary cluster ID that is applied immediately (if <code>--apply-immediately</code> was specified),
     *         or during the next maintenance window.
     */
    public String primaryClusterId() {
        return primaryClusterId;
    }

    /**
     * <p>
     * Indicates the status of Multi-AZ with automatic failover for this Redis replication group.
     * </p>
     * <p>
     * Amazon ElastiCache for Redis does not support Multi-AZ with automatic failover on:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Redis versions earlier than 2.8.6.
     * </p>
     * </li>
     * <li>
     * <p>
     * Redis (cluster mode disabled): T1 node types.
     * </p>
     * </li>
     * <li>
     * <p>
     * Redis (cluster mode enabled): T1 node types.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #automaticFailoverStatus} will return {@link PendingAutomaticFailoverStatus#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #automaticFailoverStatusAsString}.
     * </p>
     * 
     * @return Indicates the status of Multi-AZ with automatic failover for this Redis replication group.</p>
     *         <p>
     *         Amazon ElastiCache for Redis does not support Multi-AZ with automatic failover on:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Redis versions earlier than 2.8.6.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Redis (cluster mode disabled): T1 node types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Redis (cluster mode enabled): T1 node types.
     *         </p>
     *         </li>
     * @see PendingAutomaticFailoverStatus
     */
    public PendingAutomaticFailoverStatus automaticFailoverStatus() {
        return PendingAutomaticFailoverStatus.fromValue(automaticFailoverStatus);
    }

    /**
     * <p>
     * Indicates the status of Multi-AZ with automatic failover for this Redis replication group.
     * </p>
     * <p>
     * Amazon ElastiCache for Redis does not support Multi-AZ with automatic failover on:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Redis versions earlier than 2.8.6.
     * </p>
     * </li>
     * <li>
     * <p>
     * Redis (cluster mode disabled): T1 node types.
     * </p>
     * </li>
     * <li>
     * <p>
     * Redis (cluster mode enabled): T1 node types.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #automaticFailoverStatus} will return {@link PendingAutomaticFailoverStatus#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #automaticFailoverStatusAsString}.
     * </p>
     * 
     * @return Indicates the status of Multi-AZ with automatic failover for this Redis replication group.</p>
     *         <p>
     *         Amazon ElastiCache for Redis does not support Multi-AZ with automatic failover on:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Redis versions earlier than 2.8.6.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Redis (cluster mode disabled): T1 node types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Redis (cluster mode enabled): T1 node types.
     *         </p>
     *         </li>
     * @see PendingAutomaticFailoverStatus
     */
    public String automaticFailoverStatusAsString() {
        return automaticFailoverStatus;
    }

    /**
     * <p>
     * The status of an online resharding operation.
     * </p>
     * 
     * @return The status of an online resharding operation.
     */
    public ReshardingStatus resharding() {
        return resharding;
    }

    /**
     * <p>
     * The auth token status
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authTokenStatus}
     * will return {@link AuthTokenUpdateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #authTokenStatusAsString}.
     * </p>
     * 
     * @return The auth token status
     * @see AuthTokenUpdateStatus
     */
    public AuthTokenUpdateStatus authTokenStatus() {
        return AuthTokenUpdateStatus.fromValue(authTokenStatus);
    }

    /**
     * <p>
     * The auth token status
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authTokenStatus}
     * will return {@link AuthTokenUpdateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #authTokenStatusAsString}.
     * </p>
     * 
     * @return The auth token status
     * @see AuthTokenUpdateStatus
     */
    public String authTokenStatusAsString() {
        return authTokenStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(primaryClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(automaticFailoverStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resharding());
        hashCode = 31 * hashCode + Objects.hashCode(authTokenStatusAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationGroupPendingModifiedValues)) {
            return false;
        }
        ReplicationGroupPendingModifiedValues other = (ReplicationGroupPendingModifiedValues) obj;
        return Objects.equals(primaryClusterId(), other.primaryClusterId())
                && Objects.equals(automaticFailoverStatusAsString(), other.automaticFailoverStatusAsString())
                && Objects.equals(resharding(), other.resharding())
                && Objects.equals(authTokenStatusAsString(), other.authTokenStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ReplicationGroupPendingModifiedValues").add("PrimaryClusterId", primaryClusterId())
                .add("AutomaticFailoverStatus", automaticFailoverStatusAsString()).add("Resharding", resharding())
                .add("AuthTokenStatus", authTokenStatusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PrimaryClusterId":
            return Optional.ofNullable(clazz.cast(primaryClusterId()));
        case "AutomaticFailoverStatus":
            return Optional.ofNullable(clazz.cast(automaticFailoverStatusAsString()));
        case "Resharding":
            return Optional.ofNullable(clazz.cast(resharding()));
        case "AuthTokenStatus":
            return Optional.ofNullable(clazz.cast(authTokenStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReplicationGroupPendingModifiedValues, T> g) {
        return obj -> g.apply((ReplicationGroupPendingModifiedValues) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReplicationGroupPendingModifiedValues> {
        /**
         * <p>
         * The primary cluster ID that is applied immediately (if <code>--apply-immediately</code> was specified), or
         * during the next maintenance window.
         * </p>
         * 
         * @param primaryClusterId
         *        The primary cluster ID that is applied immediately (if <code>--apply-immediately</code> was
         *        specified), or during the next maintenance window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryClusterId(String primaryClusterId);

        /**
         * <p>
         * Indicates the status of Multi-AZ with automatic failover for this Redis replication group.
         * </p>
         * <p>
         * Amazon ElastiCache for Redis does not support Multi-AZ with automatic failover on:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Redis versions earlier than 2.8.6.
         * </p>
         * </li>
         * <li>
         * <p>
         * Redis (cluster mode disabled): T1 node types.
         * </p>
         * </li>
         * <li>
         * <p>
         * Redis (cluster mode enabled): T1 node types.
         * </p>
         * </li>
         * </ul>
         * 
         * @param automaticFailoverStatus
         *        Indicates the status of Multi-AZ with automatic failover for this Redis replication group.</p>
         *        <p>
         *        Amazon ElastiCache for Redis does not support Multi-AZ with automatic failover on:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Redis versions earlier than 2.8.6.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Redis (cluster mode disabled): T1 node types.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Redis (cluster mode enabled): T1 node types.
         *        </p>
         *        </li>
         * @see PendingAutomaticFailoverStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PendingAutomaticFailoverStatus
         */
        Builder automaticFailoverStatus(String automaticFailoverStatus);

        /**
         * <p>
         * Indicates the status of Multi-AZ with automatic failover for this Redis replication group.
         * </p>
         * <p>
         * Amazon ElastiCache for Redis does not support Multi-AZ with automatic failover on:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Redis versions earlier than 2.8.6.
         * </p>
         * </li>
         * <li>
         * <p>
         * Redis (cluster mode disabled): T1 node types.
         * </p>
         * </li>
         * <li>
         * <p>
         * Redis (cluster mode enabled): T1 node types.
         * </p>
         * </li>
         * </ul>
         * 
         * @param automaticFailoverStatus
         *        Indicates the status of Multi-AZ with automatic failover for this Redis replication group.</p>
         *        <p>
         *        Amazon ElastiCache for Redis does not support Multi-AZ with automatic failover on:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Redis versions earlier than 2.8.6.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Redis (cluster mode disabled): T1 node types.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Redis (cluster mode enabled): T1 node types.
         *        </p>
         *        </li>
         * @see PendingAutomaticFailoverStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PendingAutomaticFailoverStatus
         */
        Builder automaticFailoverStatus(PendingAutomaticFailoverStatus automaticFailoverStatus);

        /**
         * <p>
         * The status of an online resharding operation.
         * </p>
         * 
         * @param resharding
         *        The status of an online resharding operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resharding(ReshardingStatus resharding);

        /**
         * <p>
         * The status of an online resharding operation.
         * </p>
         * This is a convenience that creates an instance of the {@link ReshardingStatus.Builder} avoiding the need to
         * create one manually via {@link ReshardingStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link ReshardingStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #resharding(ReshardingStatus)}.
         * 
         * @param resharding
         *        a consumer that will call methods on {@link ReshardingStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resharding(ReshardingStatus)
         */
        default Builder resharding(Consumer<ReshardingStatus.Builder> resharding) {
            return resharding(ReshardingStatus.builder().applyMutation(resharding).build());
        }

        /**
         * <p>
         * The auth token status
         * </p>
         * 
         * @param authTokenStatus
         *        The auth token status
         * @see AuthTokenUpdateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthTokenUpdateStatus
         */
        Builder authTokenStatus(String authTokenStatus);

        /**
         * <p>
         * The auth token status
         * </p>
         * 
         * @param authTokenStatus
         *        The auth token status
         * @see AuthTokenUpdateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthTokenUpdateStatus
         */
        Builder authTokenStatus(AuthTokenUpdateStatus authTokenStatus);
    }

    static final class BuilderImpl implements Builder {
        private String primaryClusterId;

        private String automaticFailoverStatus;

        private ReshardingStatus resharding;

        private String authTokenStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationGroupPendingModifiedValues model) {
            primaryClusterId(model.primaryClusterId);
            automaticFailoverStatus(model.automaticFailoverStatus);
            resharding(model.resharding);
            authTokenStatus(model.authTokenStatus);
        }

        public final String getPrimaryClusterId() {
            return primaryClusterId;
        }

        @Override
        public final Builder primaryClusterId(String primaryClusterId) {
            this.primaryClusterId = primaryClusterId;
            return this;
        }

        public final void setPrimaryClusterId(String primaryClusterId) {
            this.primaryClusterId = primaryClusterId;
        }

        public final String getAutomaticFailoverStatus() {
            return automaticFailoverStatus;
        }

        @Override
        public final Builder automaticFailoverStatus(String automaticFailoverStatus) {
            this.automaticFailoverStatus = automaticFailoverStatus;
            return this;
        }

        @Override
        public final Builder automaticFailoverStatus(PendingAutomaticFailoverStatus automaticFailoverStatus) {
            this.automaticFailoverStatus(automaticFailoverStatus == null ? null : automaticFailoverStatus.toString());
            return this;
        }

        public final void setAutomaticFailoverStatus(String automaticFailoverStatus) {
            this.automaticFailoverStatus = automaticFailoverStatus;
        }

        public final ReshardingStatus.Builder getResharding() {
            return resharding != null ? resharding.toBuilder() : null;
        }

        @Override
        public final Builder resharding(ReshardingStatus resharding) {
            this.resharding = resharding;
            return this;
        }

        public final void setResharding(ReshardingStatus.BuilderImpl resharding) {
            this.resharding = resharding != null ? resharding.build() : null;
        }

        public final String getAuthTokenStatus() {
            return authTokenStatus;
        }

        @Override
        public final Builder authTokenStatus(String authTokenStatus) {
            this.authTokenStatus = authTokenStatus;
            return this;
        }

        @Override
        public final Builder authTokenStatus(AuthTokenUpdateStatus authTokenStatus) {
            this.authTokenStatus(authTokenStatus == null ? null : authTokenStatus.toString());
            return this;
        }

        public final void setAuthTokenStatus(String authTokenStatus) {
            this.authTokenStatus = authTokenStatus;
        }

        @Override
        public ReplicationGroupPendingModifiedValues build() {
            return new ReplicationGroupPendingModifiedValues(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
