/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains all of the attributes of a specific Redis replication group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReplicationGroup implements SdkPojo, Serializable,
        ToCopyableBuilder<ReplicationGroup.Builder, ReplicationGroup> {
    private static final SdkField<String> REPLICATION_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ReplicationGroup::replicationGroupId)).setter(setter(Builder::replicationGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationGroupId").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ReplicationGroup::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<GlobalReplicationGroupInfo> GLOBAL_REPLICATION_GROUP_INFO_FIELD = SdkField
            .<GlobalReplicationGroupInfo> builder(MarshallingType.SDK_POJO)
            .getter(getter(ReplicationGroup::globalReplicationGroupInfo))
            .setter(setter(Builder::globalReplicationGroupInfo))
            .constructor(GlobalReplicationGroupInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalReplicationGroupInfo").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ReplicationGroup::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<ReplicationGroupPendingModifiedValues> PENDING_MODIFIED_VALUES_FIELD = SdkField
            .<ReplicationGroupPendingModifiedValues> builder(MarshallingType.SDK_POJO)
            .getter(getter(ReplicationGroup::pendingModifiedValues)).setter(setter(Builder::pendingModifiedValues))
            .constructor(ReplicationGroupPendingModifiedValues::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PendingModifiedValues").build())
            .build();

    private static final SdkField<List<String>> MEMBER_CLUSTERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ReplicationGroup::memberClusters))
            .setter(setter(Builder::memberClusters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberClusters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("ClusterId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("ClusterId").build()).build()).build()).build();

    private static final SdkField<List<NodeGroup>> NODE_GROUPS_FIELD = SdkField
            .<List<NodeGroup>> builder(MarshallingType.LIST)
            .getter(getter(ReplicationGroup::nodeGroups))
            .setter(setter(Builder::nodeGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("NodeGroup")
                            .memberFieldInfo(
                                    SdkField.<NodeGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(NodeGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("NodeGroup").build()).build()).build()).build();

    private static final SdkField<String> SNAPSHOTTING_CLUSTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ReplicationGroup::snapshottingClusterId)).setter(setter(Builder::snapshottingClusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshottingClusterId").build())
            .build();

    private static final SdkField<String> AUTOMATIC_FAILOVER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ReplicationGroup::automaticFailoverAsString)).setter(setter(Builder::automaticFailover))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomaticFailover").build()).build();

    private static final SdkField<String> MULTI_AZ_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ReplicationGroup::multiAZAsString)).setter(setter(Builder::multiAZ))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiAZ").build()).build();

    private static final SdkField<Endpoint> CONFIGURATION_ENDPOINT_FIELD = SdkField.<Endpoint> builder(MarshallingType.SDK_POJO)
            .getter(getter(ReplicationGroup::configurationEndpoint)).setter(setter(Builder::configurationEndpoint))
            .constructor(Endpoint::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationEndpoint").build())
            .build();

    private static final SdkField<Integer> SNAPSHOT_RETENTION_LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ReplicationGroup::snapshotRetentionLimit)).setter(setter(Builder::snapshotRetentionLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotRetentionLimit").build())
            .build();

    private static final SdkField<String> SNAPSHOT_WINDOW_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ReplicationGroup::snapshotWindow)).setter(setter(Builder::snapshotWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotWindow").build()).build();

    private static final SdkField<Boolean> CLUSTER_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ReplicationGroup::clusterEnabled)).setter(setter(Builder::clusterEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterEnabled").build()).build();

    private static final SdkField<String> CACHE_NODE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ReplicationGroup::cacheNodeType)).setter(setter(Builder::cacheNodeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheNodeType").build()).build();

    private static final SdkField<Boolean> AUTH_TOKEN_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ReplicationGroup::authTokenEnabled)).setter(setter(Builder::authTokenEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthTokenEnabled").build()).build();

    private static final SdkField<Instant> AUTH_TOKEN_LAST_MODIFIED_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT).getter(getter(ReplicationGroup::authTokenLastModifiedDate))
            .setter(setter(Builder::authTokenLastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthTokenLastModifiedDate").build())
            .build();

    private static final SdkField<Boolean> TRANSIT_ENCRYPTION_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ReplicationGroup::transitEncryptionEnabled)).setter(setter(Builder::transitEncryptionEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitEncryptionEnabled").build())
            .build();

    private static final SdkField<Boolean> AT_REST_ENCRYPTION_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ReplicationGroup::atRestEncryptionEnabled)).setter(setter(Builder::atRestEncryptionEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AtRestEncryptionEnabled").build())
            .build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ReplicationGroup::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ReplicationGroup::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_GROUP_ID_FIELD,
            DESCRIPTION_FIELD, GLOBAL_REPLICATION_GROUP_INFO_FIELD, STATUS_FIELD, PENDING_MODIFIED_VALUES_FIELD,
            MEMBER_CLUSTERS_FIELD, NODE_GROUPS_FIELD, SNAPSHOTTING_CLUSTER_ID_FIELD, AUTOMATIC_FAILOVER_FIELD, MULTI_AZ_FIELD,
            CONFIGURATION_ENDPOINT_FIELD, SNAPSHOT_RETENTION_LIMIT_FIELD, SNAPSHOT_WINDOW_FIELD, CLUSTER_ENABLED_FIELD,
            CACHE_NODE_TYPE_FIELD, AUTH_TOKEN_ENABLED_FIELD, AUTH_TOKEN_LAST_MODIFIED_DATE_FIELD,
            TRANSIT_ENCRYPTION_ENABLED_FIELD, AT_REST_ENCRYPTION_ENABLED_FIELD, KMS_KEY_ID_FIELD, ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String replicationGroupId;

    private final String description;

    private final GlobalReplicationGroupInfo globalReplicationGroupInfo;

    private final String status;

    private final ReplicationGroupPendingModifiedValues pendingModifiedValues;

    private final List<String> memberClusters;

    private final List<NodeGroup> nodeGroups;

    private final String snapshottingClusterId;

    private final String automaticFailover;

    private final String multiAZ;

    private final Endpoint configurationEndpoint;

    private final Integer snapshotRetentionLimit;

    private final String snapshotWindow;

    private final Boolean clusterEnabled;

    private final String cacheNodeType;

    private final Boolean authTokenEnabled;

    private final Instant authTokenLastModifiedDate;

    private final Boolean transitEncryptionEnabled;

    private final Boolean atRestEncryptionEnabled;

    private final String kmsKeyId;

    private final String arn;

    private ReplicationGroup(BuilderImpl builder) {
        this.replicationGroupId = builder.replicationGroupId;
        this.description = builder.description;
        this.globalReplicationGroupInfo = builder.globalReplicationGroupInfo;
        this.status = builder.status;
        this.pendingModifiedValues = builder.pendingModifiedValues;
        this.memberClusters = builder.memberClusters;
        this.nodeGroups = builder.nodeGroups;
        this.snapshottingClusterId = builder.snapshottingClusterId;
        this.automaticFailover = builder.automaticFailover;
        this.multiAZ = builder.multiAZ;
        this.configurationEndpoint = builder.configurationEndpoint;
        this.snapshotRetentionLimit = builder.snapshotRetentionLimit;
        this.snapshotWindow = builder.snapshotWindow;
        this.clusterEnabled = builder.clusterEnabled;
        this.cacheNodeType = builder.cacheNodeType;
        this.authTokenEnabled = builder.authTokenEnabled;
        this.authTokenLastModifiedDate = builder.authTokenLastModifiedDate;
        this.transitEncryptionEnabled = builder.transitEncryptionEnabled;
        this.atRestEncryptionEnabled = builder.atRestEncryptionEnabled;
        this.kmsKeyId = builder.kmsKeyId;
        this.arn = builder.arn;
    }

    /**
     * <p>
     * The identifier for the replication group.
     * </p>
     * 
     * @return The identifier for the replication group.
     */
    public String replicationGroupId() {
        return replicationGroupId;
    }

    /**
     * <p>
     * The user supplied description of the replication group.
     * </p>
     * 
     * @return The user supplied description of the replication group.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The name of the Global Datastore and role of this replication group in the Global Datastore.
     * </p>
     * 
     * @return The name of the Global Datastore and role of this replication group in the Global Datastore.
     */
    public GlobalReplicationGroupInfo globalReplicationGroupInfo() {
        return globalReplicationGroupInfo;
    }

    /**
     * <p>
     * The current state of this replication group - <code>creating</code>, <code>available</code>,
     * <code>modifying</code>, <code>deleting</code>, <code>create-failed</code>, <code>snapshotting</code>.
     * </p>
     * 
     * @return The current state of this replication group - <code>creating</code>, <code>available</code>,
     *         <code>modifying</code>, <code>deleting</code>, <code>create-failed</code>, <code>snapshotting</code>.
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * A group of settings to be applied to the replication group, either immediately or during the next maintenance
     * window.
     * </p>
     * 
     * @return A group of settings to be applied to the replication group, either immediately or during the next
     *         maintenance window.
     */
    public ReplicationGroupPendingModifiedValues pendingModifiedValues() {
        return pendingModifiedValues;
    }

    /**
     * Returns true if the MemberClusters property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasMemberClusters() {
        return memberClusters != null && !(memberClusters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names of all the cache clusters that are part of this replication group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMemberClusters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The names of all the cache clusters that are part of this replication group.
     */
    public List<String> memberClusters() {
        return memberClusters;
    }

    /**
     * Returns true if the NodeGroups property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasNodeGroups() {
        return nodeGroups != null && !(nodeGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of node groups in this replication group. For Redis (cluster mode disabled) replication groups, this is a
     * single-element list. For Redis (cluster mode enabled) replication groups, the list contains an entry for each
     * node group (shard).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasNodeGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of node groups in this replication group. For Redis (cluster mode disabled) replication groups,
     *         this is a single-element list. For Redis (cluster mode enabled) replication groups, the list contains an
     *         entry for each node group (shard).
     */
    public List<NodeGroup> nodeGroups() {
        return nodeGroups;
    }

    /**
     * <p>
     * The cluster ID that is used as the daily snapshot source for the replication group.
     * </p>
     * 
     * @return The cluster ID that is used as the daily snapshot source for the replication group.
     */
    public String snapshottingClusterId() {
        return snapshottingClusterId;
    }

    /**
     * <p>
     * Indicates the status of Multi-AZ with automatic failover for this Redis replication group.
     * </p>
     * <p>
     * Amazon ElastiCache for Redis does not support Multi-AZ with automatic failover on:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Redis versions earlier than 2.8.6.
     * </p>
     * </li>
     * <li>
     * <p>
     * Redis (cluster mode disabled): T1 node types.
     * </p>
     * </li>
     * <li>
     * <p>
     * Redis (cluster mode enabled): T1 node types.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #automaticFailover}
     * will return {@link AutomaticFailoverStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #automaticFailoverAsString}.
     * </p>
     * 
     * @return Indicates the status of Multi-AZ with automatic failover for this Redis replication group.</p>
     *         <p>
     *         Amazon ElastiCache for Redis does not support Multi-AZ with automatic failover on:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Redis versions earlier than 2.8.6.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Redis (cluster mode disabled): T1 node types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Redis (cluster mode enabled): T1 node types.
     *         </p>
     *         </li>
     * @see AutomaticFailoverStatus
     */
    public AutomaticFailoverStatus automaticFailover() {
        return AutomaticFailoverStatus.fromValue(automaticFailover);
    }

    /**
     * <p>
     * Indicates the status of Multi-AZ with automatic failover for this Redis replication group.
     * </p>
     * <p>
     * Amazon ElastiCache for Redis does not support Multi-AZ with automatic failover on:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Redis versions earlier than 2.8.6.
     * </p>
     * </li>
     * <li>
     * <p>
     * Redis (cluster mode disabled): T1 node types.
     * </p>
     * </li>
     * <li>
     * <p>
     * Redis (cluster mode enabled): T1 node types.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #automaticFailover}
     * will return {@link AutomaticFailoverStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #automaticFailoverAsString}.
     * </p>
     * 
     * @return Indicates the status of Multi-AZ with automatic failover for this Redis replication group.</p>
     *         <p>
     *         Amazon ElastiCache for Redis does not support Multi-AZ with automatic failover on:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Redis versions earlier than 2.8.6.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Redis (cluster mode disabled): T1 node types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Redis (cluster mode enabled): T1 node types.
     *         </p>
     *         </li>
     * @see AutomaticFailoverStatus
     */
    public String automaticFailoverAsString() {
        return automaticFailover;
    }

    /**
     * Returns the value of the MultiAZ property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #multiAZ} will
     * return {@link MultiAZStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #multiAZAsString}.
     * </p>
     * 
     * @return The value of the MultiAZ property for this object.
     * @see MultiAZStatus
     */
    public MultiAZStatus multiAZ() {
        return MultiAZStatus.fromValue(multiAZ);
    }

    /**
     * Returns the value of the MultiAZ property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #multiAZ} will
     * return {@link MultiAZStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #multiAZAsString}.
     * </p>
     * 
     * @return The value of the MultiAZ property for this object.
     * @see MultiAZStatus
     */
    public String multiAZAsString() {
        return multiAZ;
    }

    /**
     * <p>
     * The configuration endpoint for this replication group. Use the configuration endpoint to connect to this
     * replication group.
     * </p>
     * 
     * @return The configuration endpoint for this replication group. Use the configuration endpoint to connect to this
     *         replication group.
     */
    public Endpoint configurationEndpoint() {
        return configurationEndpoint;
    }

    /**
     * <p>
     * The number of days for which ElastiCache retains automatic cluster snapshots before deleting them. For example,
     * if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was taken today is retained for 5 days
     * before being deleted.
     * </p>
     * <important>
     * <p>
     * If the value of <code>SnapshotRetentionLimit</code> is set to zero (0), backups are turned off.
     * </p>
     * </important>
     * 
     * @return The number of days for which ElastiCache retains automatic cluster snapshots before deleting them. For
     *         example, if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was taken today is retained
     *         for 5 days before being deleted.</p> <important>
     *         <p>
     *         If the value of <code>SnapshotRetentionLimit</code> is set to zero (0), backups are turned off.
     *         </p>
     */
    public Integer snapshotRetentionLimit() {
        return snapshotRetentionLimit;
    }

    /**
     * <p>
     * The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your node group (shard).
     * </p>
     * <p>
     * Example: <code>05:00-09:00</code>
     * </p>
     * <p>
     * If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.
     * </p>
     * <note>
     * <p>
     * This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.
     * </p>
     * </note>
     * 
     * @return The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your node group
     *         (shard).</p>
     *         <p>
     *         Example: <code>05:00-09:00</code>
     *         </p>
     *         <p>
     *         If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.
     *         </p>
     *         <note>
     *         <p>
     *         This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.
     *         </p>
     */
    public String snapshotWindow() {
        return snapshotWindow;
    }

    /**
     * <p>
     * A flag indicating whether or not this replication group is cluster enabled; i.e., whether its data can be
     * partitioned across multiple shards (API/CLI: node groups).
     * </p>
     * <p>
     * Valid values: <code>true</code> | <code>false</code>
     * </p>
     * 
     * @return A flag indicating whether or not this replication group is cluster enabled; i.e., whether its data can be
     *         partitioned across multiple shards (API/CLI: node groups).</p>
     *         <p>
     *         Valid values: <code>true</code> | <code>false</code>
     */
    public Boolean clusterEnabled() {
        return clusterEnabled;
    }

    /**
     * <p>
     * The name of the compute and memory capacity node type for each node in the replication group.
     * </p>
     * 
     * @return The name of the compute and memory capacity node type for each node in the replication group.
     */
    public String cacheNodeType() {
        return cacheNodeType;
    }

    /**
     * <p>
     * A flag that enables using an <code>AuthToken</code> (password) when issuing Redis commands.
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     * 
     * @return A flag that enables using an <code>AuthToken</code> (password) when issuing Redis commands.</p>
     *         <p>
     *         Default: <code>false</code>
     */
    public Boolean authTokenEnabled() {
        return authTokenEnabled;
    }

    /**
     * <p>
     * The date the auth token was last modified
     * </p>
     * 
     * @return The date the auth token was last modified
     */
    public Instant authTokenLastModifiedDate() {
        return authTokenLastModifiedDate;
    }

    /**
     * <p>
     * A flag that enables in-transit encryption when set to <code>true</code>.
     * </p>
     * <p>
     * You cannot modify the value of <code>TransitEncryptionEnabled</code> after the cluster is created. To enable
     * in-transit encryption on a cluster you must set <code>TransitEncryptionEnabled</code> to <code>true</code> when
     * you create a cluster.
     * </p>
     * <p>
     * <b>Required:</b> Only available when creating a replication group in an Amazon VPC using redis version
     * <code>3.2.6</code>, <code>4.x</code> or later.
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     * 
     * @return A flag that enables in-transit encryption when set to <code>true</code>.</p>
     *         <p>
     *         You cannot modify the value of <code>TransitEncryptionEnabled</code> after the cluster is created. To
     *         enable in-transit encryption on a cluster you must set <code>TransitEncryptionEnabled</code> to
     *         <code>true</code> when you create a cluster.
     *         </p>
     *         <p>
     *         <b>Required:</b> Only available when creating a replication group in an Amazon VPC using redis version
     *         <code>3.2.6</code>, <code>4.x</code> or later.
     *         </p>
     *         <p>
     *         Default: <code>false</code>
     */
    public Boolean transitEncryptionEnabled() {
        return transitEncryptionEnabled;
    }

    /**
     * <p>
     * A flag that enables encryption at-rest when set to <code>true</code>.
     * </p>
     * <p>
     * You cannot modify the value of <code>AtRestEncryptionEnabled</code> after the cluster is created. To enable
     * encryption at-rest on a cluster you must set <code>AtRestEncryptionEnabled</code> to <code>true</code> when you
     * create a cluster.
     * </p>
     * <p>
     * <b>Required:</b> Only available when creating a replication group in an Amazon VPC using redis version
     * <code>3.2.6</code>, <code>4.x</code> or later.
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     * 
     * @return A flag that enables encryption at-rest when set to <code>true</code>.</p>
     *         <p>
     *         You cannot modify the value of <code>AtRestEncryptionEnabled</code> after the cluster is created. To
     *         enable encryption at-rest on a cluster you must set <code>AtRestEncryptionEnabled</code> to
     *         <code>true</code> when you create a cluster.
     *         </p>
     *         <p>
     *         <b>Required:</b> Only available when creating a replication group in an Amazon VPC using redis version
     *         <code>3.2.6</code>, <code>4.x</code> or later.
     *         </p>
     *         <p>
     *         Default: <code>false</code>
     */
    public Boolean atRestEncryptionEnabled() {
        return atRestEncryptionEnabled;
    }

    /**
     * <p>
     * The ID of the KMS key used to encrypt the disk in the cluster.
     * </p>
     * 
     * @return The ID of the KMS key used to encrypt the disk in the cluster.
     */
    public String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The ARN (Amazon Resource Name) of the replication group.
     * </p>
     * 
     * @return The ARN (Amazon Resource Name) of the replication group.
     */
    public String arn() {
        return arn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(replicationGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(globalReplicationGroupInfo());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(pendingModifiedValues());
        hashCode = 31 * hashCode + Objects.hashCode(memberClusters());
        hashCode = 31 * hashCode + Objects.hashCode(nodeGroups());
        hashCode = 31 * hashCode + Objects.hashCode(snapshottingClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(automaticFailoverAsString());
        hashCode = 31 * hashCode + Objects.hashCode(multiAZAsString());
        hashCode = 31 * hashCode + Objects.hashCode(configurationEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotRetentionLimit());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotWindow());
        hashCode = 31 * hashCode + Objects.hashCode(clusterEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(cacheNodeType());
        hashCode = 31 * hashCode + Objects.hashCode(authTokenEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(authTokenLastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(transitEncryptionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(atRestEncryptionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationGroup)) {
            return false;
        }
        ReplicationGroup other = (ReplicationGroup) obj;
        return Objects.equals(replicationGroupId(), other.replicationGroupId())
                && Objects.equals(description(), other.description())
                && Objects.equals(globalReplicationGroupInfo(), other.globalReplicationGroupInfo())
                && Objects.equals(status(), other.status())
                && Objects.equals(pendingModifiedValues(), other.pendingModifiedValues())
                && Objects.equals(memberClusters(), other.memberClusters()) && Objects.equals(nodeGroups(), other.nodeGroups())
                && Objects.equals(snapshottingClusterId(), other.snapshottingClusterId())
                && Objects.equals(automaticFailoverAsString(), other.automaticFailoverAsString())
                && Objects.equals(multiAZAsString(), other.multiAZAsString())
                && Objects.equals(configurationEndpoint(), other.configurationEndpoint())
                && Objects.equals(snapshotRetentionLimit(), other.snapshotRetentionLimit())
                && Objects.equals(snapshotWindow(), other.snapshotWindow())
                && Objects.equals(clusterEnabled(), other.clusterEnabled())
                && Objects.equals(cacheNodeType(), other.cacheNodeType())
                && Objects.equals(authTokenEnabled(), other.authTokenEnabled())
                && Objects.equals(authTokenLastModifiedDate(), other.authTokenLastModifiedDate())
                && Objects.equals(transitEncryptionEnabled(), other.transitEncryptionEnabled())
                && Objects.equals(atRestEncryptionEnabled(), other.atRestEncryptionEnabled())
                && Objects.equals(kmsKeyId(), other.kmsKeyId()) && Objects.equals(arn(), other.arn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ReplicationGroup").add("ReplicationGroupId", replicationGroupId())
                .add("Description", description()).add("GlobalReplicationGroupInfo", globalReplicationGroupInfo())
                .add("Status", status()).add("PendingModifiedValues", pendingModifiedValues())
                .add("MemberClusters", memberClusters()).add("NodeGroups", nodeGroups())
                .add("SnapshottingClusterId", snapshottingClusterId()).add("AutomaticFailover", automaticFailoverAsString())
                .add("MultiAZ", multiAZAsString()).add("ConfigurationEndpoint", configurationEndpoint())
                .add("SnapshotRetentionLimit", snapshotRetentionLimit()).add("SnapshotWindow", snapshotWindow())
                .add("ClusterEnabled", clusterEnabled()).add("CacheNodeType", cacheNodeType())
                .add("AuthTokenEnabled", authTokenEnabled()).add("AuthTokenLastModifiedDate", authTokenLastModifiedDate())
                .add("TransitEncryptionEnabled", transitEncryptionEnabled())
                .add("AtRestEncryptionEnabled", atRestEncryptionEnabled()).add("KmsKeyId", kmsKeyId()).add("ARN", arn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReplicationGroupId":
            return Optional.ofNullable(clazz.cast(replicationGroupId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "GlobalReplicationGroupInfo":
            return Optional.ofNullable(clazz.cast(globalReplicationGroupInfo()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "PendingModifiedValues":
            return Optional.ofNullable(clazz.cast(pendingModifiedValues()));
        case "MemberClusters":
            return Optional.ofNullable(clazz.cast(memberClusters()));
        case "NodeGroups":
            return Optional.ofNullable(clazz.cast(nodeGroups()));
        case "SnapshottingClusterId":
            return Optional.ofNullable(clazz.cast(snapshottingClusterId()));
        case "AutomaticFailover":
            return Optional.ofNullable(clazz.cast(automaticFailoverAsString()));
        case "MultiAZ":
            return Optional.ofNullable(clazz.cast(multiAZAsString()));
        case "ConfigurationEndpoint":
            return Optional.ofNullable(clazz.cast(configurationEndpoint()));
        case "SnapshotRetentionLimit":
            return Optional.ofNullable(clazz.cast(snapshotRetentionLimit()));
        case "SnapshotWindow":
            return Optional.ofNullable(clazz.cast(snapshotWindow()));
        case "ClusterEnabled":
            return Optional.ofNullable(clazz.cast(clusterEnabled()));
        case "CacheNodeType":
            return Optional.ofNullable(clazz.cast(cacheNodeType()));
        case "AuthTokenEnabled":
            return Optional.ofNullable(clazz.cast(authTokenEnabled()));
        case "AuthTokenLastModifiedDate":
            return Optional.ofNullable(clazz.cast(authTokenLastModifiedDate()));
        case "TransitEncryptionEnabled":
            return Optional.ofNullable(clazz.cast(transitEncryptionEnabled()));
        case "AtRestEncryptionEnabled":
            return Optional.ofNullable(clazz.cast(atRestEncryptionEnabled()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "ARN":
            return Optional.ofNullable(clazz.cast(arn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReplicationGroup, T> g) {
        return obj -> g.apply((ReplicationGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReplicationGroup> {
        /**
         * <p>
         * The identifier for the replication group.
         * </p>
         * 
         * @param replicationGroupId
         *        The identifier for the replication group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationGroupId(String replicationGroupId);

        /**
         * <p>
         * The user supplied description of the replication group.
         * </p>
         * 
         * @param description
         *        The user supplied description of the replication group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The name of the Global Datastore and role of this replication group in the Global Datastore.
         * </p>
         * 
         * @param globalReplicationGroupInfo
         *        The name of the Global Datastore and role of this replication group in the Global Datastore.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalReplicationGroupInfo(GlobalReplicationGroupInfo globalReplicationGroupInfo);

        /**
         * <p>
         * The name of the Global Datastore and role of this replication group in the Global Datastore.
         * </p>
         * This is a convenience that creates an instance of the {@link GlobalReplicationGroupInfo.Builder} avoiding the
         * need to create one manually via {@link GlobalReplicationGroupInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link GlobalReplicationGroupInfo.Builder#build()} is called immediately
         * and its result is passed to {@link #globalReplicationGroupInfo(GlobalReplicationGroupInfo)}.
         * 
         * @param globalReplicationGroupInfo
         *        a consumer that will call methods on {@link GlobalReplicationGroupInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #globalReplicationGroupInfo(GlobalReplicationGroupInfo)
         */
        default Builder globalReplicationGroupInfo(Consumer<GlobalReplicationGroupInfo.Builder> globalReplicationGroupInfo) {
            return globalReplicationGroupInfo(GlobalReplicationGroupInfo.builder().applyMutation(globalReplicationGroupInfo)
                    .build());
        }

        /**
         * <p>
         * The current state of this replication group - <code>creating</code>, <code>available</code>,
         * <code>modifying</code>, <code>deleting</code>, <code>create-failed</code>, <code>snapshotting</code>.
         * </p>
         * 
         * @param status
         *        The current state of this replication group - <code>creating</code>, <code>available</code>,
         *        <code>modifying</code>, <code>deleting</code>, <code>create-failed</code>, <code>snapshotting</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * A group of settings to be applied to the replication group, either immediately or during the next maintenance
         * window.
         * </p>
         * 
         * @param pendingModifiedValues
         *        A group of settings to be applied to the replication group, either immediately or during the next
         *        maintenance window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingModifiedValues(ReplicationGroupPendingModifiedValues pendingModifiedValues);

        /**
         * <p>
         * A group of settings to be applied to the replication group, either immediately or during the next maintenance
         * window.
         * </p>
         * This is a convenience that creates an instance of the {@link ReplicationGroupPendingModifiedValues.Builder}
         * avoiding the need to create one manually via {@link ReplicationGroupPendingModifiedValues#builder()}.
         *
         * When the {@link Consumer} completes, {@link ReplicationGroupPendingModifiedValues.Builder#build()} is called
         * immediately and its result is passed to {@link #pendingModifiedValues(ReplicationGroupPendingModifiedValues)}
         * .
         * 
         * @param pendingModifiedValues
         *        a consumer that will call methods on {@link ReplicationGroupPendingModifiedValues.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pendingModifiedValues(ReplicationGroupPendingModifiedValues)
         */
        default Builder pendingModifiedValues(Consumer<ReplicationGroupPendingModifiedValues.Builder> pendingModifiedValues) {
            return pendingModifiedValues(ReplicationGroupPendingModifiedValues.builder().applyMutation(pendingModifiedValues)
                    .build());
        }

        /**
         * <p>
         * The names of all the cache clusters that are part of this replication group.
         * </p>
         * 
         * @param memberClusters
         *        The names of all the cache clusters that are part of this replication group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberClusters(Collection<String> memberClusters);

        /**
         * <p>
         * The names of all the cache clusters that are part of this replication group.
         * </p>
         * 
         * @param memberClusters
         *        The names of all the cache clusters that are part of this replication group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberClusters(String... memberClusters);

        /**
         * <p>
         * A list of node groups in this replication group. For Redis (cluster mode disabled) replication groups, this
         * is a single-element list. For Redis (cluster mode enabled) replication groups, the list contains an entry for
         * each node group (shard).
         * </p>
         * 
         * @param nodeGroups
         *        A list of node groups in this replication group. For Redis (cluster mode disabled) replication groups,
         *        this is a single-element list. For Redis (cluster mode enabled) replication groups, the list contains
         *        an entry for each node group (shard).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeGroups(Collection<NodeGroup> nodeGroups);

        /**
         * <p>
         * A list of node groups in this replication group. For Redis (cluster mode disabled) replication groups, this
         * is a single-element list. For Redis (cluster mode enabled) replication groups, the list contains an entry for
         * each node group (shard).
         * </p>
         * 
         * @param nodeGroups
         *        A list of node groups in this replication group. For Redis (cluster mode disabled) replication groups,
         *        this is a single-element list. For Redis (cluster mode enabled) replication groups, the list contains
         *        an entry for each node group (shard).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeGroups(NodeGroup... nodeGroups);

        /**
         * <p>
         * A list of node groups in this replication group. For Redis (cluster mode disabled) replication groups, this
         * is a single-element list. For Redis (cluster mode enabled) replication groups, the list contains an entry for
         * each node group (shard).
         * </p>
         * This is a convenience that creates an instance of the {@link List<NodeGroup>.Builder} avoiding the need to
         * create one manually via {@link List<NodeGroup>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<NodeGroup>.Builder#build()} is called immediately and its
         * result is passed to {@link #nodeGroups(List<NodeGroup>)}.
         * 
         * @param nodeGroups
         *        a consumer that will call methods on {@link List<NodeGroup>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nodeGroups(List<NodeGroup>)
         */
        Builder nodeGroups(Consumer<NodeGroup.Builder>... nodeGroups);

        /**
         * <p>
         * The cluster ID that is used as the daily snapshot source for the replication group.
         * </p>
         * 
         * @param snapshottingClusterId
         *        The cluster ID that is used as the daily snapshot source for the replication group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshottingClusterId(String snapshottingClusterId);

        /**
         * <p>
         * Indicates the status of Multi-AZ with automatic failover for this Redis replication group.
         * </p>
         * <p>
         * Amazon ElastiCache for Redis does not support Multi-AZ with automatic failover on:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Redis versions earlier than 2.8.6.
         * </p>
         * </li>
         * <li>
         * <p>
         * Redis (cluster mode disabled): T1 node types.
         * </p>
         * </li>
         * <li>
         * <p>
         * Redis (cluster mode enabled): T1 node types.
         * </p>
         * </li>
         * </ul>
         * 
         * @param automaticFailover
         *        Indicates the status of Multi-AZ with automatic failover for this Redis replication group.</p>
         *        <p>
         *        Amazon ElastiCache for Redis does not support Multi-AZ with automatic failover on:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Redis versions earlier than 2.8.6.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Redis (cluster mode disabled): T1 node types.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Redis (cluster mode enabled): T1 node types.
         *        </p>
         *        </li>
         * @see AutomaticFailoverStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomaticFailoverStatus
         */
        Builder automaticFailover(String automaticFailover);

        /**
         * <p>
         * Indicates the status of Multi-AZ with automatic failover for this Redis replication group.
         * </p>
         * <p>
         * Amazon ElastiCache for Redis does not support Multi-AZ with automatic failover on:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Redis versions earlier than 2.8.6.
         * </p>
         * </li>
         * <li>
         * <p>
         * Redis (cluster mode disabled): T1 node types.
         * </p>
         * </li>
         * <li>
         * <p>
         * Redis (cluster mode enabled): T1 node types.
         * </p>
         * </li>
         * </ul>
         * 
         * @param automaticFailover
         *        Indicates the status of Multi-AZ with automatic failover for this Redis replication group.</p>
         *        <p>
         *        Amazon ElastiCache for Redis does not support Multi-AZ with automatic failover on:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Redis versions earlier than 2.8.6.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Redis (cluster mode disabled): T1 node types.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Redis (cluster mode enabled): T1 node types.
         *        </p>
         *        </li>
         * @see AutomaticFailoverStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomaticFailoverStatus
         */
        Builder automaticFailover(AutomaticFailoverStatus automaticFailover);

        /**
         * Sets the value of the MultiAZ property for this object.
         *
         * @param multiAZ
         *        The new value for the MultiAZ property for this object.
         * @see MultiAZStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MultiAZStatus
         */
        Builder multiAZ(String multiAZ);

        /**
         * Sets the value of the MultiAZ property for this object.
         *
         * @param multiAZ
         *        The new value for the MultiAZ property for this object.
         * @see MultiAZStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MultiAZStatus
         */
        Builder multiAZ(MultiAZStatus multiAZ);

        /**
         * <p>
         * The configuration endpoint for this replication group. Use the configuration endpoint to connect to this
         * replication group.
         * </p>
         * 
         * @param configurationEndpoint
         *        The configuration endpoint for this replication group. Use the configuration endpoint to connect to
         *        this replication group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationEndpoint(Endpoint configurationEndpoint);

        /**
         * <p>
         * The configuration endpoint for this replication group. Use the configuration endpoint to connect to this
         * replication group.
         * </p>
         * This is a convenience that creates an instance of the {@link Endpoint.Builder} avoiding the need to create
         * one manually via {@link Endpoint#builder()}.
         *
         * When the {@link Consumer} completes, {@link Endpoint.Builder#build()} is called immediately and its result is
         * passed to {@link #configurationEndpoint(Endpoint)}.
         * 
         * @param configurationEndpoint
         *        a consumer that will call methods on {@link Endpoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configurationEndpoint(Endpoint)
         */
        default Builder configurationEndpoint(Consumer<Endpoint.Builder> configurationEndpoint) {
            return configurationEndpoint(Endpoint.builder().applyMutation(configurationEndpoint).build());
        }

        /**
         * <p>
         * The number of days for which ElastiCache retains automatic cluster snapshots before deleting them. For
         * example, if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was taken today is retained for
         * 5 days before being deleted.
         * </p>
         * <important>
         * <p>
         * If the value of <code>SnapshotRetentionLimit</code> is set to zero (0), backups are turned off.
         * </p>
         * </important>
         * 
         * @param snapshotRetentionLimit
         *        The number of days for which ElastiCache retains automatic cluster snapshots before deleting them. For
         *        example, if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was taken today is
         *        retained for 5 days before being deleted.</p> <important>
         *        <p>
         *        If the value of <code>SnapshotRetentionLimit</code> is set to zero (0), backups are turned off.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotRetentionLimit(Integer snapshotRetentionLimit);

        /**
         * <p>
         * The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your node group
         * (shard).
         * </p>
         * <p>
         * Example: <code>05:00-09:00</code>
         * </p>
         * <p>
         * If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.
         * </p>
         * <note>
         * <p>
         * This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.
         * </p>
         * </note>
         * 
         * @param snapshotWindow
         *        The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your node
         *        group (shard).</p>
         *        <p>
         *        Example: <code>05:00-09:00</code>
         *        </p>
         *        <p>
         *        If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.
         *        </p>
         *        <note>
         *        <p>
         *        This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotWindow(String snapshotWindow);

        /**
         * <p>
         * A flag indicating whether or not this replication group is cluster enabled; i.e., whether its data can be
         * partitioned across multiple shards (API/CLI: node groups).
         * </p>
         * <p>
         * Valid values: <code>true</code> | <code>false</code>
         * </p>
         * 
         * @param clusterEnabled
         *        A flag indicating whether or not this replication group is cluster enabled; i.e., whether its data can
         *        be partitioned across multiple shards (API/CLI: node groups).</p>
         *        <p>
         *        Valid values: <code>true</code> | <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterEnabled(Boolean clusterEnabled);

        /**
         * <p>
         * The name of the compute and memory capacity node type for each node in the replication group.
         * </p>
         * 
         * @param cacheNodeType
         *        The name of the compute and memory capacity node type for each node in the replication group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheNodeType(String cacheNodeType);

        /**
         * <p>
         * A flag that enables using an <code>AuthToken</code> (password) when issuing Redis commands.
         * </p>
         * <p>
         * Default: <code>false</code>
         * </p>
         * 
         * @param authTokenEnabled
         *        A flag that enables using an <code>AuthToken</code> (password) when issuing Redis commands.</p>
         *        <p>
         *        Default: <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authTokenEnabled(Boolean authTokenEnabled);

        /**
         * <p>
         * The date the auth token was last modified
         * </p>
         * 
         * @param authTokenLastModifiedDate
         *        The date the auth token was last modified
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authTokenLastModifiedDate(Instant authTokenLastModifiedDate);

        /**
         * <p>
         * A flag that enables in-transit encryption when set to <code>true</code>.
         * </p>
         * <p>
         * You cannot modify the value of <code>TransitEncryptionEnabled</code> after the cluster is created. To enable
         * in-transit encryption on a cluster you must set <code>TransitEncryptionEnabled</code> to <code>true</code>
         * when you create a cluster.
         * </p>
         * <p>
         * <b>Required:</b> Only available when creating a replication group in an Amazon VPC using redis version
         * <code>3.2.6</code>, <code>4.x</code> or later.
         * </p>
         * <p>
         * Default: <code>false</code>
         * </p>
         * 
         * @param transitEncryptionEnabled
         *        A flag that enables in-transit encryption when set to <code>true</code>.</p>
         *        <p>
         *        You cannot modify the value of <code>TransitEncryptionEnabled</code> after the cluster is created. To
         *        enable in-transit encryption on a cluster you must set <code>TransitEncryptionEnabled</code> to
         *        <code>true</code> when you create a cluster.
         *        </p>
         *        <p>
         *        <b>Required:</b> Only available when creating a replication group in an Amazon VPC using redis version
         *        <code>3.2.6</code>, <code>4.x</code> or later.
         *        </p>
         *        <p>
         *        Default: <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitEncryptionEnabled(Boolean transitEncryptionEnabled);

        /**
         * <p>
         * A flag that enables encryption at-rest when set to <code>true</code>.
         * </p>
         * <p>
         * You cannot modify the value of <code>AtRestEncryptionEnabled</code> after the cluster is created. To enable
         * encryption at-rest on a cluster you must set <code>AtRestEncryptionEnabled</code> to <code>true</code> when
         * you create a cluster.
         * </p>
         * <p>
         * <b>Required:</b> Only available when creating a replication group in an Amazon VPC using redis version
         * <code>3.2.6</code>, <code>4.x</code> or later.
         * </p>
         * <p>
         * Default: <code>false</code>
         * </p>
         * 
         * @param atRestEncryptionEnabled
         *        A flag that enables encryption at-rest when set to <code>true</code>.</p>
         *        <p>
         *        You cannot modify the value of <code>AtRestEncryptionEnabled</code> after the cluster is created. To
         *        enable encryption at-rest on a cluster you must set <code>AtRestEncryptionEnabled</code> to
         *        <code>true</code> when you create a cluster.
         *        </p>
         *        <p>
         *        <b>Required:</b> Only available when creating a replication group in an Amazon VPC using redis version
         *        <code>3.2.6</code>, <code>4.x</code> or later.
         *        </p>
         *        <p>
         *        Default: <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder atRestEncryptionEnabled(Boolean atRestEncryptionEnabled);

        /**
         * <p>
         * The ID of the KMS key used to encrypt the disk in the cluster.
         * </p>
         * 
         * @param kmsKeyId
         *        The ID of the KMS key used to encrypt the disk in the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The ARN (Amazon Resource Name) of the replication group.
         * </p>
         * 
         * @param arn
         *        The ARN (Amazon Resource Name) of the replication group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);
    }

    static final class BuilderImpl implements Builder {
        private String replicationGroupId;

        private String description;

        private GlobalReplicationGroupInfo globalReplicationGroupInfo;

        private String status;

        private ReplicationGroupPendingModifiedValues pendingModifiedValues;

        private List<String> memberClusters = DefaultSdkAutoConstructList.getInstance();

        private List<NodeGroup> nodeGroups = DefaultSdkAutoConstructList.getInstance();

        private String snapshottingClusterId;

        private String automaticFailover;

        private String multiAZ;

        private Endpoint configurationEndpoint;

        private Integer snapshotRetentionLimit;

        private String snapshotWindow;

        private Boolean clusterEnabled;

        private String cacheNodeType;

        private Boolean authTokenEnabled;

        private Instant authTokenLastModifiedDate;

        private Boolean transitEncryptionEnabled;

        private Boolean atRestEncryptionEnabled;

        private String kmsKeyId;

        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationGroup model) {
            replicationGroupId(model.replicationGroupId);
            description(model.description);
            globalReplicationGroupInfo(model.globalReplicationGroupInfo);
            status(model.status);
            pendingModifiedValues(model.pendingModifiedValues);
            memberClusters(model.memberClusters);
            nodeGroups(model.nodeGroups);
            snapshottingClusterId(model.snapshottingClusterId);
            automaticFailover(model.automaticFailover);
            multiAZ(model.multiAZ);
            configurationEndpoint(model.configurationEndpoint);
            snapshotRetentionLimit(model.snapshotRetentionLimit);
            snapshotWindow(model.snapshotWindow);
            clusterEnabled(model.clusterEnabled);
            cacheNodeType(model.cacheNodeType);
            authTokenEnabled(model.authTokenEnabled);
            authTokenLastModifiedDate(model.authTokenLastModifiedDate);
            transitEncryptionEnabled(model.transitEncryptionEnabled);
            atRestEncryptionEnabled(model.atRestEncryptionEnabled);
            kmsKeyId(model.kmsKeyId);
            arn(model.arn);
        }

        public final String getReplicationGroupId() {
            return replicationGroupId;
        }

        @Override
        public final Builder replicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
            return this;
        }

        public final void setReplicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final GlobalReplicationGroupInfo.Builder getGlobalReplicationGroupInfo() {
            return globalReplicationGroupInfo != null ? globalReplicationGroupInfo.toBuilder() : null;
        }

        @Override
        public final Builder globalReplicationGroupInfo(GlobalReplicationGroupInfo globalReplicationGroupInfo) {
            this.globalReplicationGroupInfo = globalReplicationGroupInfo;
            return this;
        }

        public final void setGlobalReplicationGroupInfo(GlobalReplicationGroupInfo.BuilderImpl globalReplicationGroupInfo) {
            this.globalReplicationGroupInfo = globalReplicationGroupInfo != null ? globalReplicationGroupInfo.build() : null;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final ReplicationGroupPendingModifiedValues.Builder getPendingModifiedValues() {
            return pendingModifiedValues != null ? pendingModifiedValues.toBuilder() : null;
        }

        @Override
        public final Builder pendingModifiedValues(ReplicationGroupPendingModifiedValues pendingModifiedValues) {
            this.pendingModifiedValues = pendingModifiedValues;
            return this;
        }

        public final void setPendingModifiedValues(ReplicationGroupPendingModifiedValues.BuilderImpl pendingModifiedValues) {
            this.pendingModifiedValues = pendingModifiedValues != null ? pendingModifiedValues.build() : null;
        }

        public final Collection<String> getMemberClusters() {
            return memberClusters;
        }

        @Override
        public final Builder memberClusters(Collection<String> memberClusters) {
            this.memberClusters = ClusterIdListCopier.copy(memberClusters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memberClusters(String... memberClusters) {
            memberClusters(Arrays.asList(memberClusters));
            return this;
        }

        public final void setMemberClusters(Collection<String> memberClusters) {
            this.memberClusters = ClusterIdListCopier.copy(memberClusters);
        }

        public final Collection<NodeGroup.Builder> getNodeGroups() {
            return nodeGroups != null ? nodeGroups.stream().map(NodeGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder nodeGroups(Collection<NodeGroup> nodeGroups) {
            this.nodeGroups = NodeGroupListCopier.copy(nodeGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeGroups(NodeGroup... nodeGroups) {
            nodeGroups(Arrays.asList(nodeGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeGroups(Consumer<NodeGroup.Builder>... nodeGroups) {
            nodeGroups(Stream.of(nodeGroups).map(c -> NodeGroup.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setNodeGroups(Collection<NodeGroup.BuilderImpl> nodeGroups) {
            this.nodeGroups = NodeGroupListCopier.copyFromBuilder(nodeGroups);
        }

        public final String getSnapshottingClusterId() {
            return snapshottingClusterId;
        }

        @Override
        public final Builder snapshottingClusterId(String snapshottingClusterId) {
            this.snapshottingClusterId = snapshottingClusterId;
            return this;
        }

        public final void setSnapshottingClusterId(String snapshottingClusterId) {
            this.snapshottingClusterId = snapshottingClusterId;
        }

        public final String getAutomaticFailover() {
            return automaticFailover;
        }

        @Override
        public final Builder automaticFailover(String automaticFailover) {
            this.automaticFailover = automaticFailover;
            return this;
        }

        @Override
        public final Builder automaticFailover(AutomaticFailoverStatus automaticFailover) {
            this.automaticFailover(automaticFailover == null ? null : automaticFailover.toString());
            return this;
        }

        public final void setAutomaticFailover(String automaticFailover) {
            this.automaticFailover = automaticFailover;
        }

        public final String getMultiAZ() {
            return multiAZ;
        }

        @Override
        public final Builder multiAZ(String multiAZ) {
            this.multiAZ = multiAZ;
            return this;
        }

        @Override
        public final Builder multiAZ(MultiAZStatus multiAZ) {
            this.multiAZ(multiAZ == null ? null : multiAZ.toString());
            return this;
        }

        public final void setMultiAZ(String multiAZ) {
            this.multiAZ = multiAZ;
        }

        public final Endpoint.Builder getConfigurationEndpoint() {
            return configurationEndpoint != null ? configurationEndpoint.toBuilder() : null;
        }

        @Override
        public final Builder configurationEndpoint(Endpoint configurationEndpoint) {
            this.configurationEndpoint = configurationEndpoint;
            return this;
        }

        public final void setConfigurationEndpoint(Endpoint.BuilderImpl configurationEndpoint) {
            this.configurationEndpoint = configurationEndpoint != null ? configurationEndpoint.build() : null;
        }

        public final Integer getSnapshotRetentionLimit() {
            return snapshotRetentionLimit;
        }

        @Override
        public final Builder snapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
            return this;
        }

        public final void setSnapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
        }

        public final String getSnapshotWindow() {
            return snapshotWindow;
        }

        @Override
        public final Builder snapshotWindow(String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
            return this;
        }

        public final void setSnapshotWindow(String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
        }

        public final Boolean getClusterEnabled() {
            return clusterEnabled;
        }

        @Override
        public final Builder clusterEnabled(Boolean clusterEnabled) {
            this.clusterEnabled = clusterEnabled;
            return this;
        }

        public final void setClusterEnabled(Boolean clusterEnabled) {
            this.clusterEnabled = clusterEnabled;
        }

        public final String getCacheNodeType() {
            return cacheNodeType;
        }

        @Override
        public final Builder cacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
            return this;
        }

        public final void setCacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
        }

        public final Boolean getAuthTokenEnabled() {
            return authTokenEnabled;
        }

        @Override
        public final Builder authTokenEnabled(Boolean authTokenEnabled) {
            this.authTokenEnabled = authTokenEnabled;
            return this;
        }

        public final void setAuthTokenEnabled(Boolean authTokenEnabled) {
            this.authTokenEnabled = authTokenEnabled;
        }

        public final Instant getAuthTokenLastModifiedDate() {
            return authTokenLastModifiedDate;
        }

        @Override
        public final Builder authTokenLastModifiedDate(Instant authTokenLastModifiedDate) {
            this.authTokenLastModifiedDate = authTokenLastModifiedDate;
            return this;
        }

        public final void setAuthTokenLastModifiedDate(Instant authTokenLastModifiedDate) {
            this.authTokenLastModifiedDate = authTokenLastModifiedDate;
        }

        public final Boolean getTransitEncryptionEnabled() {
            return transitEncryptionEnabled;
        }

        @Override
        public final Builder transitEncryptionEnabled(Boolean transitEncryptionEnabled) {
            this.transitEncryptionEnabled = transitEncryptionEnabled;
            return this;
        }

        public final void setTransitEncryptionEnabled(Boolean transitEncryptionEnabled) {
            this.transitEncryptionEnabled = transitEncryptionEnabled;
        }

        public final Boolean getAtRestEncryptionEnabled() {
            return atRestEncryptionEnabled;
        }

        @Override
        public final Builder atRestEncryptionEnabled(Boolean atRestEncryptionEnabled) {
            this.atRestEncryptionEnabled = atRestEncryptionEnabled;
            return this;
        }

        public final void setAtRestEncryptionEnabled(Boolean atRestEncryptionEnabled) {
            this.atRestEncryptionEnabled = atRestEncryptionEnabled;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public ReplicationGroup build() {
            return new ReplicationGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
