/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A group of settings that are applied to the cluster in the future, or that are currently being applied.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PendingModifiedValues implements SdkPojo, Serializable,
        ToCopyableBuilder<PendingModifiedValues.Builder, PendingModifiedValues> {
    private static final SdkField<Integer> NUM_CACHE_NODES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(PendingModifiedValues::numCacheNodes)).setter(setter(Builder::numCacheNodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumCacheNodes").build()).build();

    private static final SdkField<List<String>> CACHE_NODE_IDS_TO_REMOVE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(PendingModifiedValues::cacheNodeIdsToRemove))
            .setter(setter(Builder::cacheNodeIdsToRemove))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheNodeIdsToRemove").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("CacheNodeId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("CacheNodeId").build()).build()).build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PendingModifiedValues::engineVersion)).setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<String> CACHE_NODE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PendingModifiedValues::cacheNodeType)).setter(setter(Builder::cacheNodeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheNodeType").build()).build();

    private static final SdkField<String> AUTH_TOKEN_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PendingModifiedValues::authTokenStatusAsString)).setter(setter(Builder::authTokenStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthTokenStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NUM_CACHE_NODES_FIELD,
            CACHE_NODE_IDS_TO_REMOVE_FIELD, ENGINE_VERSION_FIELD, CACHE_NODE_TYPE_FIELD, AUTH_TOKEN_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer numCacheNodes;

    private final List<String> cacheNodeIdsToRemove;

    private final String engineVersion;

    private final String cacheNodeType;

    private final String authTokenStatus;

    private PendingModifiedValues(BuilderImpl builder) {
        this.numCacheNodes = builder.numCacheNodes;
        this.cacheNodeIdsToRemove = builder.cacheNodeIdsToRemove;
        this.engineVersion = builder.engineVersion;
        this.cacheNodeType = builder.cacheNodeType;
        this.authTokenStatus = builder.authTokenStatus;
    }

    /**
     * <p>
     * The new number of cache nodes for the cluster.
     * </p>
     * <p>
     * For clusters running Redis, this value must be 1. For clusters running Memcached, this value must be between 1
     * and 20.
     * </p>
     * 
     * @return The new number of cache nodes for the cluster.</p>
     *         <p>
     *         For clusters running Redis, this value must be 1. For clusters running Memcached, this value must be
     *         between 1 and 20.
     */
    public Integer numCacheNodes() {
        return numCacheNodes;
    }

    /**
     * Returns true if the CacheNodeIdsToRemove property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasCacheNodeIdsToRemove() {
        return cacheNodeIdsToRemove != null && !(cacheNodeIdsToRemove instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of cache node IDs that are being removed (or will be removed) from the cluster. A node ID is a 4-digit
     * numeric identifier (0001, 0002, etc.).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCacheNodeIdsToRemove()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of cache node IDs that are being removed (or will be removed) from the cluster. A node ID is a
     *         4-digit numeric identifier (0001, 0002, etc.).
     */
    public List<String> cacheNodeIdsToRemove() {
        return cacheNodeIdsToRemove;
    }

    /**
     * <p>
     * The new cache engine version that the cluster runs.
     * </p>
     * 
     * @return The new cache engine version that the cluster runs.
     */
    public String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * The cache node type that this cluster or replication group is scaled to.
     * </p>
     * 
     * @return The cache node type that this cluster or replication group is scaled to.
     */
    public String cacheNodeType() {
        return cacheNodeType;
    }

    /**
     * <p>
     * The auth token status
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authTokenStatus}
     * will return {@link AuthTokenUpdateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #authTokenStatusAsString}.
     * </p>
     * 
     * @return The auth token status
     * @see AuthTokenUpdateStatus
     */
    public AuthTokenUpdateStatus authTokenStatus() {
        return AuthTokenUpdateStatus.fromValue(authTokenStatus);
    }

    /**
     * <p>
     * The auth token status
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authTokenStatus}
     * will return {@link AuthTokenUpdateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #authTokenStatusAsString}.
     * </p>
     * 
     * @return The auth token status
     * @see AuthTokenUpdateStatus
     */
    public String authTokenStatusAsString() {
        return authTokenStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(numCacheNodes());
        hashCode = 31 * hashCode + Objects.hashCode(cacheNodeIdsToRemove());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(cacheNodeType());
        hashCode = 31 * hashCode + Objects.hashCode(authTokenStatusAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PendingModifiedValues)) {
            return false;
        }
        PendingModifiedValues other = (PendingModifiedValues) obj;
        return Objects.equals(numCacheNodes(), other.numCacheNodes())
                && Objects.equals(cacheNodeIdsToRemove(), other.cacheNodeIdsToRemove())
                && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(cacheNodeType(), other.cacheNodeType())
                && Objects.equals(authTokenStatusAsString(), other.authTokenStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PendingModifiedValues").add("NumCacheNodes", numCacheNodes())
                .add("CacheNodeIdsToRemove", cacheNodeIdsToRemove()).add("EngineVersion", engineVersion())
                .add("CacheNodeType", cacheNodeType()).add("AuthTokenStatus", authTokenStatusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NumCacheNodes":
            return Optional.ofNullable(clazz.cast(numCacheNodes()));
        case "CacheNodeIdsToRemove":
            return Optional.ofNullable(clazz.cast(cacheNodeIdsToRemove()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "CacheNodeType":
            return Optional.ofNullable(clazz.cast(cacheNodeType()));
        case "AuthTokenStatus":
            return Optional.ofNullable(clazz.cast(authTokenStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PendingModifiedValues, T> g) {
        return obj -> g.apply((PendingModifiedValues) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PendingModifiedValues> {
        /**
         * <p>
         * The new number of cache nodes for the cluster.
         * </p>
         * <p>
         * For clusters running Redis, this value must be 1. For clusters running Memcached, this value must be between
         * 1 and 20.
         * </p>
         * 
         * @param numCacheNodes
         *        The new number of cache nodes for the cluster.</p>
         *        <p>
         *        For clusters running Redis, this value must be 1. For clusters running Memcached, this value must be
         *        between 1 and 20.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numCacheNodes(Integer numCacheNodes);

        /**
         * <p>
         * A list of cache node IDs that are being removed (or will be removed) from the cluster. A node ID is a 4-digit
         * numeric identifier (0001, 0002, etc.).
         * </p>
         * 
         * @param cacheNodeIdsToRemove
         *        A list of cache node IDs that are being removed (or will be removed) from the cluster. A node ID is a
         *        4-digit numeric identifier (0001, 0002, etc.).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheNodeIdsToRemove(Collection<String> cacheNodeIdsToRemove);

        /**
         * <p>
         * A list of cache node IDs that are being removed (or will be removed) from the cluster. A node ID is a 4-digit
         * numeric identifier (0001, 0002, etc.).
         * </p>
         * 
         * @param cacheNodeIdsToRemove
         *        A list of cache node IDs that are being removed (or will be removed) from the cluster. A node ID is a
         *        4-digit numeric identifier (0001, 0002, etc.).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheNodeIdsToRemove(String... cacheNodeIdsToRemove);

        /**
         * <p>
         * The new cache engine version that the cluster runs.
         * </p>
         * 
         * @param engineVersion
         *        The new cache engine version that the cluster runs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * The cache node type that this cluster or replication group is scaled to.
         * </p>
         * 
         * @param cacheNodeType
         *        The cache node type that this cluster or replication group is scaled to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheNodeType(String cacheNodeType);

        /**
         * <p>
         * The auth token status
         * </p>
         * 
         * @param authTokenStatus
         *        The auth token status
         * @see AuthTokenUpdateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthTokenUpdateStatus
         */
        Builder authTokenStatus(String authTokenStatus);

        /**
         * <p>
         * The auth token status
         * </p>
         * 
         * @param authTokenStatus
         *        The auth token status
         * @see AuthTokenUpdateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthTokenUpdateStatus
         */
        Builder authTokenStatus(AuthTokenUpdateStatus authTokenStatus);
    }

    static final class BuilderImpl implements Builder {
        private Integer numCacheNodes;

        private List<String> cacheNodeIdsToRemove = DefaultSdkAutoConstructList.getInstance();

        private String engineVersion;

        private String cacheNodeType;

        private String authTokenStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(PendingModifiedValues model) {
            numCacheNodes(model.numCacheNodes);
            cacheNodeIdsToRemove(model.cacheNodeIdsToRemove);
            engineVersion(model.engineVersion);
            cacheNodeType(model.cacheNodeType);
            authTokenStatus(model.authTokenStatus);
        }

        public final Integer getNumCacheNodes() {
            return numCacheNodes;
        }

        @Override
        public final Builder numCacheNodes(Integer numCacheNodes) {
            this.numCacheNodes = numCacheNodes;
            return this;
        }

        public final void setNumCacheNodes(Integer numCacheNodes) {
            this.numCacheNodes = numCacheNodes;
        }

        public final Collection<String> getCacheNodeIdsToRemove() {
            return cacheNodeIdsToRemove;
        }

        @Override
        public final Builder cacheNodeIdsToRemove(Collection<String> cacheNodeIdsToRemove) {
            this.cacheNodeIdsToRemove = CacheNodeIdsListCopier.copy(cacheNodeIdsToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheNodeIdsToRemove(String... cacheNodeIdsToRemove) {
            cacheNodeIdsToRemove(Arrays.asList(cacheNodeIdsToRemove));
            return this;
        }

        public final void setCacheNodeIdsToRemove(Collection<String> cacheNodeIdsToRemove) {
            this.cacheNodeIdsToRemove = CacheNodeIdsListCopier.copy(cacheNodeIdsToRemove);
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final String getCacheNodeType() {
            return cacheNodeType;
        }

        @Override
        public final Builder cacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
            return this;
        }

        public final void setCacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
        }

        public final String getAuthTokenStatus() {
            return authTokenStatus;
        }

        @Override
        public final Builder authTokenStatus(String authTokenStatus) {
            this.authTokenStatus = authTokenStatus;
            return this;
        }

        @Override
        public final Builder authTokenStatus(AuthTokenUpdateStatus authTokenStatus) {
            this.authTokenStatus(authTokenStatus == null ? null : authTokenStatus.toString());
            return this;
        }

        public final void setAuthTokenStatus(String authTokenStatus) {
            this.authTokenStatus = authTokenStatus;
        }

        @Override
        public PendingModifiedValues build() {
            return new PendingModifiedValues(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
