/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyGlobalReplicationGroupRequest extends ElastiCacheRequest implements
        ToCopyableBuilder<ModifyGlobalReplicationGroupRequest.Builder, ModifyGlobalReplicationGroupRequest> {
    private static final SdkField<String> GLOBAL_REPLICATION_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyGlobalReplicationGroupRequest::globalReplicationGroupId))
            .setter(setter(Builder::globalReplicationGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalReplicationGroupId").build())
            .build();

    private static final SdkField<Boolean> APPLY_IMMEDIATELY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ModifyGlobalReplicationGroupRequest::applyImmediately)).setter(setter(Builder::applyImmediately))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplyImmediately").build()).build();

    private static final SdkField<String> CACHE_NODE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyGlobalReplicationGroupRequest::cacheNodeType)).setter(setter(Builder::cacheNodeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheNodeType").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyGlobalReplicationGroupRequest::engineVersion)).setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<String> GLOBAL_REPLICATION_GROUP_DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyGlobalReplicationGroupRequest::globalReplicationGroupDescription))
            .setter(setter(Builder::globalReplicationGroupDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalReplicationGroupDescription")
                    .build()).build();

    private static final SdkField<Boolean> AUTOMATIC_FAILOVER_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ModifyGlobalReplicationGroupRequest::automaticFailoverEnabled))
            .setter(setter(Builder::automaticFailoverEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomaticFailoverEnabled").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            GLOBAL_REPLICATION_GROUP_ID_FIELD, APPLY_IMMEDIATELY_FIELD, CACHE_NODE_TYPE_FIELD, ENGINE_VERSION_FIELD,
            GLOBAL_REPLICATION_GROUP_DESCRIPTION_FIELD, AUTOMATIC_FAILOVER_ENABLED_FIELD));

    private final String globalReplicationGroupId;

    private final Boolean applyImmediately;

    private final String cacheNodeType;

    private final String engineVersion;

    private final String globalReplicationGroupDescription;

    private final Boolean automaticFailoverEnabled;

    private ModifyGlobalReplicationGroupRequest(BuilderImpl builder) {
        super(builder);
        this.globalReplicationGroupId = builder.globalReplicationGroupId;
        this.applyImmediately = builder.applyImmediately;
        this.cacheNodeType = builder.cacheNodeType;
        this.engineVersion = builder.engineVersion;
        this.globalReplicationGroupDescription = builder.globalReplicationGroupDescription;
        this.automaticFailoverEnabled = builder.automaticFailoverEnabled;
    }

    /**
     * <p>
     * The name of the Global Datastore
     * </p>
     * 
     * @return The name of the Global Datastore
     */
    public String globalReplicationGroupId() {
        return globalReplicationGroupId;
    }

    /**
     * <p>
     * This parameter causes the modifications in this request and any pending modifications to be applied,
     * asynchronously and as soon as possible. Modifications to Global Replication Groups cannot be requested to be
     * applied in PreferredMaintenceWindow.
     * </p>
     * 
     * @return This parameter causes the modifications in this request and any pending modifications to be applied,
     *         asynchronously and as soon as possible. Modifications to Global Replication Groups cannot be requested to
     *         be applied in PreferredMaintenceWindow.
     */
    public Boolean applyImmediately() {
        return applyImmediately;
    }

    /**
     * <p>
     * A valid cache node type that you want to scale this Global Datastore to.
     * </p>
     * 
     * @return A valid cache node type that you want to scale this Global Datastore to.
     */
    public String cacheNodeType() {
        return cacheNodeType;
    }

    /**
     * <p>
     * The upgraded version of the cache engine to be run on the clusters in the Global Datastore.
     * </p>
     * 
     * @return The upgraded version of the cache engine to be run on the clusters in the Global Datastore.
     */
    public String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * A description of the Global Datastore
     * </p>
     * 
     * @return A description of the Global Datastore
     */
    public String globalReplicationGroupDescription() {
        return globalReplicationGroupDescription;
    }

    /**
     * <p>
     * Determines whether a read replica is automatically promoted to read/write primary if the existing primary
     * encounters a failure.
     * </p>
     * 
     * @return Determines whether a read replica is automatically promoted to read/write primary if the existing primary
     *         encounters a failure.
     */
    public Boolean automaticFailoverEnabled() {
        return automaticFailoverEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(globalReplicationGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(applyImmediately());
        hashCode = 31 * hashCode + Objects.hashCode(cacheNodeType());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(globalReplicationGroupDescription());
        hashCode = 31 * hashCode + Objects.hashCode(automaticFailoverEnabled());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyGlobalReplicationGroupRequest)) {
            return false;
        }
        ModifyGlobalReplicationGroupRequest other = (ModifyGlobalReplicationGroupRequest) obj;
        return Objects.equals(globalReplicationGroupId(), other.globalReplicationGroupId())
                && Objects.equals(applyImmediately(), other.applyImmediately())
                && Objects.equals(cacheNodeType(), other.cacheNodeType())
                && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(globalReplicationGroupDescription(), other.globalReplicationGroupDescription())
                && Objects.equals(automaticFailoverEnabled(), other.automaticFailoverEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ModifyGlobalReplicationGroupRequest")
                .add("GlobalReplicationGroupId", globalReplicationGroupId()).add("ApplyImmediately", applyImmediately())
                .add("CacheNodeType", cacheNodeType()).add("EngineVersion", engineVersion())
                .add("GlobalReplicationGroupDescription", globalReplicationGroupDescription())
                .add("AutomaticFailoverEnabled", automaticFailoverEnabled()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GlobalReplicationGroupId":
            return Optional.ofNullable(clazz.cast(globalReplicationGroupId()));
        case "ApplyImmediately":
            return Optional.ofNullable(clazz.cast(applyImmediately()));
        case "CacheNodeType":
            return Optional.ofNullable(clazz.cast(cacheNodeType()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "GlobalReplicationGroupDescription":
            return Optional.ofNullable(clazz.cast(globalReplicationGroupDescription()));
        case "AutomaticFailoverEnabled":
            return Optional.ofNullable(clazz.cast(automaticFailoverEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyGlobalReplicationGroupRequest, T> g) {
        return obj -> g.apply((ModifyGlobalReplicationGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElastiCacheRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ModifyGlobalReplicationGroupRequest> {
        /**
         * <p>
         * The name of the Global Datastore
         * </p>
         * 
         * @param globalReplicationGroupId
         *        The name of the Global Datastore
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalReplicationGroupId(String globalReplicationGroupId);

        /**
         * <p>
         * This parameter causes the modifications in this request and any pending modifications to be applied,
         * asynchronously and as soon as possible. Modifications to Global Replication Groups cannot be requested to be
         * applied in PreferredMaintenceWindow.
         * </p>
         * 
         * @param applyImmediately
         *        This parameter causes the modifications in this request and any pending modifications to be applied,
         *        asynchronously and as soon as possible. Modifications to Global Replication Groups cannot be requested
         *        to be applied in PreferredMaintenceWindow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applyImmediately(Boolean applyImmediately);

        /**
         * <p>
         * A valid cache node type that you want to scale this Global Datastore to.
         * </p>
         * 
         * @param cacheNodeType
         *        A valid cache node type that you want to scale this Global Datastore to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheNodeType(String cacheNodeType);

        /**
         * <p>
         * The upgraded version of the cache engine to be run on the clusters in the Global Datastore.
         * </p>
         * 
         * @param engineVersion
         *        The upgraded version of the cache engine to be run on the clusters in the Global Datastore.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * A description of the Global Datastore
         * </p>
         * 
         * @param globalReplicationGroupDescription
         *        A description of the Global Datastore
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalReplicationGroupDescription(String globalReplicationGroupDescription);

        /**
         * <p>
         * Determines whether a read replica is automatically promoted to read/write primary if the existing primary
         * encounters a failure.
         * </p>
         * 
         * @param automaticFailoverEnabled
         *        Determines whether a read replica is automatically promoted to read/write primary if the existing
         *        primary encounters a failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automaticFailoverEnabled(Boolean automaticFailoverEnabled);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElastiCacheRequest.BuilderImpl implements Builder {
        private String globalReplicationGroupId;

        private Boolean applyImmediately;

        private String cacheNodeType;

        private String engineVersion;

        private String globalReplicationGroupDescription;

        private Boolean automaticFailoverEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyGlobalReplicationGroupRequest model) {
            super(model);
            globalReplicationGroupId(model.globalReplicationGroupId);
            applyImmediately(model.applyImmediately);
            cacheNodeType(model.cacheNodeType);
            engineVersion(model.engineVersion);
            globalReplicationGroupDescription(model.globalReplicationGroupDescription);
            automaticFailoverEnabled(model.automaticFailoverEnabled);
        }

        public final String getGlobalReplicationGroupId() {
            return globalReplicationGroupId;
        }

        @Override
        public final Builder globalReplicationGroupId(String globalReplicationGroupId) {
            this.globalReplicationGroupId = globalReplicationGroupId;
            return this;
        }

        public final void setGlobalReplicationGroupId(String globalReplicationGroupId) {
            this.globalReplicationGroupId = globalReplicationGroupId;
        }

        public final Boolean getApplyImmediately() {
            return applyImmediately;
        }

        @Override
        public final Builder applyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
            return this;
        }

        public final void setApplyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
        }

        public final String getCacheNodeType() {
            return cacheNodeType;
        }

        @Override
        public final Builder cacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
            return this;
        }

        public final void setCacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final String getGlobalReplicationGroupDescription() {
            return globalReplicationGroupDescription;
        }

        @Override
        public final Builder globalReplicationGroupDescription(String globalReplicationGroupDescription) {
            this.globalReplicationGroupDescription = globalReplicationGroupDescription;
            return this;
        }

        public final void setGlobalReplicationGroupDescription(String globalReplicationGroupDescription) {
            this.globalReplicationGroupDescription = globalReplicationGroupDescription;
        }

        public final Boolean getAutomaticFailoverEnabled() {
            return automaticFailoverEnabled;
        }

        @Override
        public final Builder automaticFailoverEnabled(Boolean automaticFailoverEnabled) {
            this.automaticFailoverEnabled = automaticFailoverEnabled;
            return this;
        }

        public final void setAutomaticFailoverEnabled(Boolean automaticFailoverEnabled) {
            this.automaticFailoverEnabled = automaticFailoverEnabled;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyGlobalReplicationGroupRequest build() {
            return new ModifyGlobalReplicationGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
