/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeServiceUpdatesResponse extends ElastiCacheResponse implements
        ToCopyableBuilder<DescribeServiceUpdatesResponse.Builder, DescribeServiceUpdatesResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeServiceUpdatesResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<List<ServiceUpdate>> SERVICE_UPDATES_FIELD = SdkField
            .<List<ServiceUpdate>> builder(MarshallingType.LIST)
            .getter(getter(DescribeServiceUpdatesResponse::serviceUpdates))
            .setter(setter(Builder::serviceUpdates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceUpdates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("ServiceUpdate")
                            .memberFieldInfo(
                                    SdkField.<ServiceUpdate> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServiceUpdate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("ServiceUpdate").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD,
            SERVICE_UPDATES_FIELD));

    private final String marker;

    private final List<ServiceUpdate> serviceUpdates;

    private DescribeServiceUpdatesResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.serviceUpdates = builder.serviceUpdates;
    }

    /**
     * <p>
     * An optional marker returned from a prior request. Use this marker for pagination of results from this operation.
     * If this parameter is specified, the response includes only records beyond the marker, up to the value specified
     * by <code>MaxRecords</code>.
     * </p>
     * 
     * @return An optional marker returned from a prior request. Use this marker for pagination of results from this
     *         operation. If this parameter is specified, the response includes only records beyond the marker, up to
     *         the value specified by <code>MaxRecords</code>.
     */
    public String marker() {
        return marker;
    }

    /**
     * Returns true if the ServiceUpdates property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasServiceUpdates() {
        return serviceUpdates != null && !(serviceUpdates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of service updates
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasServiceUpdates()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of service updates
     */
    public List<ServiceUpdate> serviceUpdates() {
        return serviceUpdates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(serviceUpdates());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeServiceUpdatesResponse)) {
            return false;
        }
        DescribeServiceUpdatesResponse other = (DescribeServiceUpdatesResponse) obj;
        return Objects.equals(marker(), other.marker()) && Objects.equals(serviceUpdates(), other.serviceUpdates());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeServiceUpdatesResponse").add("Marker", marker()).add("ServiceUpdates", serviceUpdates())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "ServiceUpdates":
            return Optional.ofNullable(clazz.cast(serviceUpdates()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeServiceUpdatesResponse, T> g) {
        return obj -> g.apply((DescribeServiceUpdatesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElastiCacheResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeServiceUpdatesResponse> {
        /**
         * <p>
         * An optional marker returned from a prior request. Use this marker for pagination of results from this
         * operation. If this parameter is specified, the response includes only records beyond the marker, up to the
         * value specified by <code>MaxRecords</code>.
         * </p>
         * 
         * @param marker
         *        An optional marker returned from a prior request. Use this marker for pagination of results from this
         *        operation. If this parameter is specified, the response includes only records beyond the marker, up to
         *        the value specified by <code>MaxRecords</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * A list of service updates
         * </p>
         * 
         * @param serviceUpdates
         *        A list of service updates
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceUpdates(Collection<ServiceUpdate> serviceUpdates);

        /**
         * <p>
         * A list of service updates
         * </p>
         * 
         * @param serviceUpdates
         *        A list of service updates
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceUpdates(ServiceUpdate... serviceUpdates);

        /**
         * <p>
         * A list of service updates
         * </p>
         * This is a convenience that creates an instance of the {@link List<ServiceUpdate>.Builder} avoiding the need
         * to create one manually via {@link List<ServiceUpdate>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ServiceUpdate>.Builder#build()} is called immediately and
         * its result is passed to {@link #serviceUpdates(List<ServiceUpdate>)}.
         * 
         * @param serviceUpdates
         *        a consumer that will call methods on {@link List<ServiceUpdate>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceUpdates(List<ServiceUpdate>)
         */
        Builder serviceUpdates(Consumer<ServiceUpdate.Builder>... serviceUpdates);
    }

    static final class BuilderImpl extends ElastiCacheResponse.BuilderImpl implements Builder {
        private String marker;

        private List<ServiceUpdate> serviceUpdates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeServiceUpdatesResponse model) {
            super(model);
            marker(model.marker);
            serviceUpdates(model.serviceUpdates);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<ServiceUpdate.Builder> getServiceUpdates() {
            return serviceUpdates != null ? serviceUpdates.stream().map(ServiceUpdate::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder serviceUpdates(Collection<ServiceUpdate> serviceUpdates) {
            this.serviceUpdates = ServiceUpdateListCopier.copy(serviceUpdates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceUpdates(ServiceUpdate... serviceUpdates) {
            serviceUpdates(Arrays.asList(serviceUpdates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceUpdates(Consumer<ServiceUpdate.Builder>... serviceUpdates) {
            serviceUpdates(Stream.of(serviceUpdates).map(c -> ServiceUpdate.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setServiceUpdates(Collection<ServiceUpdate.BuilderImpl> serviceUpdates) {
            this.serviceUpdates = ServiceUpdateListCopier.copyFromBuilder(serviceUpdates);
        }

        @Override
        public DescribeServiceUpdatesResponse build() {
            return new DescribeServiceUpdatesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
