/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a <code>CreateCacheParameterGroup</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCacheParameterGroupRequest extends ElastiCacheRequest implements
        ToCopyableBuilder<CreateCacheParameterGroupRequest.Builder, CreateCacheParameterGroupRequest> {
    private static final SdkField<String> CACHE_PARAMETER_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateCacheParameterGroupRequest::cacheParameterGroupName))
            .setter(setter(Builder::cacheParameterGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheParameterGroupName").build())
            .build();

    private static final SdkField<String> CACHE_PARAMETER_GROUP_FAMILY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateCacheParameterGroupRequest::cacheParameterGroupFamily))
            .setter(setter(Builder::cacheParameterGroupFamily))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheParameterGroupFamily").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateCacheParameterGroupRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CACHE_PARAMETER_GROUP_NAME_FIELD, CACHE_PARAMETER_GROUP_FAMILY_FIELD, DESCRIPTION_FIELD));

    private final String cacheParameterGroupName;

    private final String cacheParameterGroupFamily;

    private final String description;

    private CreateCacheParameterGroupRequest(BuilderImpl builder) {
        super(builder);
        this.cacheParameterGroupName = builder.cacheParameterGroupName;
        this.cacheParameterGroupFamily = builder.cacheParameterGroupFamily;
        this.description = builder.description;
    }

    /**
     * <p>
     * A user-specified name for the cache parameter group.
     * </p>
     * 
     * @return A user-specified name for the cache parameter group.
     */
    public String cacheParameterGroupName() {
        return cacheParameterGroupName;
    }

    /**
     * <p>
     * The name of the cache parameter group family that the cache parameter group can be used with.
     * </p>
     * <p>
     * Valid values are: <code>memcached1.4</code> | <code>memcached1.5</code> | <code>redis2.6</code> |
     * <code>redis2.8</code> | <code>redis3.2</code> | <code>redis4.0</code> | <code>redis5.0</code> |
     * </p>
     * 
     * @return The name of the cache parameter group family that the cache parameter group can be used with.</p>
     *         <p>
     *         Valid values are: <code>memcached1.4</code> | <code>memcached1.5</code> | <code>redis2.6</code> |
     *         <code>redis2.8</code> | <code>redis3.2</code> | <code>redis4.0</code> | <code>redis5.0</code> |
     */
    public String cacheParameterGroupFamily() {
        return cacheParameterGroupFamily;
    }

    /**
     * <p>
     * A user-specified description for the cache parameter group.
     * </p>
     * 
     * @return A user-specified description for the cache parameter group.
     */
    public String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cacheParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(cacheParameterGroupFamily());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCacheParameterGroupRequest)) {
            return false;
        }
        CreateCacheParameterGroupRequest other = (CreateCacheParameterGroupRequest) obj;
        return Objects.equals(cacheParameterGroupName(), other.cacheParameterGroupName())
                && Objects.equals(cacheParameterGroupFamily(), other.cacheParameterGroupFamily())
                && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateCacheParameterGroupRequest").add("CacheParameterGroupName", cacheParameterGroupName())
                .add("CacheParameterGroupFamily", cacheParameterGroupFamily()).add("Description", description()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CacheParameterGroupName":
            return Optional.ofNullable(clazz.cast(cacheParameterGroupName()));
        case "CacheParameterGroupFamily":
            return Optional.ofNullable(clazz.cast(cacheParameterGroupFamily()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCacheParameterGroupRequest, T> g) {
        return obj -> g.apply((CreateCacheParameterGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElastiCacheRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateCacheParameterGroupRequest> {
        /**
         * <p>
         * A user-specified name for the cache parameter group.
         * </p>
         * 
         * @param cacheParameterGroupName
         *        A user-specified name for the cache parameter group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheParameterGroupName(String cacheParameterGroupName);

        /**
         * <p>
         * The name of the cache parameter group family that the cache parameter group can be used with.
         * </p>
         * <p>
         * Valid values are: <code>memcached1.4</code> | <code>memcached1.5</code> | <code>redis2.6</code> |
         * <code>redis2.8</code> | <code>redis3.2</code> | <code>redis4.0</code> | <code>redis5.0</code> |
         * </p>
         * 
         * @param cacheParameterGroupFamily
         *        The name of the cache parameter group family that the cache parameter group can be used with.</p>
         *        <p>
         *        Valid values are: <code>memcached1.4</code> | <code>memcached1.5</code> | <code>redis2.6</code> |
         *        <code>redis2.8</code> | <code>redis3.2</code> | <code>redis4.0</code> | <code>redis5.0</code> |
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheParameterGroupFamily(String cacheParameterGroupFamily);

        /**
         * <p>
         * A user-specified description for the cache parameter group.
         * </p>
         * 
         * @param description
         *        A user-specified description for the cache parameter group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElastiCacheRequest.BuilderImpl implements Builder {
        private String cacheParameterGroupName;

        private String cacheParameterGroupFamily;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCacheParameterGroupRequest model) {
            super(model);
            cacheParameterGroupName(model.cacheParameterGroupName);
            cacheParameterGroupFamily(model.cacheParameterGroupFamily);
            description(model.description);
        }

        public final String getCacheParameterGroupName() {
            return cacheParameterGroupName;
        }

        @Override
        public final Builder cacheParameterGroupName(String cacheParameterGroupName) {
            this.cacheParameterGroupName = cacheParameterGroupName;
            return this;
        }

        public final void setCacheParameterGroupName(String cacheParameterGroupName) {
            this.cacheParameterGroupName = cacheParameterGroupName;
        }

        public final String getCacheParameterGroupFamily() {
            return cacheParameterGroupFamily;
        }

        @Override
        public final Builder cacheParameterGroupFamily(String cacheParameterGroupFamily) {
            this.cacheParameterGroupFamily = cacheParameterGroupFamily;
            return this;
        }

        public final void setCacheParameterGroupFamily(String cacheParameterGroupFamily) {
            this.cacheParameterGroupFamily = cacheParameterGroupFamily;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCacheParameterGroupRequest build() {
            return new CreateCacheParameterGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
