/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchStopUpdateActionRequest extends ElastiCacheRequest implements
        ToCopyableBuilder<BatchStopUpdateActionRequest.Builder, BatchStopUpdateActionRequest> {
    private static final SdkField<List<String>> REPLICATION_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(BatchStopUpdateActionRequest::replicationGroupIds))
            .setter(setter(Builder::replicationGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> CACHE_CLUSTER_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(BatchStopUpdateActionRequest::cacheClusterIds))
            .setter(setter(Builder::cacheClusterIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheClusterIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SERVICE_UPDATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BatchStopUpdateActionRequest::serviceUpdateName)).setter(setter(Builder::serviceUpdateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceUpdateName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_GROUP_IDS_FIELD,
            CACHE_CLUSTER_IDS_FIELD, SERVICE_UPDATE_NAME_FIELD));

    private final List<String> replicationGroupIds;

    private final List<String> cacheClusterIds;

    private final String serviceUpdateName;

    private BatchStopUpdateActionRequest(BuilderImpl builder) {
        super(builder);
        this.replicationGroupIds = builder.replicationGroupIds;
        this.cacheClusterIds = builder.cacheClusterIds;
        this.serviceUpdateName = builder.serviceUpdateName;
    }

    /**
     * Returns true if the ReplicationGroupIds property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasReplicationGroupIds() {
        return replicationGroupIds != null && !(replicationGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The replication group IDs
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasReplicationGroupIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The replication group IDs
     */
    public List<String> replicationGroupIds() {
        return replicationGroupIds;
    }

    /**
     * Returns true if the CacheClusterIds property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasCacheClusterIds() {
        return cacheClusterIds != null && !(cacheClusterIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The cache cluster IDs
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCacheClusterIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The cache cluster IDs
     */
    public List<String> cacheClusterIds() {
        return cacheClusterIds;
    }

    /**
     * <p>
     * The unique ID of the service update
     * </p>
     * 
     * @return The unique ID of the service update
     */
    public String serviceUpdateName() {
        return serviceUpdateName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(replicationGroupIds());
        hashCode = 31 * hashCode + Objects.hashCode(cacheClusterIds());
        hashCode = 31 * hashCode + Objects.hashCode(serviceUpdateName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchStopUpdateActionRequest)) {
            return false;
        }
        BatchStopUpdateActionRequest other = (BatchStopUpdateActionRequest) obj;
        return Objects.equals(replicationGroupIds(), other.replicationGroupIds())
                && Objects.equals(cacheClusterIds(), other.cacheClusterIds())
                && Objects.equals(serviceUpdateName(), other.serviceUpdateName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BatchStopUpdateActionRequest").add("ReplicationGroupIds", replicationGroupIds())
                .add("CacheClusterIds", cacheClusterIds()).add("ServiceUpdateName", serviceUpdateName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReplicationGroupIds":
            return Optional.ofNullable(clazz.cast(replicationGroupIds()));
        case "CacheClusterIds":
            return Optional.ofNullable(clazz.cast(cacheClusterIds()));
        case "ServiceUpdateName":
            return Optional.ofNullable(clazz.cast(serviceUpdateName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchStopUpdateActionRequest, T> g) {
        return obj -> g.apply((BatchStopUpdateActionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElastiCacheRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchStopUpdateActionRequest> {
        /**
         * <p>
         * The replication group IDs
         * </p>
         * 
         * @param replicationGroupIds
         *        The replication group IDs
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationGroupIds(Collection<String> replicationGroupIds);

        /**
         * <p>
         * The replication group IDs
         * </p>
         * 
         * @param replicationGroupIds
         *        The replication group IDs
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationGroupIds(String... replicationGroupIds);

        /**
         * <p>
         * The cache cluster IDs
         * </p>
         * 
         * @param cacheClusterIds
         *        The cache cluster IDs
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheClusterIds(Collection<String> cacheClusterIds);

        /**
         * <p>
         * The cache cluster IDs
         * </p>
         * 
         * @param cacheClusterIds
         *        The cache cluster IDs
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheClusterIds(String... cacheClusterIds);

        /**
         * <p>
         * The unique ID of the service update
         * </p>
         * 
         * @param serviceUpdateName
         *        The unique ID of the service update
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceUpdateName(String serviceUpdateName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElastiCacheRequest.BuilderImpl implements Builder {
        private List<String> replicationGroupIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> cacheClusterIds = DefaultSdkAutoConstructList.getInstance();

        private String serviceUpdateName;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchStopUpdateActionRequest model) {
            super(model);
            replicationGroupIds(model.replicationGroupIds);
            cacheClusterIds(model.cacheClusterIds);
            serviceUpdateName(model.serviceUpdateName);
        }

        public final Collection<String> getReplicationGroupIds() {
            return replicationGroupIds;
        }

        @Override
        public final Builder replicationGroupIds(Collection<String> replicationGroupIds) {
            this.replicationGroupIds = ReplicationGroupIdListCopier.copy(replicationGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationGroupIds(String... replicationGroupIds) {
            replicationGroupIds(Arrays.asList(replicationGroupIds));
            return this;
        }

        public final void setReplicationGroupIds(Collection<String> replicationGroupIds) {
            this.replicationGroupIds = ReplicationGroupIdListCopier.copy(replicationGroupIds);
        }

        public final Collection<String> getCacheClusterIds() {
            return cacheClusterIds;
        }

        @Override
        public final Builder cacheClusterIds(Collection<String> cacheClusterIds) {
            this.cacheClusterIds = CacheClusterIdListCopier.copy(cacheClusterIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheClusterIds(String... cacheClusterIds) {
            cacheClusterIds(Arrays.asList(cacheClusterIds));
            return this;
        }

        public final void setCacheClusterIds(Collection<String> cacheClusterIds) {
            this.cacheClusterIds = CacheClusterIdListCopier.copy(cacheClusterIds);
        }

        public final String getServiceUpdateName() {
            return serviceUpdateName;
        }

        @Override
        public final Builder serviceUpdateName(String serviceUpdateName) {
            this.serviceUpdateName = serviceUpdateName;
            return this;
        }

        public final void setServiceUpdateName(String serviceUpdateName) {
            this.serviceUpdateName = serviceUpdateName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchStopUpdateActionRequest build() {
            return new BatchStopUpdateActionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
