/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeUpdateActionsResponse extends ElastiCacheResponse implements
        ToCopyableBuilder<DescribeUpdateActionsResponse.Builder, DescribeUpdateActionsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeUpdateActionsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<List<UpdateAction>> UPDATE_ACTIONS_FIELD = SdkField
            .<List<UpdateAction>> builder(MarshallingType.LIST)
            .getter(getter(DescribeUpdateActionsResponse::updateActions))
            .setter(setter(Builder::updateActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateActions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("UpdateAction")
                            .memberFieldInfo(
                                    SdkField.<UpdateAction> builder(MarshallingType.SDK_POJO)
                                            .constructor(UpdateAction::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("UpdateAction").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD,
            UPDATE_ACTIONS_FIELD));

    private final String marker;

    private final List<UpdateAction> updateActions;

    private DescribeUpdateActionsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.updateActions = builder.updateActions;
    }

    /**
     * <p>
     * An optional marker returned from a prior request. Use this marker for pagination of results from this operation.
     * If this parameter is specified, the response includes only records beyond the marker, up to the value specified
     * by <code>MaxRecords</code>.
     * </p>
     * 
     * @return An optional marker returned from a prior request. Use this marker for pagination of results from this
     *         operation. If this parameter is specified, the response includes only records beyond the marker, up to
     *         the value specified by <code>MaxRecords</code>.
     */
    public String marker() {
        return marker;
    }

    /**
     * Returns true if the UpdateActions property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasUpdateActions() {
        return updateActions != null && !(updateActions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns a list of update actions
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUpdateActions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Returns a list of update actions
     */
    public List<UpdateAction> updateActions() {
        return updateActions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(updateActions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeUpdateActionsResponse)) {
            return false;
        }
        DescribeUpdateActionsResponse other = (DescribeUpdateActionsResponse) obj;
        return Objects.equals(marker(), other.marker()) && Objects.equals(updateActions(), other.updateActions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeUpdateActionsResponse").add("Marker", marker()).add("UpdateActions", updateActions())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "UpdateActions":
            return Optional.ofNullable(clazz.cast(updateActions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeUpdateActionsResponse, T> g) {
        return obj -> g.apply((DescribeUpdateActionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElastiCacheResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeUpdateActionsResponse> {
        /**
         * <p>
         * An optional marker returned from a prior request. Use this marker for pagination of results from this
         * operation. If this parameter is specified, the response includes only records beyond the marker, up to the
         * value specified by <code>MaxRecords</code>.
         * </p>
         * 
         * @param marker
         *        An optional marker returned from a prior request. Use this marker for pagination of results from this
         *        operation. If this parameter is specified, the response includes only records beyond the marker, up to
         *        the value specified by <code>MaxRecords</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * Returns a list of update actions
         * </p>
         * 
         * @param updateActions
         *        Returns a list of update actions
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateActions(Collection<UpdateAction> updateActions);

        /**
         * <p>
         * Returns a list of update actions
         * </p>
         * 
         * @param updateActions
         *        Returns a list of update actions
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateActions(UpdateAction... updateActions);

        /**
         * <p>
         * Returns a list of update actions
         * </p>
         * This is a convenience that creates an instance of the {@link List<UpdateAction>.Builder} avoiding the need to
         * create one manually via {@link List<UpdateAction>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UpdateAction>.Builder#build()} is called immediately and its
         * result is passed to {@link #updateActions(List<UpdateAction>)}.
         * 
         * @param updateActions
         *        a consumer that will call methods on {@link List<UpdateAction>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #updateActions(List<UpdateAction>)
         */
        Builder updateActions(Consumer<UpdateAction.Builder>... updateActions);
    }

    static final class BuilderImpl extends ElastiCacheResponse.BuilderImpl implements Builder {
        private String marker;

        private List<UpdateAction> updateActions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeUpdateActionsResponse model) {
            super(model);
            marker(model.marker);
            updateActions(model.updateActions);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<UpdateAction.Builder> getUpdateActions() {
            return updateActions != null ? updateActions.stream().map(UpdateAction::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder updateActions(Collection<UpdateAction> updateActions) {
            this.updateActions = UpdateActionListCopier.copy(updateActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updateActions(UpdateAction... updateActions) {
            updateActions(Arrays.asList(updateActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updateActions(Consumer<UpdateAction.Builder>... updateActions) {
            updateActions(Stream.of(updateActions).map(c -> UpdateAction.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setUpdateActions(Collection<UpdateAction.BuilderImpl> updateActions) {
            this.updateActions = UpdateActionListCopier.copyFromBuilder(updateActions);
        }

        @Override
        public DescribeUpdateActionsResponse build() {
            return new DescribeUpdateActionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
