/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>DescribeReservedCacheNodes</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeReservedCacheNodesResponse extends ElastiCacheResponse implements
        ToCopyableBuilder<DescribeReservedCacheNodesResponse.Builder, DescribeReservedCacheNodesResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeReservedCacheNodesResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<List<ReservedCacheNode>> RESERVED_CACHE_NODES_FIELD = SdkField
            .<List<ReservedCacheNode>> builder(MarshallingType.LIST)
            .getter(getter(DescribeReservedCacheNodesResponse::reservedCacheNodes))
            .setter(setter(Builder::reservedCacheNodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedCacheNodes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("ReservedCacheNode")
                            .memberFieldInfo(
                                    SdkField.<ReservedCacheNode> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReservedCacheNode::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("ReservedCacheNode").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD,
            RESERVED_CACHE_NODES_FIELD));

    private final String marker;

    private final List<ReservedCacheNode> reservedCacheNodes;

    private DescribeReservedCacheNodesResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.reservedCacheNodes = builder.reservedCacheNodes;
    }

    /**
     * <p>
     * Provides an identifier to allow retrieval of paginated results.
     * </p>
     * 
     * @return Provides an identifier to allow retrieval of paginated results.
     */
    public String marker() {
        return marker;
    }

    /**
     * Returns true if the ReservedCacheNodes property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasReservedCacheNodes() {
        return reservedCacheNodes != null && !(reservedCacheNodes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of reserved cache nodes. Each element in the list contains detailed information about one node.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasReservedCacheNodes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of reserved cache nodes. Each element in the list contains detailed information about one node.
     */
    public List<ReservedCacheNode> reservedCacheNodes() {
        return reservedCacheNodes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(reservedCacheNodes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedCacheNodesResponse)) {
            return false;
        }
        DescribeReservedCacheNodesResponse other = (DescribeReservedCacheNodesResponse) obj;
        return Objects.equals(marker(), other.marker()) && Objects.equals(reservedCacheNodes(), other.reservedCacheNodes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeReservedCacheNodesResponse").add("Marker", marker())
                .add("ReservedCacheNodes", reservedCacheNodes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "ReservedCacheNodes":
            return Optional.ofNullable(clazz.cast(reservedCacheNodes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeReservedCacheNodesResponse, T> g) {
        return obj -> g.apply((DescribeReservedCacheNodesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElastiCacheResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeReservedCacheNodesResponse> {
        /**
         * <p>
         * Provides an identifier to allow retrieval of paginated results.
         * </p>
         * 
         * @param marker
         *        Provides an identifier to allow retrieval of paginated results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * A list of reserved cache nodes. Each element in the list contains detailed information about one node.
         * </p>
         * 
         * @param reservedCacheNodes
         *        A list of reserved cache nodes. Each element in the list contains detailed information about one node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedCacheNodes(Collection<ReservedCacheNode> reservedCacheNodes);

        /**
         * <p>
         * A list of reserved cache nodes. Each element in the list contains detailed information about one node.
         * </p>
         * 
         * @param reservedCacheNodes
         *        A list of reserved cache nodes. Each element in the list contains detailed information about one node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedCacheNodes(ReservedCacheNode... reservedCacheNodes);

        /**
         * <p>
         * A list of reserved cache nodes. Each element in the list contains detailed information about one node.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ReservedCacheNode>.Builder} avoiding the
         * need to create one manually via {@link List<ReservedCacheNode>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ReservedCacheNode>.Builder#build()} is called immediately
         * and its result is passed to {@link #reservedCacheNodes(List<ReservedCacheNode>)}.
         * 
         * @param reservedCacheNodes
         *        a consumer that will call methods on {@link List<ReservedCacheNode>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reservedCacheNodes(List<ReservedCacheNode>)
         */
        Builder reservedCacheNodes(Consumer<ReservedCacheNode.Builder>... reservedCacheNodes);
    }

    static final class BuilderImpl extends ElastiCacheResponse.BuilderImpl implements Builder {
        private String marker;

        private List<ReservedCacheNode> reservedCacheNodes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedCacheNodesResponse model) {
            super(model);
            marker(model.marker);
            reservedCacheNodes(model.reservedCacheNodes);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<ReservedCacheNode.Builder> getReservedCacheNodes() {
            return reservedCacheNodes != null ? reservedCacheNodes.stream().map(ReservedCacheNode::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder reservedCacheNodes(Collection<ReservedCacheNode> reservedCacheNodes) {
            this.reservedCacheNodes = ReservedCacheNodeListCopier.copy(reservedCacheNodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedCacheNodes(ReservedCacheNode... reservedCacheNodes) {
            reservedCacheNodes(Arrays.asList(reservedCacheNodes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedCacheNodes(Consumer<ReservedCacheNode.Builder>... reservedCacheNodes) {
            reservedCacheNodes(Stream.of(reservedCacheNodes).map(c -> ReservedCacheNode.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setReservedCacheNodes(Collection<ReservedCacheNode.BuilderImpl> reservedCacheNodes) {
            this.reservedCacheNodes = ReservedCacheNodeListCopier.copyFromBuilder(reservedCacheNodes);
        }

        @Override
        public DescribeReservedCacheNodesResponse build() {
            return new DescribeReservedCacheNodesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
