/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>DescribeCacheSubnetGroups</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeCacheSubnetGroupsResponse extends ElastiCacheResponse implements
        ToCopyableBuilder<DescribeCacheSubnetGroupsResponse.Builder, DescribeCacheSubnetGroupsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeCacheSubnetGroupsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<List<CacheSubnetGroup>> CACHE_SUBNET_GROUPS_FIELD = SdkField
            .<List<CacheSubnetGroup>> builder(MarshallingType.LIST)
            .getter(getter(DescribeCacheSubnetGroupsResponse::cacheSubnetGroups))
            .setter(setter(Builder::cacheSubnetGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheSubnetGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("CacheSubnetGroup")
                            .memberFieldInfo(
                                    SdkField.<CacheSubnetGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(CacheSubnetGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("CacheSubnetGroup").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD,
            CACHE_SUBNET_GROUPS_FIELD));

    private final String marker;

    private final List<CacheSubnetGroup> cacheSubnetGroups;

    private DescribeCacheSubnetGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.cacheSubnetGroups = builder.cacheSubnetGroups;
    }

    /**
     * <p>
     * Provides an identifier to allow retrieval of paginated results.
     * </p>
     * 
     * @return Provides an identifier to allow retrieval of paginated results.
     */
    public String marker() {
        return marker;
    }

    /**
     * Returns true if the CacheSubnetGroups property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasCacheSubnetGroups() {
        return cacheSubnetGroups != null && !(cacheSubnetGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of cache subnet groups. Each element in the list contains detailed information about one group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCacheSubnetGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of cache subnet groups. Each element in the list contains detailed information about one group.
     */
    public List<CacheSubnetGroup> cacheSubnetGroups() {
        return cacheSubnetGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(cacheSubnetGroups());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCacheSubnetGroupsResponse)) {
            return false;
        }
        DescribeCacheSubnetGroupsResponse other = (DescribeCacheSubnetGroupsResponse) obj;
        return Objects.equals(marker(), other.marker()) && Objects.equals(cacheSubnetGroups(), other.cacheSubnetGroups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeCacheSubnetGroupsResponse").add("Marker", marker())
                .add("CacheSubnetGroups", cacheSubnetGroups()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "CacheSubnetGroups":
            return Optional.ofNullable(clazz.cast(cacheSubnetGroups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCacheSubnetGroupsResponse, T> g) {
        return obj -> g.apply((DescribeCacheSubnetGroupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElastiCacheResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeCacheSubnetGroupsResponse> {
        /**
         * <p>
         * Provides an identifier to allow retrieval of paginated results.
         * </p>
         * 
         * @param marker
         *        Provides an identifier to allow retrieval of paginated results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * A list of cache subnet groups. Each element in the list contains detailed information about one group.
         * </p>
         * 
         * @param cacheSubnetGroups
         *        A list of cache subnet groups. Each element in the list contains detailed information about one group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheSubnetGroups(Collection<CacheSubnetGroup> cacheSubnetGroups);

        /**
         * <p>
         * A list of cache subnet groups. Each element in the list contains detailed information about one group.
         * </p>
         * 
         * @param cacheSubnetGroups
         *        A list of cache subnet groups. Each element in the list contains detailed information about one group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheSubnetGroups(CacheSubnetGroup... cacheSubnetGroups);

        /**
         * <p>
         * A list of cache subnet groups. Each element in the list contains detailed information about one group.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CacheSubnetGroup>.Builder} avoiding the
         * need to create one manually via {@link List<CacheSubnetGroup>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CacheSubnetGroup>.Builder#build()} is called immediately and
         * its result is passed to {@link #cacheSubnetGroups(List<CacheSubnetGroup>)}.
         * 
         * @param cacheSubnetGroups
         *        a consumer that will call methods on {@link List<CacheSubnetGroup>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cacheSubnetGroups(List<CacheSubnetGroup>)
         */
        Builder cacheSubnetGroups(Consumer<CacheSubnetGroup.Builder>... cacheSubnetGroups);
    }

    static final class BuilderImpl extends ElastiCacheResponse.BuilderImpl implements Builder {
        private String marker;

        private List<CacheSubnetGroup> cacheSubnetGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCacheSubnetGroupsResponse model) {
            super(model);
            marker(model.marker);
            cacheSubnetGroups(model.cacheSubnetGroups);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<CacheSubnetGroup.Builder> getCacheSubnetGroups() {
            return cacheSubnetGroups != null ? cacheSubnetGroups.stream().map(CacheSubnetGroup::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder cacheSubnetGroups(Collection<CacheSubnetGroup> cacheSubnetGroups) {
            this.cacheSubnetGroups = CacheSubnetGroupsCopier.copy(cacheSubnetGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheSubnetGroups(CacheSubnetGroup... cacheSubnetGroups) {
            cacheSubnetGroups(Arrays.asList(cacheSubnetGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheSubnetGroups(Consumer<CacheSubnetGroup.Builder>... cacheSubnetGroups) {
            cacheSubnetGroups(Stream.of(cacheSubnetGroups).map(c -> CacheSubnetGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setCacheSubnetGroups(Collection<CacheSubnetGroup.BuilderImpl> cacheSubnetGroups) {
            this.cacheSubnetGroups = CacheSubnetGroupsCopier.copyFromBuilder(cacheSubnetGroups);
        }

        @Override
        public DescribeCacheSubnetGroupsResponse build() {
            return new DescribeCacheSubnetGroupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
