/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a <code>CreateReplicationGroup</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateReplicationGroupRequest extends ElastiCacheRequest implements
        ToCopyableBuilder<CreateReplicationGroupRequest.Builder, CreateReplicationGroupRequest> {
    private static final SdkField<String> REPLICATION_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateReplicationGroupRequest::replicationGroupId)).setter(setter(Builder::replicationGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationGroupId").build())
            .build();

    private static final SdkField<String> REPLICATION_GROUP_DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateReplicationGroupRequest::replicationGroupDescription))
            .setter(setter(Builder::replicationGroupDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationGroupDescription")
                    .build()).build();

    private static final SdkField<String> PRIMARY_CLUSTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateReplicationGroupRequest::primaryClusterId)).setter(setter(Builder::primaryClusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryClusterId").build()).build();

    private static final SdkField<Boolean> AUTOMATIC_FAILOVER_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CreateReplicationGroupRequest::automaticFailoverEnabled))
            .setter(setter(Builder::automaticFailoverEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomaticFailoverEnabled").build())
            .build();

    private static final SdkField<Integer> NUM_CACHE_CLUSTERS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(CreateReplicationGroupRequest::numCacheClusters)).setter(setter(Builder::numCacheClusters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumCacheClusters").build()).build();

    private static final SdkField<List<String>> PREFERRED_CACHE_CLUSTER_A_ZS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CreateReplicationGroupRequest::preferredCacheClusterAZs))
            .setter(setter(Builder::preferredCacheClusterAZs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredCacheClusterAZs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("AvailabilityZone")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("AvailabilityZone").build()).build()).build()).build();

    private static final SdkField<Integer> NUM_NODE_GROUPS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(CreateReplicationGroupRequest::numNodeGroups)).setter(setter(Builder::numNodeGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumNodeGroups").build()).build();

    private static final SdkField<Integer> REPLICAS_PER_NODE_GROUP_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(CreateReplicationGroupRequest::replicasPerNodeGroup)).setter(setter(Builder::replicasPerNodeGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicasPerNodeGroup").build())
            .build();

    private static final SdkField<List<NodeGroupConfiguration>> NODE_GROUP_CONFIGURATION_FIELD = SdkField
            .<List<NodeGroupConfiguration>> builder(MarshallingType.LIST)
            .getter(getter(CreateReplicationGroupRequest::nodeGroupConfiguration))
            .setter(setter(Builder::nodeGroupConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeGroupConfiguration").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("NodeGroupConfiguration")
                            .memberFieldInfo(
                                    SdkField.<NodeGroupConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(NodeGroupConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("NodeGroupConfiguration").build()).build()).build()).build();

    private static final SdkField<String> CACHE_NODE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateReplicationGroupRequest::cacheNodeType)).setter(setter(Builder::cacheNodeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheNodeType").build()).build();

    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateReplicationGroupRequest::engine)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateReplicationGroupRequest::engineVersion)).setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<String> CACHE_PARAMETER_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateReplicationGroupRequest::cacheParameterGroupName))
            .setter(setter(Builder::cacheParameterGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheParameterGroupName").build())
            .build();

    private static final SdkField<String> CACHE_SUBNET_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateReplicationGroupRequest::cacheSubnetGroupName)).setter(setter(Builder::cacheSubnetGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheSubnetGroupName").build())
            .build();

    private static final SdkField<List<String>> CACHE_SECURITY_GROUP_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CreateReplicationGroupRequest::cacheSecurityGroupNames))
            .setter(setter(Builder::cacheSecurityGroupNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheSecurityGroupNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("CacheSecurityGroupName")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("CacheSecurityGroupName").build()).build()).build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CreateReplicationGroupRequest::securityGroupIds))
            .setter(setter(Builder::securityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("SecurityGroupId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("SecurityGroupId").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(CreateReplicationGroupRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Tag")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Tag").build()).build()).build()).build();

    private static final SdkField<List<String>> SNAPSHOT_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CreateReplicationGroupRequest::snapshotArns))
            .setter(setter(Builder::snapshotArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("SnapshotArn")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("SnapshotArn").build()).build()).build()).build();

    private static final SdkField<String> SNAPSHOT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateReplicationGroupRequest::snapshotName)).setter(setter(Builder::snapshotName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotName").build()).build();

    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateReplicationGroupRequest::preferredMaintenanceWindow))
            .setter(setter(Builder::preferredMaintenanceWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMaintenanceWindow").build())
            .build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(CreateReplicationGroupRequest::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()).build();

    private static final SdkField<String> NOTIFICATION_TOPIC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateReplicationGroupRequest::notificationTopicArn)).setter(setter(Builder::notificationTopicArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationTopicArn").build())
            .build();

    private static final SdkField<Boolean> AUTO_MINOR_VERSION_UPGRADE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CreateReplicationGroupRequest::autoMinorVersionUpgrade))
            .setter(setter(Builder::autoMinorVersionUpgrade))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMinorVersionUpgrade").build())
            .build();

    private static final SdkField<Integer> SNAPSHOT_RETENTION_LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(CreateReplicationGroupRequest::snapshotRetentionLimit))
            .setter(setter(Builder::snapshotRetentionLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotRetentionLimit").build())
            .build();

    private static final SdkField<String> SNAPSHOT_WINDOW_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateReplicationGroupRequest::snapshotWindow)).setter(setter(Builder::snapshotWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotWindow").build()).build();

    private static final SdkField<String> AUTH_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateReplicationGroupRequest::authToken)).setter(setter(Builder::authToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthToken").build()).build();

    private static final SdkField<Boolean> TRANSIT_ENCRYPTION_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CreateReplicationGroupRequest::transitEncryptionEnabled))
            .setter(setter(Builder::transitEncryptionEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitEncryptionEnabled").build())
            .build();

    private static final SdkField<Boolean> AT_REST_ENCRYPTION_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CreateReplicationGroupRequest::atRestEncryptionEnabled))
            .setter(setter(Builder::atRestEncryptionEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AtRestEncryptionEnabled").build())
            .build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateReplicationGroupRequest::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_GROUP_ID_FIELD,
            REPLICATION_GROUP_DESCRIPTION_FIELD, PRIMARY_CLUSTER_ID_FIELD, AUTOMATIC_FAILOVER_ENABLED_FIELD,
            NUM_CACHE_CLUSTERS_FIELD, PREFERRED_CACHE_CLUSTER_A_ZS_FIELD, NUM_NODE_GROUPS_FIELD, REPLICAS_PER_NODE_GROUP_FIELD,
            NODE_GROUP_CONFIGURATION_FIELD, CACHE_NODE_TYPE_FIELD, ENGINE_FIELD, ENGINE_VERSION_FIELD,
            CACHE_PARAMETER_GROUP_NAME_FIELD, CACHE_SUBNET_GROUP_NAME_FIELD, CACHE_SECURITY_GROUP_NAMES_FIELD,
            SECURITY_GROUP_IDS_FIELD, TAGS_FIELD, SNAPSHOT_ARNS_FIELD, SNAPSHOT_NAME_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD,
            PORT_FIELD, NOTIFICATION_TOPIC_ARN_FIELD, AUTO_MINOR_VERSION_UPGRADE_FIELD, SNAPSHOT_RETENTION_LIMIT_FIELD,
            SNAPSHOT_WINDOW_FIELD, AUTH_TOKEN_FIELD, TRANSIT_ENCRYPTION_ENABLED_FIELD, AT_REST_ENCRYPTION_ENABLED_FIELD,
            KMS_KEY_ID_FIELD));

    private final String replicationGroupId;

    private final String replicationGroupDescription;

    private final String primaryClusterId;

    private final Boolean automaticFailoverEnabled;

    private final Integer numCacheClusters;

    private final List<String> preferredCacheClusterAZs;

    private final Integer numNodeGroups;

    private final Integer replicasPerNodeGroup;

    private final List<NodeGroupConfiguration> nodeGroupConfiguration;

    private final String cacheNodeType;

    private final String engine;

    private final String engineVersion;

    private final String cacheParameterGroupName;

    private final String cacheSubnetGroupName;

    private final List<String> cacheSecurityGroupNames;

    private final List<String> securityGroupIds;

    private final List<Tag> tags;

    private final List<String> snapshotArns;

    private final String snapshotName;

    private final String preferredMaintenanceWindow;

    private final Integer port;

    private final String notificationTopicArn;

    private final Boolean autoMinorVersionUpgrade;

    private final Integer snapshotRetentionLimit;

    private final String snapshotWindow;

    private final String authToken;

    private final Boolean transitEncryptionEnabled;

    private final Boolean atRestEncryptionEnabled;

    private final String kmsKeyId;

    private CreateReplicationGroupRequest(BuilderImpl builder) {
        super(builder);
        this.replicationGroupId = builder.replicationGroupId;
        this.replicationGroupDescription = builder.replicationGroupDescription;
        this.primaryClusterId = builder.primaryClusterId;
        this.automaticFailoverEnabled = builder.automaticFailoverEnabled;
        this.numCacheClusters = builder.numCacheClusters;
        this.preferredCacheClusterAZs = builder.preferredCacheClusterAZs;
        this.numNodeGroups = builder.numNodeGroups;
        this.replicasPerNodeGroup = builder.replicasPerNodeGroup;
        this.nodeGroupConfiguration = builder.nodeGroupConfiguration;
        this.cacheNodeType = builder.cacheNodeType;
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.cacheParameterGroupName = builder.cacheParameterGroupName;
        this.cacheSubnetGroupName = builder.cacheSubnetGroupName;
        this.cacheSecurityGroupNames = builder.cacheSecurityGroupNames;
        this.securityGroupIds = builder.securityGroupIds;
        this.tags = builder.tags;
        this.snapshotArns = builder.snapshotArns;
        this.snapshotName = builder.snapshotName;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.port = builder.port;
        this.notificationTopicArn = builder.notificationTopicArn;
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.snapshotRetentionLimit = builder.snapshotRetentionLimit;
        this.snapshotWindow = builder.snapshotWindow;
        this.authToken = builder.authToken;
        this.transitEncryptionEnabled = builder.transitEncryptionEnabled;
        this.atRestEncryptionEnabled = builder.atRestEncryptionEnabled;
        this.kmsKeyId = builder.kmsKeyId;
    }

    /**
     * <p>
     * The replication group identifier. This parameter is stored as a lowercase string.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A name must contain from 1 to 40 alphanumeric characters or hyphens.
     * </p>
     * </li>
     * <li>
     * <p>
     * The first character must be a letter.
     * </p>
     * </li>
     * <li>
     * <p>
     * A name cannot end with a hyphen or contain two consecutive hyphens.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The replication group identifier. This parameter is stored as a lowercase string.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A name must contain from 1 to 40 alphanumeric characters or hyphens.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The first character must be a letter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A name cannot end with a hyphen or contain two consecutive hyphens.
     *         </p>
     *         </li>
     */
    public String replicationGroupId() {
        return replicationGroupId;
    }

    /**
     * <p>
     * A user-created description for the replication group.
     * </p>
     * 
     * @return A user-created description for the replication group.
     */
    public String replicationGroupDescription() {
        return replicationGroupDescription;
    }

    /**
     * <p>
     * The identifier of the cluster that serves as the primary for this replication group. This cluster must already
     * exist and have a status of <code>available</code>.
     * </p>
     * <p>
     * This parameter is not required if <code>NumCacheClusters</code>, <code>NumNodeGroups</code>, or
     * <code>ReplicasPerNodeGroup</code> is specified.
     * </p>
     * 
     * @return The identifier of the cluster that serves as the primary for this replication group. This cluster must
     *         already exist and have a status of <code>available</code>.</p>
     *         <p>
     *         This parameter is not required if <code>NumCacheClusters</code>, <code>NumNodeGroups</code>, or
     *         <code>ReplicasPerNodeGroup</code> is specified.
     */
    public String primaryClusterId() {
        return primaryClusterId;
    }

    /**
     * <p>
     * Specifies whether a read-only replica is automatically promoted to read/write primary if the existing primary
     * fails.
     * </p>
     * <p>
     * If <code>true</code>, Multi-AZ is enabled for this replication group. If <code>false</code>, Multi-AZ is disabled
     * for this replication group.
     * </p>
     * <p>
     * <code>AutomaticFailoverEnabled</code> must be enabled for Redis (cluster mode enabled) replication groups.
     * </p>
     * <p>
     * Default: false
     * </p>
     * <p>
     * Amazon ElastiCache for Redis does not support Multi-AZ with automatic failover on:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Redis versions earlier than 2.8.6.
     * </p>
     * </li>
     * <li>
     * <p>
     * Redis (cluster mode disabled): T1 node types.
     * </p>
     * </li>
     * <li>
     * <p>
     * Redis (cluster mode enabled): T1 node types.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Specifies whether a read-only replica is automatically promoted to read/write primary if the existing
     *         primary fails.</p>
     *         <p>
     *         If <code>true</code>, Multi-AZ is enabled for this replication group. If <code>false</code>, Multi-AZ is
     *         disabled for this replication group.
     *         </p>
     *         <p>
     *         <code>AutomaticFailoverEnabled</code> must be enabled for Redis (cluster mode enabled) replication
     *         groups.
     *         </p>
     *         <p>
     *         Default: false
     *         </p>
     *         <p>
     *         Amazon ElastiCache for Redis does not support Multi-AZ with automatic failover on:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Redis versions earlier than 2.8.6.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Redis (cluster mode disabled): T1 node types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Redis (cluster mode enabled): T1 node types.
     *         </p>
     *         </li>
     */
    public Boolean automaticFailoverEnabled() {
        return automaticFailoverEnabled;
    }

    /**
     * <p>
     * The number of clusters this replication group initially has.
     * </p>
     * <p>
     * This parameter is not used if there is more than one node group (shard). You should use
     * <code>ReplicasPerNodeGroup</code> instead.
     * </p>
     * <p>
     * If <code>AutomaticFailoverEnabled</code> is <code>true</code>, the value of this parameter must be at least 2. If
     * <code>AutomaticFailoverEnabled</code> is <code>false</code> you can omit this parameter (it will default to 1),
     * or you can explicitly set it to a value between 2 and 6.
     * </p>
     * <p>
     * The maximum permitted value for <code>NumCacheClusters</code> is 6 (1 primary plus 5 replicas).
     * </p>
     * 
     * @return The number of clusters this replication group initially has.</p>
     *         <p>
     *         This parameter is not used if there is more than one node group (shard). You should use
     *         <code>ReplicasPerNodeGroup</code> instead.
     *         </p>
     *         <p>
     *         If <code>AutomaticFailoverEnabled</code> is <code>true</code>, the value of this parameter must be at
     *         least 2. If <code>AutomaticFailoverEnabled</code> is <code>false</code> you can omit this parameter (it
     *         will default to 1), or you can explicitly set it to a value between 2 and 6.
     *         </p>
     *         <p>
     *         The maximum permitted value for <code>NumCacheClusters</code> is 6 (1 primary plus 5 replicas).
     */
    public Integer numCacheClusters() {
        return numCacheClusters;
    }

    /**
     * Returns true if the PreferredCacheClusterAZs property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasPreferredCacheClusterAZs() {
        return preferredCacheClusterAZs != null && !(preferredCacheClusterAZs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of EC2 Availability Zones in which the replication group's clusters are created. The order of the
     * Availability Zones in the list is the order in which clusters are allocated. The primary cluster is created in
     * the first AZ in the list.
     * </p>
     * <p>
     * This parameter is not used if there is more than one node group (shard). You should use
     * <code>NodeGroupConfiguration</code> instead.
     * </p>
     * <note>
     * <p>
     * If you are creating your replication group in an Amazon VPC (recommended), you can only locate clusters in
     * Availability Zones associated with the subnets in the selected subnet group.
     * </p>
     * <p>
     * The number of Availability Zones listed must equal the value of <code>NumCacheClusters</code>.
     * </p>
     * </note>
     * <p>
     * Default: system chosen Availability Zones.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPreferredCacheClusterAZs()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of EC2 Availability Zones in which the replication group's clusters are created. The order of the
     *         Availability Zones in the list is the order in which clusters are allocated. The primary cluster is
     *         created in the first AZ in the list.</p>
     *         <p>
     *         This parameter is not used if there is more than one node group (shard). You should use
     *         <code>NodeGroupConfiguration</code> instead.
     *         </p>
     *         <note>
     *         <p>
     *         If you are creating your replication group in an Amazon VPC (recommended), you can only locate clusters
     *         in Availability Zones associated with the subnets in the selected subnet group.
     *         </p>
     *         <p>
     *         The number of Availability Zones listed must equal the value of <code>NumCacheClusters</code>.
     *         </p>
     *         </note>
     *         <p>
     *         Default: system chosen Availability Zones.
     */
    public List<String> preferredCacheClusterAZs() {
        return preferredCacheClusterAZs;
    }

    /**
     * <p>
     * An optional parameter that specifies the number of node groups (shards) for this Redis (cluster mode enabled)
     * replication group. For Redis (cluster mode disabled) either omit this parameter or set it to 1.
     * </p>
     * <p>
     * Default: 1
     * </p>
     * 
     * @return An optional parameter that specifies the number of node groups (shards) for this Redis (cluster mode
     *         enabled) replication group. For Redis (cluster mode disabled) either omit this parameter or set it to
     *         1.</p>
     *         <p>
     *         Default: 1
     */
    public Integer numNodeGroups() {
        return numNodeGroups;
    }

    /**
     * <p>
     * An optional parameter that specifies the number of replica nodes in each node group (shard). Valid values are 0
     * to 5.
     * </p>
     * 
     * @return An optional parameter that specifies the number of replica nodes in each node group (shard). Valid values
     *         are 0 to 5.
     */
    public Integer replicasPerNodeGroup() {
        return replicasPerNodeGroup;
    }

    /**
     * Returns true if the NodeGroupConfiguration property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasNodeGroupConfiguration() {
        return nodeGroupConfiguration != null && !(nodeGroupConfiguration instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of node group (shard) configuration options. Each node group (shard) configuration has the following
     * members: <code>PrimaryAvailabilityZone</code>, <code>ReplicaAvailabilityZones</code>, <code>ReplicaCount</code>,
     * and <code>Slots</code>.
     * </p>
     * <p>
     * If you're creating a Redis (cluster mode disabled) or a Redis (cluster mode enabled) replication group, you can
     * use this parameter to individually configure each node group (shard), or you can omit this parameter. However,
     * when seeding a Redis (cluster mode enabled) cluster from a S3 rdb file, you must configure each node group
     * (shard) using this parameter because you must specify the slots for each node group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasNodeGroupConfiguration()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of node group (shard) configuration options. Each node group (shard) configuration has the
     *         following members: <code>PrimaryAvailabilityZone</code>, <code>ReplicaAvailabilityZones</code>,
     *         <code>ReplicaCount</code>, and <code>Slots</code>.</p>
     *         <p>
     *         If you're creating a Redis (cluster mode disabled) or a Redis (cluster mode enabled) replication group,
     *         you can use this parameter to individually configure each node group (shard), or you can omit this
     *         parameter. However, when seeding a Redis (cluster mode enabled) cluster from a S3 rdb file, you must
     *         configure each node group (shard) using this parameter because you must specify the slots for each node
     *         group.
     */
    public List<NodeGroupConfiguration> nodeGroupConfiguration() {
        return nodeGroupConfiguration;
    }

    /**
     * <p>
     * The compute and memory capacity of the nodes in the node group (shard).
     * </p>
     * <p>
     * The following node types are supported by ElastiCache. Generally speaking, the current generation types provide
     * more memory and computational power at lower cost when compared to their equivalent previous generation
     * counterparts.
     * </p>
     * <ul>
     * <li>
     * <p>
     * General purpose:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Current generation:
     * </p>
     * <p>
     * <b>M5 node types:</b> <code>cache.m5.large</code>, <code>cache.m5.xlarge</code>, <code>cache.m5.2xlarge</code>,
     * <code>cache.m5.4xlarge</code>, <code>cache.m5.12xlarge</code>, <code>cache.m5.24xlarge</code>
     * </p>
     * <p>
     * <b>M4 node types:</b> <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>, <code>cache.m4.2xlarge</code>,
     * <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code>
     * </p>
     * <p>
     * <b>T2 node types:</b> <code>cache.t2.micro</code>, <code>cache.t2.small</code>, <code>cache.t2.medium</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Previous generation: (not recommended)
     * </p>
     * <p>
     * <b>T1 node types:</b> <code>cache.t1.micro</code>
     * </p>
     * <p>
     * <b>M1 node types:</b> <code>cache.m1.small</code>, <code>cache.m1.medium</code>, <code>cache.m1.large</code>,
     * <code>cache.m1.xlarge</code>
     * </p>
     * <p>
     * <b>M3 node types:</b> <code>cache.m3.medium</code>, <code>cache.m3.large</code>, <code>cache.m3.xlarge</code>,
     * <code>cache.m3.2xlarge</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Compute optimized:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Previous generation: (not recommended)
     * </p>
     * <p>
     * <b>C1 node types:</b> <code>cache.c1.xlarge</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Memory optimized:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Current generation:
     * </p>
     * <p>
     * <b>R5 node types:</b> <code>cache.r5.large</code>, <code>cache.r5.xlarge</code>, <code>cache.r5.2xlarge</code>,
     * <code>cache.r5.4xlarge</code>, <code>cache.r5.12xlarge</code>, <code>cache.r5.24xlarge</code>
     * </p>
     * <p>
     * <b>R4 node types:</b> <code>cache.r4.large</code>, <code>cache.r4.xlarge</code>, <code>cache.r4.2xlarge</code>,
     * <code>cache.r4.4xlarge</code>, <code>cache.r4.8xlarge</code>, <code>cache.r4.16xlarge</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Previous generation: (not recommended)
     * </p>
     * <p>
     * <b>M2 node types:</b> <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>, <code>cache.m2.4xlarge</code>
     * </p>
     * <p>
     * <b>R3 node types:</b> <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>, <code>cache.r3.2xlarge</code>,
     * <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * <b>Additional node type info</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * All current generation instance types are created in Amazon VPC by default.
     * </p>
     * </li>
     * <li>
     * <p>
     * Redis append-only files (AOF) are not supported for T1 or T2 instances.
     * </p>
     * </li>
     * <li>
     * <p>
     * Redis Multi-AZ with automatic failover is not supported on T1 instances.
     * </p>
     * </li>
     * <li>
     * <p>
     * Redis configuration variables <code>appendonly</code> and <code>appendfsync</code> are not supported on Redis
     * version 2.8.22 and later.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The compute and memory capacity of the nodes in the node group (shard).</p>
     *         <p>
     *         The following node types are supported by ElastiCache. Generally speaking, the current generation types
     *         provide more memory and computational power at lower cost when compared to their equivalent previous
     *         generation counterparts.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         General purpose:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Current generation:
     *         </p>
     *         <p>
     *         <b>M5 node types:</b> <code>cache.m5.large</code>, <code>cache.m5.xlarge</code>,
     *         <code>cache.m5.2xlarge</code>, <code>cache.m5.4xlarge</code>, <code>cache.m5.12xlarge</code>,
     *         <code>cache.m5.24xlarge</code>
     *         </p>
     *         <p>
     *         <b>M4 node types:</b> <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>,
     *         <code>cache.m4.2xlarge</code>, <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code>
     *         </p>
     *         <p>
     *         <b>T2 node types:</b> <code>cache.t2.micro</code>, <code>cache.t2.small</code>,
     *         <code>cache.t2.medium</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Previous generation: (not recommended)
     *         </p>
     *         <p>
     *         <b>T1 node types:</b> <code>cache.t1.micro</code>
     *         </p>
     *         <p>
     *         <b>M1 node types:</b> <code>cache.m1.small</code>, <code>cache.m1.medium</code>,
     *         <code>cache.m1.large</code>, <code>cache.m1.xlarge</code>
     *         </p>
     *         <p>
     *         <b>M3 node types:</b> <code>cache.m3.medium</code>, <code>cache.m3.large</code>,
     *         <code>cache.m3.xlarge</code>, <code>cache.m3.2xlarge</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Compute optimized:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Previous generation: (not recommended)
     *         </p>
     *         <p>
     *         <b>C1 node types:</b> <code>cache.c1.xlarge</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Memory optimized:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Current generation:
     *         </p>
     *         <p>
     *         <b>R5 node types:</b> <code>cache.r5.large</code>, <code>cache.r5.xlarge</code>,
     *         <code>cache.r5.2xlarge</code>, <code>cache.r5.4xlarge</code>, <code>cache.r5.12xlarge</code>,
     *         <code>cache.r5.24xlarge</code>
     *         </p>
     *         <p>
     *         <b>R4 node types:</b> <code>cache.r4.large</code>, <code>cache.r4.xlarge</code>,
     *         <code>cache.r4.2xlarge</code>, <code>cache.r4.4xlarge</code>, <code>cache.r4.8xlarge</code>,
     *         <code>cache.r4.16xlarge</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Previous generation: (not recommended)
     *         </p>
     *         <p>
     *         <b>M2 node types:</b> <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>,
     *         <code>cache.m2.4xlarge</code>
     *         </p>
     *         <p>
     *         <b>R3 node types:</b> <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>,
     *         <code>cache.r3.2xlarge</code>, <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>Additional node type info</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         All current generation instance types are created in Amazon VPC by default.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Redis append-only files (AOF) are not supported for T1 or T2 instances.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Redis Multi-AZ with automatic failover is not supported on T1 instances.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Redis configuration variables <code>appendonly</code> and <code>appendfsync</code> are not supported on
     *         Redis version 2.8.22 and later.
     *         </p>
     *         </li>
     */
    public String cacheNodeType() {
        return cacheNodeType;
    }

    /**
     * <p>
     * The name of the cache engine to be used for the clusters in this replication group.
     * </p>
     * 
     * @return The name of the cache engine to be used for the clusters in this replication group.
     */
    public String engine() {
        return engine;
    }

    /**
     * <p>
     * The version number of the cache engine to be used for the clusters in this replication group. To view the
     * supported cache engine versions, use the <code>DescribeCacheEngineVersions</code> operation.
     * </p>
     * <p>
     * <b>Important:</b> You can upgrade to a newer engine version (see <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement">Selecting
     * a Cache Engine and Version</a>) in the <i>ElastiCache User Guide</i>, but you cannot downgrade to an earlier
     * engine version. If you want to use an earlier engine version, you must delete the existing cluster or replication
     * group and create it anew with the earlier engine version.
     * </p>
     * 
     * @return The version number of the cache engine to be used for the clusters in this replication group. To view the
     *         supported cache engine versions, use the <code>DescribeCacheEngineVersions</code> operation.</p>
     *         <p>
     *         <b>Important:</b> You can upgrade to a newer engine version (see <a
     *         href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement"
     *         >Selecting a Cache Engine and Version</a>) in the <i>ElastiCache User Guide</i>, but you cannot downgrade
     *         to an earlier engine version. If you want to use an earlier engine version, you must delete the existing
     *         cluster or replication group and create it anew with the earlier engine version.
     */
    public String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * The name of the parameter group to associate with this replication group. If this argument is omitted, the
     * default cache parameter group for the specified engine is used.
     * </p>
     * <note>
     * <p>
     * If you are restoring to an engine version that is different than the original, you must specify the default
     * version of that version. For example, <code>CacheParameterGroupName=default.redis4.0</code>.
     * </p>
     * </note>
     * <p>
     * If you are running Redis version 3.2.4 or later, only one node group (shard), and want to use a default parameter
     * group, we recommend that you specify the parameter group by name.
     * </p>
     * <ul>
     * <li>
     * <p>
     * To create a Redis (cluster mode disabled) replication group, use
     * <code>CacheParameterGroupName=default.redis3.2</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * To create a Redis (cluster mode enabled) replication group, use
     * <code>CacheParameterGroupName=default.redis3.2.cluster.on</code>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the parameter group to associate with this replication group. If this argument is omitted,
     *         the default cache parameter group for the specified engine is used.</p> <note>
     *         <p>
     *         If you are restoring to an engine version that is different than the original, you must specify the
     *         default version of that version. For example, <code>CacheParameterGroupName=default.redis4.0</code>.
     *         </p>
     *         </note>
     *         <p>
     *         If you are running Redis version 3.2.4 or later, only one node group (shard), and want to use a default
     *         parameter group, we recommend that you specify the parameter group by name.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         To create a Redis (cluster mode disabled) replication group, use
     *         <code>CacheParameterGroupName=default.redis3.2</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To create a Redis (cluster mode enabled) replication group, use
     *         <code>CacheParameterGroupName=default.redis3.2.cluster.on</code>.
     *         </p>
     *         </li>
     */
    public String cacheParameterGroupName() {
        return cacheParameterGroupName;
    }

    /**
     * <p>
     * The name of the cache subnet group to be used for the replication group.
     * </p>
     * <important>
     * <p>
     * If you're going to launch your cluster in an Amazon VPC, you need to create a subnet group before you start
     * creating a cluster. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SubnetGroups.html">Subnets and Subnet
     * Groups</a>.
     * </p>
     * </important>
     * 
     * @return The name of the cache subnet group to be used for the replication group.</p> <important>
     *         <p>
     *         If you're going to launch your cluster in an Amazon VPC, you need to create a subnet group before you
     *         start creating a cluster. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SubnetGroups.html">Subnets and Subnet
     *         Groups</a>.
     *         </p>
     */
    public String cacheSubnetGroupName() {
        return cacheSubnetGroupName;
    }

    /**
     * Returns true if the CacheSecurityGroupNames property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasCacheSecurityGroupNames() {
        return cacheSecurityGroupNames != null && !(cacheSecurityGroupNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of cache security group names to associate with this replication group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCacheSecurityGroupNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of cache security group names to associate with this replication group.
     */
    public List<String> cacheSecurityGroupNames() {
        return cacheSecurityGroupNames;
    }

    /**
     * Returns true if the SecurityGroupIds property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasSecurityGroupIds() {
        return securityGroupIds != null && !(securityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more Amazon VPC security groups associated with this replication group.
     * </p>
     * <p>
     * Use this parameter only when you are creating a replication group in an Amazon Virtual Private Cloud (Amazon
     * VPC).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSecurityGroupIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more Amazon VPC security groups associated with this replication group.</p>
     *         <p>
     *         Use this parameter only when you are creating a replication group in an Amazon Virtual Private Cloud
     *         (Amazon VPC).
     */
    public List<String> securityGroupIds() {
        return securityGroupIds;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of cost allocation tags to be added to this resource. Tags are comma-separated key,value pairs (e.g. Key=
     * <code>myKey</code>, Value=<code>myKeyValue</code>. You can include multiple tags as shown following: Key=
     * <code>myKey</code>, Value=<code>myKeyValue</code> Key=<code>mySecondKey</code>, Value=
     * <code>mySecondKeyValue</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of cost allocation tags to be added to this resource. Tags are comma-separated key,value pairs
     *         (e.g. Key=<code>myKey</code>, Value=<code>myKeyValue</code>. You can include multiple tags as shown
     *         following: Key=<code>myKey</code>, Value=<code>myKeyValue</code> Key=<code>mySecondKey</code>, Value=
     *         <code>mySecondKeyValue</code>.
     */
    public List<Tag> tags() {
        return tags;
    }

    /**
     * Returns true if the SnapshotArns property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSnapshotArns() {
        return snapshotArns != null && !(snapshotArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Amazon Resource Names (ARN) that uniquely identify the Redis RDB snapshot files stored in Amazon S3.
     * The snapshot files are used to populate the new replication group. The Amazon S3 object name in the ARN cannot
     * contain any commas. The new replication group will have the number of node groups (console: shards) specified by
     * the parameter <i>NumNodeGroups</i> or the number of node groups configured by <i>NodeGroupConfiguration</i>
     * regardless of the number of ARNs specified here.
     * </p>
     * <p>
     * Example of an Amazon S3 ARN: <code>arn:aws:s3:::my_bucket/snapshot1.rdb</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSnapshotArns()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of Amazon Resource Names (ARN) that uniquely identify the Redis RDB snapshot files stored in
     *         Amazon S3. The snapshot files are used to populate the new replication group. The Amazon S3 object name
     *         in the ARN cannot contain any commas. The new replication group will have the number of node groups
     *         (console: shards) specified by the parameter <i>NumNodeGroups</i> or the number of node groups configured
     *         by <i>NodeGroupConfiguration</i> regardless of the number of ARNs specified here.</p>
     *         <p>
     *         Example of an Amazon S3 ARN: <code>arn:aws:s3:::my_bucket/snapshot1.rdb</code>
     */
    public List<String> snapshotArns() {
        return snapshotArns;
    }

    /**
     * <p>
     * The name of a snapshot from which to restore data into the new replication group. The snapshot status changes to
     * <code>restoring</code> while the new replication group is being created.
     * </p>
     * 
     * @return The name of a snapshot from which to restore data into the new replication group. The snapshot status
     *         changes to <code>restoring</code> while the new replication group is being created.
     */
    public String snapshotName() {
        return snapshotName;
    }

    /**
     * <p>
     * Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range
     * in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.
     * Valid values for <code>ddd</code> are:
     * </p>
     * <p>
     * Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range
     * in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.
     * </p>
     * <p>
     * Valid values for <code>ddd</code> are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>sun</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>mon</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tue</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>wed</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>thu</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>fri</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sat</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Example: <code>sun:23:00-mon:01:30</code>
     * </p>
     * 
     * @return Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as
     *         a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60
     *         minute period. Valid values for <code>ddd</code> are:</p>
     *         <p>
     *         Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as
     *         a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60
     *         minute period.
     *         </p>
     *         <p>
     *         Valid values for <code>ddd</code> are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>sun</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>mon</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tue</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>wed</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>thu</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>fri</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sat</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Example: <code>sun:23:00-mon:01:30</code>
     */
    public String preferredMaintenanceWindow() {
        return preferredMaintenanceWindow;
    }

    /**
     * <p>
     * The port number on which each member of the replication group accepts connections.
     * </p>
     * 
     * @return The port number on which each member of the replication group accepts connections.
     */
    public Integer port() {
        return port;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which notifications are
     * sent.
     * </p>
     * <note>
     * <p>
     * The Amazon SNS topic owner must be the same as the cluster owner.
     * </p>
     * </note>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which
     *         notifications are sent.</p> <note>
     *         <p>
     *         The Amazon SNS topic owner must be the same as the cluster owner.
     *         </p>
     */
    public String notificationTopicArn() {
        return notificationTopicArn;
    }

    /**
     * <p>
     * This parameter is currently disabled.
     * </p>
     * 
     * @return This parameter is currently disabled.
     */
    public Boolean autoMinorVersionUpgrade() {
        return autoMinorVersionUpgrade;
    }

    /**
     * <p>
     * The number of days for which ElastiCache retains automatic snapshots before deleting them. For example, if you
     * set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was taken today is retained for 5 days before being
     * deleted.
     * </p>
     * <p>
     * Default: 0 (i.e., automatic backups are disabled for this cluster).
     * </p>
     * 
     * @return The number of days for which ElastiCache retains automatic snapshots before deleting them. For example,
     *         if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was taken today is retained for 5
     *         days before being deleted.</p>
     *         <p>
     *         Default: 0 (i.e., automatic backups are disabled for this cluster).
     */
    public Integer snapshotRetentionLimit() {
        return snapshotRetentionLimit;
    }

    /**
     * <p>
     * The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your node group (shard).
     * </p>
     * <p>
     * Example: <code>05:00-09:00</code>
     * </p>
     * <p>
     * If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.
     * </p>
     * 
     * @return The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your node group
     *         (shard).</p>
     *         <p>
     *         Example: <code>05:00-09:00</code>
     *         </p>
     *         <p>
     *         If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.
     */
    public String snapshotWindow() {
        return snapshotWindow;
    }

    /**
     * <p>
     * <b>Reserved parameter.</b> The password used to access a password protected server.
     * </p>
     * <p>
     * <code>AuthToken</code> can be specified only on replication groups where <code>TransitEncryptionEnabled</code> is
     * <code>true</code>.
     * </p>
     * <important>
     * <p>
     * For HIPAA compliance, you must specify <code>TransitEncryptionEnabled</code> as <code>true</code>, an
     * <code>AuthToken</code>, and a <code>CacheSubnetGroup</code>.
     * </p>
     * </important>
     * <p>
     * Password constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be only printable ASCII characters.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must be at least 16 characters and no more than 128 characters in length.
     * </p>
     * </li>
     * <li>
     * <p>
     * The only permitted printable special characters are !, &amp;, #, $, ^, &lt;, &gt;, and -. Other printable special
     * characters cannot be used in the AUTH token.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a href="http://redis.io/commands/AUTH">AUTH password</a> at
     * http://redis.io/commands/AUTH.
     * </p>
     * 
     * @return <b>Reserved parameter.</b> The password used to access a password protected server.</p>
     *         <p>
     *         <code>AuthToken</code> can be specified only on replication groups where
     *         <code>TransitEncryptionEnabled</code> is <code>true</code>.
     *         </p>
     *         <important>
     *         <p>
     *         For HIPAA compliance, you must specify <code>TransitEncryptionEnabled</code> as <code>true</code>, an
     *         <code>AuthToken</code>, and a <code>CacheSubnetGroup</code>.
     *         </p>
     *         </important>
     *         <p>
     *         Password constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be only printable ASCII characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must be at least 16 characters and no more than 128 characters in length.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The only permitted printable special characters are !, &amp;, #, $, ^, &lt;, &gt;, and -. Other printable
     *         special characters cannot be used in the AUTH token.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a href="http://redis.io/commands/AUTH">AUTH password</a> at
     *         http://redis.io/commands/AUTH.
     */
    public String authToken() {
        return authToken;
    }

    /**
     * <p>
     * A flag that enables in-transit encryption when set to <code>true</code>.
     * </p>
     * <p>
     * You cannot modify the value of <code>TransitEncryptionEnabled</code> after the cluster is created. To enable
     * in-transit encryption on a cluster you must set <code>TransitEncryptionEnabled</code> to <code>true</code> when
     * you create a cluster.
     * </p>
     * <p>
     * This parameter is valid only if the <code>Engine</code> parameter is <code>redis</code>, the
     * <code>EngineVersion</code> parameter is <code>3.2.6</code>, <code>4.x</code> or later, and the cluster is being
     * created in an Amazon VPC.
     * </p>
     * <p>
     * If you enable in-transit encryption, you must also specify a value for <code>CacheSubnetGroup</code>.
     * </p>
     * <p>
     * <b>Required:</b> Only available when creating a replication group in an Amazon VPC using redis version
     * <code>3.2.6</code>, <code>4.x</code> or later.
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     * <important>
     * <p>
     * For HIPAA compliance, you must specify <code>TransitEncryptionEnabled</code> as <code>true</code>, an
     * <code>AuthToken</code>, and a <code>CacheSubnetGroup</code>.
     * </p>
     * </important>
     * 
     * @return A flag that enables in-transit encryption when set to <code>true</code>.</p>
     *         <p>
     *         You cannot modify the value of <code>TransitEncryptionEnabled</code> after the cluster is created. To
     *         enable in-transit encryption on a cluster you must set <code>TransitEncryptionEnabled</code> to
     *         <code>true</code> when you create a cluster.
     *         </p>
     *         <p>
     *         This parameter is valid only if the <code>Engine</code> parameter is <code>redis</code>, the
     *         <code>EngineVersion</code> parameter is <code>3.2.6</code>, <code>4.x</code> or later, and the cluster is
     *         being created in an Amazon VPC.
     *         </p>
     *         <p>
     *         If you enable in-transit encryption, you must also specify a value for <code>CacheSubnetGroup</code>.
     *         </p>
     *         <p>
     *         <b>Required:</b> Only available when creating a replication group in an Amazon VPC using redis version
     *         <code>3.2.6</code>, <code>4.x</code> or later.
     *         </p>
     *         <p>
     *         Default: <code>false</code>
     *         </p>
     *         <important>
     *         <p>
     *         For HIPAA compliance, you must specify <code>TransitEncryptionEnabled</code> as <code>true</code>, an
     *         <code>AuthToken</code>, and a <code>CacheSubnetGroup</code>.
     *         </p>
     */
    public Boolean transitEncryptionEnabled() {
        return transitEncryptionEnabled;
    }

    /**
     * <p>
     * A flag that enables encryption at rest when set to <code>true</code>.
     * </p>
     * <p>
     * You cannot modify the value of <code>AtRestEncryptionEnabled</code> after the replication group is created. To
     * enable encryption at rest on a replication group you must set <code>AtRestEncryptionEnabled</code> to
     * <code>true</code> when you create the replication group.
     * </p>
     * <p>
     * <b>Required:</b> Only available when creating a replication group in an Amazon VPC using redis version
     * <code>3.2.6</code>, <code>4.x</code> or later.
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     * 
     * @return A flag that enables encryption at rest when set to <code>true</code>.</p>
     *         <p>
     *         You cannot modify the value of <code>AtRestEncryptionEnabled</code> after the replication group is
     *         created. To enable encryption at rest on a replication group you must set
     *         <code>AtRestEncryptionEnabled</code> to <code>true</code> when you create the replication group.
     *         </p>
     *         <p>
     *         <b>Required:</b> Only available when creating a replication group in an Amazon VPC using redis version
     *         <code>3.2.6</code>, <code>4.x</code> or later.
     *         </p>
     *         <p>
     *         Default: <code>false</code>
     */
    public Boolean atRestEncryptionEnabled() {
        return atRestEncryptionEnabled;
    }

    /**
     * <p>
     * The ID of the KMS key used to encrypt the disk on the cluster.
     * </p>
     * 
     * @return The ID of the KMS key used to encrypt the disk on the cluster.
     */
    public String kmsKeyId() {
        return kmsKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(replicationGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(replicationGroupDescription());
        hashCode = 31 * hashCode + Objects.hashCode(primaryClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(automaticFailoverEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(numCacheClusters());
        hashCode = 31 * hashCode + Objects.hashCode(preferredCacheClusterAZs());
        hashCode = 31 * hashCode + Objects.hashCode(numNodeGroups());
        hashCode = 31 * hashCode + Objects.hashCode(replicasPerNodeGroup());
        hashCode = 31 * hashCode + Objects.hashCode(nodeGroupConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(cacheNodeType());
        hashCode = 31 * hashCode + Objects.hashCode(engine());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(cacheParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(cacheSubnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(cacheSecurityGroupNames());
        hashCode = 31 * hashCode + Objects.hashCode(securityGroupIds());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotArns());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotName());
        hashCode = 31 * hashCode + Objects.hashCode(preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(notificationTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(autoMinorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotRetentionLimit());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotWindow());
        hashCode = 31 * hashCode + Objects.hashCode(authToken());
        hashCode = 31 * hashCode + Objects.hashCode(transitEncryptionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(atRestEncryptionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateReplicationGroupRequest)) {
            return false;
        }
        CreateReplicationGroupRequest other = (CreateReplicationGroupRequest) obj;
        return Objects.equals(replicationGroupId(), other.replicationGroupId())
                && Objects.equals(replicationGroupDescription(), other.replicationGroupDescription())
                && Objects.equals(primaryClusterId(), other.primaryClusterId())
                && Objects.equals(automaticFailoverEnabled(), other.automaticFailoverEnabled())
                && Objects.equals(numCacheClusters(), other.numCacheClusters())
                && Objects.equals(preferredCacheClusterAZs(), other.preferredCacheClusterAZs())
                && Objects.equals(numNodeGroups(), other.numNodeGroups())
                && Objects.equals(replicasPerNodeGroup(), other.replicasPerNodeGroup())
                && Objects.equals(nodeGroupConfiguration(), other.nodeGroupConfiguration())
                && Objects.equals(cacheNodeType(), other.cacheNodeType()) && Objects.equals(engine(), other.engine())
                && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(cacheParameterGroupName(), other.cacheParameterGroupName())
                && Objects.equals(cacheSubnetGroupName(), other.cacheSubnetGroupName())
                && Objects.equals(cacheSecurityGroupNames(), other.cacheSecurityGroupNames())
                && Objects.equals(securityGroupIds(), other.securityGroupIds()) && Objects.equals(tags(), other.tags())
                && Objects.equals(snapshotArns(), other.snapshotArns()) && Objects.equals(snapshotName(), other.snapshotName())
                && Objects.equals(preferredMaintenanceWindow(), other.preferredMaintenanceWindow())
                && Objects.equals(port(), other.port()) && Objects.equals(notificationTopicArn(), other.notificationTopicArn())
                && Objects.equals(autoMinorVersionUpgrade(), other.autoMinorVersionUpgrade())
                && Objects.equals(snapshotRetentionLimit(), other.snapshotRetentionLimit())
                && Objects.equals(snapshotWindow(), other.snapshotWindow()) && Objects.equals(authToken(), other.authToken())
                && Objects.equals(transitEncryptionEnabled(), other.transitEncryptionEnabled())
                && Objects.equals(atRestEncryptionEnabled(), other.atRestEncryptionEnabled())
                && Objects.equals(kmsKeyId(), other.kmsKeyId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateReplicationGroupRequest").add("ReplicationGroupId", replicationGroupId())
                .add("ReplicationGroupDescription", replicationGroupDescription()).add("PrimaryClusterId", primaryClusterId())
                .add("AutomaticFailoverEnabled", automaticFailoverEnabled()).add("NumCacheClusters", numCacheClusters())
                .add("PreferredCacheClusterAZs", preferredCacheClusterAZs()).add("NumNodeGroups", numNodeGroups())
                .add("ReplicasPerNodeGroup", replicasPerNodeGroup()).add("NodeGroupConfiguration", nodeGroupConfiguration())
                .add("CacheNodeType", cacheNodeType()).add("Engine", engine()).add("EngineVersion", engineVersion())
                .add("CacheParameterGroupName", cacheParameterGroupName()).add("CacheSubnetGroupName", cacheSubnetGroupName())
                .add("CacheSecurityGroupNames", cacheSecurityGroupNames()).add("SecurityGroupIds", securityGroupIds())
                .add("Tags", tags()).add("SnapshotArns", snapshotArns()).add("SnapshotName", snapshotName())
                .add("PreferredMaintenanceWindow", preferredMaintenanceWindow()).add("Port", port())
                .add("NotificationTopicArn", notificationTopicArn()).add("AutoMinorVersionUpgrade", autoMinorVersionUpgrade())
                .add("SnapshotRetentionLimit", snapshotRetentionLimit()).add("SnapshotWindow", snapshotWindow())
                .add("AuthToken", authToken()).add("TransitEncryptionEnabled", transitEncryptionEnabled())
                .add("AtRestEncryptionEnabled", atRestEncryptionEnabled()).add("KmsKeyId", kmsKeyId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReplicationGroupId":
            return Optional.ofNullable(clazz.cast(replicationGroupId()));
        case "ReplicationGroupDescription":
            return Optional.ofNullable(clazz.cast(replicationGroupDescription()));
        case "PrimaryClusterId":
            return Optional.ofNullable(clazz.cast(primaryClusterId()));
        case "AutomaticFailoverEnabled":
            return Optional.ofNullable(clazz.cast(automaticFailoverEnabled()));
        case "NumCacheClusters":
            return Optional.ofNullable(clazz.cast(numCacheClusters()));
        case "PreferredCacheClusterAZs":
            return Optional.ofNullable(clazz.cast(preferredCacheClusterAZs()));
        case "NumNodeGroups":
            return Optional.ofNullable(clazz.cast(numNodeGroups()));
        case "ReplicasPerNodeGroup":
            return Optional.ofNullable(clazz.cast(replicasPerNodeGroup()));
        case "NodeGroupConfiguration":
            return Optional.ofNullable(clazz.cast(nodeGroupConfiguration()));
        case "CacheNodeType":
            return Optional.ofNullable(clazz.cast(cacheNodeType()));
        case "Engine":
            return Optional.ofNullable(clazz.cast(engine()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "CacheParameterGroupName":
            return Optional.ofNullable(clazz.cast(cacheParameterGroupName()));
        case "CacheSubnetGroupName":
            return Optional.ofNullable(clazz.cast(cacheSubnetGroupName()));
        case "CacheSecurityGroupNames":
            return Optional.ofNullable(clazz.cast(cacheSecurityGroupNames()));
        case "SecurityGroupIds":
            return Optional.ofNullable(clazz.cast(securityGroupIds()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "SnapshotArns":
            return Optional.ofNullable(clazz.cast(snapshotArns()));
        case "SnapshotName":
            return Optional.ofNullable(clazz.cast(snapshotName()));
        case "PreferredMaintenanceWindow":
            return Optional.ofNullable(clazz.cast(preferredMaintenanceWindow()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "NotificationTopicArn":
            return Optional.ofNullable(clazz.cast(notificationTopicArn()));
        case "AutoMinorVersionUpgrade":
            return Optional.ofNullable(clazz.cast(autoMinorVersionUpgrade()));
        case "SnapshotRetentionLimit":
            return Optional.ofNullable(clazz.cast(snapshotRetentionLimit()));
        case "SnapshotWindow":
            return Optional.ofNullable(clazz.cast(snapshotWindow()));
        case "AuthToken":
            return Optional.ofNullable(clazz.cast(authToken()));
        case "TransitEncryptionEnabled":
            return Optional.ofNullable(clazz.cast(transitEncryptionEnabled()));
        case "AtRestEncryptionEnabled":
            return Optional.ofNullable(clazz.cast(atRestEncryptionEnabled()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateReplicationGroupRequest, T> g) {
        return obj -> g.apply((CreateReplicationGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElastiCacheRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateReplicationGroupRequest> {
        /**
         * <p>
         * The replication group identifier. This parameter is stored as a lowercase string.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * A name must contain from 1 to 40 alphanumeric characters or hyphens.
         * </p>
         * </li>
         * <li>
         * <p>
         * The first character must be a letter.
         * </p>
         * </li>
         * <li>
         * <p>
         * A name cannot end with a hyphen or contain two consecutive hyphens.
         * </p>
         * </li>
         * </ul>
         * 
         * @param replicationGroupId
         *        The replication group identifier. This parameter is stored as a lowercase string.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        A name must contain from 1 to 40 alphanumeric characters or hyphens.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The first character must be a letter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A name cannot end with a hyphen or contain two consecutive hyphens.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationGroupId(String replicationGroupId);

        /**
         * <p>
         * A user-created description for the replication group.
         * </p>
         * 
         * @param replicationGroupDescription
         *        A user-created description for the replication group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationGroupDescription(String replicationGroupDescription);

        /**
         * <p>
         * The identifier of the cluster that serves as the primary for this replication group. This cluster must
         * already exist and have a status of <code>available</code>.
         * </p>
         * <p>
         * This parameter is not required if <code>NumCacheClusters</code>, <code>NumNodeGroups</code>, or
         * <code>ReplicasPerNodeGroup</code> is specified.
         * </p>
         * 
         * @param primaryClusterId
         *        The identifier of the cluster that serves as the primary for this replication group. This cluster must
         *        already exist and have a status of <code>available</code>.</p>
         *        <p>
         *        This parameter is not required if <code>NumCacheClusters</code>, <code>NumNodeGroups</code>, or
         *        <code>ReplicasPerNodeGroup</code> is specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryClusterId(String primaryClusterId);

        /**
         * <p>
         * Specifies whether a read-only replica is automatically promoted to read/write primary if the existing primary
         * fails.
         * </p>
         * <p>
         * If <code>true</code>, Multi-AZ is enabled for this replication group. If <code>false</code>, Multi-AZ is
         * disabled for this replication group.
         * </p>
         * <p>
         * <code>AutomaticFailoverEnabled</code> must be enabled for Redis (cluster mode enabled) replication groups.
         * </p>
         * <p>
         * Default: false
         * </p>
         * <p>
         * Amazon ElastiCache for Redis does not support Multi-AZ with automatic failover on:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Redis versions earlier than 2.8.6.
         * </p>
         * </li>
         * <li>
         * <p>
         * Redis (cluster mode disabled): T1 node types.
         * </p>
         * </li>
         * <li>
         * <p>
         * Redis (cluster mode enabled): T1 node types.
         * </p>
         * </li>
         * </ul>
         * 
         * @param automaticFailoverEnabled
         *        Specifies whether a read-only replica is automatically promoted to read/write primary if the existing
         *        primary fails.</p>
         *        <p>
         *        If <code>true</code>, Multi-AZ is enabled for this replication group. If <code>false</code>, Multi-AZ
         *        is disabled for this replication group.
         *        </p>
         *        <p>
         *        <code>AutomaticFailoverEnabled</code> must be enabled for Redis (cluster mode enabled) replication
         *        groups.
         *        </p>
         *        <p>
         *        Default: false
         *        </p>
         *        <p>
         *        Amazon ElastiCache for Redis does not support Multi-AZ with automatic failover on:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Redis versions earlier than 2.8.6.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Redis (cluster mode disabled): T1 node types.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Redis (cluster mode enabled): T1 node types.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automaticFailoverEnabled(Boolean automaticFailoverEnabled);

        /**
         * <p>
         * The number of clusters this replication group initially has.
         * </p>
         * <p>
         * This parameter is not used if there is more than one node group (shard). You should use
         * <code>ReplicasPerNodeGroup</code> instead.
         * </p>
         * <p>
         * If <code>AutomaticFailoverEnabled</code> is <code>true</code>, the value of this parameter must be at least
         * 2. If <code>AutomaticFailoverEnabled</code> is <code>false</code> you can omit this parameter (it will
         * default to 1), or you can explicitly set it to a value between 2 and 6.
         * </p>
         * <p>
         * The maximum permitted value for <code>NumCacheClusters</code> is 6 (1 primary plus 5 replicas).
         * </p>
         * 
         * @param numCacheClusters
         *        The number of clusters this replication group initially has.</p>
         *        <p>
         *        This parameter is not used if there is more than one node group (shard). You should use
         *        <code>ReplicasPerNodeGroup</code> instead.
         *        </p>
         *        <p>
         *        If <code>AutomaticFailoverEnabled</code> is <code>true</code>, the value of this parameter must be at
         *        least 2. If <code>AutomaticFailoverEnabled</code> is <code>false</code> you can omit this parameter
         *        (it will default to 1), or you can explicitly set it to a value between 2 and 6.
         *        </p>
         *        <p>
         *        The maximum permitted value for <code>NumCacheClusters</code> is 6 (1 primary plus 5 replicas).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numCacheClusters(Integer numCacheClusters);

        /**
         * <p>
         * A list of EC2 Availability Zones in which the replication group's clusters are created. The order of the
         * Availability Zones in the list is the order in which clusters are allocated. The primary cluster is created
         * in the first AZ in the list.
         * </p>
         * <p>
         * This parameter is not used if there is more than one node group (shard). You should use
         * <code>NodeGroupConfiguration</code> instead.
         * </p>
         * <note>
         * <p>
         * If you are creating your replication group in an Amazon VPC (recommended), you can only locate clusters in
         * Availability Zones associated with the subnets in the selected subnet group.
         * </p>
         * <p>
         * The number of Availability Zones listed must equal the value of <code>NumCacheClusters</code>.
         * </p>
         * </note>
         * <p>
         * Default: system chosen Availability Zones.
         * </p>
         * 
         * @param preferredCacheClusterAZs
         *        A list of EC2 Availability Zones in which the replication group's clusters are created. The order of
         *        the Availability Zones in the list is the order in which clusters are allocated. The primary cluster
         *        is created in the first AZ in the list.</p>
         *        <p>
         *        This parameter is not used if there is more than one node group (shard). You should use
         *        <code>NodeGroupConfiguration</code> instead.
         *        </p>
         *        <note>
         *        <p>
         *        If you are creating your replication group in an Amazon VPC (recommended), you can only locate
         *        clusters in Availability Zones associated with the subnets in the selected subnet group.
         *        </p>
         *        <p>
         *        The number of Availability Zones listed must equal the value of <code>NumCacheClusters</code>.
         *        </p>
         *        </note>
         *        <p>
         *        Default: system chosen Availability Zones.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredCacheClusterAZs(Collection<String> preferredCacheClusterAZs);

        /**
         * <p>
         * A list of EC2 Availability Zones in which the replication group's clusters are created. The order of the
         * Availability Zones in the list is the order in which clusters are allocated. The primary cluster is created
         * in the first AZ in the list.
         * </p>
         * <p>
         * This parameter is not used if there is more than one node group (shard). You should use
         * <code>NodeGroupConfiguration</code> instead.
         * </p>
         * <note>
         * <p>
         * If you are creating your replication group in an Amazon VPC (recommended), you can only locate clusters in
         * Availability Zones associated with the subnets in the selected subnet group.
         * </p>
         * <p>
         * The number of Availability Zones listed must equal the value of <code>NumCacheClusters</code>.
         * </p>
         * </note>
         * <p>
         * Default: system chosen Availability Zones.
         * </p>
         * 
         * @param preferredCacheClusterAZs
         *        A list of EC2 Availability Zones in which the replication group's clusters are created. The order of
         *        the Availability Zones in the list is the order in which clusters are allocated. The primary cluster
         *        is created in the first AZ in the list.</p>
         *        <p>
         *        This parameter is not used if there is more than one node group (shard). You should use
         *        <code>NodeGroupConfiguration</code> instead.
         *        </p>
         *        <note>
         *        <p>
         *        If you are creating your replication group in an Amazon VPC (recommended), you can only locate
         *        clusters in Availability Zones associated with the subnets in the selected subnet group.
         *        </p>
         *        <p>
         *        The number of Availability Zones listed must equal the value of <code>NumCacheClusters</code>.
         *        </p>
         *        </note>
         *        <p>
         *        Default: system chosen Availability Zones.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredCacheClusterAZs(String... preferredCacheClusterAZs);

        /**
         * <p>
         * An optional parameter that specifies the number of node groups (shards) for this Redis (cluster mode enabled)
         * replication group. For Redis (cluster mode disabled) either omit this parameter or set it to 1.
         * </p>
         * <p>
         * Default: 1
         * </p>
         * 
         * @param numNodeGroups
         *        An optional parameter that specifies the number of node groups (shards) for this Redis (cluster mode
         *        enabled) replication group. For Redis (cluster mode disabled) either omit this parameter or set it to
         *        1.</p>
         *        <p>
         *        Default: 1
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numNodeGroups(Integer numNodeGroups);

        /**
         * <p>
         * An optional parameter that specifies the number of replica nodes in each node group (shard). Valid values are
         * 0 to 5.
         * </p>
         * 
         * @param replicasPerNodeGroup
         *        An optional parameter that specifies the number of replica nodes in each node group (shard). Valid
         *        values are 0 to 5.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicasPerNodeGroup(Integer replicasPerNodeGroup);

        /**
         * <p>
         * A list of node group (shard) configuration options. Each node group (shard) configuration has the following
         * members: <code>PrimaryAvailabilityZone</code>, <code>ReplicaAvailabilityZones</code>,
         * <code>ReplicaCount</code>, and <code>Slots</code>.
         * </p>
         * <p>
         * If you're creating a Redis (cluster mode disabled) or a Redis (cluster mode enabled) replication group, you
         * can use this parameter to individually configure each node group (shard), or you can omit this parameter.
         * However, when seeding a Redis (cluster mode enabled) cluster from a S3 rdb file, you must configure each node
         * group (shard) using this parameter because you must specify the slots for each node group.
         * </p>
         * 
         * @param nodeGroupConfiguration
         *        A list of node group (shard) configuration options. Each node group (shard) configuration has the
         *        following members: <code>PrimaryAvailabilityZone</code>, <code>ReplicaAvailabilityZones</code>,
         *        <code>ReplicaCount</code>, and <code>Slots</code>.</p>
         *        <p>
         *        If you're creating a Redis (cluster mode disabled) or a Redis (cluster mode enabled) replication
         *        group, you can use this parameter to individually configure each node group (shard), or you can omit
         *        this parameter. However, when seeding a Redis (cluster mode enabled) cluster from a S3 rdb file, you
         *        must configure each node group (shard) using this parameter because you must specify the slots for
         *        each node group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeGroupConfiguration(Collection<NodeGroupConfiguration> nodeGroupConfiguration);

        /**
         * <p>
         * A list of node group (shard) configuration options. Each node group (shard) configuration has the following
         * members: <code>PrimaryAvailabilityZone</code>, <code>ReplicaAvailabilityZones</code>,
         * <code>ReplicaCount</code>, and <code>Slots</code>.
         * </p>
         * <p>
         * If you're creating a Redis (cluster mode disabled) or a Redis (cluster mode enabled) replication group, you
         * can use this parameter to individually configure each node group (shard), or you can omit this parameter.
         * However, when seeding a Redis (cluster mode enabled) cluster from a S3 rdb file, you must configure each node
         * group (shard) using this parameter because you must specify the slots for each node group.
         * </p>
         * 
         * @param nodeGroupConfiguration
         *        A list of node group (shard) configuration options. Each node group (shard) configuration has the
         *        following members: <code>PrimaryAvailabilityZone</code>, <code>ReplicaAvailabilityZones</code>,
         *        <code>ReplicaCount</code>, and <code>Slots</code>.</p>
         *        <p>
         *        If you're creating a Redis (cluster mode disabled) or a Redis (cluster mode enabled) replication
         *        group, you can use this parameter to individually configure each node group (shard), or you can omit
         *        this parameter. However, when seeding a Redis (cluster mode enabled) cluster from a S3 rdb file, you
         *        must configure each node group (shard) using this parameter because you must specify the slots for
         *        each node group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeGroupConfiguration(NodeGroupConfiguration... nodeGroupConfiguration);

        /**
         * <p>
         * A list of node group (shard) configuration options. Each node group (shard) configuration has the following
         * members: <code>PrimaryAvailabilityZone</code>, <code>ReplicaAvailabilityZones</code>,
         * <code>ReplicaCount</code>, and <code>Slots</code>.
         * </p>
         * <p>
         * If you're creating a Redis (cluster mode disabled) or a Redis (cluster mode enabled) replication group, you
         * can use this parameter to individually configure each node group (shard), or you can omit this parameter.
         * However, when seeding a Redis (cluster mode enabled) cluster from a S3 rdb file, you must configure each node
         * group (shard) using this parameter because you must specify the slots for each node group.
         * </p>
         * This is a convenience that creates an instance of the {@link List<NodeGroupConfiguration>.Builder} avoiding
         * the need to create one manually via {@link List<NodeGroupConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<NodeGroupConfiguration>.Builder#build()} is called
         * immediately and its result is passed to {@link #nodeGroupConfiguration(List<NodeGroupConfiguration>)}.
         * 
         * @param nodeGroupConfiguration
         *        a consumer that will call methods on {@link List<NodeGroupConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nodeGroupConfiguration(List<NodeGroupConfiguration>)
         */
        Builder nodeGroupConfiguration(Consumer<NodeGroupConfiguration.Builder>... nodeGroupConfiguration);

        /**
         * <p>
         * The compute and memory capacity of the nodes in the node group (shard).
         * </p>
         * <p>
         * The following node types are supported by ElastiCache. Generally speaking, the current generation types
         * provide more memory and computational power at lower cost when compared to their equivalent previous
         * generation counterparts.
         * </p>
         * <ul>
         * <li>
         * <p>
         * General purpose:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Current generation:
         * </p>
         * <p>
         * <b>M5 node types:</b> <code>cache.m5.large</code>, <code>cache.m5.xlarge</code>,
         * <code>cache.m5.2xlarge</code>, <code>cache.m5.4xlarge</code>, <code>cache.m5.12xlarge</code>,
         * <code>cache.m5.24xlarge</code>
         * </p>
         * <p>
         * <b>M4 node types:</b> <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>,
         * <code>cache.m4.2xlarge</code>, <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code>
         * </p>
         * <p>
         * <b>T2 node types:</b> <code>cache.t2.micro</code>, <code>cache.t2.small</code>, <code>cache.t2.medium</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Previous generation: (not recommended)
         * </p>
         * <p>
         * <b>T1 node types:</b> <code>cache.t1.micro</code>
         * </p>
         * <p>
         * <b>M1 node types:</b> <code>cache.m1.small</code>, <code>cache.m1.medium</code>, <code>cache.m1.large</code>,
         * <code>cache.m1.xlarge</code>
         * </p>
         * <p>
         * <b>M3 node types:</b> <code>cache.m3.medium</code>, <code>cache.m3.large</code>, <code>cache.m3.xlarge</code>, <code>cache.m3.2xlarge</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * Compute optimized:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Previous generation: (not recommended)
         * </p>
         * <p>
         * <b>C1 node types:</b> <code>cache.c1.xlarge</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * Memory optimized:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Current generation:
         * </p>
         * <p>
         * <b>R5 node types:</b> <code>cache.r5.large</code>, <code>cache.r5.xlarge</code>,
         * <code>cache.r5.2xlarge</code>, <code>cache.r5.4xlarge</code>, <code>cache.r5.12xlarge</code>,
         * <code>cache.r5.24xlarge</code>
         * </p>
         * <p>
         * <b>R4 node types:</b> <code>cache.r4.large</code>, <code>cache.r4.xlarge</code>,
         * <code>cache.r4.2xlarge</code>, <code>cache.r4.4xlarge</code>, <code>cache.r4.8xlarge</code>,
         * <code>cache.r4.16xlarge</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Previous generation: (not recommended)
         * </p>
         * <p>
         * <b>M2 node types:</b> <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>,
         * <code>cache.m2.4xlarge</code>
         * </p>
         * <p>
         * <b>R3 node types:</b> <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>,
         * <code>cache.r3.2xlarge</code>, <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * <p>
         * <b>Additional node type info</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * All current generation instance types are created in Amazon VPC by default.
         * </p>
         * </li>
         * <li>
         * <p>
         * Redis append-only files (AOF) are not supported for T1 or T2 instances.
         * </p>
         * </li>
         * <li>
         * <p>
         * Redis Multi-AZ with automatic failover is not supported on T1 instances.
         * </p>
         * </li>
         * <li>
         * <p>
         * Redis configuration variables <code>appendonly</code> and <code>appendfsync</code> are not supported on Redis
         * version 2.8.22 and later.
         * </p>
         * </li>
         * </ul>
         * 
         * @param cacheNodeType
         *        The compute and memory capacity of the nodes in the node group (shard).</p>
         *        <p>
         *        The following node types are supported by ElastiCache. Generally speaking, the current generation
         *        types provide more memory and computational power at lower cost when compared to their equivalent
         *        previous generation counterparts.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        General purpose:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Current generation:
         *        </p>
         *        <p>
         *        <b>M5 node types:</b> <code>cache.m5.large</code>, <code>cache.m5.xlarge</code>,
         *        <code>cache.m5.2xlarge</code>, <code>cache.m5.4xlarge</code>, <code>cache.m5.12xlarge</code>,
         *        <code>cache.m5.24xlarge</code>
         *        </p>
         *        <p>
         *        <b>M4 node types:</b> <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>,
         *        <code>cache.m4.2xlarge</code>, <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code>
         *        </p>
         *        <p>
         *        <b>T2 node types:</b> <code>cache.t2.micro</code>, <code>cache.t2.small</code>,
         *        <code>cache.t2.medium</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Previous generation: (not recommended)
         *        </p>
         *        <p>
         *        <b>T1 node types:</b> <code>cache.t1.micro</code>
         *        </p>
         *        <p>
         *        <b>M1 node types:</b> <code>cache.m1.small</code>, <code>cache.m1.medium</code>,
         *        <code>cache.m1.large</code>, <code>cache.m1.xlarge</code>
         *        </p>
         *        <p>
         *        <b>M3 node types:</b> <code>cache.m3.medium</code>, <code>cache.m3.large</code>,
         *        <code>cache.m3.xlarge</code>, <code>cache.m3.2xlarge</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        Compute optimized:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Previous generation: (not recommended)
         *        </p>
         *        <p>
         *        <b>C1 node types:</b> <code>cache.c1.xlarge</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        Memory optimized:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Current generation:
         *        </p>
         *        <p>
         *        <b>R5 node types:</b> <code>cache.r5.large</code>, <code>cache.r5.xlarge</code>,
         *        <code>cache.r5.2xlarge</code>, <code>cache.r5.4xlarge</code>, <code>cache.r5.12xlarge</code>,
         *        <code>cache.r5.24xlarge</code>
         *        </p>
         *        <p>
         *        <b>R4 node types:</b> <code>cache.r4.large</code>, <code>cache.r4.xlarge</code>,
         *        <code>cache.r4.2xlarge</code>, <code>cache.r4.4xlarge</code>, <code>cache.r4.8xlarge</code>,
         *        <code>cache.r4.16xlarge</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Previous generation: (not recommended)
         *        </p>
         *        <p>
         *        <b>M2 node types:</b> <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>,
         *        <code>cache.m2.4xlarge</code>
         *        </p>
         *        <p>
         *        <b>R3 node types:</b> <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>,
         *        <code>cache.r3.2xlarge</code>, <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>Additional node type info</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        All current generation instance types are created in Amazon VPC by default.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Redis append-only files (AOF) are not supported for T1 or T2 instances.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Redis Multi-AZ with automatic failover is not supported on T1 instances.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Redis configuration variables <code>appendonly</code> and <code>appendfsync</code> are not supported
         *        on Redis version 2.8.22 and later.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheNodeType(String cacheNodeType);

        /**
         * <p>
         * The name of the cache engine to be used for the clusters in this replication group.
         * </p>
         * 
         * @param engine
         *        The name of the cache engine to be used for the clusters in this replication group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engine(String engine);

        /**
         * <p>
         * The version number of the cache engine to be used for the clusters in this replication group. To view the
         * supported cache engine versions, use the <code>DescribeCacheEngineVersions</code> operation.
         * </p>
         * <p>
         * <b>Important:</b> You can upgrade to a newer engine version (see <a
         * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement"
         * >Selecting a Cache Engine and Version</a>) in the <i>ElastiCache User Guide</i>, but you cannot downgrade to
         * an earlier engine version. If you want to use an earlier engine version, you must delete the existing cluster
         * or replication group and create it anew with the earlier engine version.
         * </p>
         * 
         * @param engineVersion
         *        The version number of the cache engine to be used for the clusters in this replication group. To view
         *        the supported cache engine versions, use the <code>DescribeCacheEngineVersions</code> operation.</p>
         *        <p>
         *        <b>Important:</b> You can upgrade to a newer engine version (see <a href=
         *        "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement"
         *        >Selecting a Cache Engine and Version</a>) in the <i>ElastiCache User Guide</i>, but you cannot
         *        downgrade to an earlier engine version. If you want to use an earlier engine version, you must delete
         *        the existing cluster or replication group and create it anew with the earlier engine version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * The name of the parameter group to associate with this replication group. If this argument is omitted, the
         * default cache parameter group for the specified engine is used.
         * </p>
         * <note>
         * <p>
         * If you are restoring to an engine version that is different than the original, you must specify the default
         * version of that version. For example, <code>CacheParameterGroupName=default.redis4.0</code>.
         * </p>
         * </note>
         * <p>
         * If you are running Redis version 3.2.4 or later, only one node group (shard), and want to use a default
         * parameter group, we recommend that you specify the parameter group by name.
         * </p>
         * <ul>
         * <li>
         * <p>
         * To create a Redis (cluster mode disabled) replication group, use
         * <code>CacheParameterGroupName=default.redis3.2</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * To create a Redis (cluster mode enabled) replication group, use
         * <code>CacheParameterGroupName=default.redis3.2.cluster.on</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param cacheParameterGroupName
         *        The name of the parameter group to associate with this replication group. If this argument is omitted,
         *        the default cache parameter group for the specified engine is used.</p> <note>
         *        <p>
         *        If you are restoring to an engine version that is different than the original, you must specify the
         *        default version of that version. For example, <code>CacheParameterGroupName=default.redis4.0</code>.
         *        </p>
         *        </note>
         *        <p>
         *        If you are running Redis version 3.2.4 or later, only one node group (shard), and want to use a
         *        default parameter group, we recommend that you specify the parameter group by name.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        To create a Redis (cluster mode disabled) replication group, use
         *        <code>CacheParameterGroupName=default.redis3.2</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        To create a Redis (cluster mode enabled) replication group, use
         *        <code>CacheParameterGroupName=default.redis3.2.cluster.on</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheParameterGroupName(String cacheParameterGroupName);

        /**
         * <p>
         * The name of the cache subnet group to be used for the replication group.
         * </p>
         * <important>
         * <p>
         * If you're going to launch your cluster in an Amazon VPC, you need to create a subnet group before you start
         * creating a cluster. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SubnetGroups.html">Subnets and Subnet
         * Groups</a>.
         * </p>
         * </important>
         * 
         * @param cacheSubnetGroupName
         *        The name of the cache subnet group to be used for the replication group.</p> <important>
         *        <p>
         *        If you're going to launch your cluster in an Amazon VPC, you need to create a subnet group before you
         *        start creating a cluster. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SubnetGroups.html">Subnets and
         *        Subnet Groups</a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheSubnetGroupName(String cacheSubnetGroupName);

        /**
         * <p>
         * A list of cache security group names to associate with this replication group.
         * </p>
         * 
         * @param cacheSecurityGroupNames
         *        A list of cache security group names to associate with this replication group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheSecurityGroupNames(Collection<String> cacheSecurityGroupNames);

        /**
         * <p>
         * A list of cache security group names to associate with this replication group.
         * </p>
         * 
         * @param cacheSecurityGroupNames
         *        A list of cache security group names to associate with this replication group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheSecurityGroupNames(String... cacheSecurityGroupNames);

        /**
         * <p>
         * One or more Amazon VPC security groups associated with this replication group.
         * </p>
         * <p>
         * Use this parameter only when you are creating a replication group in an Amazon Virtual Private Cloud (Amazon
         * VPC).
         * </p>
         * 
         * @param securityGroupIds
         *        One or more Amazon VPC security groups associated with this replication group.</p>
         *        <p>
         *        Use this parameter only when you are creating a replication group in an Amazon Virtual Private Cloud
         *        (Amazon VPC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * One or more Amazon VPC security groups associated with this replication group.
         * </p>
         * <p>
         * Use this parameter only when you are creating a replication group in an Amazon Virtual Private Cloud (Amazon
         * VPC).
         * </p>
         * 
         * @param securityGroupIds
         *        One or more Amazon VPC security groups associated with this replication group.</p>
         *        <p>
         *        Use this parameter only when you are creating a replication group in an Amazon Virtual Private Cloud
         *        (Amazon VPC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);

        /**
         * <p>
         * A list of cost allocation tags to be added to this resource. Tags are comma-separated key,value pairs (e.g.
         * Key=<code>myKey</code>, Value=<code>myKeyValue</code>. You can include multiple tags as shown following: Key=
         * <code>myKey</code>, Value=<code>myKeyValue</code> Key=<code>mySecondKey</code>, Value=
         * <code>mySecondKeyValue</code>.
         * </p>
         * 
         * @param tags
         *        A list of cost allocation tags to be added to this resource. Tags are comma-separated key,value pairs
         *        (e.g. Key=<code>myKey</code>, Value=<code>myKeyValue</code>. You can include multiple tags as shown
         *        following: Key=<code>myKey</code>, Value=<code>myKeyValue</code> Key=<code>mySecondKey</code>, Value=
         *        <code>mySecondKeyValue</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of cost allocation tags to be added to this resource. Tags are comma-separated key,value pairs (e.g.
         * Key=<code>myKey</code>, Value=<code>myKeyValue</code>. You can include multiple tags as shown following: Key=
         * <code>myKey</code>, Value=<code>myKeyValue</code> Key=<code>mySecondKey</code>, Value=
         * <code>mySecondKeyValue</code>.
         * </p>
         * 
         * @param tags
         *        A list of cost allocation tags to be added to this resource. Tags are comma-separated key,value pairs
         *        (e.g. Key=<code>myKey</code>, Value=<code>myKeyValue</code>. You can include multiple tags as shown
         *        following: Key=<code>myKey</code>, Value=<code>myKeyValue</code> Key=<code>mySecondKey</code>, Value=
         *        <code>mySecondKeyValue</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of cost allocation tags to be added to this resource. Tags are comma-separated key,value pairs (e.g.
         * Key=<code>myKey</code>, Value=<code>myKeyValue</code>. You can include multiple tags as shown following: Key=
         * <code>myKey</code>, Value=<code>myKeyValue</code> Key=<code>mySecondKey</code>, Value=
         * <code>mySecondKeyValue</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * A list of Amazon Resource Names (ARN) that uniquely identify the Redis RDB snapshot files stored in Amazon
         * S3. The snapshot files are used to populate the new replication group. The Amazon S3 object name in the ARN
         * cannot contain any commas. The new replication group will have the number of node groups (console: shards)
         * specified by the parameter <i>NumNodeGroups</i> or the number of node groups configured by
         * <i>NodeGroupConfiguration</i> regardless of the number of ARNs specified here.
         * </p>
         * <p>
         * Example of an Amazon S3 ARN: <code>arn:aws:s3:::my_bucket/snapshot1.rdb</code>
         * </p>
         * 
         * @param snapshotArns
         *        A list of Amazon Resource Names (ARN) that uniquely identify the Redis RDB snapshot files stored in
         *        Amazon S3. The snapshot files are used to populate the new replication group. The Amazon S3 object
         *        name in the ARN cannot contain any commas. The new replication group will have the number of node
         *        groups (console: shards) specified by the parameter <i>NumNodeGroups</i> or the number of node groups
         *        configured by <i>NodeGroupConfiguration</i> regardless of the number of ARNs specified here.</p>
         *        <p>
         *        Example of an Amazon S3 ARN: <code>arn:aws:s3:::my_bucket/snapshot1.rdb</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotArns(Collection<String> snapshotArns);

        /**
         * <p>
         * A list of Amazon Resource Names (ARN) that uniquely identify the Redis RDB snapshot files stored in Amazon
         * S3. The snapshot files are used to populate the new replication group. The Amazon S3 object name in the ARN
         * cannot contain any commas. The new replication group will have the number of node groups (console: shards)
         * specified by the parameter <i>NumNodeGroups</i> or the number of node groups configured by
         * <i>NodeGroupConfiguration</i> regardless of the number of ARNs specified here.
         * </p>
         * <p>
         * Example of an Amazon S3 ARN: <code>arn:aws:s3:::my_bucket/snapshot1.rdb</code>
         * </p>
         * 
         * @param snapshotArns
         *        A list of Amazon Resource Names (ARN) that uniquely identify the Redis RDB snapshot files stored in
         *        Amazon S3. The snapshot files are used to populate the new replication group. The Amazon S3 object
         *        name in the ARN cannot contain any commas. The new replication group will have the number of node
         *        groups (console: shards) specified by the parameter <i>NumNodeGroups</i> or the number of node groups
         *        configured by <i>NodeGroupConfiguration</i> regardless of the number of ARNs specified here.</p>
         *        <p>
         *        Example of an Amazon S3 ARN: <code>arn:aws:s3:::my_bucket/snapshot1.rdb</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotArns(String... snapshotArns);

        /**
         * <p>
         * The name of a snapshot from which to restore data into the new replication group. The snapshot status changes
         * to <code>restoring</code> while the new replication group is being created.
         * </p>
         * 
         * @param snapshotName
         *        The name of a snapshot from which to restore data into the new replication group. The snapshot status
         *        changes to <code>restoring</code> while the new replication group is being created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotName(String snapshotName);

        /**
         * <p>
         * Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a
         * range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute
         * period. Valid values for <code>ddd</code> are:
         * </p>
         * <p>
         * Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a
         * range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute
         * period.
         * </p>
         * <p>
         * Valid values for <code>ddd</code> are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>sun</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>mon</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tue</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>wed</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>thu</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>fri</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sat</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * Example: <code>sun:23:00-mon:01:30</code>
         * </p>
         * 
         * @param preferredMaintenanceWindow
         *        Specifies the weekly time range during which maintenance on the cluster is performed. It is specified
         *        as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a
         *        60 minute period. Valid values for <code>ddd</code> are:</p>
         *        <p>
         *        Specifies the weekly time range during which maintenance on the cluster is performed. It is specified
         *        as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a
         *        60 minute period.
         *        </p>
         *        <p>
         *        Valid values for <code>ddd</code> are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>sun</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>mon</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tue</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>wed</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>thu</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>fri</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sat</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Example: <code>sun:23:00-mon:01:30</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredMaintenanceWindow(String preferredMaintenanceWindow);

        /**
         * <p>
         * The port number on which each member of the replication group accepts connections.
         * </p>
         * 
         * @param port
         *        The port number on which each member of the replication group accepts connections.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which notifications
         * are sent.
         * </p>
         * <note>
         * <p>
         * The Amazon SNS topic owner must be the same as the cluster owner.
         * </p>
         * </note>
         * 
         * @param notificationTopicArn
         *        The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which
         *        notifications are sent.</p> <note>
         *        <p>
         *        The Amazon SNS topic owner must be the same as the cluster owner.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationTopicArn(String notificationTopicArn);

        /**
         * <p>
         * This parameter is currently disabled.
         * </p>
         * 
         * @param autoMinorVersionUpgrade
         *        This parameter is currently disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade);

        /**
         * <p>
         * The number of days for which ElastiCache retains automatic snapshots before deleting them. For example, if
         * you set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was taken today is retained for 5 days
         * before being deleted.
         * </p>
         * <p>
         * Default: 0 (i.e., automatic backups are disabled for this cluster).
         * </p>
         * 
         * @param snapshotRetentionLimit
         *        The number of days for which ElastiCache retains automatic snapshots before deleting them. For
         *        example, if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was taken today is
         *        retained for 5 days before being deleted.</p>
         *        <p>
         *        Default: 0 (i.e., automatic backups are disabled for this cluster).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotRetentionLimit(Integer snapshotRetentionLimit);

        /**
         * <p>
         * The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your node group
         * (shard).
         * </p>
         * <p>
         * Example: <code>05:00-09:00</code>
         * </p>
         * <p>
         * If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.
         * </p>
         * 
         * @param snapshotWindow
         *        The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your node
         *        group (shard).</p>
         *        <p>
         *        Example: <code>05:00-09:00</code>
         *        </p>
         *        <p>
         *        If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotWindow(String snapshotWindow);

        /**
         * <p>
         * <b>Reserved parameter.</b> The password used to access a password protected server.
         * </p>
         * <p>
         * <code>AuthToken</code> can be specified only on replication groups where
         * <code>TransitEncryptionEnabled</code> is <code>true</code>.
         * </p>
         * <important>
         * <p>
         * For HIPAA compliance, you must specify <code>TransitEncryptionEnabled</code> as <code>true</code>, an
         * <code>AuthToken</code>, and a <code>CacheSubnetGroup</code>.
         * </p>
         * </important>
         * <p>
         * Password constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be only printable ASCII characters.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must be at least 16 characters and no more than 128 characters in length.
         * </p>
         * </li>
         * <li>
         * <p>
         * The only permitted printable special characters are !, &amp;, #, $, ^, &lt;, &gt;, and -. Other printable
         * special characters cannot be used in the AUTH token.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a href="http://redis.io/commands/AUTH">AUTH password</a> at
         * http://redis.io/commands/AUTH.
         * </p>
         * 
         * @param authToken
         *        <b>Reserved parameter.</b> The password used to access a password protected server.</p>
         *        <p>
         *        <code>AuthToken</code> can be specified only on replication groups where
         *        <code>TransitEncryptionEnabled</code> is <code>true</code>.
         *        </p>
         *        <important>
         *        <p>
         *        For HIPAA compliance, you must specify <code>TransitEncryptionEnabled</code> as <code>true</code>, an
         *        <code>AuthToken</code>, and a <code>CacheSubnetGroup</code>.
         *        </p>
         *        </important>
         *        <p>
         *        Password constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be only printable ASCII characters.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must be at least 16 characters and no more than 128 characters in length.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The only permitted printable special characters are !, &amp;, #, $, ^, &lt;, &gt;, and -. Other
         *        printable special characters cannot be used in the AUTH token.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a href="http://redis.io/commands/AUTH">AUTH password</a> at
         *        http://redis.io/commands/AUTH.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authToken(String authToken);

        /**
         * <p>
         * A flag that enables in-transit encryption when set to <code>true</code>.
         * </p>
         * <p>
         * You cannot modify the value of <code>TransitEncryptionEnabled</code> after the cluster is created. To enable
         * in-transit encryption on a cluster you must set <code>TransitEncryptionEnabled</code> to <code>true</code>
         * when you create a cluster.
         * </p>
         * <p>
         * This parameter is valid only if the <code>Engine</code> parameter is <code>redis</code>, the
         * <code>EngineVersion</code> parameter is <code>3.2.6</code>, <code>4.x</code> or later, and the cluster is
         * being created in an Amazon VPC.
         * </p>
         * <p>
         * If you enable in-transit encryption, you must also specify a value for <code>CacheSubnetGroup</code>.
         * </p>
         * <p>
         * <b>Required:</b> Only available when creating a replication group in an Amazon VPC using redis version
         * <code>3.2.6</code>, <code>4.x</code> or later.
         * </p>
         * <p>
         * Default: <code>false</code>
         * </p>
         * <important>
         * <p>
         * For HIPAA compliance, you must specify <code>TransitEncryptionEnabled</code> as <code>true</code>, an
         * <code>AuthToken</code>, and a <code>CacheSubnetGroup</code>.
         * </p>
         * </important>
         * 
         * @param transitEncryptionEnabled
         *        A flag that enables in-transit encryption when set to <code>true</code>.</p>
         *        <p>
         *        You cannot modify the value of <code>TransitEncryptionEnabled</code> after the cluster is created. To
         *        enable in-transit encryption on a cluster you must set <code>TransitEncryptionEnabled</code> to
         *        <code>true</code> when you create a cluster.
         *        </p>
         *        <p>
         *        This parameter is valid only if the <code>Engine</code> parameter is <code>redis</code>, the
         *        <code>EngineVersion</code> parameter is <code>3.2.6</code>, <code>4.x</code> or later, and the cluster
         *        is being created in an Amazon VPC.
         *        </p>
         *        <p>
         *        If you enable in-transit encryption, you must also specify a value for <code>CacheSubnetGroup</code>.
         *        </p>
         *        <p>
         *        <b>Required:</b> Only available when creating a replication group in an Amazon VPC using redis version
         *        <code>3.2.6</code>, <code>4.x</code> or later.
         *        </p>
         *        <p>
         *        Default: <code>false</code>
         *        </p>
         *        <important>
         *        <p>
         *        For HIPAA compliance, you must specify <code>TransitEncryptionEnabled</code> as <code>true</code>, an
         *        <code>AuthToken</code>, and a <code>CacheSubnetGroup</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitEncryptionEnabled(Boolean transitEncryptionEnabled);

        /**
         * <p>
         * A flag that enables encryption at rest when set to <code>true</code>.
         * </p>
         * <p>
         * You cannot modify the value of <code>AtRestEncryptionEnabled</code> after the replication group is created.
         * To enable encryption at rest on a replication group you must set <code>AtRestEncryptionEnabled</code> to
         * <code>true</code> when you create the replication group.
         * </p>
         * <p>
         * <b>Required:</b> Only available when creating a replication group in an Amazon VPC using redis version
         * <code>3.2.6</code>, <code>4.x</code> or later.
         * </p>
         * <p>
         * Default: <code>false</code>
         * </p>
         * 
         * @param atRestEncryptionEnabled
         *        A flag that enables encryption at rest when set to <code>true</code>.</p>
         *        <p>
         *        You cannot modify the value of <code>AtRestEncryptionEnabled</code> after the replication group is
         *        created. To enable encryption at rest on a replication group you must set
         *        <code>AtRestEncryptionEnabled</code> to <code>true</code> when you create the replication group.
         *        </p>
         *        <p>
         *        <b>Required:</b> Only available when creating a replication group in an Amazon VPC using redis version
         *        <code>3.2.6</code>, <code>4.x</code> or later.
         *        </p>
         *        <p>
         *        Default: <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder atRestEncryptionEnabled(Boolean atRestEncryptionEnabled);

        /**
         * <p>
         * The ID of the KMS key used to encrypt the disk on the cluster.
         * </p>
         * 
         * @param kmsKeyId
         *        The ID of the KMS key used to encrypt the disk on the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElastiCacheRequest.BuilderImpl implements Builder {
        private String replicationGroupId;

        private String replicationGroupDescription;

        private String primaryClusterId;

        private Boolean automaticFailoverEnabled;

        private Integer numCacheClusters;

        private List<String> preferredCacheClusterAZs = DefaultSdkAutoConstructList.getInstance();

        private Integer numNodeGroups;

        private Integer replicasPerNodeGroup;

        private List<NodeGroupConfiguration> nodeGroupConfiguration = DefaultSdkAutoConstructList.getInstance();

        private String cacheNodeType;

        private String engine;

        private String engineVersion;

        private String cacheParameterGroupName;

        private String cacheSubnetGroupName;

        private List<String> cacheSecurityGroupNames = DefaultSdkAutoConstructList.getInstance();

        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private List<String> snapshotArns = DefaultSdkAutoConstructList.getInstance();

        private String snapshotName;

        private String preferredMaintenanceWindow;

        private Integer port;

        private String notificationTopicArn;

        private Boolean autoMinorVersionUpgrade;

        private Integer snapshotRetentionLimit;

        private String snapshotWindow;

        private String authToken;

        private Boolean transitEncryptionEnabled;

        private Boolean atRestEncryptionEnabled;

        private String kmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateReplicationGroupRequest model) {
            super(model);
            replicationGroupId(model.replicationGroupId);
            replicationGroupDescription(model.replicationGroupDescription);
            primaryClusterId(model.primaryClusterId);
            automaticFailoverEnabled(model.automaticFailoverEnabled);
            numCacheClusters(model.numCacheClusters);
            preferredCacheClusterAZs(model.preferredCacheClusterAZs);
            numNodeGroups(model.numNodeGroups);
            replicasPerNodeGroup(model.replicasPerNodeGroup);
            nodeGroupConfiguration(model.nodeGroupConfiguration);
            cacheNodeType(model.cacheNodeType);
            engine(model.engine);
            engineVersion(model.engineVersion);
            cacheParameterGroupName(model.cacheParameterGroupName);
            cacheSubnetGroupName(model.cacheSubnetGroupName);
            cacheSecurityGroupNames(model.cacheSecurityGroupNames);
            securityGroupIds(model.securityGroupIds);
            tags(model.tags);
            snapshotArns(model.snapshotArns);
            snapshotName(model.snapshotName);
            preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            port(model.port);
            notificationTopicArn(model.notificationTopicArn);
            autoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            snapshotRetentionLimit(model.snapshotRetentionLimit);
            snapshotWindow(model.snapshotWindow);
            authToken(model.authToken);
            transitEncryptionEnabled(model.transitEncryptionEnabled);
            atRestEncryptionEnabled(model.atRestEncryptionEnabled);
            kmsKeyId(model.kmsKeyId);
        }

        public final String getReplicationGroupId() {
            return replicationGroupId;
        }

        @Override
        public final Builder replicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
            return this;
        }

        public final void setReplicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
        }

        public final String getReplicationGroupDescription() {
            return replicationGroupDescription;
        }

        @Override
        public final Builder replicationGroupDescription(String replicationGroupDescription) {
            this.replicationGroupDescription = replicationGroupDescription;
            return this;
        }

        public final void setReplicationGroupDescription(String replicationGroupDescription) {
            this.replicationGroupDescription = replicationGroupDescription;
        }

        public final String getPrimaryClusterId() {
            return primaryClusterId;
        }

        @Override
        public final Builder primaryClusterId(String primaryClusterId) {
            this.primaryClusterId = primaryClusterId;
            return this;
        }

        public final void setPrimaryClusterId(String primaryClusterId) {
            this.primaryClusterId = primaryClusterId;
        }

        public final Boolean getAutomaticFailoverEnabled() {
            return automaticFailoverEnabled;
        }

        @Override
        public final Builder automaticFailoverEnabled(Boolean automaticFailoverEnabled) {
            this.automaticFailoverEnabled = automaticFailoverEnabled;
            return this;
        }

        public final void setAutomaticFailoverEnabled(Boolean automaticFailoverEnabled) {
            this.automaticFailoverEnabled = automaticFailoverEnabled;
        }

        public final Integer getNumCacheClusters() {
            return numCacheClusters;
        }

        @Override
        public final Builder numCacheClusters(Integer numCacheClusters) {
            this.numCacheClusters = numCacheClusters;
            return this;
        }

        public final void setNumCacheClusters(Integer numCacheClusters) {
            this.numCacheClusters = numCacheClusters;
        }

        public final Collection<String> getPreferredCacheClusterAZs() {
            return preferredCacheClusterAZs;
        }

        @Override
        public final Builder preferredCacheClusterAZs(Collection<String> preferredCacheClusterAZs) {
            this.preferredCacheClusterAZs = AvailabilityZonesListCopier.copy(preferredCacheClusterAZs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder preferredCacheClusterAZs(String... preferredCacheClusterAZs) {
            preferredCacheClusterAZs(Arrays.asList(preferredCacheClusterAZs));
            return this;
        }

        public final void setPreferredCacheClusterAZs(Collection<String> preferredCacheClusterAZs) {
            this.preferredCacheClusterAZs = AvailabilityZonesListCopier.copy(preferredCacheClusterAZs);
        }

        public final Integer getNumNodeGroups() {
            return numNodeGroups;
        }

        @Override
        public final Builder numNodeGroups(Integer numNodeGroups) {
            this.numNodeGroups = numNodeGroups;
            return this;
        }

        public final void setNumNodeGroups(Integer numNodeGroups) {
            this.numNodeGroups = numNodeGroups;
        }

        public final Integer getReplicasPerNodeGroup() {
            return replicasPerNodeGroup;
        }

        @Override
        public final Builder replicasPerNodeGroup(Integer replicasPerNodeGroup) {
            this.replicasPerNodeGroup = replicasPerNodeGroup;
            return this;
        }

        public final void setReplicasPerNodeGroup(Integer replicasPerNodeGroup) {
            this.replicasPerNodeGroup = replicasPerNodeGroup;
        }

        public final Collection<NodeGroupConfiguration.Builder> getNodeGroupConfiguration() {
            return nodeGroupConfiguration != null ? nodeGroupConfiguration.stream().map(NodeGroupConfiguration::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder nodeGroupConfiguration(Collection<NodeGroupConfiguration> nodeGroupConfiguration) {
            this.nodeGroupConfiguration = NodeGroupConfigurationListCopier.copy(nodeGroupConfiguration);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeGroupConfiguration(NodeGroupConfiguration... nodeGroupConfiguration) {
            nodeGroupConfiguration(Arrays.asList(nodeGroupConfiguration));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeGroupConfiguration(Consumer<NodeGroupConfiguration.Builder>... nodeGroupConfiguration) {
            nodeGroupConfiguration(Stream.of(nodeGroupConfiguration)
                    .map(c -> NodeGroupConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setNodeGroupConfiguration(Collection<NodeGroupConfiguration.BuilderImpl> nodeGroupConfiguration) {
            this.nodeGroupConfiguration = NodeGroupConfigurationListCopier.copyFromBuilder(nodeGroupConfiguration);
        }

        public final String getCacheNodeType() {
            return cacheNodeType;
        }

        @Override
        public final Builder cacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
            return this;
        }

        public final void setCacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
        }

        public final String getEngine() {
            return engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final String getCacheParameterGroupName() {
            return cacheParameterGroupName;
        }

        @Override
        public final Builder cacheParameterGroupName(String cacheParameterGroupName) {
            this.cacheParameterGroupName = cacheParameterGroupName;
            return this;
        }

        public final void setCacheParameterGroupName(String cacheParameterGroupName) {
            this.cacheParameterGroupName = cacheParameterGroupName;
        }

        public final String getCacheSubnetGroupName() {
            return cacheSubnetGroupName;
        }

        @Override
        public final Builder cacheSubnetGroupName(String cacheSubnetGroupName) {
            this.cacheSubnetGroupName = cacheSubnetGroupName;
            return this;
        }

        public final void setCacheSubnetGroupName(String cacheSubnetGroupName) {
            this.cacheSubnetGroupName = cacheSubnetGroupName;
        }

        public final Collection<String> getCacheSecurityGroupNames() {
            return cacheSecurityGroupNames;
        }

        @Override
        public final Builder cacheSecurityGroupNames(Collection<String> cacheSecurityGroupNames) {
            this.cacheSecurityGroupNames = CacheSecurityGroupNameListCopier.copy(cacheSecurityGroupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheSecurityGroupNames(String... cacheSecurityGroupNames) {
            cacheSecurityGroupNames(Arrays.asList(cacheSecurityGroupNames));
            return this;
        }

        public final void setCacheSecurityGroupNames(Collection<String> cacheSecurityGroupNames) {
            this.cacheSecurityGroupNames = CacheSecurityGroupNameListCopier.copy(cacheSecurityGroupNames);
        }

        public final Collection<String> getSecurityGroupIds() {
            return securityGroupIds;
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsListCopier.copy(securityGroupIds);
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final Collection<String> getSnapshotArns() {
            return snapshotArns;
        }

        @Override
        public final Builder snapshotArns(Collection<String> snapshotArns) {
            this.snapshotArns = SnapshotArnsListCopier.copy(snapshotArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshotArns(String... snapshotArns) {
            snapshotArns(Arrays.asList(snapshotArns));
            return this;
        }

        public final void setSnapshotArns(Collection<String> snapshotArns) {
            this.snapshotArns = SnapshotArnsListCopier.copy(snapshotArns);
        }

        public final String getSnapshotName() {
            return snapshotName;
        }

        @Override
        public final Builder snapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
            return this;
        }

        public final void setSnapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
        }

        public final String getPreferredMaintenanceWindow() {
            return preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        public final Integer getPort() {
            return port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getNotificationTopicArn() {
            return notificationTopicArn;
        }

        @Override
        public final Builder notificationTopicArn(String notificationTopicArn) {
            this.notificationTopicArn = notificationTopicArn;
            return this;
        }

        public final void setNotificationTopicArn(String notificationTopicArn) {
            this.notificationTopicArn = notificationTopicArn;
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        public final Integer getSnapshotRetentionLimit() {
            return snapshotRetentionLimit;
        }

        @Override
        public final Builder snapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
            return this;
        }

        public final void setSnapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
        }

        public final String getSnapshotWindow() {
            return snapshotWindow;
        }

        @Override
        public final Builder snapshotWindow(String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
            return this;
        }

        public final void setSnapshotWindow(String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
        }

        public final String getAuthToken() {
            return authToken;
        }

        @Override
        public final Builder authToken(String authToken) {
            this.authToken = authToken;
            return this;
        }

        public final void setAuthToken(String authToken) {
            this.authToken = authToken;
        }

        public final Boolean getTransitEncryptionEnabled() {
            return transitEncryptionEnabled;
        }

        @Override
        public final Builder transitEncryptionEnabled(Boolean transitEncryptionEnabled) {
            this.transitEncryptionEnabled = transitEncryptionEnabled;
            return this;
        }

        public final void setTransitEncryptionEnabled(Boolean transitEncryptionEnabled) {
            this.transitEncryptionEnabled = transitEncryptionEnabled;
        }

        public final Boolean getAtRestEncryptionEnabled() {
            return atRestEncryptionEnabled;
        }

        @Override
        public final Builder atRestEncryptionEnabled(Boolean atRestEncryptionEnabled) {
            this.atRestEncryptionEnabled = atRestEncryptionEnabled;
            return this;
        }

        public final void setAtRestEncryptionEnabled(Boolean atRestEncryptionEnabled) {
            this.atRestEncryptionEnabled = atRestEncryptionEnabled;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateReplicationGroupRequest build() {
            return new CreateReplicationGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
