/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a <code>CreateCacheSubnetGroup</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCacheSubnetGroupRequest extends ElastiCacheRequest implements
        ToCopyableBuilder<CreateCacheSubnetGroupRequest.Builder, CreateCacheSubnetGroupRequest> {
    private static final SdkField<String> CACHE_SUBNET_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateCacheSubnetGroupRequest::cacheSubnetGroupName)).setter(setter(Builder::cacheSubnetGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheSubnetGroupName").build())
            .build();

    private static final SdkField<String> CACHE_SUBNET_GROUP_DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateCacheSubnetGroupRequest::cacheSubnetGroupDescription))
            .setter(setter(Builder::cacheSubnetGroupDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheSubnetGroupDescription")
                    .build()).build();

    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CreateCacheSubnetGroupRequest::subnetIds))
            .setter(setter(Builder::subnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("SubnetIdentifier")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("SubnetIdentifier").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CACHE_SUBNET_GROUP_NAME_FIELD,
            CACHE_SUBNET_GROUP_DESCRIPTION_FIELD, SUBNET_IDS_FIELD));

    private final String cacheSubnetGroupName;

    private final String cacheSubnetGroupDescription;

    private final List<String> subnetIds;

    private CreateCacheSubnetGroupRequest(BuilderImpl builder) {
        super(builder);
        this.cacheSubnetGroupName = builder.cacheSubnetGroupName;
        this.cacheSubnetGroupDescription = builder.cacheSubnetGroupDescription;
        this.subnetIds = builder.subnetIds;
    }

    /**
     * <p>
     * A name for the cache subnet group. This value is stored as a lowercase string.
     * </p>
     * <p>
     * Constraints: Must contain no more than 255 alphanumeric characters or hyphens.
     * </p>
     * <p>
     * Example: <code>mysubnetgroup</code>
     * </p>
     * 
     * @return A name for the cache subnet group. This value is stored as a lowercase string.</p>
     *         <p>
     *         Constraints: Must contain no more than 255 alphanumeric characters or hyphens.
     *         </p>
     *         <p>
     *         Example: <code>mysubnetgroup</code>
     */
    public String cacheSubnetGroupName() {
        return cacheSubnetGroupName;
    }

    /**
     * <p>
     * A description for the cache subnet group.
     * </p>
     * 
     * @return A description for the cache subnet group.
     */
    public String cacheSubnetGroupDescription() {
        return cacheSubnetGroupDescription;
    }

    /**
     * Returns true if the SubnetIds property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSubnetIds() {
        return subnetIds != null && !(subnetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of VPC subnet IDs for the cache subnet group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSubnetIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of VPC subnet IDs for the cache subnet group.
     */
    public List<String> subnetIds() {
        return subnetIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cacheSubnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(cacheSubnetGroupDescription());
        hashCode = 31 * hashCode + Objects.hashCode(subnetIds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCacheSubnetGroupRequest)) {
            return false;
        }
        CreateCacheSubnetGroupRequest other = (CreateCacheSubnetGroupRequest) obj;
        return Objects.equals(cacheSubnetGroupName(), other.cacheSubnetGroupName())
                && Objects.equals(cacheSubnetGroupDescription(), other.cacheSubnetGroupDescription())
                && Objects.equals(subnetIds(), other.subnetIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateCacheSubnetGroupRequest").add("CacheSubnetGroupName", cacheSubnetGroupName())
                .add("CacheSubnetGroupDescription", cacheSubnetGroupDescription()).add("SubnetIds", subnetIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CacheSubnetGroupName":
            return Optional.ofNullable(clazz.cast(cacheSubnetGroupName()));
        case "CacheSubnetGroupDescription":
            return Optional.ofNullable(clazz.cast(cacheSubnetGroupDescription()));
        case "SubnetIds":
            return Optional.ofNullable(clazz.cast(subnetIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCacheSubnetGroupRequest, T> g) {
        return obj -> g.apply((CreateCacheSubnetGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElastiCacheRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateCacheSubnetGroupRequest> {
        /**
         * <p>
         * A name for the cache subnet group. This value is stored as a lowercase string.
         * </p>
         * <p>
         * Constraints: Must contain no more than 255 alphanumeric characters or hyphens.
         * </p>
         * <p>
         * Example: <code>mysubnetgroup</code>
         * </p>
         * 
         * @param cacheSubnetGroupName
         *        A name for the cache subnet group. This value is stored as a lowercase string.</p>
         *        <p>
         *        Constraints: Must contain no more than 255 alphanumeric characters or hyphens.
         *        </p>
         *        <p>
         *        Example: <code>mysubnetgroup</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheSubnetGroupName(String cacheSubnetGroupName);

        /**
         * <p>
         * A description for the cache subnet group.
         * </p>
         * 
         * @param cacheSubnetGroupDescription
         *        A description for the cache subnet group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheSubnetGroupDescription(String cacheSubnetGroupDescription);

        /**
         * <p>
         * A list of VPC subnet IDs for the cache subnet group.
         * </p>
         * 
         * @param subnetIds
         *        A list of VPC subnet IDs for the cache subnet group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(Collection<String> subnetIds);

        /**
         * <p>
         * A list of VPC subnet IDs for the cache subnet group.
         * </p>
         * 
         * @param subnetIds
         *        A list of VPC subnet IDs for the cache subnet group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(String... subnetIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElastiCacheRequest.BuilderImpl implements Builder {
        private String cacheSubnetGroupName;

        private String cacheSubnetGroupDescription;

        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCacheSubnetGroupRequest model) {
            super(model);
            cacheSubnetGroupName(model.cacheSubnetGroupName);
            cacheSubnetGroupDescription(model.cacheSubnetGroupDescription);
            subnetIds(model.subnetIds);
        }

        public final String getCacheSubnetGroupName() {
            return cacheSubnetGroupName;
        }

        @Override
        public final Builder cacheSubnetGroupName(String cacheSubnetGroupName) {
            this.cacheSubnetGroupName = cacheSubnetGroupName;
            return this;
        }

        public final void setCacheSubnetGroupName(String cacheSubnetGroupName) {
            this.cacheSubnetGroupName = cacheSubnetGroupName;
        }

        public final String getCacheSubnetGroupDescription() {
            return cacheSubnetGroupDescription;
        }

        @Override
        public final Builder cacheSubnetGroupDescription(String cacheSubnetGroupDescription) {
            this.cacheSubnetGroupDescription = cacheSubnetGroupDescription;
            return this;
        }

        public final void setCacheSubnetGroupDescription(String cacheSubnetGroupDescription) {
            this.cacheSubnetGroupDescription = cacheSubnetGroupDescription;
        }

        public final Collection<String> getSubnetIds() {
            return subnetIds;
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdentifierListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String... subnetIds) {
            subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdentifierListCopier.copy(subnetIds);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCacheSubnetGroupRequest build() {
            return new CreateCacheSubnetGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
