/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a cluster's status within a particular cache security group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CacheSecurityGroupMembership implements SdkPojo, Serializable,
        ToCopyableBuilder<CacheSecurityGroupMembership.Builder, CacheSecurityGroupMembership> {
    private static final SdkField<String> CACHE_SECURITY_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CacheSecurityGroupMembership::cacheSecurityGroupName)).setter(setter(Builder::cacheSecurityGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheSecurityGroupName").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CacheSecurityGroupMembership::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CACHE_SECURITY_GROUP_NAME_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String cacheSecurityGroupName;

    private final String status;

    private CacheSecurityGroupMembership(BuilderImpl builder) {
        this.cacheSecurityGroupName = builder.cacheSecurityGroupName;
        this.status = builder.status;
    }

    /**
     * <p>
     * The name of the cache security group.
     * </p>
     * 
     * @return The name of the cache security group.
     */
    public String cacheSecurityGroupName() {
        return cacheSecurityGroupName;
    }

    /**
     * <p>
     * The membership status in the cache security group. The status changes when a cache security group is modified, or
     * when the cache security groups assigned to a cluster are modified.
     * </p>
     * 
     * @return The membership status in the cache security group. The status changes when a cache security group is
     *         modified, or when the cache security groups assigned to a cluster are modified.
     */
    public String status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cacheSecurityGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CacheSecurityGroupMembership)) {
            return false;
        }
        CacheSecurityGroupMembership other = (CacheSecurityGroupMembership) obj;
        return Objects.equals(cacheSecurityGroupName(), other.cacheSecurityGroupName())
                && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CacheSecurityGroupMembership").add("CacheSecurityGroupName", cacheSecurityGroupName())
                .add("Status", status()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CacheSecurityGroupName":
            return Optional.ofNullable(clazz.cast(cacheSecurityGroupName()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CacheSecurityGroupMembership, T> g) {
        return obj -> g.apply((CacheSecurityGroupMembership) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CacheSecurityGroupMembership> {
        /**
         * <p>
         * The name of the cache security group.
         * </p>
         * 
         * @param cacheSecurityGroupName
         *        The name of the cache security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheSecurityGroupName(String cacheSecurityGroupName);

        /**
         * <p>
         * The membership status in the cache security group. The status changes when a cache security group is
         * modified, or when the cache security groups assigned to a cluster are modified.
         * </p>
         * 
         * @param status
         *        The membership status in the cache security group. The status changes when a cache security group is
         *        modified, or when the cache security groups assigned to a cluster are modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);
    }

    static final class BuilderImpl implements Builder {
        private String cacheSecurityGroupName;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(CacheSecurityGroupMembership model) {
            cacheSecurityGroupName(model.cacheSecurityGroupName);
            status(model.status);
        }

        public final String getCacheSecurityGroupName() {
            return cacheSecurityGroupName;
        }

        @Override
        public final Builder cacheSecurityGroupName(String cacheSecurityGroupName) {
            this.cacheSecurityGroupName = cacheSecurityGroupName;
            return this;
        }

        public final void setCacheSecurityGroupName(String cacheSecurityGroupName) {
            this.cacheSecurityGroupName = cacheSecurityGroupName;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public CacheSecurityGroupMembership build() {
            return new CacheSecurityGroupMembership(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
