/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Status of the cache parameter group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CacheParameterGroupStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<CacheParameterGroupStatus.Builder, CacheParameterGroupStatus> {
    private static final SdkField<String> CACHE_PARAMETER_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CacheParameterGroupStatus::cacheParameterGroupName)).setter(setter(Builder::cacheParameterGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheParameterGroupName").build())
            .build();

    private static final SdkField<String> PARAMETER_APPLY_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CacheParameterGroupStatus::parameterApplyStatus)).setter(setter(Builder::parameterApplyStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterApplyStatus").build())
            .build();

    private static final SdkField<List<String>> CACHE_NODE_IDS_TO_REBOOT_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CacheParameterGroupStatus::cacheNodeIdsToReboot))
            .setter(setter(Builder::cacheNodeIdsToReboot))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheNodeIdsToReboot").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("CacheNodeId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("CacheNodeId").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CACHE_PARAMETER_GROUP_NAME_FIELD, PARAMETER_APPLY_STATUS_FIELD, CACHE_NODE_IDS_TO_REBOOT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String cacheParameterGroupName;

    private final String parameterApplyStatus;

    private final List<String> cacheNodeIdsToReboot;

    private CacheParameterGroupStatus(BuilderImpl builder) {
        this.cacheParameterGroupName = builder.cacheParameterGroupName;
        this.parameterApplyStatus = builder.parameterApplyStatus;
        this.cacheNodeIdsToReboot = builder.cacheNodeIdsToReboot;
    }

    /**
     * <p>
     * The name of the cache parameter group.
     * </p>
     * 
     * @return The name of the cache parameter group.
     */
    public String cacheParameterGroupName() {
        return cacheParameterGroupName;
    }

    /**
     * <p>
     * The status of parameter updates.
     * </p>
     * 
     * @return The status of parameter updates.
     */
    public String parameterApplyStatus() {
        return parameterApplyStatus;
    }

    /**
     * Returns true if the CacheNodeIdsToReboot property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasCacheNodeIdsToReboot() {
        return cacheNodeIdsToReboot != null && !(cacheNodeIdsToReboot instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the cache node IDs which need to be rebooted for parameter changes to be applied. A node ID is a
     * numeric identifier (0001, 0002, etc.).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCacheNodeIdsToReboot()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of the cache node IDs which need to be rebooted for parameter changes to be applied. A node ID is
     *         a numeric identifier (0001, 0002, etc.).
     */
    public List<String> cacheNodeIdsToReboot() {
        return cacheNodeIdsToReboot;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cacheParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(parameterApplyStatus());
        hashCode = 31 * hashCode + Objects.hashCode(cacheNodeIdsToReboot());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CacheParameterGroupStatus)) {
            return false;
        }
        CacheParameterGroupStatus other = (CacheParameterGroupStatus) obj;
        return Objects.equals(cacheParameterGroupName(), other.cacheParameterGroupName())
                && Objects.equals(parameterApplyStatus(), other.parameterApplyStatus())
                && Objects.equals(cacheNodeIdsToReboot(), other.cacheNodeIdsToReboot());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CacheParameterGroupStatus").add("CacheParameterGroupName", cacheParameterGroupName())
                .add("ParameterApplyStatus", parameterApplyStatus()).add("CacheNodeIdsToReboot", cacheNodeIdsToReboot()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CacheParameterGroupName":
            return Optional.ofNullable(clazz.cast(cacheParameterGroupName()));
        case "ParameterApplyStatus":
            return Optional.ofNullable(clazz.cast(parameterApplyStatus()));
        case "CacheNodeIdsToReboot":
            return Optional.ofNullable(clazz.cast(cacheNodeIdsToReboot()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CacheParameterGroupStatus, T> g) {
        return obj -> g.apply((CacheParameterGroupStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CacheParameterGroupStatus> {
        /**
         * <p>
         * The name of the cache parameter group.
         * </p>
         * 
         * @param cacheParameterGroupName
         *        The name of the cache parameter group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheParameterGroupName(String cacheParameterGroupName);

        /**
         * <p>
         * The status of parameter updates.
         * </p>
         * 
         * @param parameterApplyStatus
         *        The status of parameter updates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterApplyStatus(String parameterApplyStatus);

        /**
         * <p>
         * A list of the cache node IDs which need to be rebooted for parameter changes to be applied. A node ID is a
         * numeric identifier (0001, 0002, etc.).
         * </p>
         * 
         * @param cacheNodeIdsToReboot
         *        A list of the cache node IDs which need to be rebooted for parameter changes to be applied. A node ID
         *        is a numeric identifier (0001, 0002, etc.).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheNodeIdsToReboot(Collection<String> cacheNodeIdsToReboot);

        /**
         * <p>
         * A list of the cache node IDs which need to be rebooted for parameter changes to be applied. A node ID is a
         * numeric identifier (0001, 0002, etc.).
         * </p>
         * 
         * @param cacheNodeIdsToReboot
         *        A list of the cache node IDs which need to be rebooted for parameter changes to be applied. A node ID
         *        is a numeric identifier (0001, 0002, etc.).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheNodeIdsToReboot(String... cacheNodeIdsToReboot);
    }

    static final class BuilderImpl implements Builder {
        private String cacheParameterGroupName;

        private String parameterApplyStatus;

        private List<String> cacheNodeIdsToReboot = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CacheParameterGroupStatus model) {
            cacheParameterGroupName(model.cacheParameterGroupName);
            parameterApplyStatus(model.parameterApplyStatus);
            cacheNodeIdsToReboot(model.cacheNodeIdsToReboot);
        }

        public final String getCacheParameterGroupName() {
            return cacheParameterGroupName;
        }

        @Override
        public final Builder cacheParameterGroupName(String cacheParameterGroupName) {
            this.cacheParameterGroupName = cacheParameterGroupName;
            return this;
        }

        public final void setCacheParameterGroupName(String cacheParameterGroupName) {
            this.cacheParameterGroupName = cacheParameterGroupName;
        }

        public final String getParameterApplyStatus() {
            return parameterApplyStatus;
        }

        @Override
        public final Builder parameterApplyStatus(String parameterApplyStatus) {
            this.parameterApplyStatus = parameterApplyStatus;
            return this;
        }

        public final void setParameterApplyStatus(String parameterApplyStatus) {
            this.parameterApplyStatus = parameterApplyStatus;
        }

        public final Collection<String> getCacheNodeIdsToReboot() {
            return cacheNodeIdsToReboot;
        }

        @Override
        public final Builder cacheNodeIdsToReboot(Collection<String> cacheNodeIdsToReboot) {
            this.cacheNodeIdsToReboot = CacheNodeIdsListCopier.copy(cacheNodeIdsToReboot);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheNodeIdsToReboot(String... cacheNodeIdsToReboot) {
            cacheNodeIdsToReboot(Arrays.asList(cacheNodeIdsToReboot));
            return this;
        }

        public final void setCacheNodeIdsToReboot(Collection<String> cacheNodeIdsToReboot) {
            this.cacheNodeIdsToReboot = CacheNodeIdsListCopier.copy(cacheNodeIdsToReboot);
        }

        @Override
        public CacheParameterGroupStatus build() {
            return new CacheParameterGroupStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
