/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.elasticache.model.AuthTokenUpdateStatus;
import software.amazon.awssdk.services.elasticache.model.CacheNodeIdsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PendingModifiedValues
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PendingModifiedValues> {
    private static final SdkField<Integer> NUM_CACHE_NODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(PendingModifiedValues.getter(PendingModifiedValues::numCacheNodes)).setter(PendingModifiedValues.setter(Builder::numCacheNodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumCacheNodes").build()}).build();
    private static final SdkField<List<String>> CACHE_NODE_IDS_TO_REMOVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(PendingModifiedValues.getter(PendingModifiedValues::cacheNodeIdsToRemove)).setter(PendingModifiedValues.setter(Builder::cacheNodeIdsToRemove)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheNodeIdsToRemove").build(), ListTrait.builder().memberLocationName("CacheNodeId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheNodeId").build()}).build()).build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PendingModifiedValues.getter(PendingModifiedValues::engineVersion)).setter(PendingModifiedValues.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()}).build();
    private static final SdkField<String> CACHE_NODE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PendingModifiedValues.getter(PendingModifiedValues::cacheNodeType)).setter(PendingModifiedValues.setter(Builder::cacheNodeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheNodeType").build()}).build();
    private static final SdkField<String> AUTH_TOKEN_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PendingModifiedValues.getter(PendingModifiedValues::authTokenStatusAsString)).setter(PendingModifiedValues.setter(Builder::authTokenStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthTokenStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NUM_CACHE_NODES_FIELD, CACHE_NODE_IDS_TO_REMOVE_FIELD, ENGINE_VERSION_FIELD, CACHE_NODE_TYPE_FIELD, AUTH_TOKEN_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer numCacheNodes;
    private final List<String> cacheNodeIdsToRemove;
    private final String engineVersion;
    private final String cacheNodeType;
    private final String authTokenStatus;

    private PendingModifiedValues(BuilderImpl builder) {
        this.numCacheNodes = builder.numCacheNodes;
        this.cacheNodeIdsToRemove = builder.cacheNodeIdsToRemove;
        this.engineVersion = builder.engineVersion;
        this.cacheNodeType = builder.cacheNodeType;
        this.authTokenStatus = builder.authTokenStatus;
    }

    public Integer numCacheNodes() {
        return this.numCacheNodes;
    }

    public List<String> cacheNodeIdsToRemove() {
        return this.cacheNodeIdsToRemove;
    }

    public String engineVersion() {
        return this.engineVersion;
    }

    public String cacheNodeType() {
        return this.cacheNodeType;
    }

    public AuthTokenUpdateStatus authTokenStatus() {
        return AuthTokenUpdateStatus.fromValue(this.authTokenStatus);
    }

    public String authTokenStatusAsString() {
        return this.authTokenStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.numCacheNodes());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheNodeIdsToRemove());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheNodeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.authTokenStatusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PendingModifiedValues)) {
            return false;
        }
        PendingModifiedValues other = (PendingModifiedValues)obj;
        return Objects.equals(this.numCacheNodes(), other.numCacheNodes()) && Objects.equals(this.cacheNodeIdsToRemove(), other.cacheNodeIdsToRemove()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.cacheNodeType(), other.cacheNodeType()) && Objects.equals(this.authTokenStatusAsString(), other.authTokenStatusAsString());
    }

    public String toString() {
        return ToString.builder((String)"PendingModifiedValues").add("NumCacheNodes", (Object)this.numCacheNodes()).add("CacheNodeIdsToRemove", this.cacheNodeIdsToRemove()).add("EngineVersion", (Object)this.engineVersion()).add("CacheNodeType", (Object)this.cacheNodeType()).add("AuthTokenStatus", (Object)this.authTokenStatusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NumCacheNodes": {
                return Optional.ofNullable(clazz.cast(this.numCacheNodes()));
            }
            case "CacheNodeIdsToRemove": {
                return Optional.ofNullable(clazz.cast(this.cacheNodeIdsToRemove()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "CacheNodeType": {
                return Optional.ofNullable(clazz.cast(this.cacheNodeType()));
            }
            case "AuthTokenStatus": {
                return Optional.ofNullable(clazz.cast(this.authTokenStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PendingModifiedValues, T> g) {
        return obj -> g.apply((PendingModifiedValues)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer numCacheNodes;
        private List<String> cacheNodeIdsToRemove = DefaultSdkAutoConstructList.getInstance();
        private String engineVersion;
        private String cacheNodeType;
        private String authTokenStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(PendingModifiedValues model) {
            this.numCacheNodes(model.numCacheNodes);
            this.cacheNodeIdsToRemove(model.cacheNodeIdsToRemove);
            this.engineVersion(model.engineVersion);
            this.cacheNodeType(model.cacheNodeType);
            this.authTokenStatus(model.authTokenStatus);
        }

        public final Integer getNumCacheNodes() {
            return this.numCacheNodes;
        }

        @Override
        public final Builder numCacheNodes(Integer numCacheNodes) {
            this.numCacheNodes = numCacheNodes;
            return this;
        }

        public final void setNumCacheNodes(Integer numCacheNodes) {
            this.numCacheNodes = numCacheNodes;
        }

        public final Collection<String> getCacheNodeIdsToRemove() {
            return this.cacheNodeIdsToRemove;
        }

        @Override
        public final Builder cacheNodeIdsToRemove(Collection<String> cacheNodeIdsToRemove) {
            this.cacheNodeIdsToRemove = CacheNodeIdsListCopier.copy(cacheNodeIdsToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheNodeIdsToRemove(String ... cacheNodeIdsToRemove) {
            this.cacheNodeIdsToRemove(Arrays.asList(cacheNodeIdsToRemove));
            return this;
        }

        public final void setCacheNodeIdsToRemove(Collection<String> cacheNodeIdsToRemove) {
            this.cacheNodeIdsToRemove = CacheNodeIdsListCopier.copy(cacheNodeIdsToRemove);
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final String getCacheNodeType() {
            return this.cacheNodeType;
        }

        @Override
        public final Builder cacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
            return this;
        }

        public final void setCacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
        }

        public final String getAuthTokenStatusAsString() {
            return this.authTokenStatus;
        }

        @Override
        public final Builder authTokenStatus(String authTokenStatus) {
            this.authTokenStatus = authTokenStatus;
            return this;
        }

        @Override
        public final Builder authTokenStatus(AuthTokenUpdateStatus authTokenStatus) {
            this.authTokenStatus(authTokenStatus == null ? null : authTokenStatus.toString());
            return this;
        }

        public final void setAuthTokenStatus(String authTokenStatus) {
            this.authTokenStatus = authTokenStatus;
        }

        public PendingModifiedValues build() {
            return new PendingModifiedValues(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PendingModifiedValues> {
        public Builder numCacheNodes(Integer var1);

        public Builder cacheNodeIdsToRemove(Collection<String> var1);

        public Builder cacheNodeIdsToRemove(String ... var1);

        public Builder engineVersion(String var1);

        public Builder cacheNodeType(String var1);

        public Builder authTokenStatus(String var1);

        public Builder authTokenStatus(AuthTokenUpdateStatus var1);
    }
}

