/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elasticache.ElastiCacheClient;
import software.amazon.awssdk.services.elasticache.model.DescribeReplicationGroupsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeReplicationGroupsResponse;
import software.amazon.awssdk.services.elasticache.model.ReplicationGroup;

public class DescribeReplicationGroupsIterable
implements SdkIterable<DescribeReplicationGroupsResponse> {
    private final ElastiCacheClient client;
    private final DescribeReplicationGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeReplicationGroupsIterable(ElastiCacheClient client, DescribeReplicationGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeReplicationGroupsResponseFetcher();
    }

    public Iterator<DescribeReplicationGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ReplicationGroup> replicationGroups() {
        Function<DescribeReplicationGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.replicationGroups() != null) {
                return response.replicationGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final DescribeReplicationGroupsIterable resume(DescribeReplicationGroupsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeReplicationGroupsIterable(this.client, (DescribeReplicationGroupsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeReplicationGroupsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeReplicationGroupsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeReplicationGroupsResponseFetcher
    implements SyncPageFetcher<DescribeReplicationGroupsResponse> {
        private DescribeReplicationGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReplicationGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeReplicationGroupsResponse nextPage(DescribeReplicationGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeReplicationGroupsIterable.this.client.describeReplicationGroups(DescribeReplicationGroupsIterable.this.firstRequest);
            }
            return DescribeReplicationGroupsIterable.this.client.describeReplicationGroups((DescribeReplicationGroupsRequest)((Object)DescribeReplicationGroupsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

